/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.controller.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.chat.api.model.JustChatError;
import de.justsoftware.chat.api.model.exception.ApiGatewayException;
import de.justsoftware.chat.api.model.exception.DeprecatedChangesException;
import de.justsoftware.chat.api.model.exception.IllegalApiArgumentException;
import de.justsoftware.chat.api.model.exception.IllegalAttachmentException;
import de.justsoftware.chat.api.model.exception.IllegalTenantException;
import de.justsoftware.chat.api.model.exception.InvalidChangeTokenException;
import de.justsoftware.chat.api.model.exception.InvalidMessageException;
import de.justsoftware.chat.api.model.exception.InvalidPushPlatformException;
import de.justsoftware.chat.api.model.exception.InvalidUserIdException;
import de.justsoftware.onx.profile.model.ProfileValidationException;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackages={"de.justsoftware.chat.api"})
@ParametersAreNonnullByDefault
public class JustChatExceptionHandlingControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(JustChatExceptionHandlingControllerAdvice.class);
    private final ObjectMapper _objectMapper;

    @Autowired
    public JustChatExceptionHandlingControllerAdvice(ObjectMapper objectMapper) {
        this._objectMapper = objectMapper;
    }

    @ExceptionHandler(value={PermissionDeniedException.class, NotLoggedInException.class, BadCredentialsException.class})
    @Nonnull
    public ResponseEntity<JustChatError> handleForbidden(Throwable t) {
        LOG.error("Permission denied (403)", t);
        return this.createJustChatError(t, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @Nonnull
    public ResponseEntity<JustChatError> handleUnauthorized(AuthenticationException t) {
        LOG.error("Authentication denied (401)", (Throwable)t);
        return this.createJustChatError((Throwable)t, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, ServiceException.class, JucoConstraintViolationException.class, InvalidChangeTokenException.class, InvalidMessageException.class, IllegalApiArgumentException.class, ProfileValidationException.class, IllegalTenantException.class})
    @Nonnull
    public ResponseEntity<JustChatError> handleBadRequest(Throwable t) {
        LOG.error("Invalid HTTP message (400)", t);
        return this.createJustChatError(t, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DeprecatedChangesException.class, InvalidIdServiceException.class, InvalidPushPlatformException.class, IllegalAttachmentException.class, InvalidUserIdException.class})
    @Nonnull
    public ResponseEntity<JustChatError> handleNotFound(Throwable t) {
        if (t instanceof DeprecatedChangesException) {
            LOG.info("Changes deprecated (404) ({}: {})", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
        } else {
            LOG.error("Resource not found (404)", t);
        }
        return this.createJustChatError(t, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ApiGatewayException.class})
    @Nonnull
    public ResponseEntity<JustChatError> handleApiGatewayHttpError(ApiGatewayException t) {
        HttpStatus statusCode = t.getStatusCode();
        LOG.error("HTTP error " + statusCode + " in API gateway call", (Throwable)t);
        return this.createJustChatError(t, statusCode);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ResponseEntity<JustChatError> handleInternalServerError(Throwable t) {
        LOG.error("Some unexpected error happened", t);
        return this.createJustChatError(t, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    private ResponseEntity<JustChatError> createJustChatError(Throwable t, HttpStatus status) {
        JustChatError error = new JustChatError(this._objectMapper, t.getClass().getSimpleName() + ": " + t.getMessage());
        return new ResponseEntity((Object)error, status);
    }
}

