/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.controller.config;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.chat.api.controller.config.DisableChatApiInterceptor;
import de.justsoftware.chat.api.service.ClientVersion;
import de.justsoftware.chat.api.service.ClientVersionCheckResult;
import de.justsoftware.chat.api.service.ClientVersionsService;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@EnableWebMvc
@Configuration
@ParametersAreNonnullByDefault
public class JustChatWebConfiguration
implements WebMvcConfigurer {
    @Autowired
    private Settings _settings;
    @Autowired
    private ClientVersionsService _clientVersionsService;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new DisableChatApiInterceptor(this._settings)).addPathPatterns(new String[]{"/chat/api/**"});
        registry.addInterceptor((HandlerInterceptor)new AppVersionCheckInterceptor(this._clientVersionsService)).addPathPatterns(new String[]{"/chat/api/v2/**"});
    }

    @ParametersAreNonnullByDefault
    private static class AppVersionCheckInterceptor
    extends HandlerInterceptorAdapter {
        private final ClientVersionsService _clientVersionsService;

        AppVersionCheckInterceptor(ClientVersionsService clientVersionsService) {
            this._clientVersionsService = clientVersionsService;
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            ClientVersion clientVersion = ClientVersionsService.getVersion(request);
            ClientVersionCheckResult checkResult = this._clientVersionsService.checkVersion(clientVersion);
            if (checkResult.isVersionCodeTooLow()) {
                response.sendError(HttpStatus.PRECONDITION_FAILED.value(), checkResult.getErrorMessage());
                return false;
            }
            return true;
        }
    }
}

