/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.controller;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.model.UserList;
import de.justsoftware.chat.api.model.exception.InvalidUserIdException;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/chat/api/v2/users"})
public class UserController {
    private final UserService _userService;

    @Autowired
    public UserController(UserService userService) {
        this._userService = userService;
    }

    @GetMapping(produces={"application/json"})
    @ApiOperation(value="Return users within the specified range.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public UserList users(@AuthorizedContext AuthorizationContext authCtx, @RequestParam(name="filter", required=false, defaultValue="") String filter, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        List<User> users = this._userService.users(authCtx, filter, offset, limit);
        return new UserList(users);
    }

    @PostMapping(value={"/image"}, headers={"content-type=multipart/*"}, produces={"application/json"})
    @ApiOperation(value="Updates the current user's profile image with the uploaded image.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public User updateImage(@AuthorizedContext AuthorizationContext authCtx, @RequestPart(value="image") MultipartFile image) {
        return this._userService.updateImage(authCtx, image);
    }

    @DeleteMapping(value={"/image"}, produces={"application/json"})
    @ApiOperation(value="Deletes the current user's profile image.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public User deleteImage(@AuthorizedContext AuthorizationContext authCtx) {
        return this._userService.deleteImage(authCtx);
    }

    @GetMapping(value={"/{userId}"}, produces={"application/json"})
    @ApiOperation(value="Returns the profile of the user with the given ID.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public User user(@PathVariable(value="userId") String userId, @AuthorizedContext AuthorizationContext authCtx) {
        try {
            User user = this._userService.user(authCtx, userId);
            if (!user.isChattable()) {
                throw new InvalidUserIdException(userId);
            }
            return user;
        }
        catch (InvalidIdServiceException e) {
            throw new InvalidUserIdException(userId, e);
        }
    }
}

