/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.controller;

import de.justsoftware.chat.api.model.PeopleApiSearchResult;
import de.justsoftware.chat.api.model.SearchItemType;
import de.justsoftware.chat.api.model.SearchResult;
import de.justsoftware.chat.api.service.ApiGatewayService;
import de.justsoftware.chat.api.service.SearchResultMapper;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ChatRestApiSearchController")
@ParametersAreNonnullByDefault
@RequestMapping(path={"/chat/api/v2/search"})
public class SearchController {
    private final ApiGatewayService _apiGatewayService;
    private final SearchResultMapper _searchResultMapper;

    @Autowired
    public SearchController(ApiGatewayService apiGatewayService, SearchResultMapper searchResultMapper) {
        this._apiGatewayService = apiGatewayService;
        this._searchResultMapper = searchResultMapper;
    }

    @GetMapping(path={"/participants/name"}, produces={"application/json"})
    @ApiOperation(value="Searches for users and user groups by name.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public SearchResult searchParticipantsByName(@AuthorizedContext AuthorizationContext authContext, @Nullable @RequestParam(value="query", required=false) String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @Nullable @RequestParam(value="type", required=false) List<SearchItemType> types) {
        PeopleApiSearchResult peopleSearchResult = this._apiGatewayService.peopleSearchByName(authContext.getTenantId(), query, offset, limit, types);
        return this._searchResultMapper.toSearchResult(peopleSearchResult, authContext);
    }
}

