/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.controller;

import de.justsoftware.chat.api.controller.Controllers;
import de.justsoftware.chat.api.model.PushPlatform;
import de.justsoftware.chat.api.service.PushService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="chatPushNotificationController")
@ParametersAreNonnullByDefault
@RequestMapping(path={"/chat/api/v2"})
public class PushNotificationController {
    private final PushService _pushService;

    @Autowired
    public PushNotificationController(PushService pushService) {
        this._pushService = pushService;
    }

    @PostMapping(path={"/push/{platform}"}, produces={"application/json"})
    @ApiOperation(value="Register a new push notification device token.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<String> register(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="platform") String platformString, @RequestBody @Nullable String jsonToken) {
        String token = Controllers.parseJsonString(jsonToken);
        if (StringUtils.isBlank((String)token)) {
            return new ResponseEntity((Object)token, HttpStatus.BAD_REQUEST);
        }
        PushPlatform platform = PushPlatform.parse(platformString);
        HttpStatus status = this._pushService.register(authCtx, platform, token) ? HttpStatus.CREATED : HttpStatus.NOT_MODIFIED;
        return new ResponseEntity((Object)token, status);
    }

    @DeleteMapping(path={"/push/{platform}/{token}"}, produces={"application/json"})
    @ApiOperation(value="Unregister a push notification device token.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<String> unregister(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="platform") String platformString, @PathVariable(value="token") String token) {
        if (StringUtils.isBlank((String)token)) {
            return new ResponseEntity((Object)token, HttpStatus.NOT_FOUND);
        }
        PushPlatform platform = PushPlatform.parse(platformString);
        HttpStatus status = this._pushService.unregister(authCtx, platform, token) ? HttpStatus.NO_CONTENT : HttpStatus.NOT_MODIFIED;
        return new ResponseEntity(status);
    }
}

