/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.controller;

import com.google.common.base.Strings;
import de.justsoftware.chat.api.model.Attachment;
import de.justsoftware.chat.api.model.Change;
import de.justsoftware.chat.api.model.ChangeList;
import de.justsoftware.chat.api.model.ChangeToken;
import de.justsoftware.chat.api.model.Chat;
import de.justsoftware.chat.api.model.ChatList;
import de.justsoftware.chat.api.model.ChatSettings;
import de.justsoftware.chat.api.model.Message;
import de.justsoftware.chat.api.model.MessageContent;
import de.justsoftware.chat.api.model.MessageList;
import de.justsoftware.chat.api.model.MessageType;
import de.justsoftware.chat.api.model.MessageTypeUpdate;
import de.justsoftware.chat.api.model.Setting;
import de.justsoftware.chat.api.model.ThumbnailSize;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.model.UserGroup;
import de.justsoftware.chat.api.model.exception.IllegalApiArgumentException;
import de.justsoftware.chat.api.model.exception.InvalidMessageException;
import de.justsoftware.chat.api.service.ApiGatewayService;
import de.justsoftware.chat.api.service.ChatService;
import de.justsoftware.chat.api.service.ClientVersion;
import de.justsoftware.chat.api.service.ClientVersionsService;
import de.justsoftware.chat.api.service.SettingService;
import de.justsoftware.chat.api.service.TimeService;
import de.justsoftware.chat.api.service.UserGroupService;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.chat.api.util.Chats;
import de.justsoftware.chat.api.util.Messages;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.chat.model.AttachmentFilter;
import de.justsoftware.onx.common.integration.persistence.DBConversationAlreadyExists;
import de.justsoftware.onx.common.integration.persistence.DBMessageAlreadyExists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="chatController")
@ParametersAreNonnullByDefault
@RequestMapping(path={"/chat/api/v2"})
public class ChatController {
    private final ChatService _chatService;
    private final UserService _userService;
    private final UserGroupService _userGroupService;
    private final SettingService _settingService;
    private final ApiGatewayService _apiGatewayService;
    private final TimeService _timeService;

    @Autowired
    public ChatController(ChatService chatService, UserService userService, UserGroupService userGroupService, SettingService settingService, ApiGatewayService apiGatewayService, TimeService timeService) {
        this._chatService = chatService;
        this._userService = userService;
        this._userGroupService = userGroupService;
        this._settingService = settingService;
        this._apiGatewayService = apiGatewayService;
        this._timeService = timeService;
    }

    @GetMapping(path={"/chats"}, produces={"application/json"})
    @ApiOperation(value="Return chats within the specified range.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ChatList chats(@AuthorizedContext AuthorizationContext authCtx, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        List<Chat> chats = this._chatService.recentChats(authCtx, offset, limit);
        Set<String> userIds = Chats.userIdsOfParticipants(chats);
        Set<User> participants = this._userService.users(authCtx, userIds);
        Set<String> userGroupIds = Chats.userGroupIds(chats);
        List<UserGroup> userGroups = this._userGroupService.userGroups(authCtx, userGroupIds);
        return new ChatList(chats, participants, userGroups);
    }

    @PostMapping(path={"/chats"}, produces={"application/json"})
    @ApiOperation(value="Start a new chat (or return an existing chat if starting a one-on-one chat).", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public Chat startChat(@AuthorizedContext AuthorizationContext authCtx, @RequestBody @Nullable Chat chat) {
        if (chat == null) {
            throw new IllegalApiArgumentException("No chat provided.");
        }
        try {
            return this._chatService.startChat(authCtx, chat);
        }
        catch (DBConversationAlreadyExists e) {
            return this._chatService.chat(authCtx, e.getConversationId().asString());
        }
    }

    @PutMapping(path={"/chats"}, produces={"application/json"})
    @ApiOperation(value="Update a chat", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public Chat updateChat(@AuthorizedContext AuthorizationContext authCtx, @RequestBody @Nullable Chat chat) {
        if (chat == null) {
            throw new IllegalApiArgumentException("No chat provided.");
        }
        return this._chatService.updateChat(authCtx, chat);
    }

    @GetMapping(path={"/chats/{chatId}"}, produces={"application/json"})
    @ApiOperation(value="Return a single chat.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public Chat chat(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId) {
        return this._chatService.chat(authCtx, chatId);
    }

    @DeleteMapping(path={"/chats/{chatId}"}, produces={"application/json"})
    @ApiOperation(value="Deletes a single chat.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<String> deleteChat(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId) {
        this._chatService.deleteChat(authCtx, chatId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @GetMapping(path={"/chats/{chatId}/settings"}, produces={"application/json"})
    @ApiOperation(value="Return chat settings.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ChatSettings chatSettings(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId) {
        return this._chatService.chatSettings(authCtx, chatId);
    }

    @PutMapping(path={"/chats/{chatId}/settings"}, produces={"application/json"})
    @ApiOperation(value="Update chat settings.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ChatSettings updateChatSettings(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId, @RequestBody @Nullable ChatSettings chatSettings) {
        if (chatSettings == null) {
            throw new IllegalApiArgumentException("No chat settings provided.");
        }
        if (!Objects.equals(chatId, chatSettings.getChatId())) {
            throw new IllegalApiArgumentException("Chat settings for another chat.");
        }
        return this._chatService.updateChatSettings(authCtx, chatSettings);
    }

    @PutMapping(path={"/chats/{chatId}/read"}, produces={"application/json"})
    @ApiOperation(value="Mark all messages of a chat up to given time as read.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public Chat readChat(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId, @RequestBody @Nullable DateTime readTime) {
        if (readTime == null) {
            throw new IllegalApiArgumentException("Missing read time.");
        }
        return this._chatService.read(authCtx, chatId, readTime);
    }

    @GetMapping(path={"/chats/{chatId}/messages"}, produces={"application/json"})
    @ApiOperation(value="Return the messages of a chat within the specified range ordered descending by create date.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public MessageList messages(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId, @RequestParam(value="offsetId", required=false) @Nullable String offsetMessageId, @RequestParam(value="limit", required=false, defaultValue="20") int limit, @RequestParam(value="attachmentFilter", required=false) @Nullable AttachmentFilter attachmentFilter) {
        List<Message> messages = attachmentFilter != null ? this._chatService.attachmentMessages(authCtx, chatId, attachmentFilter, offsetMessageId, limit) : this._chatService.messages(authCtx, chatId, offsetMessageId, limit);
        Set<String> authorIds = Messages.userIdsOfAuthors(messages);
        Set<User> authors = this._userService.users(authCtx, authorIds);
        Chat chat = this._chatService.chat(authCtx, chatId);
        return new MessageList(messages, chat, authors);
    }

    @GetMapping(path={"/messages/{messageId}"}, produces={"application/json"})
    @ApiOperation(value="Return a single message.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public Message message(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="messageId") String messageId) {
        return this._chatService.message(authCtx, messageId);
    }

    @PatchMapping(path={"/messages/{messageId}"}, produces={"application/json"})
    @ApiOperation(value="Updates the type of the message and returns the updated message. Only changing the type to DELETED_MESSAGE is supported.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public Message updateMessage(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="messageId") String messageId, @RequestBody MessageTypeUpdate messageTypeUpdate) {
        if (!Objects.equals(messageId, messageTypeUpdate.getId())) {
            throw new InvalidMessageException("Message IDs of URL and body are not consistent.");
        }
        if (messageTypeUpdate.getType() != MessageType.DELETED_MESSAGE) {
            throw new InvalidMessageException("Only updating message type to DELETED_MESSAGE is supported.");
        }
        return this._chatService.deleteMessage(authCtx, messageId);
    }

    @PostMapping(path={"/chats/{chatId}/messages"}, produces={"application/json"})
    @ApiOperation(value="Create a new message.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Message> createMessage(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId, @RequestParam(name="markChatAsRead", defaultValue="true") boolean markChatAsRead, @RequestBody @Nullable MessageContent message) {
        if (message == null) {
            throw new IllegalApiArgumentException("No message provided.");
        }
        if (!Objects.equals(chatId, message.getChatId())) {
            throw new InvalidMessageException("Tried to send message to another chat.");
        }
        return this.createOrGetTextMessage(authCtx, message, markChatAsRead);
    }

    @Nonnull
    private ResponseEntity<Message> createOrGetTextMessage(AuthorizationContext authCtx, MessageContent message, boolean markAsRead) {
        try {
            String text = message.getText();
            if (text == null) {
                throw new InvalidMessageException("Unable to create text message without text.");
            }
            return new ResponseEntity((Object)this._chatService.createMessage(authCtx, message.getChatId(), message.getId(), message.getType(), text, markAsRead), HttpStatus.CREATED);
        }
        catch (DBMessageAlreadyExists e) {
            return new ResponseEntity((Object)this._chatService.message(authCtx, e.getChatMessageId().asString()), HttpStatus.OK);
        }
    }

    @PostMapping(path={"/chats/{chatId}/attachments"}, headers={"content-type=multipart/*"}, produces={"application/json"})
    @ApiOperation(value="Upload an attachment and create a new attachment message.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Message> createAttachmentMessage(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="chatId") String chatId, @RequestParam(value="attachment") @Nullable MultipartFile attachment, @RequestPart(value="message", required=false) @Nullable MessageContent message, @RequestParam(name="markChatAsRead", defaultValue="true") boolean markChatAsRead) {
        String messageChatId;
        if (attachment == null) {
            throw new IllegalApiArgumentException("No attachment provided.");
        }
        String string = messageChatId = message != null ? message.getChatId() : null;
        if (messageChatId != null && !messageChatId.equals(chatId)) {
            throw new InvalidMessageException("Tried to send message to another chat.");
        }
        String messageId = message != null ? message.getId() : null;
        return this.createOrGetAttachmentMessage(authCtx, chatId, messageId, attachment, markChatAsRead);
    }

    @Nonnull
    private ResponseEntity<Message> createOrGetAttachmentMessage(AuthorizationContext authCtx, String chatId, @Nullable String messageId, MultipartFile attachment, boolean markAsRead) {
        try {
            return new ResponseEntity((Object)this._chatService.createMessage(authCtx, chatId, messageId, attachment, markAsRead), HttpStatus.CREATED);
        }
        catch (DBMessageAlreadyExists e) {
            return new ResponseEntity((Object)this._chatService.message(authCtx, e.getChatMessageId().asString()), HttpStatus.OK);
        }
    }

    @GetMapping(path={"/messages/{messageId}/attachment"}, produces={"*/*"})
    @ApiOperation(value="Return the attachment of a message (if any).", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Resource> attachment(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="messageId") String messageId) {
        Attachment attachment = this._chatService.attachment(authCtx, messageId);
        return this._apiGatewayService.download(attachment);
    }

    @GetMapping(path={"/changes"}, produces={"application/json"})
    @ApiOperation(value="Return a list of changes (updated and deleted resources).", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ChangeList changes(@AuthorizedContext AuthorizationContext authCtx, HttpServletRequest request, @RequestParam(value="token", required=false) @Nullable String tokenEncoded) {
        DateTime changesCallTimestamp = this._timeService.now();
        ChangeToken token = Strings.isNullOrEmpty((String)tokenEncoded) ? null : ChangeToken.decode(tokenEncoded);
        ClientVersion clientVersion = ClientVersionsService.getVersion(request);
        List<Change> changes = this._chatService.changes(authCtx, token, clientVersion);
        ChangeToken nextToken = new ChangeToken(changesCallTimestamp, clientVersion.getVersionCode(), authCtx.getTenantId());
        return new ChangeList(changes, nextToken);
    }

    @GetMapping(path={"/settings"}, produces={"application/json"})
    @ApiOperation(value="Return API settings.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public List<Setting> settings() {
        return this._settingService.settings();
    }

    @GetMapping(value={"/messages/{messageId}/attachment/thumbnail"}, produces={"*/*"})
    @ApiOperation(value="Get a thumbnail of the attachment message with the given messageId.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Resource> thumbnailImage(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="messageId") String messageId, @RequestParam(value="size", defaultValue="MEDIUM") String size) {
        Attachment attachment = this._chatService.attachment(authCtx, messageId);
        ThumbnailSize thumbnailSize = ThumbnailSize.of(size);
        return this._apiGatewayService.thumbnailImage(attachment, thumbnailSize);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/preview"}, produces={"*/*"})
    @ApiOperation(value="Get a preview image of a message's attachment with the given messageId.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Resource> previewImage(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="messageId") String messageId) {
        Attachment attachment = this._chatService.attachment(authCtx, messageId);
        return this._apiGatewayService.previewImage(attachment);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/video"}, produces={"*/*"})
    @ApiOperation(value="Get a video stream of a message's attachment with the given messageId.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<Resource> videoStream(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="messageId") String messageId) {
        Attachment attachment = this._chatService.attachment(authCtx, messageId);
        return this._apiGatewayService.videoStream(attachment);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/video/url"}, produces={"text/plain"})
    @ApiOperation(value="Get a short-lived URL to access the stream of a video attachment without authorization.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public String unauthorizedVideoStreamUrl(@AuthorizedContext AuthorizationContext authCtx, @PathVariable(value="messageId") String messageId) {
        Attachment attachment = this._chatService.attachment(authCtx, messageId);
        return this._apiGatewayService.unauthorizedVideoStreamUrl(attachment);
    }
}

