/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.application;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import de.justsoftware.authentication.configuration.JwtKeyConfiguration;
import de.justsoftware.authentication.configuration.MetadataConfiguration;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.codec.Base64;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ConfigurationProperties
@ParametersAreNonnullByDefault
public class ZookeeperConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfiguration.class);
    private static final int ZOOKEEPER_BASE_SLEEP_TIME_MS = 1000;
    private static final int ZOOKEEPER_MAX_RETRIES = 10;

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"curator"})
    public CuratorFramework curator(@Value(value="${zookeeper.connectString}") String zookeeperConnectString) {
        return CuratorFrameworkFactory.newClient((String)zookeeperConnectString, (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"systemDomainPrefixNodeCache"})
    public NodeCache systemDomainPrefixNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, "/just/url/systemDomainPrefix");
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"systemSslKeyNodeCache"})
    public NodeCache systemSslKeyNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, "/just/config/common/ssl/privateKey");
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"idpServerNodeCache"})
    public NodeCache idpMetadataUrlNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, "/just/saml/idpServer");
    }

    @Nonnull
    @Bean(name={"metadataConfiguration"})
    public MetadataConfiguration metadataConfiguration(@Qualifier(value="systemDomainPrefixNodeCache") NodeCache systemDomainPrefixNodeCache, @Qualifier(value="systemSslKeyNodeCache") NodeCache systemSslKeyNodeCache, @Qualifier(value="idpServerNodeCache") NodeCache idpServerNodeCache) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"jwtPublicKeyNodeCache"})
    public NodeCache jwtPublicKeyNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, "/just/config/common/jwt/publicKey");
    }

    @Nonnull
    @Bean(destroyMethod="close", initMethod="start", name={"jwtPrivateKeyNodeCache"})
    public NodeCache jwtPrivateKeyNodeCache(CuratorFramework curator) {
        return new NodeCache(curator, "/just/config/common/jwt/privateKey");
    }

    @Nonnull
    @Bean(name={"jwtKeyConfiguration"})
    public JwtKeyConfiguration jwtConfiguration(@Qualifier(value="jwtPublicKeyNodeCache") NodeCache jwtPublicKeyNodeCache, @Qualifier(value="jwtPrivateKeyNodeCache") NodeCache jwtPrivateKeyNodeCache) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @CheckForNull
    private static String getStringFromNodeCache(NodeCache cache) {
        byte[] bytes = ZookeeperConfiguration.getBytesFromNodeCache((NodeCache)cache);
        return bytes != null ? Strings.emptyToNull((String)new String(bytes, Charsets.UTF_8).trim()) : null;
    }

    @CheckForNull
    private static byte[] getBytesFromNodeCache(NodeCache cache) {
        ChildData currentData = cache.getCurrentData();
        return currentData != null ? currentData.getData() : null;
    }

    @CheckForNull
    private static byte[] getBase64BytesFromNodeCache(NodeCache cache) {
        byte[] bytes = ZookeeperConfiguration.getBytesFromNodeCache((NodeCache)cache);
        return bytes != null ? Base64.decode((byte[])bytes) : null;
    }

    @CheckForNull
    private static String getPathOfNodeCache(NodeCache cache) {
        ChildData currentData = cache.getCurrentData();
        return currentData != null ? currentData.getPath() : null;
    }

    private static void addListener(NodeCache cache, Runnable listener) {
        NodeCacheListener ncl = () -> {
            try {
                listener.run();
            }
            catch (RuntimeException re) {
                LOGGER.error("processing change on " + ZookeeperConfiguration.getPathOfNodeCache((NodeCache)cache) + " raised exception: ", (Throwable)re);
            }
        };
        cache.getListenable().addListener((Object)ncl);
        try {
            ncl.nodeChanged();
        }
        catch (Exception e) {
            LOGGER.error("processing initial value on path " + ZookeeperConfiguration.getPathOfNodeCache((NodeCache)cache) + " raised exception: ", (Throwable)e);
        }
    }
}

