"use strict";function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _possibleConstructorReturn(self,call){if(!self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!call||"object"!=typeof call&&"function"!=typeof call?self:call}function _inherits(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function, not "+typeof superClass);subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:!1,writable:!0,configurable:!0}}),superClass&&(Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass)}function RestService($q,$http,Environment,$window){function getJustToken(){return $window.just&&$window.just.auth&&$window.just.auth.token||""}function getDefaultHeaders(){return{"just-token":getJustToken()}}function toPromise(httpPromise){return $q(function(resolve,reject){httpPromise.success(resolve).error(function(info,status){reject({info:info,status:status})})})}function fromResource(resource){return Environment.getAbsoluteApiEndpoint()+"/"+resource}function get(resource,params,bypassErrorInterceptor,ignoreAuthModule,config){var timeout=config?config.timeout:void 0;return toPromise($http({method:"GET",url:fromResource(resource),params:params||{},bypassErrorInterceptor:bypassErrorInterceptor,ignoreAuthModule:ignoreAuthModule,timeout:timeout,headers:getDefaultHeaders()}))}function put(resource,data,bypassErrorInterceptor,ignoreAuthModule){return toPromise($http({method:"PUT",url:fromResource(resource),data:data||{},bypassErrorInterceptor:bypassErrorInterceptor,ignoreAuthModule:ignoreAuthModule,headers:getDefaultHeaders()}))}function post(resource,data,bypassErrorInterceptor,ignoreAuthModule){return toPromise($http({method:"POST",url:fromResource(resource),data:data||{},bypassErrorInterceptor:bypassErrorInterceptor,ignoreAuthModule:ignoreAuthModule,headers:getDefaultHeaders()}))}function remove(resource,params,bypassErrorInterceptor,ignoreAuthModule){return toPromise($http({method:"DELETE",url:fromResource(resource),params:params||{},bypassErrorInterceptor:bypassErrorInterceptor,ignoreAuthModule:ignoreAuthModule,headers:getDefaultHeaders()}))}this.fromResource=fromResource,this.get=get,this.put=put,this.post=post,this["delete"]=remove}function JcSecuredImageController($scope,$element,$window,$document,JucoRestService){"ngInject";function init(){self.base64Data=void 0,angular.element($window).on("scroll",checkLoadImage),$scope.$on("$destroy",function(){angular.element($window).off("$destroy",checkLoadImage)}),checkLoadImage()}function loadImage(){loadingStatus=LOADING_STATUS.LOADING,JucoRestService.getBase64(self.src).then(function(imageData){self.base64Data=imageData,loadingStatus=LOADING_STATUS.LOADED})["catch"](function(){loadingStatus=LOADING_STATUS.ERROR})}function checkLoadImage(){loadingStatus===LOADING_STATUS.NOT_LOADED&&shouldLoadImage()&&loadImage()}function shouldLoadImage(){var rect=$element[0].getBoundingClientRect();return rect.top>=-LOADING_OFFSET-rect.height&&rect.left>=-LOADING_OFFSET-rect.width&&rect.bottom<=LOADING_OFFSET+($window.innerHeight||$document[0].documentElement.clientHeight)&&rect.right<=LOADING_OFFSET+($window.innerWidth||$document[0].documentElement.clientWidth)}var self=this,LOADING_OFFSET=200,LOADING_STATUS={NOT_LOADED:"NOT_LOADED",LOADING:"LOADING",LOADED:"LOADED",ERROR:"ERROR"},loadingStatus=LOADING_STATUS.NOT_LOADED;init()}function JcDropdownController($timeout,$transclude,$scope){var _this=this;this.open=!1;var firstEvent=!1;$scope.$on("$destroy",function(){document.removeEventListener("click",closeListener)});var closeListener=function(){return firstEvent?void(firstEvent=!1):void $timeout(_this.toggleDropdown)};$transclude(function(transcludeContent){_this.overrideToggle=!!transcludeContent.length}),this.toggleDropdown=function(){_this.open=!_this.open,_this.open?(firstEvent=!0,document.addEventListener("click",closeListener)):document.removeEventListener("click",closeListener)}}function FeedService(JucoRestService,$q,Cache,REST,$rootScope,EVENTS,ResourceType,IdUtil,FileService){"ngInject";function cacheKey(id,params){return id+"+"+(params&&params.offset||"")}function commentChangedListener(event,commentInfo){commentInfo&&commentInfo.parentId&&IdUtil.getResourceType(commentInfo.parentId)===ResourceType.WORKSTREAM_MESSAGE&&(workstreamMessageCache.remove(commentInfo.parentId),invalidateWorkstreamCache())}function invalidateWorkstreamCache(){workstreamCache.removeAll(),$rootScope.$broadcast(EVENTS.onWorkstreamInvalidated)}function invalidatePinnedWorkstreamCache(){pinnedWorkstreamCache.removeAll(),$rootScope.$broadcast(EVENTS.onWorkstreamInvalidated)}function invalidateAllCaches(){workstreamMessageCache.removeAll(),workstreamCache.removeAll(),pinnedWorkstreamCache.removeAll(),$rootScope.$broadcast(EVENTS.onWorkstreamInvalidated)}function postMessageWithAttachments(workstreamId,quillDelta,title,files,bypassErrorInterceptor,abortPromise){var data={quillDelta:quillDelta,title:title};return FileService.toAttachments(files).then(function(attachments){return attachments.length>0&&(data.files=attachments),JucoRestService.post(REST.workstream.BASE64(workstreamId),data,bypassErrorInterceptor,abortPromise).then(function(result){return invalidateWorkstreamCache(),result})})}function postMessageWithoutAttachments(workstreamId,quillDelta,title,bypassErrorInterceptor,abortPromise){var message={quillDelta:quillDelta,title:title};return JucoRestService.post(REST.workstream.BASE(workstreamId),message,bypassErrorInterceptor,abortPromise).then(function(data){return invalidateWorkstreamCache(),data})}function getWorkstream(workstreamId,params){var restUri=REST.workstream.WORKSTREAM(workstreamId);return JucoRestService.getCached(restUri,params,workstreamCache,cacheKey(workstreamId,params)).then(normalizeFeed)}function getPinnedWorkstream(workstreamId,params){var restUri=REST.workstream.PINNED_WORKSTREAM(workstreamId);return JucoRestService.getCached(restUri,params,pinnedWorkstreamCache,cacheKey(workstreamId,params)).then(normalizeFeed)}function hidePinnedWorkstream(workstreamId){return updatePinnedWorkstreamHiddenStatus(workstreamId,!0)}function unhidePinnedWorkstream(workstreamId){return updatePinnedWorkstreamHiddenStatus(workstreamId,!1)}function updatePinnedWorkstreamHiddenStatus(workstreamId,hidden){var restUri=REST.workstream.PINNED_WORKSTREAM_HIDDEN(workstreamId,hidden);return JucoRestService.put(restUri).then(function(data){return invalidatePinnedWorkstreamCache(),data})}function getMessage(msgId,numberOfCommentsToLoad){var restUri=REST.workstream.MESSAGE(msgId),params={numberOfCommentsToLoad:numberOfCommentsToLoad,newestCommentFirst:!1};return JucoRestService.getCached(restUri,params,workstreamMessageCache,msgId).then(normalize)}function deleteMessage(msgId){return JucoRestService.deleteCall(REST.workstream.MESSAGE(msgId)).then(function(data){return invalidateWorkstreamCache(),workstreamMessageCache.remove(msgId),data})}function postMessage(workstreamId,quillDeltaJson,title,files,bypassErrorInterceptor,abortPromise){var quillDelta=JSON.stringify(quillDeltaJson);return files&&files.length>0?postMessageWithAttachments(workstreamId,quillDelta,title,files,bypassErrorInterceptor,abortPromise):postMessageWithoutAttachments(workstreamId,quillDelta,title,bypassErrorInterceptor,abortPromise)}function updateMessage(messageId){function invalidateCaches(){invalidateWorkstreamCache(),workstreamMessageCache.remove(messageId)}var title=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",quillDeltaJson=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},addedFiles=arguments.length>3&&void 0!==arguments[3]?arguments[3]:[],deletedAttachments=arguments.length>4&&void 0!==arguments[4]?arguments[4]:[],abortPromise=arguments.length>5&&void 0!==arguments[5]?arguments[5]:void 0,quillDelta=JSON.stringify(quillDeltaJson),data={quillDelta:quillDelta,title:title,filesToDelete:deletedAttachments.map(function(attachment){return attachment.id}),filesToAdd:[]};return 0===addedFiles.length?JucoRestService.put(REST.workstream.MESSAGE(messageId),data).then(invalidateCaches):FileService.toAttachments(addedFiles).then(function(attachments){return data.filesToAdd=attachments,JucoRestService.put(REST.workstream.B64MESSAGE(messageId),data,!0,abortPromise).then(invalidateCaches)})}function likeMessage(msgId,like){return JucoRestService.put(REST.like.BASE(msgId),angular.toJson(like)).then(function(data){return invalidateWorkstreamCache(),workstreamMessageCache.remove(msgId),data})}function normalizeFeed(feed){return Object.assign(feed,{messages:feed.messages.map(normalize)})}function normalize(message){return Object.assign({attachments:[],title:"",text:"",quillDelta:"",like:{may:[],recentLikers:[],likeCount:0,iLike:!1},may:[],comments:{totalSize:0,subList:[]}},message)}var workstreamCache=Cache.createCache("workstream"),pinnedWorkstreamCache=Cache.createCache("pinnedWworkstream"),workstreamMessageCache=Cache.createCache("workstreamMessage");this.getWorkstream=getWorkstream,this.getPinnedWorkstream=getPinnedWorkstream,this.hidePinnedWorkstream=hidePinnedWorkstream,this.unhidePinnedWorkstream=unhidePinnedWorkstream,this.getMessage=getMessage,this.deleteMessage=deleteMessage,this.postMessage=postMessage,this.likeMessage=likeMessage,this.updateMessage=updateMessage,$rootScope.$on(EVENTS.onCommentDeleted,commentChangedListener),$rootScope.$on(EVENTS.onCommentCreated,commentChangedListener),$rootScope.$on(EVENTS.onProfileContactChanged,invalidateAllCaches),$rootScope.$on(EVENTS.onEntityMemberStatusChanged,invalidateAllCaches)}function ComposerImagePreviewController($window,FileService){"ngInject";var ctrl=this,isAttachment=!!ctrl.file.id&&!!ctrl.file.previewUrl;ctrl.$onInit=function(){ctrl.src="",ctrl.imagePreviewReady=!1,ctrl.isAttachment=isAttachment,ctrl.isAttachment?ctrl.imagePreviewReady=!0:ctrl.file instanceof Blob?FileService.blobToB64(ctrl.file).then(function(result){ctrl.src=result,ctrl.imagePreviewReady=!0}):(ctrl.src=FileService.addContentTypeToB64(ctrl.file,null),ctrl.imagePreviewReady=!0)},ctrl.removeAttachment=function(){ctrl.onRemoveAttachment({$event:{file:ctrl.file}})}}function FakeComposerController($state){"ngInject";var ctrl=this;ctrl.openComposer=function(files){var params={feedId:ctrl.feedId};files&&files.length>0&&(params.files=files),$state.go("main.feedMessageCreate",params)},ctrl.onFileSelect=function(files){files&&files.length>0&&ctrl.openComposer(files)}}function FeedController($scope,$rootScope,$transitions,FeedService,$state,EVENTS,ENUMS,FEED_MESSAGE_TYPE,FeedCache,DomUtil,CurrentUser,PromiseUtil){"ngInject";function initialFetchMessages(){ctrl.feed={messages:[],mayPost:!1,hasMore:!1},ctrl.pinnedFeed={messages:[],hasMore:!1},ctrl.loading=!0,ctrl.fetchingNextMessages=!0,ctrl.fetchingNextPinnedMessages=!0,$state.current.data&&$state.current.data.initialScrollTop&&DomUtil.scrollToYIfPossible(0,1),initialFetchDate=0,PromiseUtil.all([FeedService.getWorkstream(ctrl.feedId),FeedService.getPinnedWorkstream(ctrl.feedId)],function(workstream,pinnedWorkstream){ctrl.feed=createFeedFromRestData([],workstream),ctrl.pinnedFeed=createPinnedFeedFromRestData([],pinnedWorkstream),initialFetchDate=Date.now(),ctrl.loading=!1,ctrl.fetchingNextMessages=!1,ctrl.fetchingNextPinnedMessages=!1})["catch"](function(){ctrl.loading=!1,ctrl.fetchingNextMessages=!1,ctrl.fetchingNextPinnedMessages=!1,ctrl.showErrorMessage=!0})}function createFeedFromRestData(currentMessages,restData){return{messages:currentMessages.concat(restData.messages),mayPost:$state.current.data&&!$state.current.data.editorDisabled&&restData.may.indexOf(ENUMS.staticAction.CREATE)>-1,hasMore:restData.hasMore}}function createPinnedFeedFromRestData(currentMessages,restData){var pinnedFeed=createFeedFromRestData(currentMessages,restData);return pinnedFeed.hideDate=restData.hideDate,pinnedFeed}function fetchNextMessages(){var params=void 0;ctrl.fetchingNextMessages||(ctrl.fetchingNextMessages=!0,ctrl.feed.messages.length>0&&(params={offset:new Date(ctrl.feed.messages[ctrl.feed.messages.length-1].modifyDate).toISOString()}),FeedService.getWorkstream(ctrl.feedId,params).then(function(data){ctrl.feed=createFeedFromRestData(ctrl.feed.messages,data),ctrl.loading=!1,ctrl.fetchingNextMessages=!1,initialFetchDate||(initialFetchDate=Date.now())})["catch"](function(){ctrl.loading=!1,ctrl.showErrorMessage=!0}))}function saveScrollHeightOnLeaving(){scrollHeightOnLeaving=DomUtil.getScrollHeight()}function reloadFeedIfExpired(){isExpired(initialFetchDate)&&initialFetchMessages()}function isExpired(date){return Date.now()-date>cacheMaxAge}var ctrl=this,cacheKey=ctrl.feedId,cacheMaxAge=FeedCache.info().maxAge,scrollHeightOnLeaving=0,onStateChangeStartListenerDeregistration=void 0,initialFetchDate=0;ctrl.$onInit=function(){var cacheResult=FeedCache.get(cacheKey);ctrl.fetchingNextMessages=!1,ctrl.fetchingNextPinnedMessages=!1,ctrl.loading=!1,ctrl.showErrorMessage=!1,onStateChangeStartListenerDeregistration=$transitions.onExit({},saveScrollHeightOnLeaving),$scope.$on("jc-fetch-next-ws-messages",fetchNextMessages),$scope.$on(EVENTS.onAppResume,reloadFeedIfExpired),cacheResult&&!isExpired(cacheResult.initialFetchDate)?(ctrl.pinnedFeed=cacheResult.pinnedFeed,ctrl.feed=cacheResult.feed,initialFetchDate=cacheResult.initialFetchDate,DomUtil.scrollToYIfPossible(cacheResult.scrollHeight,3),FeedCache.remove(cacheKey)):initialFetchMessages(),$rootScope.$on(EVENTS.onWorkstreamInvalidated,FeedCache.removeAll)},ctrl.$onDestroy=function(){CurrentUser.isAuthenticated()&&!isExpired(initialFetchDate)&&(FeedCache.put(cacheKey,{pinnedFeed:ctrl.pinnedFeed,feed:ctrl.feed,initialFetchDate:initialFetchDate,scrollHeight:scrollHeightOnLeaving}),onStateChangeStartListenerDeregistration&&onStateChangeStartListenerDeregistration())},ctrl.fetchNextPinnedMessages=function(hasHiddenPinnedMessages){function handleError(){ctrl.fetchingNextPinnedMessages=!1,ctrl.showErrorMessage=!0}if(!ctrl.fetchingNextPinnedMessages)if(ctrl.fetchingNextPinnedMessages=!0,hasHiddenPinnedMessages)FeedService.unhidePinnedWorkstream(ctrl.feedId).then(function(){ctrl.pinnedFeed.hideDate=null,ctrl.pinnedFeed=Object.assign({},ctrl.pinnedFeed),ctrl.fetchingNextPinnedMessages=!1})["catch"](handleError);else{var params=void 0;ctrl.pinnedFeed.messages.length>0&&(params={offset:new Date(ctrl.pinnedFeed.messages[ctrl.pinnedFeed.messages.length-1].pinDate).toISOString()}),FeedService.getPinnedWorkstream(ctrl.feedId,params).then(function(data){ctrl.pinnedFeed=createPinnedFeedFromRestData(ctrl.pinnedFeed.messages,data),ctrl.fetchingNextPinnedMessages=!1})["catch"](handleError)}},ctrl.hidePinnedMessages=function(){ctrl.fetchingNextPinnedMessages||(ctrl.fetchingNextPinnedMessages=!0,FeedService.hidePinnedWorkstream(ctrl.feedId).then(function(hideDate){ctrl.pinnedFeed.hideDate=hideDate,ctrl.pinnedFeed=Object.assign({},ctrl.pinnedFeed),ctrl.fetchingNextPinnedMessages=!1})["catch"](function(){ctrl.fetchingNextPinnedMessages=!1,ctrl.showErrorMessage=!0}))}}function FeedAttachments(FEED_ATTACHMENT_TYPE,Environment,ContentTypeUtil,urlUtil){"ngInject";function isDriveImageAttachment(attachment){return attachment.type===FEED_ATTACHMENT_TYPE.DOCUMENT&&ContentTypeUtil.isSupportedImageContentType(attachment.mimeType)}function isImageAttachment(attachment){return attachment.type===FEED_ATTACHMENT_TYPE.IMAGE||isDriveImageAttachment(attachment)}function isVideoAttachment(attachment){return attachment.type===FEED_ATTACHMENT_TYPE.DOCUMENT&&ContentTypeUtil.isSupportedVideoContentType(attachment.mimeType)}function isMediaAttachment(attachment){return isImageAttachment(attachment)||isVideoAttachment(attachment)}function isNonMediaAttachment(attachment){return!isMediaAttachment(attachment)}function nonMediaAttachments(attachments){return attachments?attachments.filter(isNonMediaAttachment):[]}function mediaAttachments(attachments){return attachments?attachments.filter(isMediaAttachment):[]}function supportedAttachments(attachments){return attachments?attachments.filter(function(attachment){return SUPPORTED_ATTACHMENT_TYPES.indexOf(attachment.type)>-1}):[]}function imageAttachmentUrl(relativeUrl,isLegacyImageAttachment){var apiUrl=isLegacyImageAttachment?relativeUrl:Environment.getAbsoluteApiContext()+relativeUrl;return Environment.isCordova()?urlUtil.normalizeAbsolutePath(apiUrl,Environment.getServerBase()):apiUrl}function isLegacyImageAttachment(attachment){return attachment.type===FEED_ATTACHMENT_TYPE.IMAGE}function imageAttachmentDownloadUrl(imageAttachment){return imageAttachmentUrl(imageAttachment.url,isLegacyImageAttachment(imageAttachment))}function imageAttachmentPreviewUrl(imageAttachment){var legacyImageAttachment=isLegacyImageAttachment(imageAttachment),previewUrl=legacyImageAttachment?imageAttachment.url:imageAttachment.previewUrl;return imageAttachmentUrl(previewUrl,legacyImageAttachment)}var SUPPORTED_ATTACHMENT_TYPES=Object.values(FEED_ATTACHMENT_TYPE);this.isImageAttachment=isImageAttachment,this.isVideoAttachment=isVideoAttachment,this.mediaAttachments=mediaAttachments,this.nonMediaAttachments=nonMediaAttachments,this.supportedAttachments=supportedAttachments,this.imageAttachmentDownloadUrl=imageAttachmentDownloadUrl,this.imageAttachmentPreviewUrl=imageAttachmentPreviewUrl}function FeedDocumentAttachmentController(DocumentService){"ngInject";var ctrl=this;ctrl.$onInit=function(){ctrl.documentTag=DocumentService.getDocumentFileTypeTag(ctrl.attachment)},ctrl.onClick=function(){ctrl.ignoreClick||DocumentService.downloadDocument(ctrl.attachment.id)}}function FeedExternalVideoAttachmentController(urlUtil){"ngInject";function addHttpsIfNecessary(url){return urlUtil.hasProtocol(url)||url.length<2?url:"//"===url.substr(0,2)?"https:"+url:"https://"+url}function addHttpsInHtmlIfNecessary(html){return html.replace(/src="\/\//gi,'src="https://')}var ctrl=this;ctrl.$onInit=function(){ctrl.thumbnailURL=addHttpsIfNecessary(ctrl.attachment.thumbnailURL),ctrl.url=addHttpsIfNecessary(ctrl.attachment.url),ctrl.embedHTML=addHttpsInHtmlIfNecessary(ctrl.attachment.embedHTML)},ctrl.onClick=function(){ctrl.ignoreClick||(ctrl.showVideo=!0)}}function FeedImageAttachmentController(DocumentService,FeedAttachments,$window){"ngInject";function download(){DocumentService.getDocumentDownloadUrl(ctrl.attachment.id,!0).then(function(downloadUrl){$window.location.href=downloadUrl})}var ctrl=this;ctrl.$onInit=function(){ctrl.downloadUrl=FeedAttachments.imageAttachmentDownloadUrl(ctrl.attachment),ctrl.previewUrl=FeedAttachments.imageAttachmentPreviewUrl(ctrl.attachment),ctrl.onImageClicked=function(){ctrl.ignoreClick||download()}}}function FeedLinkAttachmentController(Environment,urlUtil){"ngInject";var ctrl=this;ctrl.$onInit=function(){ctrl.faviconUrl=Environment.isCordova()?urlUtil.normalizeAbsolutePath(ctrl.attachment.faviconUrl,Environment.getServerBase()):ctrl.attachment.faviconUrl}}function feedLinkAttachmentUrl(Environment,urlUtil,ExternalRefUtil,UrlTokenResolver){"ngInject";function link(scope,element,attributes){if(scope.url&&!scope.ignoreClick){var urlHash=urlUtil.getDesktopURLHash(scope.url);!urlHash||0!==urlHash.indexOf("#!")&&0!==urlHash.indexOf("#/")?handleUrl(element,attributes,scope.url):handleToken(element,urlHash)}}function handleToken(element,token){var processing=!1;element.on("click",function(){processing||(processing=!0,UrlTokenResolver.resolveToken(token).then(function(resolvedToken){UrlTokenResolver.handleToken(token,resolvedToken),processing=!1})["catch"](function(){processing=!1}))})}function handleUrl(element,attributes,url){Environment.isCordova()?element.on("click",function(){ExternalRefUtil.openUrl(url)}):(attributes.$set("href",url),attributes.$set("target","_blank"))}return{restrict:"A",scope:{url:"<feedLinkAttachmentUrl",ignoreClick:"<"},link:link}}function FeedMessageAttachment($compile,FEED_ATTACHMENT_TYPE,FeedAttachments){"ngInject";function createTemplate(attachment){if(FeedAttachments.isImageAttachment(attachment))return'<feed-image-attachment attachment="attachment" ignore-click="ignoreClick"></feed-image-attachment>';if(FeedAttachments.isVideoAttachment(attachment))return'<feed-video-attachment attachment="attachment" show-controls="!ignoreClick"></feed-video-attachment>';switch(attachment.type){case FEED_ATTACHMENT_TYPE.DOCUMENT:return'<feed-document-attachment attachment="attachment" ignore-click="ignoreClick"></feed-document-attachment>';case FEED_ATTACHMENT_TYPE.EXTERNAL_VIDEO:return'<feed-external-video-attachment attachment="attachment" ignore-click="ignoreClick"></feed-external-video-attachment>';case FEED_ATTACHMENT_TYPE.EXTERNAL_LINK:case FEED_ATTACHMENT_TYPE.INTERNAL_LINK:case FEED_ATTACHMENT_TYPE.MAILTO_LINK:return'<feed-link-attachment attachment="attachment" ignore-click="ignoreClick"></feed-link-attachment>';default:return""}}return{restrict:"E",replace:!0,scope:{attachment:"<",ignoreClick:"<"},link:function(scope,element){element.html(createTemplate(scope.attachment)),$compile(element.contents())(scope)}}}function FeedVideoAttachmentController(DriveService){"ngInject";var ctrl=this;ctrl.$onInit=function(){DriveService.getVideoPreview(ctrl.attachment.id).then(function(videoPreview){ctrl.previewReady=!0,ctrl.coverImage=videoPreview.coverImage,ctrl.videoUrl=videoPreview.video,ctrl.showControls=ctrl.showControls||void 0})["catch"](function(){ctrl.showControls=void 0,ctrl.showPreviewPendingHint=!0})}}function FeedCommentController($state,ENUMS,profileNameFilter,i18nextFilter){"ngInject";function buildMenu(){ctrl.menuItems=[],mayDeleteComment()&&ctrl.menuItems.push({i18nKey:"workstream.deleteComment",action:function(){ctrl.onDeleteComment({$event:{comment:comment}})}})}function mayDeleteComment(){return comment.may.indexOf(ENUMS.staticAction.DELETE)>-1}var ctrl=this,comment=ctrl.comment;ctrl.$onInit=function(){ctrl.liking=!1,ctrl.authorName=comment.author?profileNameFilter(comment.author):i18nextFilter("workstream.unknownAuthor"),buildMenu()},ctrl.$onChanges=function(changes){changes.comment&&buildMenu()},ctrl.goToAuthor=function(){comment.author&&!comment.author.deleted&&$state.go("main.profile",{profileId:comment.author.id})},ctrl.goToLikers=function(){$state.go("main.likers",{itemId:comment.id,appId:ctrl.appId})},ctrl.mayLikeOrUnlike=function(){return comment.like.may.indexOf(comment.like.iLike?ENUMS.staticAction.UNLIKE:ENUMS.staticAction.LIKE)>-1},ctrl.toggleLike=function(){ctrl.liking||(ctrl.liking=!0,ctrl.onToggleLike({$event:{id:comment.id,like:!comment.like.iLike}})["finally"](function(){ctrl.liking=!1}))},ctrl.handleMenuItemSelected=function(item){return item.action()}}function FeedCommentComposerController(CommentService,MessageHandler){"ngInject";function onError(error){ctrl.commenting=!1,error&&error.data&&"FORBIDDEN"===error.data.code?MessageHandler.error("workstream.postCommentPermissonDenied"):MessageHandler.error("workstream.postCommentFailed")}function validateComment(text){return!!text||(MessageHandler.error("workstream.commentMustNotBeEmpty"),!1)}var ctrl=this;ctrl.$onInit=function(){ctrl.commenting=!1,ctrl.expandCommentTextArea=!1,ctrl.text=""},ctrl.postComment=function(){ctrl.commenting||validateComment(ctrl.text)&&(ctrl.commenting=!0,CommentService.postComment(ctrl.messageId,ctrl.text,!0).then(function(){ctrl.commenting=!1,ctrl.text="",ctrl.expanded=!1})["catch"](onError))},ctrl.expand=function(){ctrl.expanded=!0}}function FeedCommentsController(CommentService,HtmlUtil,ArrayUtil,$rootScope,EVENTS){"ngInject";function setComments(comments){ctrl.comments=comments.subList,ctrl.comments.forEach(function(comment){comment.htmlText=HtmlUtil.escapeAndLinkify(comment.text)}),ctrl.moreCommentCount=comments.totalSize-ctrl.comments.length}function reloadComments(){CommentService.getComments(ctrl.messageId,!1,ctrl.comments.length).then(setComments)}var ctrl=this;ctrl.$onInit=function(){ctrl.comments=[],ctrl.moreCommentCount=0,CommentService.getComments(ctrl.messageId,!1,2).then(setComments),$rootScope.$on(EVENTS.onCommentDeleted,reloadComments),$rootScope.$on(EVENTS.onCommentCreated,reloadComments)},ctrl.loadAllComments=function(){CommentService.getComments(ctrl.messageId,!1).then(setComments)},ctrl.onToggleLike=function($event){return CommentService.likeComment($event.id,$event.like).then(function(data){var updatedComment=ArrayUtil.find(ctrl.comments,function(comment){return comment.id===$event.id});updatedComment.like=data})},ctrl.onDeleteComment=function($event){ctrl.showCommentDeleteDialog=!0,ctrl.commentToDelete=$event.comment},ctrl.abortDeleteComment=function(){ctrl.showCommentDeleteDialog=!1,ctrl.commentToDelete=null},ctrl.deleteComment=function(){ctrl.showCommentDeleteDialog=!1,CommentService.deleteComment(ctrl.commentToDelete.id,ctrl.commentToDelete.parentId)}}function FeedMessageController(FEED_MESSAGE_TYPE,FeedAttachments){"ngInject";var ctrl=this;ctrl.$onInit=function(){var supportedAttachments=FeedAttachments.supportedAttachments(ctrl.message.attachments);ctrl.isActivityMessage=ctrl.message.messageType!==FEED_MESSAGE_TYPE.MICROBLOG_POSTING,ctrl.hasTitle=ctrl.message.title.length>0,ctrl.hasContent=ctrl.message.text.length>0||ctrl.message.quillDelta.length>0,ctrl.hasSupportedAttachments=supportedAttachments.length>0,ctrl.mediaAttachments=FeedAttachments.mediaAttachments(supportedAttachments),ctrl.hasMediaAttachments=ctrl.mediaAttachments.length>0},ctrl.showDetails=function(){ctrl.onShowDetails({$event:{messageId:ctrl.message.id}})}}function FeedMessageActionsController(FEED_MESSAGE_TYPE,ENUMS){"ngInject";var ctrl=this;ctrl.$onInit=function(){var message=ctrl.message,isMicroblogPosting=message.messageType===FEED_MESSAGE_TYPE.MICROBLOG_POSTING,likeAction=message.like.iLike?ENUMS.staticAction.UNLIKE:ENUMS.staticAction.LIKE;ctrl.mayComment=isMicroblogPosting&&message.may.indexOf(ENUMS.staticAction.COMMENT)>-1,ctrl.mayLikeOrUnlike=isMicroblogPosting&&message.like.may.indexOf(likeAction)>-1}}function FeedMessageAttachmentsController(FeedAttachments){"ngInject";var ctrl=this;ctrl.$onInit=function(){if(ctrl.attachments){var supportedAttachments=FeedAttachments.supportedAttachments(ctrl.attachments);ctrl.hasSupportedAttachments=supportedAttachments.length>0,ctrl.hasUnsupportedAttachments=supportedAttachments.length<ctrl.attachments.length,ctrl.mediaAttachments=FeedAttachments.mediaAttachments(supportedAttachments),ctrl.nonMediaAttachments=FeedAttachments.nonMediaAttachments(supportedAttachments),ctrl.hasMediaAttachments=ctrl.mediaAttachments.length>0,ctrl.hasNonMediaAttachments=ctrl.nonMediaAttachments.length>0}}}function FeedActivityMessage(FeedActivityMessageTranslationService,ResourceStateService,EVENTS){"ngInject";function link(scope,$element){function renderMessage(){var translationResult=FeedActivityMessageTranslationService.translateMessage(scope.message,scope);translationResult?($element.html(translationResult.translation),replaceLinks(translationResult.linkMap)):$element.html("")}function replaceLinks(linkMap){linkMap&&Object.keys(linkMap).forEach(function(id){var placeholders=$element[0].getElementsByClassName(id);Array.prototype.forEach.call(placeholders,function(placeholder){var linkFunction=linkMap[id];if(linkFunction){var $link=linkFunction(scope);angular.element(placeholder).replaceWith($link)}})})}scope.goToResource=ResourceStateService.goToResource,scope.$on(EVENTS.i18nextLanguageChange,renderMessage),renderMessage()}return{restrict:"E",scope:{message:"<"},link:link}}function FeedActivityMessageTranslationService(FEED_MESSAGE_TYPE,HtmlUtil,StringUtil,UUID,$compile,$i18next){"ngInject";function translateEntityMessage(message,additionalTranslationOptions,scope){var entityLinkId=UUID.generate(),translationOptions=angular.extend({context:message.entityType,entityLink:linkPlaceholder(entityLinkId)},additionalTranslationOptions||{}),translation=translate(message.messageType,translationOptions),linkMap={};return linkMap[entityLinkId]=createResourceLinkFunction(message.originId,message.entityName,scope),{translation:translation,linkMap:linkMap}}function translateDocumentMessage(message,additionalTranslationOptions,scope){var documentLinkId=UUID.generate(),translationOptions=angular.extend({documentLink:linkPlaceholder(documentLinkId)},additionalTranslationOptions||{}),translation=translate(message.messageType,translationOptions),linkMap={};return linkMap[documentLinkId]=createResourceLinkFunction(message.documentId,message.documentName,scope),{translation:translation,linkMap:linkMap}}function translateProfileNewContactMessage(message,scope){var friendLinkId=UUID.generate(),translation=translate(message.messageType,{context:message.author.gender,friendLink:linkPlaceholder(friendLinkId)}),linkMap={};return linkMap[friendLinkId]=createResourceLinkFunction(message.friendId,message.friendName,scope),{translation:translation,linkMap:linkMap}}function translateEntityVersionPublishedMessage(message){var versionTranslation=translate(message.messageType,{context:message.entityType,entityVersion:HtmlUtil.escapeHtml(message.version)}),translation=void 0;if(StringUtil.isBlank(message.changeMessage))translation=versionTranslation;else{var changeMessageTranslation=translate("entityVersionChangeMessage",{context:message.entityType,changeMessage:HtmlUtil.escapeHtml(message.changeMessage)});translation=[versionTranslation,changeMessageTranslation].join(" ")}return{translation:translation}}function translationTaskStatusChangedMessage(message,scope){var entityStatusTranslated=translateEntityStatus(message.status,message.entityType),iconId=UUID.generate(),iconPlaceholder=linkPlaceholder(iconId),iconAndStatus=[iconPlaceholder,entityStatusTranslated].join(" "),translation=translate(message.messageType,{entityStatus:iconAndStatus}),linkMap={};return linkMap[iconId]=createIconFunction(message.icon,scope),{translation:translation,linkMap:linkMap}}function translateTaskAssignedMessage(message,scope){var assignee=message.assignee,profileLinkId=void 0,translation=void 0,linkMap=void 0;return assignee?(profileLinkId=UUID.generate(),translation=translate(message.messageType,{profileLink:linkPlaceholder(profileLinkId)}),linkMap={},linkMap[profileLinkId]=createProfileLinkFunction(assignee,scope)):translation=translate("taskUnassigned"),{translation:translation,linkMap:linkMap}}function createProfileLinkFunction(person,scope){var html='<a class="jc-click-link app-connect-color" ng-click="goToResource(person.id, $event)">{{ person | profileName }}</a>';return scope.person=person,$compile(html)}function createIconFunction(icon,scope){var html='<i class="fa3 fa" ng-class="icon"></i>';return scope.icon=icon,$compile(html)}function linkPlaceholder(linkId){return'<span class="'+linkId+'"></span>'}function translate(keySuffix,options){var key=translationPrefix+keySuffix.replace(/_/g,"-");return $i18next(key,options)}function translateEntityStatus(status,entityType){var key="entityStatus."+status.replace(/_/g,"-");return $i18next(key,{context:entityType})}function createResourceLinkFunction(resourceId,resourceName,scope){var html='<a class="jc-click-link app-connect-color" ng-click="goToResource(resourceId, $event)">{{ resourceName }}</a>';return scope.resourceId=resourceId,scope.resourceName=resourceName,$compile(html)}var translationPrefix="workstreamActivityMessage.";this.translateMessage=function(message,scope){switch(message.messageType){case FEED_MESSAGE_TYPE.MICROBLOG_POSTING:return;case FEED_MESSAGE_TYPE.ENTITY_CREATED:case FEED_MESSAGE_TYPE.ENTITY_NEW_MEMBERSHIP:case FEED_MESSAGE_TYPE.ENTITY_DESCRIPTION_UPDATED:case FEED_MESSAGE_TYPE.ENTITY_PARENTS_CHANGED:return translateEntityMessage(message,void 0,scope);case FEED_MESSAGE_TYPE.WIKI_VERSION_CREATED:return translateEntityMessage(message,{wikiVersion:HtmlUtil.escapeHtml(message.version)},scope);case FEED_MESSAGE_TYPE.DOCUMENT_NEW:return;case FEED_MESSAGE_TYPE.DRIVE_DOCUMENT_NEW_VERSION:
case FEED_MESSAGE_TYPE.DOCUMENT_NEW_VERSION:return translateDocumentMessage(message,{documentVersion:HtmlUtil.escapeHtml(message.documentVersion)},scope);case FEED_MESSAGE_TYPE.DRIVE_DOCUMENT_COMMENT:case FEED_MESSAGE_TYPE.DOCUMENT_COMMENT:return translateDocumentMessage(message,void 0,scope);case FEED_MESSAGE_TYPE.VIDEOLINK_CREATED:case FEED_MESSAGE_TYPE.VIDEOLINK_COMMENTED:return{translation:translate(message.messageType,{videoTitle:HtmlUtil.escapeHtml(message.videoTitle)})};case FEED_MESSAGE_TYPE.PROFILE_UPDATED:return{translation:translate(message.messageType)};case FEED_MESSAGE_TYPE.PROFILE_NEW_CONTACT:return translateProfileNewContactMessage(message,scope);case FEED_MESSAGE_TYPE.ENTITY_VERSION_PUBLISHED:return translateEntityVersionPublishedMessage(message);case FEED_MESSAGE_TYPE.SURVEY_PUBLISHED:return{translation:translate(message.messageType,{surveyTitle:HtmlUtil.escapeHtml(message.surveyTitle)})};case FEED_MESSAGE_TYPE.TASK_STATUS_CHANGED:return translationTaskStatusChangedMessage(message,scope);case FEED_MESSAGE_TYPE.TASK_ASSIGNED:return translateTaskAssignedMessage(message,scope);default:return{translation:translate("unknownType",{messageType:message.messageType})}}}}function FeedMessageContentController(FEED_MESSAGE_TYPE){"ngInject";var ctrl=this;ctrl.$onInit=function(){ctrl.isActivityMessage=ctrl.message.messageType!==FEED_MESSAGE_TYPE.MICROBLOG_POSTING}}function FeedMessageCoverController(){var ctrl=this;ctrl.$onInit=function(){ctrl.mediaAttachments.length>0&&(ctrl.coverAttachment=ctrl.mediaAttachments[0]),ctrl.totalAttachmentCount=ctrl.mediaAttachments.length}}function FeedMessageCreateController($state,$q,FeedService,MessageHandler,$log,ResourceType,IdUtil){"ngInject";function returnToTarget(){var resourceType=IdUtil.getResourceType(ctrl.targetId);resourceType===ResourceType.ENTITY?$state.go("main.entity.workstream",{entityId:ctrl.targetId}):($log.warn("workstream composer: unknown target resource type "+resourceType),$state.go("main.start"))}function abortUpload(){ctrl.uploading&&(uploadAborted=!0,abortUploadPromise.resolve())}function post($event){ctrl.uploading||(ctrl.uploading=!0,abortUploadPromise=$q.defer(),FeedService.postMessage(ctrl.targetId,$event.content,$event.title,$event.files,!0,abortUploadPromise.promise).then(returnToTarget)["catch"](function(error){var errorMsg=void 0,errorCode=error.data?error.data.code:"";return uploadAborted?void(uploadAborted=!1):(errorMsg="FORBIDDEN"===errorCode?"workstream.composerPostPermissionDenied":"workstream.composerPostFailed",void MessageHandler.error(errorMsg))})["finally"](function(){ctrl.uploading=!1}))}var ctrl=this,abortUploadPromise=void 0,uploadAborted=!1;ctrl.$onInit=function(){ctrl.cancel=returnToTarget,ctrl.post=post,ctrl.abortUpload=abortUpload,ctrl.uploading=!1}}function FeedMessageDetailsController(FEED_MESSAGE_TYPE,ENUMS,FeedAttachments,FeedService,ResourceStateService,$state){"ngInject";var ctrl=this;ctrl.$onInit=function(){var supportedAttachments=FeedAttachments.supportedAttachments(ctrl.message.attachments),mediaAttachments=FeedAttachments.mediaAttachments(supportedAttachments),nonMediaAttachments=FeedAttachments.nonMediaAttachments(supportedAttachments);ctrl.hasTitle=ctrl.message.title.length>0,ctrl.hasContent=ctrl.message.text.length>0||ctrl.message.quillDelta.length>0,ctrl.hasSupportedAttachments=supportedAttachments.length>0,ctrl.hasMediaAttachments=mediaAttachments.length>0,ctrl.coverAttachment=ctrl.hasMediaAttachments?mediaAttachments[0]:void 0,ctrl.attachments=(ctrl.hasMediaAttachments?mediaAttachments.slice(1):[]).concat(nonMediaAttachments),ctrl.mayComment=!1,ctrl.mayLikeOrUnlike=!1,ctrl.isActivityMessage=!0,ctrl.deleteDialogVisible=!1,ctrl.message.messageType===FEED_MESSAGE_TYPE.MICROBLOG_POSTING&&(ctrl.mayComment=ctrl.message.may.indexOf(ENUMS.staticAction.COMMENT)>-1,ctrl.mayLikeOrUnlike=ctrl.message.like.may.indexOf(ctrl.message.like.iLike?ENUMS.staticAction.UNLIKE:ENUMS.staticAction.LIKE)>-1,ctrl.isActivityMessage=!1)},ctrl.showDeleteDialog=function(){ctrl.deleteDialogVisible=!0},ctrl.hideDeleteDialog=function(){ctrl.deleteDialogVisible=!1},ctrl.deleteMessage=function(){FeedService.deleteMessage(ctrl.message.id).then(function(){ctrl.hideDeleteDialog(),ResourceStateService.goToResource(ctrl.message.originId,!0)})},ctrl.editMessage=function(){$state.go("main.feedMessage.edit",{})}}function FeedMessageEditController($state,$q,FeedService,MessageHandler){"ngInject";function returnToMessage(){$state.go("main.feedMessage",{messageId:ctrl.message.id},{reload:!0})}var _this6=this,ctrl=this,abortUploadPromise=void 0,uploadAborted=!1;ctrl.$onInit=function(){ctrl.uploading=!1},ctrl.cancel=returnToMessage,ctrl.abortUpload=function(){ctrl.uploading&&(uploadAborted=!0,abortUploadPromise.resolve())},ctrl.post=function($event){if(!ctrl.uploading){ctrl.uploading=!0,abortUploadPromise=$q.defer();var title=$event.title,content=$event.content,files=$event.files,originalFiles=ctrl.message.attachments,addedFiles=files.filter(function(f){return originalFiles.indexOf(f)<0}),removedFiles=originalFiles.filter(function(f){return files.indexOf(f)<0});FeedService.updateMessage(ctrl.message.id,title,content,addedFiles,removedFiles,abortUploadPromise.promise).then(returnToMessage)["catch"](function(error){var errorCode=error.data?error.data.code:"";return uploadAborted?void(uploadAborted=!1):void MessageHandler.error("FORBIDDEN"===errorCode?"workstream.composerPostPermissionDenied":"workstream.composerPostFailed")})["finally"](function(){_this6.uploading=!1})}}}function FeedMessageHeaderController(ResourceStateService,FEED_MESSAGE_TYPE,ENUMS){"ngInject";function getAvailableMenuItems(){var result=[];return ctrl.displayActions&&mayEditMessage()&&result.push({i18nKey:"workstream.editPost",action:ctrl.onEditMessage}),ctrl.displayActions&&mayDeleteMessage()&&result.push({i18nKey:"workstream.deletePost",action:ctrl.onShowDeleteDialog}),result}function mayEditMessage(){return ctrl.message.messageType===FEED_MESSAGE_TYPE.MICROBLOG_POSTING&&ctrl.message.may.indexOf(ENUMS.staticAction.EDIT)>-1}function mayDeleteMessage(){return ctrl.message.messageType===FEED_MESSAGE_TYPE.MICROBLOG_POSTING&&ctrl.message.may.indexOf(ENUMS.staticAction.DELETE)>-1}var ctrl=this;ctrl.$onInit=function(){ctrl.menuItems=getAvailableMenuItems()},ctrl.goToAuthor=function(){ctrl.message.author&&!ctrl.message.author.deleted&&ResourceStateService.goToResource(ctrl.message.author.id)},ctrl.goToOrigin=function(){ctrl.feedId!==ctrl.message.originId&&ResourceStateService.goToResource(ctrl.message.originId)},ctrl.handleMenuItemSelected=function(item){return item.action()}}function FeedMessageInputController(FileService,EntityService,MessageHandler,IdUtil,ResourceType,$q){"ngInject";function getTargetName(){var resourceType=IdUtil.getResourceType(ctrl.targetId);return resourceType===ResourceType.ENTITY?EntityService.getEntityById(ctrl.targetId).then(function(entity){return entity.name}):$q.resolve("")}function validate(){return!!hasText()||(MessageHandler.error("workstream.composerPostMustNotBeEmpty"),!1)}function overrideLinkPlaceholder(quill){quill.theme.tooltip.textbox.setAttribute("data-link",linkPlaceholder)}function hasText(){return quill&&quill.getText()&&quill.getText().trim().length>0}function hasAttachments(){return ctrl.files&&ctrl.files.length>0}function hasTitle(){return ctrl.title&&ctrl.title.trim().length>0}function isEmpty(){return!hasText()&&!hasAttachments()&&!hasTitle()}var ctrl=this,linkPlaceholder="https://just.social",quill=void 0;ctrl.$onInit=function(){if(ctrl.numFilteredFiles=0,ctrl.showCancelDialog=!1,ctrl.quillEditorModules={toolbar:[["bold","italic"],[{list:"bullet"},{list:"ordered"}],["link"]]},ctrl.files=ctrl.files||[],ctrl.message){var message=Object.assign({},ctrl.message);message.quillDelta?(ctrl.format="json",ctrl.content=message.quillDelta):(ctrl.format="html",ctrl.content=message.text),ctrl.title=message.title,ctrl.onFilesSelected(Object.assign([],message.attachments)),ctrl.author=message.author,ctrl.targetName=message.originName,ctrl.targetId=message.originId}else getTargetName().then(function(targetName){ctrl.targetName=targetName})},ctrl.post=function(){validate()&&ctrl.onPost({$event:{title:ctrl.title,content:quill.editor.delta,files:ctrl.files}})},ctrl.requestCancel=function(){isEmpty()?ctrl.onCancel():ctrl.showCancelDialog=!0},ctrl.abortCancel=function(){ctrl.showCancelDialog=!1},ctrl.removeAttachment=function($event){var index=ctrl.files.indexOf($event.file);index>-1&&ctrl.files.splice(index,1)},ctrl.onFilesSelected=function(files){if(files&&0!==files.length){var images=files.filter(FileService.isImage);ctrl.files=ctrl.files.concat(images),ctrl.numFilteredFiles+=files.length-images.length}},ctrl.onEditorCreated=function(quillEditor){quill=quillEditor,overrideLinkPlaceholder(quill)}}function FeedMessageLikesController(FeedService){"ngInject";var ctrl=this;ctrl.$onInit=function(){ctrl.liking=!1,ctrl.like=Object.assign({},ctrl.message.like)},ctrl.toggleLike=function(){ctrl.liking||(ctrl.liking=!0,FeedService.likeMessage(ctrl.message.id,!ctrl.like.iLike).then(function(data){ctrl.like=data})["finally"](function(){ctrl.liking=!1}))}}function FeedMessagesController($state){"ngInject";var ctrl=this;ctrl.goToDetails=function($event){$state.go("main.feedMessage",{messageId:$event.messageId})}}function PinnedFeedMessageController(ResourceStateService,$state){"ngInject";var ctrl=this;ctrl.$onInit=function(){ctrl.title=ctrl.message.title||ctrl.message.text},ctrl.goToDetails=function(){$state.go("main.feedMessage",{messageId:ctrl.message.id})},ctrl.goToAuthor=function(){ctrl.message.author&&!ctrl.message.author.deleted&&$state.go("main.profile",{profileId:ctrl.message.author.id})}}function PinnedFeedMessagesController(){function updateFeedMetaData(feed){var hideDate=void 0,pinDate=void 0,message=void 0,i=void 0;if(ctrl.hasHiddenPinnedMessages=!1,ctrl.hasPinnedMessagesToShow=!1,ctrl.hasNewHiddenPinnedMessages=!1,feed.hideDate)for(hideDate=new Date(feed.hideDate),i=0;i<feed.messages.length;i++)message=feed.messages[i],pinDate=new Date(message.pinDate),pinDate<hideDate?(ctrl.hasHiddenPinnedMessages=!0,new Date(message.modifyDate)>=hideDate&&(ctrl.hasNewHiddenPinnedMessages=!0)):ctrl.hasPinnedMessagesToShow=!0;else ctrl.hasPinnedMessagesToShow=feed.messages.length>0}var ctrl=this;ctrl.$onInit=function(){ctrl.hasHiddenPinnedMessages=!1,ctrl.hasPinnedMessagesToShow=!1,ctrl.hasNewHiddenPinnedMessages=!1,updateFeedMetaData(ctrl.feed)},ctrl.$onChanges=function(changes){changes.feed&&updateFeedMetaData(ctrl.feed)},ctrl.showMessage=function(message){var hideDate=ctrl.feed.hideDate,pinDate=message.pinDate;return!hideDate||!pinDate||new Date(pinDate)>=new Date(hideDate)}}function LikesController(LikeService,$scope,$state){"ngInject";function loadLikers(){ctrl.loading=!0,LikeService.getLikers(ctrl.itemId,offset,limit).then(function(likers){0===offset?ctrl.likers=likers:ctrl.likers=ctrl.likers.concat(likers),offset=ctrl.likers.length,ctrl.hasMoreResults=likers.length===limit})["finally"](function(){ctrl.loading=!1})}function loadNextLikers(){!ctrl.loading&&ctrl.hasMoreResults&&loadLikers()}var ctrl=this,limit=30,offset=0;ctrl.goTo=function(profileId){return $state.go("main.profile",{profileId:profileId})},ctrl.$onInit=function(){ctrl.likers=[],ctrl.loading=!1,loadLikers(),$scope.$on("jc-fetch-next-likers",loadNextLikers)}}function ChatDeprecatedController(ExternalRefUtil,Environment,$window,$scope,$state,ChatDeprecatedState){function init(){if(self.appInstalled=!0,self.destroyed=!1,self.onInstall=onInstall,ChatDeprecatedState.shouldBeSkipped)return void skipCurrentState();beforeDestroy(function(){self.terminating=!0});var openAppUrl=Environment.isIos()?IOS_OPEN_APP_URL:ANDROID_OPEN_APP_URL;ExternalRefUtil.openApp(openAppUrl).then(skipCurrentState)["catch"](showAppInstallationInstructions)}function onInstall(){var storeUrl=Environment.isIos()?APP_STORE_URL:PLAY_STORE_URL;ExternalRefUtil.openUrl(storeUrl)}function skipCurrentState(){self.terminating?ChatDeprecatedState.shouldBeSkipped=!0:(ChatDeprecatedState.shouldBeSkipped=!1,$window.history.back())}function showAppInstallationInstructions(){self.appInstalled=!1}function beforeDestroy(action){$scope.$on("$stateChangeStart",function(event,toState,toParams,fromState){fromState.url===$state.current.url&&action()})}var self=this,ANDROID_OPEN_APP_URL="just://connect/",IOS_OPEN_APP_URL="justconnect:default",PLAY_STORE_URL="https://play.google.com/store/apps/details?id=de.justsoftware.mobile.chat",APP_STORE_URL="https://itunes.apple.com/de/app/just-connect/id1296211683";init()}function TaskAssignmentController(SearchService,TaskService,$scope,$state,$timeout){"ngInject";function debounce(fn){var debounceDelay=200;$timeout.cancel(pendingDebounce),pendingDebounce=$timeout(fn,debounceDelay)}function suggestProfiles(){ctrl.loading=!0,SearchService.suggestProfiles(ctrl.query,offset,30).then(function(searchResult){return 0===offset?ctrl.profiles=searchResult.teasers:ctrl.profiles=ctrl.profiles.concat(searchResult.teasers),offset=ctrl.profiles.length,ctrl.hasMoreResults=searchResult.numberOfResults>ctrl.profiles.length,searchResult})["finally"](function(){ctrl.loading=!1})}var ctrl=this,offset=0,pendingDebounce=void 0;ctrl.assignUser=function(profileId){return TaskService.saveAssignee(ctrl.taskId,profileId).then(function(taskDetails){return $state.go("main.task.details",{id:ctrl.taskId}),taskDetails})["catch"](function(){return ctrl.error="task.errorSavingAssignee"})},ctrl.updateQuery=function(event){return debounce(function(){ctrl.query!==event.target.value&&(ctrl.query=event.target.value,offset=0,suggestProfiles())})},ctrl.$onInit=function(){ctrl.query="",ctrl.profiles=[],ctrl.loading=!1,suggestProfiles(),$scope.$on("jc-fetch-next-task-assignable-users",function(){ctrl.loading||suggestProfiles()})}}function TaskController(TaskService,TaskStatus,$state){"ngInject";var ctrl=this;ctrl.showDetails=function(){return $state.go("main.task.details",{id:ctrl.teaser.id})},ctrl.valueChanged=function(newValue){ctrl.checked=newValue,TaskService.setTaskStatus(ctrl.teaser.id,ctrl.checked?TaskStatus.COMPLETED:TaskStatus.OPEN)},ctrl.$onInit=function(){ctrl.checked=ctrl.teaser.status===TaskStatus.COMPLETED}}function TaskDetailsController($rootScope,$scope,$timeout,TaskService,MessageHandler,$state,TaskStatus,PromiseUtil,profileNameFilter,dateFilter,$i18next,ChangeWatcher){"ngInject";function profileIdOrUndefined(profile){return profile?profile.id:void 0}function onTaskLoadError(){ctrl.loading=!1,MessageHandler.error("task.errorLoadingTask"),ctrl.error="task.errorLoadingTask"}function onStateChangeError(){$rootScope.showViewLoading=!1,ctrl.showErrorDialog=!0}function closeDialog(){ctrl.showErrorDialog=!1,ctrl.showOptionsDialog=!1,ctrl.showDeleteTaskConfirmDialog=ctrl.isDeletingTask,ctrl.showDatePicker=!1}function openDeleteTaskConfirmDialog(){ctrl.showDeleteTaskConfirmDialog=!0}function saveChangedValues(){return changeWatcher.saveChangedValues()["catch"](function(err){return MessageHandler.error("task.errorSavingChanges"),PromiseUtil.immediateReject(err)})}function getParentAndSetHeader(parentId){TaskService.setParentTitleAsHeader(parentId,profileIdOrUndefined(ctrl.task.owner),profileIdOrUndefined(ctrl.task.assignee)).then(function(parentName){return ctrl.parentName=parentName})}function initTaskOptions(task){task.assignable&&ctrl.taskOptions.push({label:"task.assignUser",icon:"fa-user",action:function(){return $state.go("main.task.details.assign",{id:ctrl.taskId})}}),task.titleEditable&&ctrl.taskOptions.push({label:"task.editTitle",icon:"fa-pencil",action:function(){closeDialog(),ctrl.shouldFocusTitle=!0}}),task.dueDateEditable&&ctrl.taskOptions.push({label:"task.editDueDate",icon:"fa-clock-o",action:function(){closeDialog(),ctrl.showDatePicker=!0}}),task.deletable&&ctrl.taskOptions.push({label:"task.deleteTask",icon:"fa-trash-o",action:function(){closeDialog(),openDeleteTaskConfirmDialog()}})}function onTaskRetrieved(taskDetails){ctrl.task=taskDetails.task,ctrl.name=taskDetails.task.name.trim(),ctrl.titleEditable=taskDetails.task.titleEditable,ctrl.taskCompleted=taskDetails.task.status===TaskStatus.COMPLETED,ctrl.statusChangeable=taskDetails.task.statusChangeable,ctrl.description=taskDetails.description.trim(),ctrl.descriptionEditable=taskDetails.task.descriptionEditable,ctrl.assignee={id:profileIdOrUndefined(taskDetails.task.assignee),name:taskDetails.task.assignee?profileNameFilter(taskDetails.task.assignee):$i18next("task.nobody")},ctrl.dueDate=taskDetails.task.dueDate,ctrl.createdBy=profileNameFilter(taskDetails.task.owner),ctrl.createdAt=dateFilter(taskDetails.task.createDate,$i18next("date.dateTimeFormat")),ctrl.isSubTask=TaskService.isTaskId(taskDetails.task.parentId),initTaskOptions(taskDetails.task),ctrl.loading=!1,getParentAndSetHeader(taskDetails.task.parentId)}function saveDescription(){return TaskService.saveDescription(ctrl.taskId,ctrl.description)}function saveTitle(){return TaskService.saveTitle(ctrl.taskId,ctrl.name)}function saveDueDate(){return TaskService.saveDueDate(ctrl.taskId,ctrl.dueDate)}function initWatchers(){changeWatcher.watchValue($scope,"$ctrl.description",saveDescription),changeWatcher.watchValue($scope,"$ctrl.name",saveTitle),changeWatcher.watchValue($scope,"$ctrl.dueDate",saveDueDate)}var ctrl=this,changeWatcher=void 0;ctrl.deleteTask=function(){ctrl.isDeletingTask||(ctrl.isDeletingTask=!0,TaskService.deleteTask(ctrl.taskId).then(function(){var parentId=ctrl.task.parentId;"main.task.createdByMe"===ctrl.previousState.name?$state.go("main.task.createdByMe",{showBackButton:!1}):"main.task.assignedToMe"===ctrl.previousState.name?$state.go("main.task.assignedToMe",{showBackButton:!1}):TaskService.isTaskListId(parentId)?$state.go("main.task.list",{id:parentId,showBackButton:!1}):TaskService.isTaskId(parentId)?$state.go("main.task.details",{id:parentId,showBackButton:!1}):$state.go("main.task.assignedToMe",{showBackButton:!1})})["catch"](function(){return MessageHandler.error("task.errorDeletingTask")})["finally"](function(){ctrl.isDeletingTask=!1}))},ctrl.openDeleteTaskConfirmDialog=openDeleteTaskConfirmDialog,ctrl.closeDialog=closeDialog,ctrl.openOptionsDialog=function(){return ctrl.showOptionsDialog=!0},ctrl.taskStatusChanged=function(newValue){ctrl.taskCompleted=newValue,TaskService.setTaskStatus(ctrl.task.id,ctrl.taskCompleted?TaskStatus.COMPLETED:TaskStatus.OPEN)["catch"](function(){MessageHandler.error("task.errorSettingTaskStatus"),ctrl.taskCompleted=!newValue})},ctrl.saveChangedValues=saveChangedValues,ctrl.doForceStateChange=function(){return changeWatcher.doForceStateChange()},ctrl.retrySavingChanges=function(){return changeWatcher.retrySavingChanges()["catch"](onStateChangeError)},ctrl.goToProfile=function(id){id&&$state.go("main.profile",{profileId:id})},ctrl.removeDueDate=function(){ctrl.dueDate=null,closeDialog(),$timeout(saveChangedValues)},ctrl.onDateSelected=function(){closeDialog(),saveChangedValues()},ctrl.getFormattedDueDate=function(){return ctrl.dueDate?dateFilter(ctrl.dueDate,$i18next("date.dateFormat")):$i18next("task.noDueDate")},ctrl.titleChanged=function($event){ctrl.name=$event.title&&$event.title.trim()},ctrl.$onInit=function(){changeWatcher=ChangeWatcher.create(),ctrl.taskOptions=[],ctrl.loading=!0,changeWatcher.saveAllBeforeStateChange($scope,onStateChangeError),TaskService.getTaskById(ctrl.taskId).then(onTaskRetrieved)["catch"](onTaskLoadError).then(initWatchers)}}function TaskListsController($state,TaskService,MessageHandler){"ngInject";var ctrl=this;ctrl.goToList=function(listId){return $state.go("main.task.list",{id:listId})},ctrl.$onInit=function(){ctrl.taskLists=[],ctrl.loading=!0,TaskService.getMyTaskLists().then(function(taskLists){return ctrl.taskLists=taskLists})["catch"](function(){MessageHandler.error("task.errorLoadingMyLists"),ctrl.error="task.errorLoadingMyLists"})["finally"](function(){return ctrl.loading=!1})}}function TaskTitleEditorController($scope,$timeout,$window){"ngInject";function onFocusChanged(doFocus){doFocus&&$timeout(function(){$window.document.getElementById("task-title-editor").focus()})}function onTitleChanged(title){ctrl.onTitleChanged({$event:{title:title}})}function onSubmit(){$window.document.getElementById("task-title-editor").blur(),ctrl.onSave()}function onBlur(){ctrl.focus=!1,ctrl.onSave()}function onFocus(){ctrl.focus=!0}var ctrl=this;ctrl.$onInit=function(){ctrl.onSubmit=onSubmit,ctrl.onBlur=onBlur,ctrl.onFocus=onFocus,$scope.$watch("$ctrl.focus",onFocusChanged),$scope.$watch("$ctrl.title",onTitleChanged)}}function TasksController($scope,TaskService,HeaderTitleService,MessageHandler,PromiseUtil,TaskStatus,TaskFilter){"ngInject";function onOpenTasksLoaded(openTasks){var totalOpen=openTasks.countByStatus[TaskStatus.OPEN];ctrl.openTasks=ctrl.openTasks.concat(openTasks.tasks),ctrl.hasMoreOpenTasks=totalOpen>ctrl.openTasks.length}function onCompletedTasksLoaded(completedTasks){var totalCompleted=completedTasks.countByStatus[TaskStatus.COMPLETED];ctrl.completedTasks=completedTasks?ctrl.completedTasks.concat(completedTasks.tasks):ctrl.completedTasks,ctrl.hasMoreCompletedTasks=totalCompleted>ctrl.completedTasks.length,ctrl.hasCompletedTasks=totalCompleted>0}function onTasksLoaded(openTasks,completedTasks){onOpenTasksLoaded(openTasks),onCompletedTasksLoaded(completedTasks),ctrl.loading=!1}function loadTasks(taskStatus){ctrl.loading=!0;var offset=taskStatus===TaskStatus.OPEN?ctrl.openTasks.length:ctrl.completedTasks.length;return TaskService.getTasksByFilterAndStatus(ctrl.filter,taskStatus,offset)}function onErrorHandler(errorMessage){return function(){ctrl.loading=!1,MessageHandler.error(errorMessage),ctrl.error=errorMessage}}function loadNextTasks(taskStatus,callback){ctrl.loading||loadTasks(taskStatus).then(callback)["catch"](onErrorHandler("task.errorLoadingTasks"))["finally"](function(){return ctrl.loading=!1})}var ctrl=this;ctrl.toggleShowCompletedTasks=function(){return ctrl.showCompletedTasks=!ctrl.showCompletedTasks},ctrl.createNewTask=function(){""===ctrl.newTaskName||ctrl.creatingNewTask||(ctrl.creatingNewTask=!0,TaskService.createNewTask(ctrl.filter,ctrl.newTaskName).then(function(newTask){ctrl.openTasks.unshift(newTask),ctrl.newTaskName="",ctrl.creatingNewTask=!1})["catch"](function(){ctrl.creatingNewTask=!1,onErrorHandler("task.errorCreatingTask")()}))},ctrl.$onInit=function(){ctrl.openTasks=[],ctrl.completedTasks=[],ctrl.showCompletedTasks=!1,ctrl.newTaskName="",$scope.$on("jc-fetch-next-open-tasks",function(){return loadNextTasks(TaskStatus.OPEN,onOpenTasksLoaded)}),$scope.$on("jc-fetch-next-completed-tasks",function(){return loadNextTasks(TaskStatus.COMPLETED,onCompletedTasksLoaded)}),ctrl.filter===TaskFilter.ASSIGNED_TO_ME||ctrl.filter===TaskFilter.CREATED_BY_ME||TaskService.isTaskId(ctrl.filter)?PromiseUtil.all([loadTasks(TaskStatus.OPEN),loadTasks(TaskStatus.COMPLETED)],onTasksLoaded):TaskService.isTaskListId(ctrl.filter)?PromiseUtil.all([TaskService.getTaskListById(ctrl.filter),loadTasks(TaskStatus.OPEN),loadTasks(TaskStatus.COMPLETED)],function(taskList,openTasks,completedTasks){HeaderTitleService.setHeaderTitleValue(taskList.name),onTasksLoaded(openTasks,completedTasks)})["catch"](onErrorHandler("task.errorLoadingTasks")):onErrorHandler("task.invalidTaskFilterType")()}}function TaskRootController($rootScope,EVENTS){"ngInject";var ctrl=this;ctrl.$onInit=function(){$rootScope.$broadcast(EVENTS.onBackButtonUpdate,ctrl.showBackButton)}}JcSecuredImageController.$inject=["$scope","$element","$window","$document","JucoRestService"],FeedService.$inject=["JucoRestService","$q","Cache","REST","$rootScope","EVENTS","ResourceType","IdUtil","FileService"],ComposerImagePreviewController.$inject=["$window","FileService"],FakeComposerController.$inject=["$state"],FeedController.$inject=["$scope","$rootScope","$transitions","FeedService","$state","EVENTS","ENUMS","FEED_MESSAGE_TYPE","FeedCache","DomUtil","CurrentUser","PromiseUtil"],FeedAttachments.$inject=["FEED_ATTACHMENT_TYPE","Environment","ContentTypeUtil","urlUtil"],FeedDocumentAttachmentController.$inject=["DocumentService"],FeedExternalVideoAttachmentController.$inject=["urlUtil"],FeedImageAttachmentController.$inject=["DocumentService","FeedAttachments","$window"],FeedLinkAttachmentController.$inject=["Environment","urlUtil"],feedLinkAttachmentUrl.$inject=["Environment","urlUtil","ExternalRefUtil","UrlTokenResolver"],FeedMessageAttachment.$inject=["$compile","FEED_ATTACHMENT_TYPE","FeedAttachments"],FeedVideoAttachmentController.$inject=["DriveService"],FeedCommentController.$inject=["$state","ENUMS","profileNameFilter","i18nextFilter"],FeedCommentComposerController.$inject=["CommentService","MessageHandler"],FeedCommentsController.$inject=["CommentService","HtmlUtil","ArrayUtil","$rootScope","EVENTS"],FeedMessageController.$inject=["FEED_MESSAGE_TYPE","FeedAttachments"],FeedMessageActionsController.$inject=["FEED_MESSAGE_TYPE","ENUMS"],FeedMessageAttachmentsController.$inject=["FeedAttachments"],FeedActivityMessage.$inject=["FeedActivityMessageTranslationService","ResourceStateService","EVENTS"],FeedActivityMessageTranslationService.$inject=["FEED_MESSAGE_TYPE","HtmlUtil","StringUtil","UUID","$compile","$i18next"],FeedMessageContentController.$inject=["FEED_MESSAGE_TYPE"],FeedMessageCreateController.$inject=["$state","$q","FeedService","MessageHandler","$log","ResourceType","IdUtil"],FeedMessageDetailsController.$inject=["FEED_MESSAGE_TYPE","ENUMS","FeedAttachments","FeedService","ResourceStateService","$state"],FeedMessageEditController.$inject=["$state","$q","FeedService","MessageHandler"],FeedMessageHeaderController.$inject=["ResourceStateService","FEED_MESSAGE_TYPE","ENUMS"],FeedMessageInputController.$inject=["FileService","EntityService","MessageHandler","IdUtil","ResourceType","$q"],FeedMessageLikesController.$inject=["FeedService"],FeedMessagesController.$inject=["$state"],PinnedFeedMessageController.$inject=["ResourceStateService","$state"],LikesController.$inject=["LikeService","$scope","$state"],TaskAssignmentController.$inject=["SearchService","TaskService","$scope","$state","$timeout"],TaskController.$inject=["TaskService","TaskStatus","$state"],TaskDetailsController.$inject=["$rootScope","$scope","$timeout","TaskService","MessageHandler","$state","TaskStatus","PromiseUtil","profileNameFilter","dateFilter","$i18next","ChangeWatcher"],TaskListsController.$inject=["$state","TaskService","MessageHandler"],TaskTitleEditorController.$inject=["$scope","$timeout","$window"],TasksController.$inject=["$scope","TaskService","HeaderTitleService","MessageHandler","PromiseUtil","TaskStatus","TaskFilter"],TaskRootController.$inject=["$rootScope","EVENTS"];var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}(),_get=function get(object,property,receiver){null===object&&(object=Function.prototype);var desc=Object.getOwnPropertyDescriptor(object,property);if(void 0===desc){var parent=Object.getPrototypeOf(object);return null===parent?void 0:get(parent,property,receiver)}if("value"in desc)return desc.value;var getter=desc.get;if(void 0!==getter)return getter.call(receiver)};angular.module("juco.shared.common.util",["ngSanitize"]),angular.module("juco.shared.ngSharedResource",[]),angular.module("juco.shared.common",["juco.shared.rest","angular-cache","ui.router","juco.shared.common.util"]),angular.module("juco.shared.configuration",[]),angular.module("juco.shared.message",["juco.shared.common","juco.shared.configuration","juco.shared.xmpp","juco.shared.profile","ngFileUpload"]),angular.module("juco.shared.profile",["juco.shared.common","juco.shared.configuration"]),angular.module("juco.shared.rest",["juco.shared.configuration"]),angular.module("juco.shared.teaser",["juco.shared.common","juco.shared.xmpp","juco.shared.message"]),angular.module("juco.shared.xmpp",["juco.shared.profile","ngCookies","juco.shared.ngSharedResource"]),angular.module("juco.shared.search",[]),function(){String.prototype.startsWith||(String.prototype.startsWith=function(searchString,position){return this.substr(position||0,searchString.length)===searchString})}(),angular.module("juco.shared.common").service("ArrayUtil",[function(){function defaultComparator(first,second){var a=toLexicalOrder(first),b=toLexicalOrder(second);return a===b?0:a<b?-1:1}function toLexicalOrder(value){return value&&"string"==typeof value?value.toLowerCase().replace(/\xe4/g,"a").replace(/\xf6/g,"o").replace(/\xfc/g,"u").replace(/\xdf/g,"s"):value}function flatten(arrOfArr){return arrOfArr.reduce(function(flattened,arr){return flattened.concat(arr)},[])}function toUniqueIndex(array,member){return array.reduce(function(result,item){return result[item[member]]=item,result},{})}function sortByItemMember(array,sortByMember){return array.sort(function(first,second){return defaultComparator(first[sortByMember],second[sortByMember])})}function copyAndSortByItemMember(array,sortByMember){return sortByItemMember(array.slice(0),sortByMember)}function find(array,predicate){var value,i,list=Object(array),length=list.length>>>0,thisArg=arguments[2];if(null===array)throw new TypeError("no array provided");if("function"!=typeof predicate)throw new TypeError("predicate must be a function");for(i=0;i<length;i++)if(value=list[i],predicate.call(thisArg,value,i,list))return value}function contains(array,element){return!!array&&array.indexOf(element)>-1}function containsEvery(array,elements){return elements.every(function(element){return contains(array,element)})}function containsSome(array,elements){return elements.some(function(element){return contains(array,element)})}this.defaultComparator=defaultComparator,this.copyAndSortByItemMember=copyAndSortByItemMember,this.toUniqueIndex=toUniqueIndex,this.flatten=flatten,this.sortByItemMember=sortByItemMember,this.find=find,this.contains=contains,this.containsEvery=containsEvery,this.containsSome=containsSome}]),angular.module("juco.shared.common").service("CommonErrorHandler",["MessageHandler","$log",function(MessageHandler,$log){function handleError(error,i18nKey){MessageHandler.error(i18nKey,{errorName:error.name})}function handleJabberError(error,i18nKey){error.triggeredByUser?handleError(error,i18nKey):$log.error(error)}function handleJabberMessageError(error,i18nKey){MessageHandler.error(error.errorMessage.i18nKey,error.errorMessage.i18nParams)}this.handleError=handleError,this.handleJabberError=handleJabberError,this.handleJabberMessageError=handleJabberMessageError}]),angular.module("juco.shared.common").service("ContentTypeUtil",[function(){function isSupportedImageContentType(contentType){return SUPPORTED_IMAGE_TYPES.some(function(supportedType){return 0===contentType.search(supportedType)})}function isSupportedVideoContentType(contentType){return/^video\//.test(contentType)}function isGif(contentType){return 0===contentType.search(GIF_CONTENT_TYPE)}var GIF_CONTENT_TYPE=/image\/gif(?:$|;)/i,SUPPORTED_IMAGE_TYPES=[/image\/bmp(?:$|;)/i,GIF_CONTENT_TYPE,/image\/jpeg(?:$|;)/i,/image\/png(?:$|;)/i,/image\/x-png(?:$|;)/i,/image\/tiff(?:$|;)/i];this.isSupportedImageContentType=isSupportedImageContentType,this.isSupportedVideoContentType=isSupportedVideoContentType,this.isGif=isGif}]),function(){angular.module("juco.shared.common").service("DateUtil",[function(){function isSameDay(date1,date2){var d1=new Date(date1),d2=new Date(date2);return d1.getDate()===d2.getDate()&&d1.getMonth()===d2.getMonth()&&d1.getYear()===d2.getYear()}function isAllDayEvent(startDate,endDate){var start=new Date(startDate),end=new Date(endDate);return 0===start.getHours()&&0===start.getMinutes()&&0===start.getMilliseconds()&&23===end.getHours()&&59===end.getMinutes()&&0===end.getMilliseconds();
}this.isSameDay=isSameDay,this.isAllDayEvent=isAllDayEvent}])}(),angular.module("juco.shared.common").service("EmojiUtil",["$sanitize","$sce","Environment",function($sanitize,$sce,Environment){function init(){polyfill(),setAssetsServerBase("")}function polyfill(){String.prototype.includes||(String.prototype.includes=function(search,start){return"number"!=typeof start&&(start=0),!(start+search.length>this.length)&&this.indexOf(search,start)!==-1})}function unicodeToImage(text){return shouldEmojify?augmentImageTags(emojione.unicodeToImage(text)):text}function shortnameToImage(text){return shouldEmojify?augmentImageTags(emojione.shortnameToImage(text)):text}function shortnameToUnicode(text){return shouldEmojify?emojione.shortnameToUnicode(text):text}function augmentImageTags(text){var augmentedText=$sanitize(text).replace(/<img /g,'<img draggable="false" ');return $sce.trustAsHtml(augmentedText)}function getAssetsPath(){return assetsPath}function setAssetsServerBase(serverBase){return emojioneAvailable?(assetsPath=serverBase+"/emojione/"+emojione.emojiVersion+"/",emojione.imagePathPNG=assetsPath+"png/64/",void(emojione.unicodeAlt=!0)):void(assetsPath=serverBase)}var assetsPath,emojioneAvailable="undefined"!=typeof emojione&&emojione,shouldEmojify=emojioneAvailable&&!Environment.isIos();init(),this.unicodeToImage=unicodeToImage,this.shortnameToImage=shortnameToImage,this.shortnameToUnicode=shortnameToUnicode,this.getAssetsPath=getAssetsPath,this.setAssetsServerBase=setAssetsServerBase}]),angular.module("juco.shared.common").service("ExternalRefUtil",["Environment","$window","$timeout","$q",function(Environment,$window,$timeout,$q){"ngInject";function inAppBrowserEventCb(){inAppBrowserStillOpen=!1,inAppBrowserWindow&&inAppBrowserWindow.removeEventListener("exit",inAppBrowserEventCb)}function openUrl(url,forceInAppBrowser,hideToolbar){if(Environment.isCordova()){if(forceInAppBrowser&&inAppBrowserStillOpen)return;if(forceInAppBrowser){var options="toolbarposition=top,enableViewportScale=yes";hideToolbar&&(options+=",location=no"),inAppBrowserWindow=$window.open(url,"_blank",options),inAppBrowserStillOpen=!0,inAppBrowserWindow.addEventListener("exit",inAppBrowserEventCb)}else $window.open(url,"_system")}else $window.open(url,"_blank")}function createLinkFunction(directiveName,forceInAppBrowser,hideToolbar){return function(scope,element,attributes){var url="";Environment.isCordova()&&element.on("click",function(){openUrl(url,forceInAppBrowser,hideToolbar)}),attributes.$observe(directiveName,function(value){Environment.isCordova()?(attributes.$set("href",""),url=value):(attributes.$set("href",value||null),attributes.$set("target","_blank"))})}}function openApp(appUrl){var WAIT_FOR_APP_MS=1e3,SUCCESSFUL_APP_START_AFTER_MS=1100;return $q(function(resolve,reject){var startTime=(new Date).valueOf();$window.location=appUrl,$timeout(function(){(new Date).valueOf()-startTime>SUCCESSFUL_APP_START_AFTER_MS?resolve():reject()},WAIT_FOR_APP_MS)})}var inAppBrowserWindow=void 0,inAppBrowserStillOpen=!1;this.openUrl=openUrl,this.createLinkFunction=createLinkFunction,this.openApp=openApp}]),angular.module("juco.shared.common").service("HtmlUtil",["$sce","urlUtil","StringUtil","EmojiUtil","Environment",function($sce,urlUtil,StringUtil,EmojiUtil,Environment){function escapeHtml(str){return str?angular.isString(str)?doEscapeHtml(str):str:""}function doEscapeHtml(str){return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/'/g,"&#39;").replace(/"/g,"&quot;")}function linkShouldOpenInSameTab(url){return!Environment.isCordova()&&urlUtil.urlOnSameHost(url)}function addLinkTagsForUrls(text,urlMaxLength,cssMarkerClass){return text?text.replace(urlUtil.getUrlSearchPattern(),function(url){var urlWithProtocol=urlUtil.addHttpIfNecessary(url),cssMarker=cssMarkerClass?' class="'+cssMarkerClass+'"':"",displayedUrl=urlMaxLength>0?shorten(url,urlMaxLength,0):url,target=linkShouldOpenInSameTab(url)?"":' target="_blank"',rel=linkShouldOpenInSameTab(url)?"":' rel="noreferrer noopener"';return'<a href="'+urlWithProtocol+'"'+cssMarker+target+rel+">"+displayedUrl+"</a>"}):""}function shorten(string,maxLength,startIndex){var i,j,s2,s3,length=string.length,actualMaxLength=maxLength-3;return maxLength<length-startIndex?(i=Math.floor(actualMaxLength/2),j=i+actualMaxLength%2,s2=Math.min(j,length),s3=Math.min(length-i,length),string.substr(startIndex,s2)+"..."+string.substr(s3)):string.substr(startIndex)}function shortenText(text,displayedLength){var startIndex=0,cutIndex=displayedLength,urls=urlUtil.findUrls(text);return urls.some(function(url){var currentIndex=text.indexOf(url,startIndex);if(currentIndex!==-1&&currentIndex<displayedLength){if(startIndex=currentIndex+url.length,startIndex>displayedLength)return cutIndex=currentIndex,!0}else if(currentIndex>=displayedLength)return!0}),text.substr(0,cutIndex)}function shortenEscapeAndLinkify(text,maxLength,maxUrlLength){var escapedText,truncated,shortenedText=text;return text?(maxLength>0&&text.length>maxLength&&(shortenedText=shortenText(text,maxLength)),shortenedText.length>=.9*text.length?(escapedText=doEscapeHtml(text),truncated=!1):(escapedText=doEscapeHtml(shortenedText),truncated=!0),{text:addLinkTagsForUrls(escapedText,maxUrlLength),truncated:truncated}):""}function escapeAndLinkify(text){return text?angular.isString(text)?addLinkTagsForUrls(doEscapeHtml(text)):text:""}function emojify(text){return text?EmojiUtil.unicodeToImage(text):""}function emojifyFirstChar(text){var matchedTag,tagName,regExp,matchedHtml,emojified=$sce.getTrustedHtml(emojify(text));return"<"===emojified.charAt(0)&&"<"!==text.charAt(0)&&(matchedTag=emojified.match(/^<([a-zA-Z0-9]+)/),matchedTag&&(tagName=matchedTag[1],regExp=new RegExp("^<"+tagName+"(?:.+?</"+tagName+">|[^>]+>)"),matchedHtml=emojified.match(regExp)))?$sce.trustAsHtml(matchedHtml[0]):StringUtil.firstCharOf(text)}function escapeAndEmojifyHtml(str){return str?angular.isString(str)?EmojiUtil.unicodeToImage(doEscapeHtml(str)):str:""}this.escapeHtml=escapeHtml,this.addLinkTagsForUrls=addLinkTagsForUrls,this.escapeAndLinkify=escapeAndLinkify,this.emojify=emojify,this.escapeAndEmojifyHtml=escapeAndEmojifyHtml,this.emojifyFirstChar=emojifyFirstChar,this.shorten=shorten,this.shortenText=shortenText,this.shortenEscapeAndLinkify=shortenEscapeAndLinkify}]),angular.module("juco.shared.common").service("IdUtil",[function(){function getResourceType(id){var pos;return id?(pos=id.indexOf(","),pos>-1?id.substring(0,pos):""):null}function getRawIdAsString(id){var pos;return id?(pos=id.indexOf(","),id.substring(pos+1)):null}function getRawId(id){var rawIdString=getRawIdAsString(id);return rawIdString?parseInt(rawIdString):null}function toPersonId(id){var rawId=getRawIdAsString(id);return"PERSON,"+rawId}this.getResourceType=getResourceType,this.getRawId=getRawId,this.getRawIdAsString=getRawIdAsString,this.toPersonId=toPersonId}]),angular.module("juco.shared.common.util").directive("jcAutofillFix",function(){var findParent=function(elem,tagName){for(var currentTagName,current=elem;;){if(currentTagName=current[0].nodeName.toLowerCase(),currentTagName===tagName)return current;if("html"===currentTagName)return;current=current.parent()}},handleSubmit=function(form){return function(){["input","textarea","select"].forEach(function(tag){angular.forEach(form.find(tag),triggerWatch)})}},triggerWatch=function(element){element=angular.element(element),element.triggerHandler("input"),element.triggerHandler("change"),element.triggerHandler("keydown")},linker=function(scope,elem){"form"===elem[0].nodeName.toLowerCase()?elem.on("submit",handleSubmit(elem)):elem.on("click",handleSubmit(findParent(elem,"form")))};return{restrict:"A",link:linker,priority:-1}}),angular.module("juco.shared.common.util").filter("jcTrustedHtml",["$sce",function($sce){return function(html){return $sce.trustAsHtml(html)}}]),angular.module("juco.shared.common").factory("jQuery",["$window",function($window){return $window.jQuery}]),angular.module("juco.shared.common").service("MessageHandler",["$rootScope","EVENTS","$log","$window",function($rootScope,EVENTS,$log,$window){function remapErrorMessageKey(key,errorDescription){switch(key){case"UNAUTHORIZED":return"exception.unauthorized";case"TOKEN_EXPIRED":return"exception.tokenExpired";case"FORBIDDEN":return"exception.forbidden";case"ACCOUNT_INACTIVE":return"exception.accountInactive";case"ACCOUNT_BLOCKED":return"exception.accountBlocked";case"NOT_FOUND":return"exception.notFound";case"WRONG_FORMAT":return"exception.wrongFormat";case"TOO_MANY_REQUESTS":return"exception.tooManyRequests";case"INTERNAL_SERVER_ERROR":return"exception.internalServerError";case"SERVICE_UNAVAILABLE":return"exception.serviceUnavailable";case"UNPROCESSABLE_ENTITY":return"exception.unprocessableEntity";case"MISSING_PARAMETER":return"exception.missingParameter";case"VALUE_TOO_LARGE":return"exception.valueTooLarge";case"NOT_IMPLEMENTED":return"exception.notImplemented";case"ACCOUNT_ACTIVATED_OR_INEXISTENT":return"accountActivatedOrInexistent";case"exception.invalid_grant":switch(errorDescription){case"User account is locked":return"exception.accountBlocked";case"User is disabled":return"exception.accountInactive";default:return key}default:return key}}function getErrorMessageKey(errorInfo){var unknownError="exception.anErrorOccurred",errorData=errorInfo&&errorInfo.info&&!errorInfo.data?errorInfo.info:errorInfo,dataCode=errorData&&errorData.data?errorData.data.code:void 0,dataMessage=errorData?errorData.message:void 0,dataError=errorData&&errorData.error?"exception."+errorData.error:void 0,dataErrorDescription=errorData?errorData.error_description:void 0,error=dataCode||dataMessage||dataError||dataErrorDescription||unknownError,errorKey=remapErrorMessageKey(error,dataErrorDescription);return $window.i18n.exists(errorKey)?errorKey:unknownError}function broadcastFeedback(sever,messageOrKey,i18nOptions){var messageObject=createMessage(sever,messageOrKey,i18nOptions);messageObject&&($rootScope.$broadcast(EVENTS.onFeedback,messageObject),sever===severity.ERROR?$log.error(messageObject.isI18nKey?messageObject:messageObject.message):sever===severity.WARN&&$log.warn(messageObject.isI18nKey?messageObject:messageObject.message))}function createMessage(sever,messageOrKey,i18nOptions){if(messageOrKey)return{message:messageOrKey,i18nOptions:i18nOptions,severity:sever}}function createErrorMessage(messageOrKey,i18nOptions){return createMessage(severity.ERROR,messageOrKey,i18nOptions)}function error(messageOrKey,i18nOptions){broadcastFeedback(severity.ERROR,messageOrKey,i18nOptions)}function warn(messageOrKey,i18nOptions){broadcastFeedback(severity.WARN,messageOrKey,i18nOptions)}function info(messageOrKey,i18nOptions){broadcastFeedback(severity.INFO,messageOrKey,i18nOptions)}var severity={ERROR:"error",WARN:"warn",INFO:"info"};this.broadcastFeedback=broadcastFeedback,this.createMessage=createMessage,this.createErrorMessage=createErrorMessage,this.error=error,this.warn=warn,this.info=info,this.getErrorMessageKey=getErrorMessageKey}]),angular.module("juco.shared.common").service("ObjectUtil",["ArrayUtil",function(ArrayUtil){function isDefined(element){return"undefined"!=typeof element&&null!==element}function getProperty(object,propertyName){return object?object[propertyName]:void 0}function orderByArray(orderedArray,obj){return Object.keys(obj).map(function(key){if(ArrayUtil.contains(orderedArray,key))return{key:key,value:obj[key],order:orderedArray.indexOf(key)}}).filter(function(elem){return isDefined(elem)})}function isEmpty(object){return!object||"{}"===JSON.stringify(object)}function filterEmptyProperties(object){var filtered={};return Object.keys(object).forEach(function(key){isDefined(object[key])&&(filtered[key]=object[key])}),filtered}this.orderByArray=orderByArray,this.getProperty=getProperty,this.isDefined=isDefined,this.isEmpty=isEmpty,this.filterEmptyProperties=filterEmptyProperties}]),angular.module("juco.shared.common").service("PromiseUtil",["$q","$timeout",function($q,$timeout){function spread(targetFn,scope){return function(){var params=[].concat(arguments[0]);return targetFn.apply(scope,params)}}function all(promises,targetFn,scope){return $q.all(promises).then(spread(targetFn,scope))}function immediateResolve(result){return $q(function(resolve){resolve(result)})}function immediateReject(result){return $q(function(resolve,reject){reject(result)})}function isValidDelay(input){return angular.isNumber(input)&&!isNaN(input)}function delayedResolve(result,delay){return $q(function(resolve){$timeout(function(){resolve(result)},isValidDelay(delay)?delay:1e3)})}function delayedReject(result,delay){return $q(function(resolve,reject){$timeout(function(){reject(result)},isValidDelay(delay)?delay:1e3)})}this.spread=spread,this.all=all,this.immediateResolve=immediateResolve,this.immediateReject=immediateReject,this.delayedResolve=delayedResolve,this.delayedReject=delayedReject}]),angular.module("juco.shared.common").service("StringUtil",function(){function isEmpty(s){return!s||0===s.length}function isBlank(s){return!s||0===s.trim().length}function fixedCharAt(s,pos){for(var idx=pos,text=s||"",surrogatePairs=/[\uD800-\uDBFF][\uDC00-\uDFFF]/g;null!==surrogatePairs.exec(text)&&surrogatePairs.lastIndex-2<idx;)idx++;return idx>=text.length||idx<0?"":/[\uD800-\uDBFF]/.test(text.charAt(idx))&&/[\uDC00-\uDFFF]/.test(text.charAt(idx+1))?text.substring(idx,idx+2):text.charAt(idx)}function firstCharOf(s){return fixedCharAt(s,0)}this.isEmpty=isEmpty,this.isBlank=isBlank,this.firstCharOf=firstCharOf,this.fixedCharAt=fixedCharAt}),angular.module("juco.shared.common").service("urlUtil",["$location","CONFIG","Environment",function($location,CONFIG,Environment){function addParameter(url,parameterName,parameterValue){var urlParts,parameters,urlHash,sourceUrl,parameterParts,i,cl=url.indexOf("#"),newQueryString="";if(cl>0?urlHash=url.substring(cl,url.length):(urlHash="",cl=url.length),sourceUrl=url.substring(0,cl),urlParts=sourceUrl.split("?"),urlParts.length>1)for(parameters=urlParts[1].split("&"),i=0;i<parameters.length;i++)parameterParts=parameters[i].split("="),parameterParts[0]!==parameterName&&(""===newQueryString?newQueryString="?":newQueryString+="&",newQueryString+=parameterParts[0]+"="+(parameterParts[1]?parameterParts[1]:""));return""===newQueryString&&(newQueryString="?"),"?"!==newQueryString&&(newQueryString+="&"),newQueryString+=parameterName+"="+(parameterValue?parameterValue:""),urlParts[0]+newQueryString+urlHash}function getUrlSearchPattern(){return urlSearchPattern}function parseURL(url){var parser,hostname,port,host;try{parser=urlRegExPattern.exec(decodeURI(url))}catch(e){}return parser?(hostname=parser[3],port=parser[5],host=hostname?hostname+(port?":"+port:""):void 0,{href:parser[0],protocol:parser[2],host:host,hostname:parser[3],port:port,pathname:parser[6],search:parser[7],hash:parser[9]}):{}}function buildURL(config){var parts=[];return parts.push(config.protocol||"http:"),parts.push("//"),parts.push(config.hostname),config.port&&(parts.push(":"),parts.push(config.port)),parts.push(config.pathname),parts.push(config.search),parts.push(config.hash),parts.join("")}function getDesktopURLHash(url){var decodedUrl,parsedUrl,host;if(url){try{decodedUrl=decodeURI(url)}catch(e){return}return 0===decodedUrl.indexOf("#")?decodedUrl:(parsedUrl=parseURL(url),host=getHost(),parsedUrl.hostname&&parsedUrl.hostname!==host||parsedUrl.pathname!==CONFIG.desktopClientUrl?void 0:parsedUrl.hash)}}function getHost(){var parsed;return Environment.isCordova()?(parsed=parseURL(Environment.getServerBase()),parsed.hostname):$location.host()}function addHttpIfNecessary(url){return 0===url.search(protocolPattern)?url:"http://"+url}function removeProtocol(url){var matches=url.match(protocolPattern);return matches&&matches.length>0?matches[1]:url}function hasProtocol(url){var matches=url.match(protocolPattern);return matches&&matches.length>0}function normalizeForBaseUrl(url){var urlWithProtocol=addHttpIfNecessary(url.toLocaleLowerCase()),parsedUrl=parseURL(urlWithProtocol);return"http:"!==parsedUrl.protocol&&"https:"!==parsedUrl.protocol||!parsedUrl.host?null:parsedUrl.protocol+"//"+parsedUrl.host}function normalizeAbsolutePath(url,baseUrl){return url&&"/"===url.charAt(0)?baseUrl+url:url}function getUrlToken(url){var urlHash=getDesktopURLHash(url);return!urlHash||0!==urlHash.indexOf("#!")&&0!==urlHash.indexOf("#/")?"":urlHash}function joinParts(parts){return parts.reduce(function(prev,curr){return prev.endsWith("/")&&(prev=prev.slice(0,-1)),curr.startsWith("/")&&(curr=curr.slice(1)),prev+"/"+curr})}function findUrls(text){var match,pattern=getUrlSearchPattern(),urls=[];do match=pattern.exec(text),match&&urls.push(match[0]);while(match);return urls}function urlOnSameHost(url){var parsedURL=parseURL(url),host=getHost();return!!parsedURL.host&&!!host&&parsedURL.host.toLowerCase()===host.toLowerCase()}var urlRegExPattern=/(([a-z]+:)\/\/)?([a-z0-9\-\.]+)?(\:([0-9]+))?(\/[a-z0-9\/\-\.]+)?(\?([^#]+)?)?(#.*)?/i,urlBasePattern="((?:((?:https?|ftp|file|mailto):(?://|[a-z0-9%]))|ww\\d{1,3}|www\\d{0,3}[.])(?:[^\\s()<>]+|\\(?:([^\\s()<>]+|(?:\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(?:\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\\\".,<>?\xab\xbb\u201c\u201d\u2018\u2019]))",urlSearchPattern=new RegExp(urlBasePattern,"gi"),protocolPattern=/^(?:mailto:|(?:https?|ftp|file):\/\/)(.+)/i;this.joinParts=joinParts,this.getUrlToken=getUrlToken,this.parseURL=parseURL,this.getUrlSearchPattern=getUrlSearchPattern,this.addParameter=addParameter,this.buildURL=buildURL,this.getDesktopURLHash=getDesktopURLHash,this.removeProtocol=removeProtocol,this.addHttpIfNecessary=addHttpIfNecessary,this.normalizeForBaseUrl=normalizeForBaseUrl,this.hasProtocol=hasProtocol,this.normalizeAbsolutePath=normalizeAbsolutePath,this.findUrls=findUrls,this.urlOnSameHost=urlOnSameHost}]),angular.module("juco.shared.common").service("UUID",[function(){function generate(){var d0=4294967295*Math.random()|0,d1=4294967295*Math.random()|0,d2=4294967295*Math.random()|0,d3=4294967295*Math.random()|0;return lut[255&d0]+lut[d0>>8&255]+lut[d0>>16&255]+lut[d0>>24&255]+"-"+lut[255&d1]+lut[d1>>8&255]+"-"+lut[d1>>16&15|64]+lut[d1>>24&255]+"-"+lut[63&d2|128]+lut[d2>>8&255]+"-"+lut[d2>>16&255]+lut[d2>>24&255]+lut[255&d3]+lut[d3>>8&255]+lut[d3>>16&255]+lut[d3>>24&255]}var i,lut=[];for(i=0;i<256;i++)lut[i]=(i<16?"0":"")+i.toString(16);this.generate=generate}]),angular.module("juco.shared.common").filter("jcExtendClasses",function(){function fromArray(exp){return exp.reduce(function(result,value){return result[value]=!0,result},{})}function toObject(exp){return exp?angular.isString(exp)?fromArray(exp.split(" ")):angular.isArray(exp)?fromArray(exp):angular.isObject(exp)?exp:{}:{}}return function(orig,additional){return angular.extend({},toObject(orig),toObject(additional))}}),angular.module("juco.shared.common").filter("jcFileSize",["numberFilter",function(numberFilter){function displayFormatted(sizeScaled,unit){var fractionLength,numStr;return fractionLength=sizeScaled<10?2:sizeScaled<100?1:0,numStr=numberFilter(sizeScaled,fractionLength),2===fractionLength&&"00"===numStr.substr(numStr.length-2,2)?numStr=numStr.substr(0,numStr.length-3):fractionLength>0&&"0"===numStr.charAt(numStr.length-1)&&(numStr=numStr.substr(0,numStr.length-3+fractionLength)),numStr+unit}return function(size){var KB=1024,MB=1024*KB,GB=1024*MB,sizeScaled=size;return sizeScaled<1e3?sizeScaled+" B":(sizeScaled=size/KB,sizeScaled<1e3?displayFormatted(sizeScaled," KB"):(sizeScaled=size/MB,sizeScaled<1e3?displayFormatted(sizeScaled," MB"):(sizeScaled=size/GB,displayFormatted(sizeScaled," GB"))))}}]),angular.module("juco.shared.common").filter("jcI18nDynamicAttribute",["i18nextFilter","$window",function(i18nextFilter,$window){return function(attribute,attributePrefix,i18nOptions){var i18nKey=(attributePrefix?attributePrefix:"")+attribute;return $window.i18n.exists(i18nKey,i18nOptions)?i18nextFilter(i18nKey,i18nOptions):attribute}}]),angular.module("juco.shared.common").filter("jcImage",["Environment","urlUtil","UriService","ImageSize",function(Environment,urlUtil,UriService,ImageSize){return function(url,size){var result;if(url)return result=UriService.toTmpl(url)(size?ImageSize[size]:ImageSize.small),Environment.isCordova()?urlUtil.normalizeAbsolutePath(result,Environment.getServerBase()):result}}]),angular.module("juco.shared.common").filter("jcUnreadCount",[function(){return function(count){return count&&0!==count?count>9?"9+":count:"\xa0\xa0"}}]),angular.module("juco.shared.common").service("Cache",["PromiseUtil","CacheFactory",function(PromiseUtil,CacheFactory){function createCache(name,options){var cache=CacheFactory.get(name);return cache?cache:CacheFactory.createCache(name,options)}function clearAll(){CacheFactory.clearAll()}function getCachedPromise(key,cache,onCacheMiss){var cachedPromise,promiseKey,promise,fromCache=cache.get(key);return fromCache?PromiseUtil.immediateResolve(fromCache):(promiseKey=cache.info().id+key,(cachedPromise=promiseCache.get(promiseKey))?cachedPromise:(promise=onCacheMiss().then(function(result){return promiseCache.remove(promiseKey),cache.put(key,result),result}),promiseCache.put(promiseKey,promise),promise))}function getCached(key,cache,onCacheMiss){var onCacheMissResult,fromCache=cache.get(key);return fromCache?fromCache:(onCacheMissResult=onCacheMiss(),cache.put(key,onCacheMissResult),onCacheMissResult)}var promiseCache=createCache("promiseCache",{maxAge:5e3,storeOnResolve:!1,storeOnReject:!1});this.createCache=createCache,this.getCachedPromise=getCachedPromise,this.getCached=getCached,this.clearAll=clearAll}]),angular.module("juco.shared.common").service("ConfigurationService",["RestService","REST","Cache",function(RestService,REST,Cache){function getConfiguration(){return Cache.getCachedPromise("__CONFIGURATION__",configCache,function(){return RestService.get(REST.config.BASE())})}function isChatEnabled(){return getConfiguration().then(function(config){return config.conversationConfig.chatEnabled})}var configCache=Cache.createCache("configCache");this.getConfiguration=getConfiguration,this.isChatEnabled=isChatEnabled}]),angular.module("juco.shared.common").service("History",["$rootScope","$state",function($rootScope,$state){function back(){previousState&&previousState.name&&($state.go(previousState.name,previousState.params||{}),previousState=null)}function hasPreviousState(){return!!previousState}var previousState;$rootScope.$on("$stateChangeSuccess",function(event,toState,toParams,fromState,fromParams){return toParams.noBack?void(previousState=void 0):void(previousState={name:fromState,params:fromParams})}),this.back=back,this.hasPreviousState=hasPreviousState}]),angular.module("juco.shared.common").service("HolmesService",["$window","$location",function($window,$location){function track(trackingObject){if(isHolmesAvailable())try{$window.Holmes.track(trackingObject)}catch(e){}}function pageView(additionalPayload){var path,hash,trackingObject;if(isHolmesAvailable())try{path=$location.path(),hash=$location.hash()||"",hash.length>0&&(path+="#"+hash),trackingObject=angular.extend({path:path},additionalPayload||{}),$window.Holmes.pageView(trackingObject)}catch(e){}}function isHolmesAvailable(){return"undefined"!=typeof $window.Holmes}this.track=track,this.pageView=pageView,this.isHolmesAvailable=isHolmesAvailable}]),angular.module("juco.shared.common").service("PlatformInfoService",["RestService","REST","Cache",function(RestService,REST,Cache){function getPlatformInfo(bypassErrorHandler){return Cache.getCachedPromise("__PLATFORM_INFO__",platformInfoCache,function(){return RestService.get(REST.platformInfo.BASE(),null,bypassErrorHandler,!1,{timeout:2e4})})}function resetPlatformInfo(){platformInfoCache.removeAll()}function getFeatureToggles(){return getPlatformInfo().then(function(platformInfo){return platformInfo.apiFeatureToggles||{}})}function getFeatureToggle(name){return getFeatureToggles().then(function(featureToggles){return!!featureToggles[name]})}function isDriveAvailable(){return getPlatformInfo().then(function(platformInfo){return platformInfo.driveInMobileEnabled})}function isTaskAvailable(){return getPlatformInfo().then(function(platformInfo){return platformInfo.taskInMobileEnabled})}function isPeopleAvailable(){return getPlatformInfo().then(function(platformInfo){return platformInfo.peopleInMobileEnabled})}var platformInfoCache=Cache.createCache("platformInfoCache");this.getPlatformInfo=getPlatformInfo,this.resetPlatformInfo=resetPlatformInfo,this.getFeatureToggles=getFeatureToggles,this.getFeatureToggle=getFeatureToggle,this.isDriveAvailable=isDriveAvailable,this.isTaskAvailable=isTaskAvailable,this.isPeopleAvailable=isPeopleAvailable}]),angular.module("juco.shared.common").service("RemoteLogService",["UUID","ArrayUtil","Environment","RestService","REST","CurrentUser","$log","$rootScope","EVENTS","$window","PromiseUtil",function(UUID,ArrayUtil,Environment,RestService,REST,CurrentUser,$log,$rootScope,EVENTS,$window,PromiseUtil){function init(){Environment.getClientVersion().then(setClientVersion),deviceId=Environment.getDeviceId()||UUID.generate(),deviceType=Environment.getDeviceType(),instanceId=UUID.generate(),$rootScope.$on(EVENTS.onLogConfigurationVersionChanged,onNewConfiguration)}function setClientVersion(version){clientVersion=version}function onNewConfiguration(event,newVersion){newVersion&&configVersion&&newVersion===configVersion?$log.debug("RemoteLogService - skip sync of configuration, already up to date"):synchronizeConfiguration()}function getActiveLogLevel(configuredLevel){return KNOWN_LOG_LEVEL.slice(KNOWN_LOG_LEVEL.indexOf(configuredLevel))}function updateConfiguration(cfg){promisedConfiguration=void 0,configVersion=cfg.version,logLevel=getActiveLogLevel(cfg.level),$log.debug("RemoteLogService - updated configuration to: "+angular.toJson(cfg))}function synchronizeConfiguration(){promisedConfiguration?$log.debug("RemoteLogService - skip sync of configuration, sync already in progress"):(promisedConfiguration=RestService.get(REST.log.CONFIGURATION,{},BYPASS_ERROR_INTERCEPTOR,BYPASS_AUTH_MODULE),promisedConfiguration.then(updateConfiguration))}function send(level,message){function sendWithNewConfiguration(cfg){return sendIfLevelMatches(getActiveLogLevel(cfg.level),level,message)}return logLevel||synchronizeConfiguration(),promisedConfiguration?promisedConfiguration.then(sendWithNewConfiguration):PromiseUtil.immediateResolve(sendIfLevelMatches(logLevel,level,message))}function sendIfLevelMatches(activeLevels,level,message){return ArrayUtil.contains(activeLevels,level)?sendToServer(level,message):void $log.debug("RemoteLogService - skipped sending of log message with level: "+level+" - "+message)}function sendToServer(level,message){var entry={clientTimestamp:(new Date).getTime(),level:level,message:message,userId:CurrentUser.getId(),deviceId:deviceId,deviceType:deviceType,clientVersion:clientVersion,instanceId:instanceId};return RestService.post(REST.log.SEND,entry,BYPASS_ERROR_INTERCEPTOR,BYPASS_AUTH_MODULE),entry}function toMessage(message,payload){return payload?message+": "+angular.toJson(payload):message}function trace(message,payload){var logMessage=toMessage(message,payload);return $log.debug(logMessage),send("TRACE",logMessage)}function debug(message,payload){var logMessage=toMessage(message,payload);return $log.debug(logMessage),send("DEBUG",logMessage)}function info(message,payload){var logMessage=toMessage(message,payload);return $log.info(logMessage),send("INFO",logMessage)}function warn(message,payload){var logMessage=toMessage(message,payload);return $log.warn(logMessage),send("WARN",logMessage)}function error(message,payload){var logMessage=toMessage(message,payload);return $log.error(toMessage(message,payload)),send("ERROR",logMessage)}var deviceId,instanceId,deviceType,clientVersion,configVersion,logLevel,promisedConfiguration,BYPASS_ERROR_INTERCEPTOR=!0,BYPASS_AUTH_MODULE=!0,KNOWN_LOG_LEVEL=["TRACE","DEBUG","INFO","WARN","ERROR"];init(),this.trace=trace,this.debug=debug,this.info=info,this.warn=warn,this.error=error}]),angular.module("juco.shared.common").service("VisibilityChangeService",["$document","$window","$rootScope","EVENTS",function($document,$window,$rootScope,EVENTS){function init(){var android,angularWindow=angular.element($window),mobileSafari=$window.navigator.userAgent.match(/safari/i)&&($window.navigator.userAgent.match(/iPad/i)||$window.navigator.userAgent.match(/iPhone/i));mobileSafari||(android=parseFloat((/android (\d+\.\d*)/.exec(angular.lowercase(($window.navigator||{}).userAgent))||[])[1])),"undefined"!=typeof $window.document.hidden?(hidden="hidden",visibilityChange="visibilitychange"):"undefined"!=typeof $window.document.mozHidden?(hidden="mozHidden",visibilityChange="mozvisibilitychange"):"undefined"!=typeof $window.document.msHidden?(hidden="msHidden",visibilityChange="msvisibilitychange"):"undefined"!=typeof $window.document.webkitHidden&&(hidden="webkitHidden",visibilityChange="webkitvisibilitychange"),mobileSafari?(angularWindow.on("pageshow pagehide",onVisibilityEvent),initialPageLoad=!0):visibilityChange&&(!android||android>=4.3)?$document.on(visibilityChange,onVisibilityEvent):("onfocusin"in $window.document?angularWindow.on("focusin focusout",onVisibilityEvent):angularWindow.on("focus blur",onVisibilityEvent),initialPageLoad=!0),$rootScope.$on("$destroy",function(){angularWindow.off("pageshow pagehide focusin focusout focus blur",onVisibilityEvent),$document.off(visibilityChange,onVisibilityEvent)})}function isCurrentlyVisible(event){var fixedMapping={focus:!0,focusin:!0,pageshow:!0,blur:!1,focusout:!1,pagehide:!1};return event&&event.type&&event.type in fixedMapping?fixedMapping[event.type]:!$document.prop(hidden)}function onVisibilityEvent(event){initialPageLoad?initialPageLoad=!1:$rootScope.$broadcast(EVENTS.onVisibilityChanged,isCurrentlyVisible(event))}var hidden,visibilityChange,initialPageLoad=!1;init(),this.isCurrentlyVisible=isCurrentlyVisible}]),function(){angular.module("juco.shared.common").constant("API_FEATURE_TOGGLES",{})}(),angular.module("juco.shared.common").constant("ERROR",{CHAT:{CHAT_UNAVAILABLE:"CHAT_UNAVAILABLE",JABBER_ERROR:"JABBER_ERROR",JABBER_MESSAGE_ERROR:"JABBER_MESSAGE_ERROR",UNEXPECTED_CHAT_ERROR:"UNEXPECTED_CHAT_ERROR"}}),angular.module("juco.shared.common").constant("EVENTS",function(){return{onJabberConnected:"jc-ng-on-jabber-connected",onJabberConnectionInitializedAsOffline:"jc-ng-on-jabber-connection-initialized-as-offline",onJabberDisconnected:"jc-ng-on-jabber-disconnected",onJabberMessage:"jc-ng-on-jabber-message",onNewConversation:"jc-ng-on-new-conversation",onNewConversationMessage:"jc-ng-on-new-conversation-message",onConversationSelectedViaSearch:"jc-ng-on-conversation-selected-via-search",onConversationParticipantSuggestionSelected:"jc-ng-on-conversation-participant-suggestion-selected",onChatBarOpened:"jc-on-chat-bar-opened",onChatBarCollapsed:"jc-on-chat-bar-collapsed",onPresenceChanged:"jc-on-presence-changed",onConversationFocusGained:"jc-ng-on-conversation-focus-gained",onConversationFocusLost:"jc-ng-on-conversation-focus-lost",onShowAutoHideSnackbar:"on-show-autoHide-snackbar",onReloadConversations:"on-reload-conversations",onRemovedFromConversation:"jc-ng-on-removed-from-conversation",onParticipantsUpdated:"jc-ng-on-participants-updated",onConversationTitleChanged:"jc-ng-on-conversation-title-changed",onSearch:"jc-on-do-search",onToogleMenu:"jc-on-toogle-menu",onStateChangeStart:"$stateChangeStart",onFeedback:"jc-feedback",onUserAuthenticated:"jcUserAuthenticated",onUserDeauthenticated:"jcUserDeauthenticated",onWorkstreamInvalidated:"jcWorkstreamInvalidated",onCommentCreated:"jcOnCommentCreated",onCommentDeleted:"jcOnCommentDeleted",onNotificationCountChanged:"jcOnNotificationCountChanged",fetchNotifications:"jcFetchNotifications",onEntityMemberStatusChanged:"onEntityMemberStatusChanged",onProfileContactChanged:"onProfileContactChanged",
onUnreadConversationCountUpdate:"jcOnUnreadConversationCountUpdate",onUnreadConversationCountChanged:"jc-ng-on-unread-conversation-count-changed",onConversationMarkedAsRead:"jcOnConversationMarkedAsRead",onResetPageTitle:"jcOnResetPageTitle",onConversationSettingsChanged:"jcOnConversationSettingsChanged",onVisibilityChanged:"onVisibilityChanged",onWebNotificationGrantRequestAnswered:"jcOnWebNotificationGrantRequestAnswered",onPlatformConfigChanged:"jcOnPlatformConfigChanged",onNotificationClicked:"jcOnNotificationClicked",onManifestVersionChanged:"jcOnManifestVersionChanged",wrapperUpgradeProgressEvent:"wrapperUpgradeProgressEvent",onAppResume:"jcOnAppResume",onDownloadStarted:"jcOnDownloadStarted",onDownloadProgress:"jcOnDownloadProgress",onDownloadSuccessful:"jcOnDownloadSuccessful",onDownloadFailed:"jcOnDownloadFailed",onDownloadAborted:"jcOnDownloadAborted",onGotoState:"jcOnGotoState",i18nextLanguageChange:"i18nextLanguageChange",onAuthenticationRequired:"event:auth-loginRequired",onStartChat:"jc-ng-on-start-chat",onError:"jc-ng-on-error",onLogConfigurationVersionChanged:"onLogConfigurationVersionChanged",onChatFileUploadStarted:"onChatFileUploadStarted",onChatFileUploadProgress:"onChatFileUploadProgress",onChatFileUploadFinished:"onChatFileUploadFinished",onChatFileUploadFailed:"onChatFileUploadFailed",onChatFileUploadRetry:"onChatFileUploadRetry",onChatFilesSelectedForUpload:"onChatFilesSelectedForUpload",onCurrentUserUpdated:"onCurrentUserUpdated",onCurrentUserCreated:"onCurrentUserCreated",onCurrentUserDeleted:"onCurrentUserDeleted",onCurrentUserSwitched:"onCurrentUserSwitched",onHeaderTitleChanged:"onHeaderTitleChanged",onWindowFocus:"onWindowFocus",onWindowBlur:"onWindowBlur",onBackButtonUpdate:"onBackButtonUpdate"}}()),angular.module("juco.shared.common").constant("ImageSize",function(){return{ORIGINAL:"original",X_SMALL:"xsmall",SMALL:"small",NORMAL:"normal",BIG:"big",LARGE:"large",ICON_SMALL:"iconsmall",ICON_MEDIUM:"iconmedium",ICON:"icon",LOGO_SMALL:"logosmall",LOGO:"logo",MOBILE_LOGO:"mobilelogo",BANNER:"banner",HORIZONTAL_NAVIGATION:"horizontalNavigation",HORIZONTAL_NAVIGATION_SELECTED:"horizontalNavigationSelected",HEADING_BOX:"headingBoxWide",HEADING_BOX_NARROW:"headingBoxNarrow",ORIGINAL_UNSCALED:"originalunscaled",NG_LOGIN_PAGE_LOGO:"ngloginpagelogo",EMAIL_HEADER_LOGO:"emailHeaderLogo"}}()),angular.module("juco.shared.common").factory("Map",["OrderedSet","SortedSet",function(OrderedSet,SortedSet){function createBackingSet(strategy,sortFunction){switch(strategy){case sorted:return new SortedSet(sortFunction);case ordered:return new OrderedSet;case sortedValues:return new OrderedSet;default:return new OrderedSet}}function Map(strategy,sortFunction,mapValueFunction){function contains(value){return backingSet.contains(value)}function remove(key){return delete valueMap[key],backingSet.remove(key)}function entries(){var i,k,result=[],keys=backingSet.entries();for(i=0;i<keys.length;i++)k=keys[i],result.push({key:k,value:valueMap[k]});return strategy===sortedValues&&sortFunction&&(result=sortEntries(result)),result}function sortEntries(entries){return mapValueFunction?mapBasedSort(entries,sortFunction,function(e){return mapValueFunction(e.value)}):entries.sort(function(e1,e2){return sortFunction(e1.value,e2.value)})}function keySet(){return backingSet}function values(){var i,k,result=[],keys=backingSet.entries();for(i=0;i<keys.length;i++)k=keys[i],result.push(valueMap[k]);return strategy===sortedValues&&(result=sortValues(result)),result}function sortValues(values){return mapValueFunction&&sortFunction?mapBasedSort(values,sortFunction,mapValueFunction):values.sort(sortFunction)}function mapBasedSort(values,compareFn,mapValueFn){var mappedValues=values.map(function(value,index){return{index:index,value:mapValueFn(value)}});return mappedValues.sort(function(v1,v2){return compareFn(v1.value,v2.value)}),mappedValues.map(function(mappedValue){return values[mappedValue.index]})}function size(){return backingSet.size()}function put(key,value){backingSet.add(key),valueMap[key]=value}function putFirst(key,value){backingSet.addFirst(key),valueMap[key]=value}function putLast(key,value){backingSet.addLast(key),valueMap[key]=value}function get(key){return valueMap[key]}function removeLast(){var keys=backingSet.entries(),lastKey=keys[keys.length-1];return!!lastKey&&(delete valueMap[lastKey],backingSet.removeLast(),!0)}function removeFirst(){var keys=backingSet.entries(),firstKey=keys[0];return!!firstKey&&(delete valueMap[firstKey],backingSet.removeFirst(),!0)}function clear(){backingSet.clear(),valueMap={}}var backingSet=createBackingSet(strategy,sortFunction),valueMap={},strategy=strategy,sortFunction=sortFunction,mapValueFunction=mapValueFunction;this.contains=contains,this.remove=remove,this.entries=entries,this.keySet=keySet,this.values=values,this.size=size,this.put=put,this.putFirst=putFirst,this.putLast=putLast,this.get=get,this.removeLast=removeLast,this.removeFirst=removeFirst,this.clear=clear}var sorted=1,ordered=2,sortedValues=3;return Map.setStrategy={sorted:sorted,ordered:ordered,sortedValues:sortedValues},Map}]),angular.module("juco.shared.common").factory("OrderedSet",[function(){function OrderedSet(){var orderedValues=[],valueSet={},contains=function(value){return value in valueSet},indexOf=function(value){if(contains(value))for(var i=0;i<orderedValues.length;i++)if(orderedValues[i]===value)return i;return-1},removeByIndex=function(index){var value;return!("undefined"==typeof index||index<0||index>=orderedValues.length)&&(value=orderedValues[index],delete valueSet[value],orderedValues.splice(index,1),!0)};this.remove=function(value){return removeByIndex(indexOf(value))},this.removeFirst=function(){return removeByIndex(0)},this.removeLast=function(){return removeByIndex(orderedValues.length-1)},this.entries=function(){return orderedValues},this.size=function(){return orderedValues.length},this.contains=contains,this.add=function(value){return!contains(value)&&(valueSet[value]=!0,orderedValues.push(value),!0)},this.addFirst=function(value){this.remove(value),valueSet[value]=!0,orderedValues.unshift(value)},this.addLast=function(value){this.remove(value),this.add(value)},this.addAll=function(values){for(var i=0;i<values.length;i++)this.add(values[i])},this.clear=function(){valueSet={},orderedValues.length=0}}return OrderedSet}]),angular.module("juco.shared.common").constant("ResolvedTokenType",{RESOURCE:"RESOURCE",STARTPAGE:"STARTPAGE",HOME:"HOME",NOT_SUPPORTED:"NOT_SUPPORTED",INVALID:"INVALID",FILE:"FILE",FOLDER:"FOLDER",NOTIFICATION_CENTER:"NOTIFICATION_CENTER",FEED:"FEED",CHANNELS:"CHANNELS",TASK:"TASK",TASK_LIST:"TASK_LIST"}),angular.module("juco.shared.common").constant("ResourceType",function(){return{PROFILE:"PROFILE",CONVERSATION:"CONVERSATION",ENTITY:"ENTITY",DOCUMENT:"DOCUMENT",COMMENT:"COMMENT",WORKSTREAM_MESSAGE:"WORKSTREAM_MESSAGE",ALBUM_IMAGE:"ALBUM_IMAGE",LINK:"LINK",VIDEOLINK:"VIDEOLINK",NOTIFICATION:"NOTIFICATION",DRIVE_DOCUMENT:"DRIVE_DOCUMENT",SHARE:"SHARE",TASK:"TASK",TASK_LIST:"TASK_LIST"}}()),angular.module("juco.shared.common").factory("SortedSet",[function(){function SortedSet(sortFunction){function contains(value){return value in valueSet}function indexOf(value){for(var i=0,l=sortedValues.length;i<l;){if(sortedValues[i]===value)return i;++i}return-1}function removeByIndex(index){return!("undefined"==typeof index||index<0||index>=sortedValues.length)&&(delete valueSet[sortedValues[index]],sortedValues.splice(index,1),!0)}function addWithoutSorting(value){return!contains(value)&&(valueSet[value]=!0,sortedValues.push(value),!0)}function remove(value){return removeByIndex(indexOf(value))}function entries(){return sortedValues}function size(){return sortedValues.length}function add(value){var result=addWithoutSorting(value);return result&&sortedValues.sort(sortFunction),result}function addAll(values){for(var result=!0,i=0,l=values.length;i<l;)result=result&&addWithoutSorting(values[i]),++i;return sortedValues.sort(sortFunction),result}function clear(){valueSet={},sortedValues.length=0}var sortedValues=[],valueSet={};this.add=add,this.addFirst=add,this.addLast=add,this.addAll=addAll,this.contains=contains,this.indexOf=indexOf,this.entries=entries,this.size=size,this.remove=remove,this.removeFirst=remove,this.removeLast=remove,this.clear=clear}return SortedSet}]),function(){angular.module("juco.shared.common").directive("jcAutofocus",["$timeout",function($timeout){function isInteger(value){var intValue=parseInt(value,10);return intValue===value&&!isNaN(intValue)}function link($scope,$element,$attrs){var autofocusDelay,autofocusValue=$scope.$eval($attrs.jcAutofocus);autofocusValue!==!1&&(autofocusDelay=isInteger(autofocusValue)?autofocusValue:0,$timeout(function(){var el=$element[0],val=el.value;el.focus(),el.value="",el.value=val},autofocusDelay))}return{restrict:"A",link:link}}])}(),angular.module("juco.shared.common").directive("jcExternalRef",["ExternalRefUtil",function(ExternalRefUtil){return{priority:99,restrict:"A",link:ExternalRefUtil.createLinkFunction("jcExternalRef",!1)}}]),angular.module("juco.shared.common").directive("jcFocus",["$window",function($window){function handler(id){return function(){$window.document.getElementById(id).focus(),event.preventDefault()}}function linker(scope,element,attrs){element.on("click",handler(attrs.jcFocus))}return{restrict:"A",link:linker}}]),angular.module("juco.shared.common").directive("jcImgRef",["ExternalRefUtil",function(ExternalRefUtil){return{priority:99,restrict:"A",link:ExternalRefUtil.createLinkFunction("jcImgRef",!0,!0)}}]);var juco=juco||{};juco.baseConstants=function(){var apiContext="/toro";return{apiContext:apiContext,apiEndpoint:apiContext+"/api/v1",contextApiEndpoint:apiContext+"/context/api/v1",driveApiEndpoint:"/drive/api",notificationCenterApiEndpoint:"/notification/api",desktopClientUrl:"/toro/resource/html",defaultLanguage:"en",baseCookiePath:"/toro",jabberPingIntervalMs:45e3,jabberPingTimeoutMs:5e3,jabberReconnectIntervalMs:15e3,jabberMaxReconnectTimeMs:3e5,chatMessageMergeTime:6e4,errorMessageDisplayInterval:5e3,autoHideSnackbarDisplayInterval:1e4,fileUploadRetries:3}}();var juco=juco||{};juco.baseStates={CHAT_CONVERSATION:"conversation",PRIVATE_CLOUD_CONFIG:"private-cloud-config",PRIVATE_LOGIN:"dialog.login",EXTERNAL_LOGIN:"dialog.externalLogin"},angular.module("juco.shared.configuration").constant("EnvConfigState",function(){return{NOT_CONFIGURED:{value:"NOT_CONFIGURED",isConfigured:!1,loginState:juco.baseStates.PRIVATE_CLOUD_CONFIG},TEMPORARY:{value:"TEMPORARY",isConfigured:!1,loginState:juco.baseStates.PRIVATE_LOGIN},PRIVATE:{value:"PRIVATE",isConfigured:!0,loginState:juco.baseStates.PRIVATE_LOGIN},WEB:{value:"WEB",isConfigured:!0,loginState:juco.baseStates.PRIVATE_LOGIN}}}()),angular.module("juco.shared.configuration").service("BaseEnvironment",["EnvConfigState","CONFIG","$window","$q",function(EnvConfigState,CONFIG,$window,$q){function getConfigState(){return EnvConfigState.WEB}function isJustSocialNative(){return $window.justSocialAndroidSettings||$window.justSocialIosSettings}function isCordova(){return!1}function isAndroid(){return $window.justSocialAndroidSettings}function isIos(){return $window.justSocialIosSettings}function isDesktop(){return!1}function getServerBase(){return""}function getAbsoluteApiContext(){return CONFIG.apiContext}function getAbsoluteApiEndpoint(){return CONFIG.apiEndpoint}function getAbsoluteOauthApiEndpoint(){return CONFIG.oauthApiEndpoint}function getAbsoluteDriveApiEndpoint(){return CONFIG.driveApiEndpoint}function getAbsoluteContextApiEndpoint(){return CONFIG.contextApiEndpoint}function getAbsoluteNotificationCenterApiEndpoint(){return CONFIG.notificationCenterApiEndpoint}function getClientVersion(){return $q(function(resolve){resolve()})}function getDeviceType(){return"unknown"}function getDeviceId(){}this.getConfigState=getConfigState,this.isCordova=isCordova,this.isJustSocialNative=isJustSocialNative,this.isAndroid=isAndroid,this.isIos=isIos,this.isDesktop=isDesktop,this.getServerBase=getServerBase,this.getAbsoluteApiContext=getAbsoluteApiContext,this.getAbsoluteApiEndpoint=getAbsoluteApiEndpoint,this.getAbsoluteOauthApiEndpoint=getAbsoluteOauthApiEndpoint,this.getAbsoluteDriveApiEndpoint=getAbsoluteDriveApiEndpoint,this.getAbsoluteContextApiEndpoint=getAbsoluteContextApiEndpoint,this.getAbsoluteNotificationCenterApiEndpoint=getAbsoluteNotificationCenterApiEndpoint,this.getClientVersion=getClientVersion,this.getDeviceType=getDeviceType,this.getDeviceId=getDeviceId}]),angular.module("juco.shared.ngSharedResource").service("NgSharedResourceService",["$window",function($window){function destroyResourcesBeforeUnload(){var key,resources=$window.$jucoNgSharedResource.resources;for(key in resources)destroyResource(key);angular.element($window).off("beforeunload",destroyResourcesBeforeUnload)}function destroyResource(uniqueResourceName){var sharedResource=$window.$jucoNgSharedResource.resources,res=sharedResource[uniqueResourceName];if(res&&"function"==typeof res.onDestroy)try{res.onDestroy()}catch(e){}delete sharedResource[uniqueResourceName],delete $window.$jucoNgSharedResource.resourcesRootScopes[uniqueResourceName]}function getOrCreateResource($rootScope,uniqueResourceName,Resource){function cleanAngularAppData(){var resourceRootScopes=sharedResources.resourcesRootScopes[uniqueResourceName]||[],index=resourceRootScopes.indexOf($rootScope);if(index>=0&&resourceRootScopes.splice(index,1),resource&&"function"==typeof resource.onAngularAppDestroy)try{resource.onAngularAppDestroy($rootScope)}catch(e){}0===resourceRootScopes.length&&destroyResource(uniqueResourceName),deregisterRootScopeHandler&&(deregisterRootScopeHandler(),deregisterRootScopeHandler=void 0),angular.element($window).off("beforeunload",destroyResourcesBeforeUnload)}var deregisterRootScopeHandler,sharedResources=$window.$jucoNgSharedResource,resource=sharedResources.resources[uniqueResourceName];if("function"!=typeof Resource)throw"resourceCreator muss be a function";return sharedResources.resourcesRootScopes[uniqueResourceName]=sharedResources.resourcesRootScopes[uniqueResourceName]||[],sharedResources.resourcesRootScopes[uniqueResourceName].indexOf($rootScope)<0&&(sharedResources.resourcesRootScopes[uniqueResourceName].push($rootScope),deregisterRootScopeHandler=$rootScope.$on("$destroy",cleanAngularAppData)),resource?resource:(resource=new Resource,sharedResources.resources[uniqueResourceName]=resource,resource)}var isIE10=Function("/*@cc_on return 10===document.documentMode@*/")();$window.$jucoNgSharedResource=$window.$jucoNgSharedResource||{resources:{},resourcesRootScopes:{}},isIE10||angular.element($window).on("beforeunload",destroyResourcesBeforeUnload),this.getOrCreateResource=getOrCreateResource}]),angular.module("juco.shared.message").filter("conversationChatBuddyId",["CurrentUser","ConversationType",function(CurrentUser,ConversationType){return function(conversation){if(conversation&&conversation.type===ConversationType.ONE_ON_ONE){var participants=conversation.participants.concat(conversation.deletedParticipants);return participants[0].id===CurrentUser.getId()?participants[1].id:participants[0].id}}}]),angular.module("juco.shared.message").factory("ChatMessageSet",["MessageUtil",function(MessageUtil){function messageComparator(m1,m2){return null!==m1&&void 0!==m1||null!==m2&&void 0!==m2?null===m1||void 0===m1?1:null===m2||void 0===m2?-1:m1.id===m2.id?0:m1.createDate===m2.createDate?m2.id.localeCompare(m1.id):m1.createDate-m2.createDate:0}function ChatMessageSet(){function addMessage(message){var index=self.insertOne(message);return angular.isNumber(index)&&MessageUtil.addAdditionalInfo(message,getPrevious(index),getNext(index)),index}function addAllMessages(messages){var i;for(i=0;i<messages.length;i++)addMessage(messages[i])}function removeMessageById(messageId){var key=getIndexById(messageId);return key>=0&&self.remove(key),key>=0}function getMessageById(messageId){var key=getIndexById(messageId);return key>=0?self[key]:null}function getIndexById(messageId){var i;for(i=self.length-1;i>0;--i)if(self[i]&&self[i].id===messageId)return i;return-1}function getPrevious(index){return index<=0?null:self[index-1]}function getNext(index){return index>=self.length?null:self[index+1]}var self=this;SortedList.call(self,{compare:messageComparator,unique:!0}),this.addMessage=addMessage,this.addAllMessages=addAllMessages,this.removeMessageById=removeMessageById,this.getMessageById=getMessageById}return ChatMessageSet.prototype=new SortedList,ChatMessageSet.prototype.constructor=SortedList.prototype.constructor,ChatMessageSet}]),angular.module("juco.shared.message").constant("ChatMessageType",function(){return{CHAT_MESSAGE:"CHAT_MESSAGE",REMOVED_FROM_CONVERSATION:"REMOVED_FROM_CONVERSATION",ADDED_TO_CONVERSATION:"ADDED_TO_CONVERSATION",LEFT_CONVERSATION:"LEFT_CONVERSATION",YOU_WERE_REMOVED:"YOU_WERE_REMOVED",YOU_WERE_ADDED:"YOU_WERE_ADDED",CONVERSATION_TITLE_CHANGED:"CONVERSATION_TITLE_CHANGED",CONVERSATION_CREATED:"CONVERSATION_CREATED",ATTACHMENT_CHAT_MESSAGE:"ATTACHMENT_CHAT_MESSAGE",PERSON_DELETED:"PERSON_DELETED",NEW_MESSAGES:"NEW_MESSAGES"}}()),function(){var CHAT_THUMBNAIL_SIZE={MOBILE:"MOBILE",DESKTOP_LARGE:"DESKTOP_LARGE",DESKTOP_SMALL:"DESKTOP_SMALL"};angular.module("juco.shared.message").constant("CHAT_THUMBNAIL_SIZE",CHAT_THUMBNAIL_SIZE)}(),angular.module("juco.shared.message").constant("ConversationAction",function(){return{CONVERSATION_READ:"CONVERSATION_READ",CONVERSATION_MODIFY:"CONVERSATION_MODIFY",CONVERSATION_DELETE:"CONVERSATION_DELETE"}}()),angular.module("juco.shared.message").constant("ConversationControlMessageType",function(){return{MARK_CONVERSATION_AS_READ:"MARK_CONVERSATION_AS_READ",CONVERSATION_SETTINGS_CHANGED:"CONVERSATION_SETTINGS_CHANGED"}}()),angular.module("juco.shared.message").constant("ConversationType",function(){return{MULTI_USER_CHAT:"MULTI_USER_CHAT",ONE_ON_ONE:"ONE_ON_ONE"}}()),angular.module("juco.shared.message").constant("JcXmppMessageType",function(){return{incomingChatMesage:"INCOMING_CHAT_MESSAGE",outgoingChatMessage:"OUTGOING_CHAT_MESSAGE"}}()),function(){function FileUploadQueue(){function enqueue(newFiles){angular.isArray(newFiles)&&newFiles.length>0&&(queue=queue.concat(newFiles))}function getByConversation(conversationId){return queue.filter(function(file){return file.conversationId===conversationId})}function getNext(){return queue[0]}function dequeue(fileId){queue=queue.filter(function(file){return file.id!==fileId})}var queue=[];this.enqueue=enqueue,this.getByConversation=getByConversation,this.getNext=getNext,this.dequeue=dequeue}function ConversationFileUploadService($rootScope,EVENTS,CONFIG,REST,Upload,Environment,UUID,ProfileService,$window){function enqueue(conversationId,files){return files=files.map(function(file){var enqueuedFile={id:UUID.generate(),file:file,conversationId:conversationId};return enqueuedFile.abort=function(){abortUpload(enqueuedFile)},enqueuedFile}),fileUploadQueue.enqueue(files),uploading||doUpload(),getCurrentUploadsForConversation(conversationId)}function getCurrentUploadsForConversation(conversationId){return fileUploadQueue.getByConversation(conversationId)}function abortUpload(file){file.upload?(aborting=!0,file.upload.abort()):fileUploadQueue.dequeue(file.id)}function retryOrFail(file){return fileUploadQueue.dequeue(file.id),aborting?void(aborting=!1):(file.retries=file.retries||0,void(file.retries>=CONFIG.fileUploadRetries?$rootScope.$broadcast(EVENTS.onChatFileUploadFailed,file):($rootScope.$broadcast(EVENTS.onChatFileUploadRetry,file),file.retries++,file.upload=void 0,fileUploadQueue.enqueue([file]))))}function doUpload(){function error(reason){retryOrFail(current)}function update(progressEvent){var percentage=Math.ceil(progressEvent.loaded/progressEvent.total*100);(percentage>=lastProgress+PROGRESS_STEP||lastProgress>percentage)&&(current.progress=percentage,lastProgress=percentage,$rootScope.$broadcast(EVENTS.onChatFileUploadProgress,current))}function success(result){var message=result.data;fileUploadQueue.dequeue(current.id),$rootScope.$broadcast(EVENTS.onChatFileUploadFinished,current,message),ProfileService.getCurrentProfile().then(function(profile){message.sentFrom=profile,$rootScope.$broadcast(EVENTS.onNewConversationMessage,{message:message,conversationId:current.conversationId})})}var upload,current=fileUploadQueue.getNext();current&&!uploading&&(uploading=!0,upload=uploadFile(current.conversationId,current.file),upload.then(success,error,update)["finally"](function(){uploading=!1,doUpload()}),current.upload=upload,$rootScope.$broadcast(EVENTS.onChatFileUploadStarted,current))}function getJustToken(){return $window.just&&$window.just.auth&&$window.just.auth.token||""}function uploadFile(conversationId,file){var url=Environment.getAbsoluteApiEndpoint()+"/"+REST.message.CONVERSATION_MESSAGE(conversationId),token=getJustToken(),headers=token?{"just-token":token}:{};return Upload.upload({url:url,data:{attachment:file},headers:headers,bypassErrorInterceptor:!0})}var PROGRESS_STEP=1,fileUploadQueue=new FileUploadQueue,uploading=!1,lastProgress=0,aborting=!1;this.enqueue=enqueue,this.getCurrentUploadsForConversation=getCurrentUploadsForConversation}angular.module("juco.shared.message").service("ConversationFileUploadService",["$rootScope","EVENTS","CONFIG","REST","Upload","Environment","UUID","ProfileService","$window",ConversationFileUploadService])}(),angular.module("juco.shared.message").service("ConversationService",["$rootScope","EVENTS","ArrayUtil","RestService","REST","Cache","ConfigurationService",function($rootScope,EVENTS,ArrayUtil,RestService,REST,Cache,ConfigurationService){function invalidateAllConversationCaches(conversationId){conversationByIdCache.remove(conversationId),conversationTeaserByIdCache.remove(conversationId),conversationSettingsCache.remove(conversationId),conversationAllowedActionsCache.remove(conversationId)}function invalidateConversationAndTeaserCaches(conversationId){conversationByIdCache.remove(conversationId),conversationTeaserByIdCache.remove(conversationId)}function getConversation(conversationId,bypassErrorInterceptor){return Cache.getCachedPromise(conversationId,conversationByIdCache,function(){return RestService.get(REST.message.CONVERSATION(conversationId),null,bypassErrorInterceptor)})}function loadConversation(conversationId,bypassErrorInterceptor){return conversationByIdCache.remove(conversationId),getConversation(conversationId,bypassErrorInterceptor)}function updateConversation(conversation,bypassErrorInterceptor){return RestService.put(REST.message.CONVERSATION(conversation.id),conversation,bypassErrorInterceptor).then(function(updatedConversation){return conversationByIdCache.put(updatedConversation.id,updatedConversation),updatedConversation})}function deleteConversation(conversationId,bypassErrorInterceptor){return RestService["delete"](REST.message.CONVERSATION(conversationId),{},bypassErrorInterceptor).then(function(){invalidateAllConversationCaches(conversationId),$rootScope.$broadcast(EVENTS.onRemovedFromConversation,conversationId)})}function getConversationConfig(){return ConfigurationService.getConfiguration().then(function(config){return config.conversationConfig})}function getConversations(offset,limit){return RestService.get(REST.message.CONVERSATIONS(),{limit:limit,offset:offset}).then(function(conversations){return conversations.forEach(function(conversation){conversationByIdCache.put(conversation.id,conversation)}),conversations})}function getConversationTeasers(offset,limit){return RestService.get(REST.message.CONVERSATION_TEASERS(),{limit:limit,offset:offset}).then(handleLoadedConversationTeasers)}function getConversationOneOnOneTeasers(offset,limit){return RestService.get(REST.message.CONVERSATION_ONE_ON_ONE_TEASERS(),{limit:limit,offset:offset}).then(handleLoadedConversationTeasers)}function getConversationMultiUserTeasers(offset,limit){return RestService.get(REST.message.CONVERSATION_MULTI_USER_TEASERS(),{limit:limit,offset:offset}).then(handleLoadedConversationTeasers)}function handleLoadedConversationTeasers(conversationTeasers){return conversationTeasers.forEach(function(teaser){conversationTeaserByIdCache.put(teaser.id,teaser)}),conversationTeasers}function loadConversationTeaser(conversationId,bypassErrorInterceptor){return conversationTeaserByIdCache.remove(conversationId),Cache.getCachedPromise(conversationId,conversationTeaserByIdCache,function(){return RestService.get(REST.message.CONVERSATION_TEASER(conversationId),null,bypassErrorInterceptor)})}function startNewConversation(participantIds,title){var params={participantIds:participantIds,title:title};return RestService.post(REST.message.CONVERSATIONS(),params).then(function(conversation){return $rootScope.$broadcast(EVENTS.onNewConversation,conversation),conversation})}function updateParticipants(conversationId,participants,bypassErrorInterceptor){return getConversation(conversationId,bypassErrorInterceptor).then(function(conversation){var conversationForUpdating=angular.copy(conversation);return conversationForUpdating.participants=participants,updateConversation(conversationForUpdating,bypassErrorInterceptor)})}function updateTitle(conversationId,title,bypassErrorInterceptor){return getConversation(conversationId,bypassErrorInterceptor).then(function(conversation){var conversationForUpdating=angular.copy(conversation);return conversationForUpdating.title=title,updateConversation(conversationForUpdating,bypassErrorInterceptor)})}function leaveConversation(conversationId,userId,bypassErrorInterceptor){return getConversation(conversationId,bypassErrorInterceptor).then(function(conversation){var conversationForUpdating=angular.copy(conversation);return conversationForUpdating.participants=conversation.participants.filter(function(participant){return participant.id!==userId}),updateConversation(conversationForUpdating,bypassErrorInterceptor)})}function handleUserRemovedFromConversation(conversationId){invalidateAllConversationCaches(conversationId),$rootScope.$broadcast(EVENTS.onRemovedFromConversation,conversationId)}function handleUserAddedToConversation(conversationId){return invalidateAllConversationCaches(conversationId),getConversation(conversationId).then(function(conversation){$rootScope.$broadcast(EVENTS.onNewConversation,conversation)})}function handleUpdatedParticipantListInConversation(conversationId){invalidateConversationAndTeaserCaches(conversationId),$rootScope.$broadcast(EVENTS.onParticipantsUpdated,conversationId)}function handleConversationTitleChanged(conversationId){return invalidateConversationAndTeaserCaches(conversationId),loadConversationTeaser(conversationId).then(function(conversation){$rootScope.$broadcast(EVENTS.onConversationTitleChanged,conversation)})}function handleMarkConversationAsReadControlMessage(conversationId){$rootScope.$broadcast(EVENTS.onConversationMarkedAsRead,{conversationId:conversationId,count:0})}function handleResetPageTitleControlMessage(){$rootScope.$broadcast(EVENTS.onResetPageTitle)}function handleConversationSettingsChangedControlMessage(conversationSettings){var teaser=conversationTeaserByIdCache.get(conversationSettings.conversationId),apiConversationSettings={conversationId:conversationSettings.conversationId,participantId:conversationSettings.participantId,muted:conversationSettings.muted,hidden:conversationSettings.hidden};conversationSettingsCache.put(apiConversationSettings.conversationId,apiConversationSettings),teaser&&(teaser.muted=apiConversationSettings.muted),$rootScope.$broadcast(EVENTS.onConversationSettingsChanged,apiConversationSettings)}function suggestConversation(query,sortBy,offset,limit){var params={query:query,sortBy:sortBy,offset:offset,count:limit};return RestService.get(REST.message.CONVERSATION_SUGGEST(),params)}function suggestParticipant(query,sortBy,offset,limit){var params={query:query,sortBy:sortBy,offset:offset,count:limit};return RestService.get(REST.message.PARTICIPANT_SUGGEST(),params)}function getFilesByConversationId(conversationId,offset,limit){var params={limit:limit};return offset&&(params.offset=angular.isDate(offset)?offset.toISOString():new Date(offset).toISOString()),RestService.get(REST.message.ATTACHMENTS(conversationId),params)}function getConversationSettings(conversationId){return Cache.getCachedPromise(conversationId,conversationSettingsCache,function(){return RestService.get(REST.message.CONVERSATION_SETTINGS(conversationId))})}function updateConversationSettings(conversationSettings){return RestService.put(REST.message.CONVERSATION_SETTINGS(conversationSettings.conversationId),conversationSettings).then(function(updatedConversationSettings){return conversationSettingsCache.put(updatedConversationSettings.conversationId,updatedConversationSettings),$rootScope.$broadcast(EVENTS.onConversationSettingsChanged,updatedConversationSettings),updatedConversationSettings})}function getUnreadConversationsCount(bypassErrorInterceptor){return RestService.get(REST.message.CONVERSATION_UNREAD(),{},bypassErrorInterceptor)}function getConversationAllowedActions(conversationId,bypassErrorInterceptor){return Cache.getCachedPromise(conversationId,conversationAllowedActionsCache,function(){return RestService.get(REST.message.CONVERSATION_ALLOWED_ACTIONS(conversationId),{},bypassErrorInterceptor)})}function invalidateConversationSettingsOnNewMessage(conversationId){var settings=conversationSettingsCache.get(conversationId);settings&&settings.hidden&&conversationSettingsCache.remove(conversationId)}var conversationByIdCache=Cache.createCache("conversationByIdCache"),conversationTeaserByIdCache=Cache.createCache("conversationTeaserByIdCache"),conversationSettingsCache=Cache.createCache("conversationSettingsCache"),conversationAllowedActionsCache=Cache.createCache("conversationAllowedActions");this.loadConversationTeaser=loadConversationTeaser,this.getConversationTeasers=getConversationTeasers,this.getConversationOneOnOneTeasers=getConversationOneOnOneTeasers,this.getConversationMultiUserTeasers=getConversationMultiUserTeasers,this.leaveConversation=leaveConversation,this.handleUserRemovedFromConversation=handleUserRemovedFromConversation,this.handleUserAddedToConversation=handleUserAddedToConversation,this.handleUpdatedParticipantListInConversation=handleUpdatedParticipantListInConversation,this.handleConversationTitleChanged=handleConversationTitleChanged,this.getConversations=getConversations,this.getConversation=getConversation,this.loadConversation=loadConversation,this.startNewConversation=startNewConversation,this.updateParticipants=updateParticipants,this.getConversationConfig=getConversationConfig,this.updateTitle=updateTitle,this.updateConversation=updateConversation,this.deleteConversation=deleteConversation,this.handleMarkConversationAsReadControlMessage=handleMarkConversationAsReadControlMessage,this.handleResetPageTitleControlMessage=handleResetPageTitleControlMessage,this.handleConversationSettingsChangedControlMessage=handleConversationSettingsChangedControlMessage,this.suggestConversation=suggestConversation,this.suggestParticipant=suggestParticipant,this.getFilesByConversationId=getFilesByConversationId,this.getConversationSettings=getConversationSettings,this.updateConversationSettings=updateConversationSettings,this.getUnreadConversationsCount=getUnreadConversationsCount,this.getConversationAllowedActions=getConversationAllowedActions,this.invalidateConversationSettingsOnNewMessage=invalidateConversationSettingsOnNewMessage}]),angular.module("juco.shared.message").service("ConversationMarkAsReadService",["RestService","REST","$interval","$rootScope","EVENTS","Cache",function(RestService,REST,$interval,$rootScope,EVENTS,Cache){function markReadImmediately(conversationId){var callTime=Date.now(),sameConversationAsLastTime=conversationId===lastConversationId;return lastConversationId=conversationId,RestService.post(REST.message.CONVERSATION_MARK_READ(conversationId)).then(function(unreadCount){
var cachedLastReadDate=lastReadDateCache.get(conversationId);return sameConversationAsLastTime&&cachedLastReadDate&&callTime-cachedLastReadDate.callTime<3e3?unreadCount.unreadMessagesCount.lastReadDate=cachedLastReadDate.lastReadDate:lastReadDateCache.put(conversationId,{lastReadDate:unreadCount.unreadMessagesCount.lastReadDate,callTime:callTime}),$rootScope.$broadcast(EVENTS.onConversationMarkedAsRead,unreadCount.unreadMessagesCount),$rootScope.$broadcast(EVENTS.onUnreadConversationCountUpdate,unreadCount.unreadConversationsCount.count),unreadCount})}function markConversationReadInternal(){0===Object.keys(ids).length?($interval.cancel(refreshIntervalPromise),refreshIntervalPromise=void 0):(Object.keys(ids).forEach(markReadImmediately),ids={})}function markConversationRead(conversationId){ids[conversationId]=conversationId,refreshIntervalPromise||(refreshIntervalPromise=$interval(markConversationReadInternal,persistInterval))}var refreshIntervalPromise,lastConversationId,persistInterval=1e3,ids={},lastReadDateCache=Cache.createCache("lastReadDateCache");this.markConversationRead=markConversationRead,this.markConversationReadImmediately=markReadImmediately}]),angular.module("juco.shared.message").service("MessageService",["$rootScope","EVENTS","JcXmppMessageType","ChatMessageType","RestService","$q","PromiseUtil","REST","ProfileService","ArrayUtil","XmppService","XmppConnectionService","ConversationMarkAsReadService","ConversationService",function($rootScope,EVENTS,JcXmppMessageType,ChatMessageType,RestService,$q,PromiseUtil,REST,ProfileService,ArrayUtil,XmppService,XmppConnectionService,ConversationMarkAsReadService,ConversationService){function mergeMessagesAndParticipant(messages,conversation){var participants=conversation.participants.concat(conversation.deletedParticipants),participantMap=ArrayUtil.toUniqueIndex(participants,"id");return messages.subList=messages.subList.map(function(message){return message.sentFrom=participantMap[message.sentFrom],message}),messages}function getMessagesAroundId(conversationId,messageId,limit){var params={limit:limit||30};return $q.all([RestService.get(REST.message.MESSAGE(messageId),params),ConversationService.getConversation(conversationId)]).then(PromiseUtil.spread(function(messageSection,conversation){return mergeMessagesAndParticipant(messageSection.messagesBefore,conversation),mergeMessagesAndParticipant({subList:[messageSection.currentMessage]},conversation),mergeMessagesAndParticipant(messageSection.messagesAfter,conversation),messageSection}))}function getMessages(conversationId,limit,offset,direction){var params={};return params.limit=limit,params.loadDirection=direction,offset&&(params.offset=angular.isDate(offset)?offset.toISOString():new Date(offset).toISOString()),RestService.get(REST.message.CONVERSATION_MESSAGE(conversationId),params)}function searchMessages(conversationId,query,sortBy,offset,limit){var params={query:query,offset:offset,count:limit};return sortBy&&(params.sortBy=sortBy),RestService.get(REST.message.CONVERSATION_MESSAGE(conversationId),params)}function getMessagesForConversationInternal(conversationId,limit,offset,direction){return $q.all([getMessages(conversationId,limit,offset,direction),ConversationService.getConversation(conversationId)]).then(PromiseUtil.spread(function(messages,conversation){return mergeMessagesAndParticipant(messages,conversation)}))}function sendMessage(message,conversationId){return $q.all([ProfileService.getCurrentProfile(),RestService.post(REST.message.CONVERSATION_MESSAGE(conversationId),{message:message})]).then(PromiseUtil.spread(function(profile,msg){return msg.sentFrom=profile,broadcastOwnMessageAsNewMessage(msg,conversationId),msg}))}function broadcastOwnMessageAsNewMessage(message,conversationId){$rootScope.$broadcast(EVENTS.onNewConversationMessage,{message:message,conversationId:conversationId})}function getMessagesForConversation(conversationId,offset,direction){return getMessagesForConversationInternal(conversationId,15,offset,direction)}function getInitialMessagesForConversation(conversationId){return getMessagesForConversationInternal(conversationId,30)}this.getMessagesAroundId=getMessagesAroundId,this.sendMessage=sendMessage,this.getMessagesForConversation=getMessagesForConversation,this.getInitialMessagesForConversation=getInitialMessagesForConversation,this.searchMessages=searchMessages}]),angular.module("juco.shared.message").service("MessageReceiverService",["$rootScope","EVENTS","ArrayUtil","XmppConnectionService","ConversationService","ChatMessageType","ConversationControlMessageType","$log","ERROR","MessageUtil",function($rootScope,EVENTS,ArrayUtil,XmppConnectionService,ConversationService,ChatMessageType,ConversationControlMessageType,$log,ERROR,MessageUtil){function mergeMessageAndParticipant(message,participants){var participantMap=ArrayUtil.toUniqueIndex(participants,"id");return message.sentFrom=participantMap[message.sentFrom],message}function handleNotifications(payload){switch(payload.type){case ChatMessageType.YOU_WERE_REMOVED:return ConversationService.handleUserRemovedFromConversation(payload.conversationId),!1;case ChatMessageType.YOU_WERE_ADDED:return ConversationService.handleUserAddedToConversation(payload.conversationId),!1;case ChatMessageType.REMOVED_FROM_CONVERSATION:case ChatMessageType.ADDED_TO_CONVERSATION:case ChatMessageType.LEFT_CONVERSATION:case ChatMessageType.PERSON_DELETED:return ConversationService.handleUpdatedParticipantListInConversation(payload.conversationId),!0;case ChatMessageType.CONVERSATION_TITLE_CHANGED:return ConversationService.handleConversationTitleChanged(payload.conversationId),!0;case ChatMessageType.CHAT_MESSAGE:case ChatMessageType.ATTACHMENT_CHAT_MESSAGE:return!0;case ConversationControlMessageType.MARK_CONVERSATION_AS_READ:return ConversationService.handleMarkConversationAsReadControlMessage(payload.parameters.conversationId),ConversationService.handleResetPageTitleControlMessage(),!1;case ConversationControlMessageType.CONVERSATION_SETTINGS_CHANGED:return ConversationService.handleConversationSettingsChangedControlMessage(payload.parameters.conversationSettings),!1}return!0}function raiseMessageError(msg,originText){$rootScope.$broadcast(EVENTS.onError,{type:ERROR.CHAT.JABBER_MESSAGE_ERROR,code:msg.errorCode,message:originText})}function raiseOnNewConversationMessage(jsonMessage,handlerIndex){var conversationId=jsonMessage.conversationId;return conversationId?(jsonMessage.type!==ChatMessageType.CHAT_MESSAGE&&jsonMessage.type!==ChatMessageType.ATTACHMENT_CHAT_MESSAGE||ConversationService.invalidateConversationSettingsOnNewMessage(conversationId),void ConversationService.getConversation(conversationId).then(function(conversation){$rootScope.$broadcast(EVENTS.onNewConversationMessage,{message:mergeMessageAndParticipant(jsonMessage,conversation.participants.concat(conversation.deletedParticipants)),conversationId:conversationId,handlerIndex:handlerIndex})})):void $log.warn("Ignoring new message without conversationId: ",jsonMessage)}function onJabberMessage(message){var msg=message.message,jsonMessage=angular.fromJson(decodeURIComponent(msg.message));XmppConnectionService.getChatSettings().then(function(settings){var from=msg.from,processFurther=!0,messageType=msg.type;if(MessageUtil.removeResourceFromJid(from)!==MessageUtil.removeResourceFromJid(settings.messageDistributorJid))return void $log.debug("Got message from: "+from+"\nWe will ignore this message: "+msg.message);switch(messageType){case"error":raiseMessageError(msg,jsonMessage.message);break;case"headline":if(processFurther=handleNotifications(jsonMessage),!processFurther)break;case"chat":case"group-chat":case"normal":default:raiseOnNewConversationMessage(jsonMessage,message.handlerIndex)}})}this.onJabberMessage=onJabberMessage}]),function(){function FileIconUtil(DRIVE_MIME_TYPES,Environment){function lookupFileIconUrl(mimeType){var typePair=mimeType.split("/",2),type=typePair[0],subType=typePair[1],canonicalFileName=type+"-"+subType+".png",typeFileName=type+".png",fallbackFileName="application-octet-stream.png",resultIcon=DRIVE_MIME_TYPES.indexOf(canonicalFileName)!==-1?canonicalFileName:DRIVE_MIME_TYPES.indexOf(typeFileName)!==-1?typeFileName:fallbackFileName;return Environment.getServerBase()+"/toro/file-icons/"+resultIcon}function getFileIconUrl(mimeType){return cache[mimeType]||(cache[mimeType]=lookupFileIconUrl(mimeType)),cache[mimeType]}var cache={};this.getFileIconUrl=getFileIconUrl}angular.module("juco.shared.message").service("FileIconUtil",["DRIVE_MIME_TYPES","Environment",FileIconUtil])}(),angular.module("juco.shared.message").service("MessageComposerCache",["Map",function(Map){function setMessage(conversationId,text){conversationId&&(text&&text!==EMPTY_MESSAGE?CACHE.put(conversationId,text):CACHE.remove(conversationId))}function getMessage(conversationId){var text=CACHE.get(conversationId);return text?text:EMPTY_MESSAGE}function resetMessage(conversationId){setMessage(conversationId)}var CACHE=new Map,EMPTY_MESSAGE="";this.setMessage=setMessage,this.getMessage=getMessage,this.resetMessage=resetMessage,this.getSize=CACHE.size}]),angular.module("juco.shared.message").service("MessageUtil",["ChatMessageType","CONFIG","ArrayUtil","DateUtil","CurrentUser",function(ChatMessageType,CONFIG,ArrayUtil,DateUtil,CurrentUser){function addAdditionalInfo(message,previousMessage,nextMessage){var hasSuccessor=isSuccessorMessage(message,nextMessage),isSuccessor=isSuccessorMessage(previousMessage,message);message.isSuccessor=isSuccessor,message.hasSuccessor=hasSuccessor,message.isFirstOfANewDay=isMessageFirstOfANewDay(previousMessage,message),previousMessage&&(previousMessage.hasSuccessor=isSuccessor),nextMessage&&(nextMessage.isSuccessor=hasSuccessor,nextMessage.isFirstOfANewDay=isMessageFirstOfANewDay(message,nextMessage))}function isMessageFirstOfANewDay(olderMessage,newerMessage){return!olderMessage||!DateUtil.isSameDay(olderMessage.createDate,newerMessage.createDate)}function isSuccessorMessage(olderMessage,newerMessage){return!(!olderMessage||!newerMessage)&&(!(olderMessage.type!==ChatMessageType.CHAT_MESSAGE&&olderMessage.type!==ChatMessageType.ATTACHMENT_CHAT_MESSAGE||newerMessage.type!==ChatMessageType.CHAT_MESSAGE&&newerMessage.type!==ChatMessageType.ATTACHMENT_CHAT_MESSAGE||olderMessage.sentFrom.id!==newerMessage.sentFrom.id)&&(!(newerMessage.createDate-olderMessage.createDate>=CONFIG.chatMessageMergeTime)&&DateUtil.isSameDay(olderMessage.createDate,newerMessage.createDate)))}function sortParticipants(participants){return participants.sort(function(p1,p2){var order=ArrayUtil.defaultComparator(p1.lastname,p2.lastname);return 0!==order?order:(order=ArrayUtil.defaultComparator(p1.firstname,p2.firstname),0!==order?order:ArrayUtil.defaultComparator(p1.id,p2.id))})}function isMultiUserChat(participantIds){return 0===participantIds.length||1===participantIds.length&&participantIds[0]===CurrentUser.getId()||2===participantIds.length&&participantIds.indexOf(CurrentUser.getId())===-1||participantIds.length>2}function removeResourceFromJid(jid){return"string"!=typeof jid||""===jid?"":jid.replace(/\/.*/g,"")}this.addAdditionalInfo=addAdditionalInfo,this.sortParticipants=sortParticipants,this.isMultiUserChat=isMultiUserChat,this.isMessageFirstOfANewDay=isMessageFirstOfANewDay,this.removeResourceFromJid=removeResourceFromJid}]),angular.module("juco.shared.profile").service("ProfileService",["RestService","$q","REST","CONFIG","PROFILE","CurrentUser","$rootScope","EVENTS","Cache","PromiseUtil",function(RestService,$q,REST,CONFIG,PROFILE,CurrentUser,$rootScope,EVENTS,Cache,PromiseUtil){function cacheKey(id,params){var key=id;return params&&params.offset&&(key+="+"+params.offset),key}function removeFromAllCaches(contactId){contactCache.remove(contactId),myContactsCache.removeAll(),profileCache.remove(contactId),attributesCache.remove(contactId)}function updateContactStatus(contactId,newStatus,bypassErrorHandler){var contactStatus={contactStatus:newStatus,allowedActions:[]},personId=CurrentUser.getId(),promise=RestService.put(REST.profile.CONTACT_STATUS(personId,contactId),contactStatus,bypassErrorHandler).then(function(data){return removeFromAllCaches(contactId),$rootScope.$broadcast(EVENTS.onProfileContactChanged,{personId:personId,contactId:contactId,newStatus:data.contactStatus}),data},function(error){return removeFromAllCaches(contactId),$q.reject(error)});return promise}function getProfile(id){return Cache.getCachedPromise(id,profileCache,function(){return RestService.get(REST.profile.PROFILE(id))})}function getContactsForPerson(id,params){return Cache.getCachedPromise(cacheKey(id,params),myContactsCache,function(){return RestService.get(REST.profile.CONTACTS(id),params)})}function declineContactRequest(contactId,bypassErrorHandler){return updateContactStatus(contactId,PROFILE.contactStatus.NONE,bypassErrorHandler)}function withdrawContactRequest(contactId,bypassErrorHandler){return updateContactStatus(contactId,PROFILE.contactStatus.NONE,bypassErrorHandler)}function acceptContactRequest(contactId,bypassErrorHandler){return updateContactStatus(contactId,PROFILE.contactStatus.CONTACT,bypassErrorHandler)}function sendContactRequest(contactId,bypassErrorHandler){return updateContactStatus(contactId,PROFILE.contactStatus.SENT_CONTACT_REQUEST,bypassErrorHandler)}function removeContact(contactId,bypassErrorHandler){return updateContactStatus(contactId,PROFILE.contactStatus.NONE,bypassErrorHandler)}function getContactStatus(userId,contactId){return Cache.getCachedPromise(contactId,contactCache,function(){return RestService.get(REST.profile.CONTACT_STATUS(userId,contactId))})}function getSettingCached(settingKey){return Cache.getCachedPromise(SETTINGS_CACHE_KEY,settingsCache,function(){return RestService.get(REST.profile.SETTINGS(CurrentUser.getId()))}).then(function(settings){return settings[settingKey]})}function getSetting(settingKey,bypassErrorHandler){return RestService.get(REST.profile.SETTINGS(CurrentUser.getId()),{},bypassErrorHandler).then(function(settings){return settingsCache.put(SETTINGS_CACHE_KEY,settings),settings[settingKey]})}function updateSetting(settingKey,settingValue){var settings={},currentSettings=settingsCache.get(SETTINGS_CACHE_KEY);return currentSettings&&currentSettings[settingKey]===angular.toJson(settingValue)?PromiseUtil.immediateResolve(currentSettings[settingKey]):(settings[settingKey]=settingValue,settingsCache.remove(SETTINGS_CACHE_KEY),RestService.put(REST.profile.SETTINGS(CurrentUser.getId()),settings).then(function(settings){return settingsCache.put(SETTINGS_CACHE_KEY,settings),settings[settingKey]}))}function getCurrentProfile(){return getProfile(CurrentUser.getId())}function getProfileAttributes(profileId){return Cache.getCachedPromise(profileId,attributesCache,function(){return RestService.get(REST.profile.ATTRIBUTES(profileId))})}function isActive(profile){return profile.active||profile.activated}function getProfileNamePrefixTranslationKey(profile){return isActive(profile)&&profile.blocked?"profile.blockedUserPrefix":!isActive(profile)&&profile.blocked?"profile.deactivatedAndBlockedUserPrefix":isActive(profile)||profile.blocked?"":"profile.deactivatedUserPrefix"}var profileCache=Cache.createCache("profileCache"),myContactsCache=Cache.createCache("myContactsCache"),contactCache=Cache.createCache("contactCache"),SETTINGS_CACHE_KEY="settings",settingsCache=Cache.createCache("settingsCache"),attributesCache=Cache.createCache("attributesCache");this.getProfile=getProfile,this.getContactsForPerson=getContactsForPerson,this.declineContactRequest=declineContactRequest,this.withdrawContactRequest=withdrawContactRequest,this.acceptContactRequest=acceptContactRequest,this.sendContactRequest=sendContactRequest,this.removeContact=removeContact,this.getContactStatus=getContactStatus,this.getSettingCached=getSettingCached,this.getSetting=getSetting,this.updateSetting=updateSetting,this.getCurrentProfile=getCurrentProfile,this.getProfileAttributes=getProfileAttributes,this.getProfileNamePrefixTranslationKey=getProfileNamePrefixTranslationKey}]),angular.module("juco.shared.profile").constant("PROFILE",{contactStatus:{CONTACT:"CONTACT",NONE:"NONE",HAS_CONTACT_REQUEST:"HAS_CONTACT_REQUEST",SENT_CONTACT_REQUEST:"SENT_CONTACT_REQUEST"},contactAction:{ADD_CONTACT:"ADD_CONTACT",REMOVE_CONTACT:"REMOVE_CONTACT",WITHDRAW_CONTACT_REQUEST:"WITHDRAW_CONTACT_REQUEST",ACCEPT_CONTACT_REQUEST:"ACCEPT_CONTACT_REQUEST"}}),angular.module("juco.shared.rest").service("RestService",["$q","$http","Environment","$window",RestService]),angular.module("juco.shared.rest").service("UriService",["$log",function($log){var EXPANSION_PATTERN=/({(.+?)})/g;this.toTmpl=function(uriTemplate){if(!uriTemplate)throw $log.error("no uri template given"),"no uri template given";return function(){var args=Array.prototype.slice.call(arguments);return args.unshift(uriTemplate),expand.apply(this,args)}};var expand=function(uriTemplate,values){return angular.isArray(values)?expandFromArray(uriTemplate,values):angular.isObject(values)?expandFromObject(uriTemplate,values):expandFromArray(uriTemplate,Array.prototype.slice.call(arguments,1))},expandFromArray=function(template,values){for(var groups,result=template,valueIndex=0;null!==(groups=EXPANSION_PATTERN.exec(template));)result=result.replace(groups[1],values[valueIndex++]);return result},expandFromObject=function(template,values){for(var groups,value,result=template;null!==(groups=EXPANSION_PATTERN.exec(template));)value=values[groups[2]],value&&(result=result.replace(groups[1],value));return result}}]),angular.module("juco.shared.rest").factory("REST",["UriService",function(UriService){"ngInject";var WORKSTREAM_BASE="workstream",LIKE_BASE="like",DOCUMENT_BASE="document",COMMENT_BASE="comment",ENTITY_BASE="entity",PROFILE_BASE="person",NOTIFICATION_BASE="notification",CHILD_ENTITIES_BASE="childentities",TOKEN_BASE="token",CONFIG_BASE="config",MY_CONTENT_BASE="mycontent",CONVERSATION_BASE="conversation",SEARCH_BASE="search",CHAT_BASE="chat",PLATFORM_INFO_BASE="info",ACCOUNT_BASE="account",PUSH_BASE="push",PUSH_REGISTRATION_BASE=PUSH_BASE+"/registration",UPDATES_BASE="updates",UPGRADE_BASE="upgrade",PERSON_BASE="person",OAUTH_BASE="oauth",LOG_BASE="log",THEME_BASE="theme",DRIVE_BASE="shares",DRIVE_DOCUMENT_BASE="documents",DRIVE_PREVIEW_BASE="previews",JWT_BASE="jwt",TASK_BASE="task_app";return{chat:{SETTINGS:UriService.toTmpl(CHAT_BASE+"/settings"),PASSWORD:UriService.toTmpl(CHAT_BASE+"/password"),PRESENCE:UriService.toTmpl(CHAT_BASE+"/{personId}/presence"),PRESENCES:CHAT_BASE+"/presences"},childEntities:{BASE:CHILD_ENTITIES_BASE},comment:{BASE:UriService.toTmpl(COMMENT_BASE),COMMENT:UriService.toTmpl(COMMENT_BASE+"/{commentId}")},config:{BASE:UriService.toTmpl(CONFIG_BASE)},platformInfo:{BASE:UriService.toTmpl(PLATFORM_INFO_BASE)},document:{BASE:DOCUMENT_BASE,URL:UriService.toTmpl(DOCUMENT_BASE+"/url/{id}?inline={inline}"),DOCUMENTS:DOCUMENT_BASE+"/documents"},entity:{ENTITY:UriService.toTmpl(ENTITY_BASE+"/{entityId}"),MEMBER:UriService.toTmpl(ENTITY_BASE+"/{entityId}/members"),MEMBERS:UriService.toTmpl(ENTITY_BASE+"/{entityId}/members/{memberId}"),MULTI_WIKI:UriService.toTmpl(ENTITY_BASE+"/{entityId}/multiWiki"),WIKI:UriService.toTmpl(ENTITY_BASE+"/{entityId}/wiki"),RAW_EDITORS:UriService.toTmpl(ENTITY_BASE+"/{entityId}/rawEditors"),BASE_DATA:UriService.toTmpl(ENTITY_BASE+"/{entityId}/baseData"),ENTITIES:UriService.toTmpl(ENTITY_BASE+"/all/{entityType}"),ENTITIES_BY_TYPES:UriService.toTmpl(ENTITY_BASE+"/all/list/{entityTypes}"),SUBSCRIPTION:UriService.toTmpl(ENTITY_BASE+"/{entityId}/options/subscription")},like:{BASE:UriService.toTmpl(LIKE_BASE+"/{itemId}"),LIKERS:UriService.toTmpl(LIKE_BASE+"/{itemId}/likers")},message:{CONVERSATIONS:UriService.toTmpl(CONVERSATION_BASE),CONVERSATION:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}"),CONVERSATION_MESSAGE:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/message"),CONVERSATION_PARTICIPANT:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/participant"),CONVERSATION_UNREAD_COUNT:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/unreadCount"),CONVERSATION_MARK_READ:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/markRead"),CONVERSATION_SUGGEST:UriService.toTmpl(CONVERSATION_BASE+"/suggestConversations"),CONVERSATION_TEASER:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/teaser"),CONVERSATION_TEASERS:UriService.toTmpl(CONVERSATION_BASE+"/teasers"),CONVERSATION_ONE_ON_ONE_TEASERS:UriService.toTmpl(CONVERSATION_BASE+"/one-on-one/teasers"),CONVERSATION_MULTI_USER_TEASERS:UriService.toTmpl(CONVERSATION_BASE+"/multi-user/teasers"),CONVERSATION_UNREAD:UriService.toTmpl(CONVERSATION_BASE+"/unread"),CONTROL_MESSAGE:UriService.toTmpl(CONVERSATION_BASE+"/sendControlMessage/{type}"),MESSAGE:UriService.toTmpl(CONVERSATION_BASE+"/message/{messageId}"),MESSAGE_ATTACHMENT:UriService.toTmpl(CONVERSATION_BASE+"/message/{messageId}/attachment"),MESSAGE_ATTACHMENT_URL:UriService.toTmpl(CONVERSATION_BASE+"/message/{messageId}/attachment/url"),MESSAGE_THUMBNAIL:UriService.toTmpl(CONVERSATION_BASE+"/message/{messageId}/thumbnail?size={size}&fallbackToOriginalImage={fallbackToOriginalImage}"),ATTACHMENTS:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/attachment"),CONVERSATION_SETTINGS:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/settings"),CONVERSATION_ALLOWED_ACTIONS:UriService.toTmpl(CONVERSATION_BASE+"/{conversationId}/allowed-actions"),PARTICIPANT_SUGGEST:UriService.toTmpl(CONVERSATION_BASE+"/suggestParticipants")},myContent:{BASE:MY_CONTENT_BASE,TYPES:UriService.toTmpl(MY_CONTENT_BASE+"/list/{entityTypes}")},notification:{BASE:NOTIFICATION_BASE,FILTER:NOTIFICATION_BASE+"/filter"},notificationCenter:{NOTIFICATION:NOTIFICATION_BASE,COUNT:UriService.toTmpl(NOTIFICATION_BASE+"/count"),ARCHIVE_NOTIFICATION:UriService.toTmpl(NOTIFICATION_BASE+"/archive/{notificationId}"),MARK_NOTIFICATION:UriService.toTmpl(NOTIFICATION_BASE+"/{notificationId}/mark"),UNMARK_NOTIFICATION:UriService.toTmpl(NOTIFICATION_BASE+"/{notificationId}/unmark")},profile:{PROFILE:UriService.toTmpl(PROFILE_BASE+"/{personId}"),SETTINGS:UriService.toTmpl(PROFILE_BASE+"/{personId}/settings"),CONTACTS:UriService.toTmpl(PROFILE_BASE+"/{personId}/contacts"),CONTACT_STATUS:UriService.toTmpl(PROFILE_BASE+"/{personId}/contacts/{contactId}/status"),ATTRIBUTES:UriService.toTmpl(PROFILE_BASE+"/{personId}/attributes")},search:{SEARCH:UriService.toTmpl(SEARCH_BASE),SUGGEST:UriService.toTmpl(SEARCH_BASE+"/suggest")},token:{BASE:TOKEN_BASE,RESOLVE:TOKEN_BASE+"/resolve"},workstream:{BASE:UriService.toTmpl(WORKSTREAM_BASE+"/{workstreamId}"),BASE64:UriService.toTmpl(WORKSTREAM_BASE+"/b64/{workstreamId}"),MESSAGE:UriService.toTmpl(WORKSTREAM_BASE+"/message/{msgId}"),B64MESSAGE:UriService.toTmpl(WORKSTREAM_BASE+"/b64/message/{messageId}"),WORKSTREAM:UriService.toTmpl(WORKSTREAM_BASE+"/{workstreamId}"),PINNED_WORKSTREAM:UriService.toTmpl(WORKSTREAM_BASE+"/{workstreamId}/pinned"),PINNED_WORKSTREAM_HIDDEN:UriService.toTmpl(WORKSTREAM_BASE+"/{workstreamId}/pinned?hidden={hidden}")},account:{LOGIN_CODE:ACCOUNT_BASE+"/loginCode",ACCEPT_TERMS:UriService.toTmpl(ACCOUNT_BASE+"/acceptTerms?loginCode={loginCode}")},push:{BASE:UriService.toTmpl(PUSH_BASE),REGISTRATIONS:UriService.toTmpl(PUSH_REGISTRATION_BASE),REGISTRATION:UriService.toTmpl(PUSH_REGISTRATION_BASE+"/{registrationId}")},updates:{BASE:UriService.toTmpl(UPDATES_BASE)},upgrade:{BASE:UriService.toTmpl(UPGRADE_BASE),MANIFEST:UriService.toTmpl(UPGRADE_BASE+"/manifest")},person:{CURRENT:PERSON_BASE+"/current"},oauth:{token:{BASE:OAUTH_BASE+"/token",REVOKE:OAUTH_BASE+"/token/revoke"}},log:{BASE:LOG_BASE,CONFIGURATION:LOG_BASE+"/configuration",SEND:LOG_BASE+"/send"},theme:{BASE:UriService.toTmpl(THEME_BASE),THEME:UriService.toTmpl(THEME_BASE+"/{themeId}"),GLOBAL:UriService.toTmpl(THEME_BASE+"/global"),DEFAULT:UriService.toTmpl(THEME_BASE+"/info/default"),INFO:UriService.toTmpl(THEME_BASE+"/info/{entityId}")},drive:{BASE:UriService.toTmpl(DRIVE_BASE),DRIVE:UriService.toTmpl(DRIVE_BASE+"/{driveId}"),DOCUMENTS:UriService.toTmpl(DRIVE_DOCUMENT_BASE+"/folder/{folderId}"),SHARE_DOCUMENTS:UriService.toTmpl(DRIVE_DOCUMENT_BASE+"/item/{itemId}"),ACCESS_TOKEN:UriService.toTmpl(DRIVE_PREVIEW_BASE+"/preview/{documentId}/accessToken"),PREVIEW_VIDEO:UriService.toTmpl("unauthenticated/previewVideoFile/{accessToken}"),PREVIEW_IMAGE:UriService.toTmpl("unauthenticated/previewImage/{accessToken}")},jwt:{BASE:UriService.toTmpl(JWT_BASE)},task:{TASK:UriService.toTmpl(TASK_BASE+"/tasks/{taskId}"),NEW:UriService.toTmpl(TASK_BASE+"/tasks/{filterId}"),LIST:UriService.toTmpl(TASK_BASE+"/lists/{taskListId}"),MY_LISTS:UriService.toTmpl(TASK_BASE+"/lists/"),TASKS_FILTER:UriService.toTmpl(TASK_BASE+"/tasks/filter/{filter}"),STATUS:UriService.toTmpl(TASK_BASE+"/tasks/{taskId}/status/{status}"),DESCRIPTION:UriService.toTmpl(TASK_BASE+"/tasks/{taskId}/description"),ASSIGNEE:UriService.toTmpl(TASK_BASE+"/tasks/{taskId}/assignee"),TITLE:UriService.toTmpl(TASK_BASE+"/tasks/{taskId}/name"),DUE_DATE:UriService.toTmpl(TASK_BASE+"/tasks/{taskId}/duedate")}}}]),angular.module("juco.shared.search").constant("SortType",function(){return{relevance:"RELEVANCE",activity:"ACTIVITY",alphabetical:"ALPHABETICAL",timeAscending:"TIME_ASCENDING",timeDescending:"TIME_DESCENDING",publicationDate:"PUBLICATION_DATE",expirationDate:"EXPIRATION_DATE"}}()),angular.module("juco.shared.teaser").filter("jcHighlighting",["HtmlUtil",function(HtmlUtil){return function(text,options){var result,openingTag=options&&options.className?'<strong class="'+options.className+'">':"<strong>";return text?(result=HtmlUtil.escapeHtml(text).replace(/\[hl\]/gi,openingTag).replace(/\[\/hl\]/gi,"</strong>"),options&&options.emojify&&(result=HtmlUtil.emojify(result)),result):text}}]),angular.module("juco.shared.xmpp").constant("JcXmppPresenceType",function(){return{offline:"OFFLINE",connecting:"CONNECTING",online:"ONLINE",chat:"CHAT",away:"AWAY",xa:"XA",dnd:"DND",unknown:"UNKNOWN"}}()),angular.module("juco.shared.xmpp").constant("XmppPresenceUpdateOrigin",function(){return{USER:"USER",AUTO:"AUTO",REMOTE:"REMOTE"}}()),angular.module("juco.shared.xmpp").constant("JcXmppResourcePrefix",function(){return{DESKTOP:"desktop-",MOBILE_WEB:"mobile-web-",MOBILE_WRAPPER:"mobile-wrapper-"}}()),angular.module("juco.shared.xmpp").constant("XmppConnectionRejectReason",function(){return{ALREADY_CONNECTED:"ALREADY_CONNECTED",FAILED_TO_LOAD_PRECONDITIONS:"FAILED_TO_LOAD_PRECONDITIONS",ERROR:"ERROR"}}()),angular.module("juco.shared.xmpp").service("SharedXmppConnection",["$rootScope","NgSharedResourceService",function($rootScope,NgSharedResourceService){function generateUUID(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=16*Math.random()|0,v="x"==c?r:3&r|8;return v.toString(16)})}function SharedXmppConnection(){function start(){started&&stop(),window.addEventListener("storage",onStorageEvent),window.addEventListener("beforeunload",onBeforeUnloadEvent),checkInterval=setInterval(checkConnection,XMPP_CONNECTION_TAB_ALIVE_INTERVALL_IN_MS),checkConnection(),started=!0}function stop(){window.removeEventListener("storage",onStorageEvent),window.removeEventListener("beforeunload",onBeforeUnloadEvent),clearInterval(checkInterval),started=!1}function onStorageEvent(event){if(event.key===XMPP_CONNECTION_EVENT){var eventData=JSON.parse(storage.getItem(XMPP_CONNECTION_EVENT));fireEventToOurTab(eventData.event,eventData.data)}else if(event.key===XMPP_CONNECTION_TAB_ID){var xmppConnectionConnectionTabId=storage.getItem(XMPP_CONNECTION_TAB_ID);null==xmppConnectionConnectionTabId&&checkConnection()}else if(event.key===XMPP_CONNECTION_SET_MY_PRESENCE&&isTabWithConnection()){var setMyPresenceData=JSON.parse(storage.getItem(XMPP_CONNECTION_SET_MY_PRESENCE));setMyPresence(setMyPresenceData.presence)}}function onBeforeUnloadEvent(){hasXmppConnection()&&(storage.removeItem(XMPP_CONNECTION_TAB_LAST_ALIVE_DATE),storage.removeItem(XMPP_CONNECTION_TAB_ID),disconnect())}function checkConnection(){try{var hasConnection=hasXmppConnection();if(hasConnection)return void storage.setItem(XMPP_CONNECTION_TAB_LAST_ALIVE_DATE,(new Date).getTime());if(connection)return void disconnect();isLastAliveTimestampTimedOut()&&(establishConnection(),storage.setItem(XMPP_CONNECTION_TAB_LAST_ALIVE_DATE,(new Date).getTime()))}catch(e){console&&"function"==typeof console.error&&console.error("error during checkConnection in shared-xmpp-connection",e)}}function isLastAliveTimestampTimedOut(){var lastAliveDateMillis=parseInt(storage.getItem(XMPP_CONNECTION_TAB_LAST_ALIVE_DATE));return isNaN(lastAliveDateMillis)||lastAliveDateMillis+XMPP_CONNECTION_TAB_ALIVE_TIMEOUT_IN_MS<(new Date).getTime()}function hasXmppConnection(){return connection&&isTabWithConnection()}function establishConnection(){storage.setItem(XMPP_CONNECTION_TAB_ID,TAB_ID),fireEventToOurTab("onReconnect")}function getOrCreateScopeHandlers(scope){return handlers[scope.$id]=handlers[scope.$id]||{onConnect:[],onReconnect:[],onDisconnect:[],onError:[],onConnectingError:[],onPresence:[],onMessage:[],onMyPresenceChanged:[]},handlers[scope.$id]}function getScopeHandlers(scope,event){var scopeHandlers=getOrCreateScopeHandlers(scope),handlerArray=scopeHandlers[event];if(!handlerArray)throw'Event "'+event+'" does not exists';return handlerArray}function addHandler(scope,event,handler){var h=getScopeHandlers(scope,event);h.indexOf(handler)<0&&h.push(handler)}function getAllHandlers(event){var scopeId,scopeHandlers,allHandlers=[];for(scopeId in handlers)scopeHandlers=handlers[scopeId][event],scopeHandlers&&(allHandlers=allHandlers.concat(scopeHandlers));return allHandlers}function clearAngularHandlers(scope){delete handlers[scope.$id]}function onAngularAppDestroy(scope){clearAngularHandlers(scope)}function onDestroy(){hasConnectedXmppConnection()&&disconnect(),handlers={}}function initConnection(scope,config,jabberHandlers,loginData){var connectionSettings={httpbase:config.httpbase,timerval:2e3};setAngularAppHandlers(scope,jabberHandlers),connection||(xmppConfig=config,connection=new JSJaCHttpBindingConnection(connectionSettings),connection.connect(loginData),registerInternalHandler(connection),storage.setItem(XMPP_CONNECTION_TAB_ID,TAB_ID))}function setAngularAppHandlers(scope,jabberHandlers){clearAngularHandlers(scope),addHandler(scope,"onConnectingError",jabberHandlers.onConnectingError),addHandler(scope,"onConnect",jabberHandlers.onConnect),addHandler(scope,"onDisconnect",jabberHandlers.onDisconnect),addHandler(scope,"onReconnect",jabberHandlers.onReconnect),addHandler(scope,"onError",jabberHandlers.onError),addHandler(scope,"onMessage",jabberHandlers.onMessage),addHandler(scope,"onPresence",jabberHandlers.onPresence),addHandler(scope,"onMyPresenceChanged",jabberHandlers.onMyPresenceChanged)}function fireEventToOurTab(event,data){for(var allHandlers=getAllHandlers(event),i=0;i<allHandlers.length;i++)try{allHandlers[i](data,i)}catch(err){console.error("Error during call handler for event "+event)}return!0}function registerInternalHandler(conn){var handlerHash={onconnect:function(){if(stopReconnecting(),startPinging(xmppConfig.domain),oldConnection){if(oldConnection.connected())try{oldConnection.disconnect()}catch(e){}oldConnection=void 0}isTabWithConnection()&&storage.setItem(XMPP_CONNECTION_CONNECTED,"true"),fireEventToAllTabs("onConnect")},ondisconnect:function(){stopPinging(),userTriggeredDisconnect||startReconnecting(),userTriggeredDisconnect=!1,unregisterHandlerHash(conn,handlerHash),connection=void 0,isTabWithConnection()&&storage.setItem(XMPP_CONNECTION_CONNECTED,"false"),fireEventToAllTabs("onDisconnect")},onerror:function(error){console.error("Connection onerror called: ",error),"connecting"!==conn.status()?fireEventToAllTabs("onError",convertErrorPackage(error)):(connection=void 0,fireEventToAllTabs("onConnectingError",convertErrorPackage(error))),isTabWithConnection()&&storage.setItem(XMPP_CONNECTION_CONNECTED,hasConnectedXmppConnection());
},presence:function(presencePackage){fireEventToAllTabs("onPresence",convertPresencePackage(presencePackage))},message:function(msg){fireEventToAllTabs("onMessage",convertMessagePackage(msg))}};registerHandlerHash(conn,handlerHash)}function convertErrorPackage(errorPackage){if(!errorPackage)return[];for(var result=[],i=0;i<errorPackage.childNodes.length;i++)result.push(errorPackage.childNodes[i].tagName);return result}function convertMessagePackage(messagePackage){if(!messagePackage)return null;var messageType=messagePackage.getType(),result={from:messagePackage.getFrom(),type:messageType,fromJID:convertJID(messagePackage.getFromJID()),message:messagePackage.getBody()};if("error"===messageType){var error=messagePackage.getChild("error");result.errorCode=error?error.getAttribute("code"):"unknown"}return result}function convertPresencePackage(presencePackage){return presencePackage?{fromJID:convertJID(presencePackage.getFromJID()),type:presencePackage.getType(),show:presencePackage.getChildVal("show","*"),delay:presencePackage.getChild("delay")}:null}function convertJID(jsJaCJid){return jsJaCJid?{username:jsJaCJid.getNode(),domain:jsJaCJid.getDomain(),resource:jsJaCJid.getResource(),isCurrentConnectionResource:getResource()===jsJaCJid.getResource()}:null}function fireEventToAllTabs(event,data){isTabWithConnection()&&(fireEventToOurTab(event,data),storage.setItem(XMPP_CONNECTION_EVENT,JSON.stringify({event:event,data:data,timestamp:(new Date).getTime()})))}function registerHandlerHash(conn,handlerHash){function registerEventNameForHash(eventName){conn.registerHandler(eventName,handlerHash[eventName])}Object.keys(handlerHash).forEach(registerEventNameForHash)}function unregisterHandlerHash(conn,handlerHash){function unregisterEventNameForHash(eventName){conn.unregisterHandler(eventName,handlerHash[eventName])}Object.keys(handlerHash).forEach(unregisterEventNameForHash)}function startPinging(){pingTimer||(pingTimer=setInterval(function(){var ping;return connection&&connection.connected()?(ping=new JSJaCIQ,ping.setTo(xmppConfig.domain),ping.setType("get"),createAndAppendElement(ping,"ping","urn:xmpp:ping"),pingTimeoutTimer=setTimeout(function(){disconnectInternal(!1)},xmppConfig.jabberPingTimeoutMs),void connection.send(ping,function(response){clearTimeout(pingTimeoutTimer),"error"===response.getType().toLowerCase()&&disconnectInternal(!1)})):void stopPinging()},xmppConfig.jabberPingIntervalMs))}function stopPinging(){clearTimeout(pingTimeoutTimer),clearInterval(pingTimer),pingTimeoutTimer=void 0,pingTimer=void 0}function createAndAppendElement(root,elementName,xmlns){var element;return root.getDoc().createElementNS?element=root.getDoc().createElementNS(xmlns,elementName):(element=root.getDoc().createElement(elementName),element.setAttribute("xmlns",xmlns)),root.getNode().appendChild(element),element}function startReconnecting(){console.info("start reconnecting to Jabber"),reconnectTimer&&clearInterval(reconnectTimer),reconnectTimer=setInterval(function(){return reconnectTimedOut()||storage.getItem(XMPP_CONNECTION_TAB_ID)!==TAB_ID?void stopReconnecting():void fireEventToOurTab("onReconnect")},xmppConfig.jabberReconnectIntervalMs)}function reconnectTimedOut(){return lastReconnectStartTime=lastReconnectStartTime||(new Date).getTime(),lastReconnectStartTime+xmppConfig.jabberMaxReconnectTimeMs<(new Date).getTime()}function stopReconnecting(){console.info("stop reconnecting to Jabber"),clearInterval(reconnectTimer),lastReconnectStartTime=void 0,reconnectTimer=void 0}function disconnectInternal(triggeredByUser){var connectionExists=connection,connected=connectionExists&&connection.connected();connectionExists&&(connected&&(userTriggeredDisconnect=triggeredByUser),triggeredByUser&&connected?(console.info("Disconnecting from Jabber..."),connection.disconnect(),console.info("Successfully disconnected from Jabber.")):(oldConnection=connection,disconnectByEvent()),connection=void 0)}function disconnectByEvent(){connection&&connection._handleEvent("ondisconnect")}function sendMessage(xmppMessage){return hasConnectedXmppConnection()&&connection.send(xmppMessage)}function setMyPresence(presence){if(isTabWithConnection()){var presenceMessage=new JSJaCPresence;return presenceMessage.setShow(presence),presenceMessage.setPriority(1),sendMessage(presenceMessage)&&fireEventToAllTabs("onMyPresenceChanged",presence)}storage.setItem(XMPP_CONNECTION_SET_MY_PRESENCE,JSON.stringify({timestamp:(new Date).getTime(),presence:presence}))}function isConnected(){return isTabWithConnection()?hasConnectedXmppConnection():!isLastAliveTimestampTimedOut()&&"true"===storage.getItem(XMPP_CONNECTION_CONNECTED)}function isTabWithConnection(){return storage.getItem(XMPP_CONNECTION_TAB_ID)===TAB_ID}function hasConnectedXmppConnection(){return connection&&connection.connected()}function disconnect(){disconnectInternal(!0)}function getResource(){if(hasConnectedXmppConnection())return connection.resource}function disconnectOnResume(){disconnectInternal(!1)}function setLogger(logger){connection&&(connection.oDbg=logger)}var connection,oldConnection,xmppConfig,pingTimeoutTimer,pingTimer,lastReconnectStartTime,reconnectTimer,checkInterval,userTriggeredDisconnect=!1,handlers={},started=!1;this.start=start,this.stop=stop,this.onAngularAppDestroy=onAngularAppDestroy,this.onDestroy=onDestroy,this.setLogger=setLogger,this.initConnection=initConnection,this.sendMessage=sendMessage,this.disconnect=disconnect,this.disconnectOnResume=disconnectOnResume,this.isConnected=isConnected,this.getResource=getResource,this.setMyPresence=setMyPresence}var XMPP_CONNECTION_TAB_ALIVE_INTERVALL_IN_MS=1e4,XMPP_CONNECTION_TAB_ALIVE_TIMEOUT_IN_MS=2e4,XMPP_CONNECTION_EVENT="XMPP_CONNECTION_EVENT",XMPP_CONNECTION_SET_MY_PRESENCE="XMPP_CONNECTION_SET_MY_PRESENCE",XMPP_CONNECTION_TAB_LAST_ALIVE_DATE="XMPP_CONNECTION_TAB_LAST_ALIVE_DATE",XMPP_CONNECTION_TAB_ID="XMPP_CONNECTION_TAB_ID",XMPP_CONNECTION_CONNECTED="XMPP_CONNECTION_CONNECTED",TAB_ID=generateUUID(),storage=window.localStorage;return NgSharedResourceService.getOrCreateResource($rootScope,"juco.shared.xmpp.SharedXmppConnection",SharedXmppConnection)}]),angular.module("juco.shared.xmpp").service("XmppConnectionService",["RestService","REST","CurrentUser","Cache","PromiseUtil","$q","$window","urlUtil","UUID","$cookies","CONFIG","$log","XmppConnectionRejectReason","Environment","JcXmppResourcePrefix","SharedXmppConnection","$rootScope",function(RestService,REST,CurrentUser,Cache,PromiseUtil,$q,$window,urlUtil,UUID,$cookies,CONFIG,$log,XmppConnectionRejectReason,Environment,JcXmppResourcePrefix,SharedXmppConnection,$rootScope){function initConnection(config){function onSuccess(result){return $log.info("Jabber connection successfully established."),result}function onError(e){throw $log.error("Jabber connection failed to establish: "+e),e}return $log.info("Establishing Jabber connection..."),initConnectionInternal(config).then(onSuccess,onError)}function sendMessage(xmppMessage){return SharedXmppConnection.sendMessage(xmppMessage)}function setMyPresence(presence){return SharedXmppConnection.setMyPresence(presence)}function isConnected(){return SharedXmppConnection.isConnected()}function disconnect(){SharedXmppConnection.disconnect()}function getChatPassword(){return RestService.get(REST.chat.PASSWORD())}function getNonCachedChatSettings(){return RestService.get(REST.chat.SETTINGS())}function getChatSettings(){return Cache.getCachedPromise(chatSettingsCacheKey,chatSettingsCache,getNonCachedChatSettings)}function initConnectionInternal(config){return $q.all([getChatPassword(),getChatSettings()]).then(PromiseUtil.spread(function(password,chatSettings){var userConnectionSettings={domain:chatSettings.domain,username:CurrentUser.getRawId(),resource:determineResource(),pass:password.password,register:!1},xmppConfig={jabberMaxReconnectTimeMs:CONFIG.jabberMaxReconnectTimeMs,jabberReconnectIntervalMs:CONFIG.jabberReconnectIntervalMs,jabberPingTimeoutMs:CONFIG.jabberPingTimeoutMs,jabberPingIntervalMs:CONFIG.jabberPingIntervalMs,httpbase:"/http-bind",domain:chatSettings.domain},handlers={onConnectingError:config.onConnectingError,onConnect:config.onConnect,onReconnect:config.onReconnect,onDisconnect:config.onDisconnect,onError:config.onError,onMessage:config.message,onPresence:config.presence,onMyPresenceChanged:config.onMyPresenceChanged};return SharedXmppConnection.initConnection($rootScope,xmppConfig,handlers,userConnectionSettings)}),function(){return PromiseUtil.immediateReject(XmppConnectionRejectReason.FAILED_TO_LOAD_PRECONDITIONS)})}function determineResource(){var prefix=Environment.isDesktop()?JcXmppResourcePrefix.DESKTOP:Environment.isCordova()?JcXmppResourcePrefix.MOBILE_WRAPPER:JcXmppResourcePrefix.MOBILE_WEB;return prefix+UUID.generate()}function disconnectOnResume(){SharedXmppConnection.disconnectOnResume()}function start(){SharedXmppConnection.start()}function stop(){SharedXmppConnection.stop()}var chatSettingsCache=({path:CONFIG.baseCookiePath},Cache.createCache("chatSettingsCache",{maxAge:864e5})),chatSettingsCacheKey="chatSettingsCache";this.start=start,this.stop=stop,this.initConnection=initConnection,this.sendMessage=sendMessage,this.isConnected=isConnected,this.disconnect=disconnect,this.getChatSettings=getChatSettings,this.disconnectOnResume=disconnectOnResume,this.setMyPresence=setMyPresence}]),function(){function XmppService($rootScope,EVENTS,JcXmppPresenceType,XmppConnectionService,RestService,REST,CurrentUser,ProfileService,ConfigurationService,PromiseUtil,$log,$q,$interval,XmppPresenceUpdateOrigin,XmppConnectionRejectReason,$timeout,ERROR){function init(){$rootScope.$on("$destroy",function(){$interval.cancel(sessionCheckInterval)}),$rootScope.$on(EVENTS.onVisibilityChanged,handleVisibilityChange),$rootScope.$on(EVENTS.onAppResume,refreshConnection),$rootScope.$on(EVENTS.onUserAuthenticated,function(){XmppConnectionService.getChatSettings().then(function(settings){sessionCheckInterval=$interval(checkPeriodicallyForSessionUserChange,1e3*settings.sessionCheckInterval)})})}function refreshConnection(){CurrentUser.isAuthenticated&&!CurrentUser.isAuthenticated()||ConfigurationService.isChatEnabled().then(function(enabled){enabled&&($log.info("Reconnecting to jabber after app resume"),XmppConnectionService.disconnectOnResume(),handleReconnect())})}function handleVisibilityChange(event,visible){!visible||CurrentUser.isAuthenticated&&!CurrentUser.isAuthenticated()||XmppConnectionService.start()}function loginToChat(){return XmppConnectionService.start(),updateMyPresence(void 0,XmppPresenceUpdateOrigin.AUTO)["catch"](function(reason){reason!==XmppConnectionRejectReason.ALREADY_CONNECTED&&$rootScope.$broadcast(EVENTS.onError,{type:ERROR.CHAT.CHAT_UNAVAILABLE})})}function logoutOfChat(){XmppConnectionService.stop(),XmppConnectionService.disconnect()}function onDisconnect(){return $rootScope.$broadcast(EVENTS.onJabberDisconnected),updateMyPresence(JcXmppPresenceType.offline,XmppPresenceUpdateOrigin.AUTO)}function initChatConnection(){return $q(function(resolve,reject){var connectionConfig={onConnect:resolve,onDisconnect:onDisconnect,onError:onJabberError,onConnectingError:function(error){updateMyPresence(JcXmppPresenceType.offline,XmppPresenceUpdateOrigin.AUTO),$rootScope.$broadcast(EVENTS.onJabberConnectionInitializedAsOffline),onJabberError(error)},onReconnect:function(data,handlerIndex){return 0===handlerIndex?handleReconnect():PromiseUtil.immediateResolve()},presence:onJabberPresenceChanged,message:function(msg,handlerIndex){$rootScope.$broadcast(EVENTS.onJabberMessage,{message:msg,handlerIndex:handlerIndex})},onMyPresenceChanged:function(show){var myPresence=mapShowToPresence(show);storeMyPresenceLocally(myPresence),$rootScope.$broadcast(EVENTS.onPresenceChanged,{presence:myPresence,profileId:CurrentUser.getId()})}};XmppConnectionService.initConnection(connectionConfig)["catch"](reject)}).then(function(result){return $rootScope.$broadcast(EVENTS.onJabberConnected),result})}function handleReconnect(){return getMyPresencePreferenceFromDbUncached(!0).then(function(presenceFromDb){return updateMyPresence(presenceFromDb,XmppPresenceUpdateOrigin.AUTO)})}function isConnected(){return XmppConnectionService.isConnected()}function sendMessage(xmppMessage){return!!XmppConnectionService.isConnected()&&XmppConnectionService.sendMessage(xmppMessage)}function onJabberError(errors){if(errors)for(var i=0;i<errors.length;i++){var errorName=errors[i];switch(errorName){case"service-unavailable":$rootScope.$broadcast(EVENTS.onError,{type:ERROR.CHAT.JABBER_ERROR,name:errorName,triggeredByUser:errorTriggeredByUser});break;default:$rootScope.$broadcast(EVENTS.onError,{type:ERROR.CHAT.UNEXPECTED_CHAT_ERROR,name:errorName,triggeredByUser:errorTriggeredByUser})}}}function createMyJabberIdFromSettings(settings){return new JSJaCJID({node:CurrentUser.getRawId(),domain:settings.domain})}function askForRoster(){XmppConnectionService.getChatSettings().then(function(settings){var rosterIq=new JSJaCIQ;rosterIq.setTo(createMyJabberIdFromSettings(settings)),rosterIq.setType("get"),rosterIq.setQuery("jabber:iq:roster"),sendMessage(rosterIq)})}function onJabberPresenceChanged(presencePackage){var jid=presencePackage.fromJID,type=presencePackage.type;if("subscribe"!==type&&"subscribed"!==type&&"unsubscribed"!==type)return XmppConnectionService.getChatSettings().then(function(settings){var personId=jid?jid.username:void 0,profileId="PROFILE,"+personId;return isNaN(parseFloat(personId))||jid.domain!==settings.domain?void $log.debug("ignoring change in xmpp presence of "+jid.username+"@"+jid.domain):void(CurrentUser.getId()===profileId?onMyPresenceChanged(getJCXmppPresenceType(presencePackage),jid,presencePackage):onBuddiesPresenceChanged(profileId,getJCXmppPresenceType(presencePackage)))})}function onMyPresenceChanged(newPresence,fromJid,presencePackage){var ourOwnPresenceUpdate=fromJid.isCurrentConnectionResource,offlinePresenceUpdate=presencePackage.delay;ourOwnPresenceUpdate||offlinePresenceUpdate||$timeout(function(){getMyPresence().then(function(currentPresence){if(currentPresence!==newPresence)return newPresence===JcXmppPresenceType.offline?getMyPresencePreferenceFromDbUncached().then(function(presenceFromDb){presenceFromDb===newPresence&&updateMyPresence(newPresence,XmppPresenceUpdateOrigin.REMOTE)}):void updateMyPresence(newPresence,XmppPresenceUpdateOrigin.REMOTE)})})}function onBuddiesPresenceChanged(profileId,presence){var newLastModified=new Date;presence===JcXmppPresenceType.offline?getJabberPresenceByProfileIdUncached(profileId).then(function(presenceFromJabber){cacheAndBroadcastBuddyPresenceChanged(profileId,presenceFromJabber,newLastModified)}):cacheAndBroadcastBuddyPresenceChanged(profileId,presence,newLastModified)}function cacheAndBroadcastBuddyPresenceChanged(profileId,newPresence,newLastModified){var currentPresence=chatContactPresences[profileId],lastModified=chatContactPresencesLastModified[profileId];if(!(null!==lastModified&&lastModified>newLastModified)){if(currentPresence===newPresence)return void(chatContactPresencesLastModified[profileId]=newLastModified);chatContactPresences[profileId]=newPresence,chatContactPresencesLastModified[profileId]=newLastModified,$rootScope.$broadcast(EVENTS.onPresenceChanged,{profileId:profileId,presence:newPresence})}}function getJabberPresenceByProfileId(profileId){if(profileId===CurrentUser.getId())return getMyPresence();var presence=chatContactPresences[profileId];return presence?PromiseUtil.immediateResolve(presence):getJabberPresenceByProfileIdUncached(profileId)}function getJabberPresenceByProfileIdUncached(profileId){performJabberPresenceRequestTimeout||(performJabberPresenceRequestTimeout=$timeout(performJabberPresenceRequests));var requestDeferers=collectedJabberPresenceRequests[profileId]||[],deferred=$q.defer();return requestDeferers.push(deferred),collectedJabberPresenceRequests[profileId]=requestDeferers,deferred.promise}function performJabberPresenceRequests(){var requests=collectedJabberPresenceRequests,profileIds=Object.keys(requests);performJabberPresenceRequestTimeout=null,collectedJabberPresenceRequests={},RestService.post(REST.chat.PRESENCES,profileIds).then(function(presences){Object.keys(presences).forEach(function(profileId){var presence=presences[profileId];requests[profileId].forEach(function(deferred){deferred.resolve(presence)})})},function(e){Object.keys(requests).forEach(function(profileId){requests[profileId].forEach(function(deferred){deferred.reject(e)})})})}function updateMyPresence(newPresence,updateOrigin){var deferred=$q.defer();return getMyPresence().then(function(currentPresence){var storeToDbPromise,targetPresence=newPresence||currentPresence,connected=isConnected(),initializingPresence=!newPresence,goingOffline=targetPresence===JcXmppPresenceType.offline,presenceChanged=targetPresence!==currentPresence,setByRemote=XmppPresenceUpdateOrigin.REMOTE===updateOrigin,setByUser=XmppPresenceUpdateOrigin.USER===updateOrigin,result={updated:!0,presence:targetPresence};!connected||presenceChanged||initializingPresence?(storeMyPresenceLocally(targetPresence),storeToDbPromise=initializingPresence||setByRemote||goingOffline?PromiseUtil.immediateResolve(targetPresence):storeMyPresenceInDb(targetPresence),goingOffline?storeToDbPromise.then(function(){updateOrigin!==XmppPresenceUpdateOrigin.AUTO&&XmppConnectionService.disconnect(),initializingPresence&&$rootScope.$broadcast(EVENTS.onJabberConnectionInitializedAsOffline),deferred.resolve(result)},deferred.reject):setByUser?storeAndSendPresence(storeToDbPromise,targetPresence).then(function(){deferred.resolve(result)},deferred.reject):setByRemote?storeToDbPromise.then(function(){deferred.resolve(result)}):(errorTriggeredByUser=setByUser,initChatConnection().then(function(){errorTriggeredByUser=!1,askForRoster(),storeAndSendPresence(storeToDbPromise,targetPresence).then(function(){deferred.resolve(result)},deferred.reject)},deferred.reject))):(result.updated=!1,deferred.resolve(result))}),deferred.promise.then(handlePresenceUpdated,handleConnectionError)}function storeAndSendPresence(storeToDbPromise,targetPresence){return $q(function(resolve,reject){storeToDbPromise.then(function(){sendPresence(targetPresence),resolve()},reject)})}function handlePresenceUpdated(result){return result.updated&&$rootScope.$broadcast(EVENTS.onPresenceChanged,{profileId:CurrentUser.getId(),presence:result.presence}),result.presence}function handleConnectionError(reason){return $rootScope.$broadcast(EVENTS.onPresenceChanged,{profileId:CurrentUser.getId(),presence:JcXmppPresenceType.offline}),chatContactPresences[CurrentUser.getId()]=JcXmppPresenceType.offline,PromiseUtil.immediateReject(reason)}function setMyPresence(newPresence){return updateMyPresence(newPresence,XmppPresenceUpdateOrigin.USER)}function sendPresence(presence){XmppConnectionService.setMyPresence(mapPresenceToShow(presence))}function getMyPresence(){return chatContactPresences[CurrentUser.getId()]?PromiseUtil.immediateResolve(chatContactPresences[CurrentUser.getId()]):getMyPresencePreferenceFromDb().then(function(presenceStatus){return storeMyPresenceLocally(presenceStatus),presenceStatus})}function getMyPresencePreferenceFromDb(){return ProfileService.getSettingCached("PRESENCE_STATUS").then(function(presenceSetting){return presenceSetting||MY_DEFAULT_PRESENCE_PREFERENCE})}function getMyPresencePreferenceFromDbUncached(isReconnecting){return ProfileService.getSetting("PRESENCE_STATUS",isReconnecting).then(function(presenceSetting){return presenceSetting||MY_DEFAULT_PRESENCE_PREFERENCE})}function storeMyPresenceInDb(presence){return ProfileService.updateSetting("PRESENCE_STATUS",presence)}function storeMyPresenceLocally(presence){chatContactPresencesLastModified[CurrentUser.getId()]=new Date,chatContactPresences[CurrentUser.getId()]=presence}function mapPresenceToShow(presence){switch(presence){case JcXmppPresenceType.dnd:return"dnd";case JcXmppPresenceType.away:return"away";case JcXmppPresenceType.online:return""}}function mapShowToPresence(show){if(!show)return JcXmppPresenceType.online;switch(show){case"dnd":return JcXmppPresenceType.dnd;case"xa":return JcXmppPresenceType.xa;case"away":return JcXmppPresenceType.away;case"chat":return JcXmppPresenceType.chat;default:return JcXmppPresenceType.unknown}}function getJCXmppPresenceType(presencePackage){if("unavailable"===presencePackage.type)return JcXmppPresenceType.offline;var show=presencePackage.show;return mapShowToPresence(show)}function getServerCurrentUserId(){return RestService.get(REST.person.CURRENT).then(function(current){return current.id},function(){return null})}function disconnectIfUserChanged(cUID){cUID!==lastCurrentUserId&&(lastCurrentUserId=cUID,cUID||logoutOfChat())}function checkAndDisconnectIfUserChanged(myPresence){myPresence!==JcXmppPresenceType.offline&&myPresence!==JcXmppPresenceType.unknown&&getServerCurrentUserId().then(disconnectIfUserChanged)}function checkPeriodicallyForSessionUserChange(){CurrentUser.getId()&&XmppConnectionService.isConnected()&&getMyPresence().then(checkAndDisconnectIfUserChanged,logoutOfChat)}var sessionCheckInterval,MY_DEFAULT_PRESENCE_PREFERENCE=JcXmppPresenceType.online,chatContactPresences={},chatContactPresencesLastModified={},errorTriggeredByUser=!1,lastCurrentUserId=CurrentUser.getId(),collectedJabberPresenceRequests={},performJabberPresenceRequestTimeout=null;init(),this.loginToChat=loginToChat,this.logoutOfChat=logoutOfChat,this.getMyPresence=getMyPresence,this.setMyPresence=setMyPresence,this.getJabberPresenceByProfileId=getJabberPresenceByProfileId,this.isConnected=isConnected,this.refreshConnection=refreshConnection}angular.module("juco.shared.xmpp").service("XmppService",["$rootScope","EVENTS","JcXmppPresenceType","XmppConnectionService","RestService","REST","CurrentUser","ProfileService","ConfigurationService","PromiseUtil","$log","$q","$interval","XmppPresenceUpdateOrigin","XmppConnectionRejectReason","$timeout","ERROR",XmppService])}(),angular.module("juco.mobile.templates",[]),angular.module("juco.constants",[]),angular.module("juco.mobile.component",[]),angular.module("juco.mobile.configuration",[]),angular.module("juco.mobile.notification-center",["juco.mobile.auth","juco.mobile.common","juco.mobile.component","jm.i18next"]),angular.module("juco.mobile.quill",["juco.shared.common"]),angular.module("juco.mobile.download",["juco.shared.common"]),angular.module("juco.mobile.entity",["juco.services","juco.mobile.feed"]),angular.module("juco.mobile.account",["juco.mobile.auth","juco.i18next"]),angular.module("juco.mobile.common",["juco.shared.common","juco.shared.message","juco.mobile.configuration","juco.i18next","juco.util","juco.mobile.task"]),angular.module("juco.mobile.message",["juco.shared.message","juco.shared.teaser","juco.mobile.common","juco.mobile.xmpp","juco.services","ngFileUpload"]),angular.module("juco.mobile.profile",["juco.shared.profile"]),angular.module("juco.mobile.xmpp",["juco.shared.xmpp"]),angular.module("juco.mobile.network",[]),angular.module("juco.mobile.push",["juco.shared.common","juco.shared.rest","juco.mobile.configuration","juco.mobile.common"]),angular.module("juco.mobile.upgrade",["juco.shared.common","juco.shared.rest","juco.mobile.configuration"]),angular.module("juco.mobile.document",["juco.shared.common","juco.mobile.download","juco.util","juco.mobile.configuration","juco.mobile.rest"]),angular.module("juco.mobile.drive",["juco.shared.common","juco.mobile.rest"]),angular.module("juco.mobile.people",["juco.mobile.common"]),angular.module("juco.i18next",["jm.i18next","juco.mobile.configuration","juco.constants","juco.mobile.auth","juco.mobile.templates"]),angular.module("juco.util",["juco.mobile.configuration","juco.constants","ui.router"]),angular.module("juco.error",["juco.constants","juco.i18next","ui.router","juco.util"]),angular.module("juco.mobile.rest",["juco.shared.common","juco.error","juco.util","juco.mobile.configuration","ngFileUpload"]),angular.module("juco.mobile.auth",["juco.services","juco.error","juco.mobile.network","angular-cache","http-auth-interceptor","juco.mobile.rest"]),angular.module("juco.directives",["juco.constants","juco.util","juco.shared.common","juco.shared.common.util","juco.mobile.document","juco.services","juco.i18next"]),angular.module("juco.filters",["juco.util","jm.i18next"]),angular.module("juco.services",["juco.mobile.download","juco.mobile.message","juco.mobile.profile","juco.constants","juco.mobile.auth","juco.mobile.configuration","juco.error","juco.i18next","juco.mobile.rest","ngFileUpload","juco.util","juco.shared.search","juco.mobile.notification-center"]),angular.module("juco.controller",["juco.mobile.notification-center","juco.services","juco.filters","juco.constants","juco.mobile.configuration","juco.mobile.rest","ngFileUpload","juco.util","juco.mobile.document","juco.mobile.drive","juco.mobile.task"]);var juco=juco||{};!function(){juco.fromStateParams=function(key){return function($stateParams){return $stateParams[key]}},juco.resolve=function(){var keys=Array.prototype.slice.call(arguments,0);return keys.reduce(function(prev,current){return prev[current]=juco.fromStateParams(current),prev},{})}}(),angular.module("juco.mobile",["ui.router","ngSanitize","ngTouch","ngIOS9UIWebViewPatch","juco.directives","juco.constants","juco.filters","juco.services","juco.controller","juco.mobile.configuration","juco.mobile.common","juco.mobile.entity","juco.mobile.message","juco.mobile.profile","juco.mobile.auth","juco.mobile.templates","juco.mobile.push","juco.mobile.upgrade","juco.mobile.account","juco.mobile.like","juco.mobile.people"]).config(["$stateProvider","$urlRouterProvider","CacheFactoryProvider","$uiViewScrollProvider",function($stateProvider,$urlRouterProvider,CacheFactoryProvider,$uiViewScrollProvider){function ensureValidConfigState(Environment,$q,$state){"ngInject";return Environment.isCordova()&&!Environment.getConfigState().isConfigured?($state.go("private-cloud-config"),$q.reject()):$q.resolve()}ensureValidConfigState.$inject=["Environment","$q","$state"],$uiViewScrollProvider.useAnchorScroll(),$urlRouterProvider.otherwise("/"),$stateProvider.state("main",{"abstract":!0,url:"/",views:{"":{templateUrl:"scripts/common/controller/main.html",controller:"MainController"},"main-navigation@main":{templateUrl:"scripts/common/controller/main-navigation.html",controller:"MainNavigationController",controllerAs:"vm"}},data:{titleKey:void 0,titleContext:void 0,backButton:!1,additionalStyles:void 0,additionalHeaderStyles:void 0},resolve:{init:["AuthenticationService","ThemeService","Environment","$q","$state",function(AuthenticationService,ThemeService,Environment,$q,$state){"ngInject";return ensureValidConfigState(Environment,$q,$state).then(AuthenticationService.authenticate).then(ThemeService.resolveInitialTheme)}]}}).state("main.start",{url:"",redirectTo:function(transition){var CONFIG=transition.injector().get("CONFIG");return{state:"main.feed",params:{appId:CONFIG.defaultFeed}}}}).state("main.search",{url:"search",templateUrl:"scripts/search/controller/search.html",controller:"SearchController",params:{query:""},resolve:juco.resolve("query")}).state("main.myContent",{url:"myContent",templateUrl:"scripts/my-content/controller/my-content.html",controller:"MyContentController",data:{titleKey:"mainNavigation.myContent"}}).state("main.myContact",{url:"contacts",templateUrl:"scripts/my-content/controller/my-content.html",controller:"MyContentContactController",data:{titleKey:"mainNavigation.myContacts"}}).state("main.myDocument",{url:"myDocument",templateUrl:"scripts/my-content/controller/my-content.html",controller:"MyContentDocumentController",data:{titleKey:"mainNavigation.myDocuments"}}).state("main.document",{url:"document/:documentId",templateUrl:"scripts/document/controller/document.html",controller:"DocumentController",controllerAs:"document",data:{titleKey:"document.documentDetailsHeader"},resolve:juco.resolve("documentId")}).state("main.myDrives",{url:"my-drives",templateUrl:"scripts/drive/controller/my-drives.html",controller:"MyDrivesController",controllerAs:"vm",data:{titleKey:"drive.myDrives",additionalHeaderStyles:"header-colored-background app-drive-bg-color",additionalStyles:"app-drive"}}).state("main.driveFolder",{url:"folder/:folderId",templateUrl:"scripts/drive/controller/drive-folder.html",controller:"DriveFolderController",controllerAs:"vm",data:{additionalHeaderStyles:"header-colored-background app-drive-bg-color",additionalStyles:"app-drive",backButton:!0},resolve:juco.resolve("folderId")}).state("dialog",{"abstract":!0,url:"/",templateUrl:"scripts/common/controller/dialog.html",controller:"MainController",resolve:{validConfigState:ensureValidConfigState}}).state("dialog.terms",{url:"terms?destination",templateUrl:"scripts/account/controller/terms.html",controller:"TermsController",controllerAs:"vm",resolve:{loginCode:["AccountService",function(AccountService){return AccountService.getLoginCode()}],destination:juco.fromStateParams("destination"),loginThemeResolved:["ThemeService",function(ThemeService){return ThemeService.resolveLoginTheme()}]}}).state("dialog.login",{url:"login?destination",templateUrl:"scripts/auth/controller/login.html",controller:"LoginController",controllerAs:"login",data:{mayNotBeLoggedIn:!0},resolve:{destination:juco.fromStateParams("destination"),loginThemeResolved:["ThemeService",function(ThemeService){return ThemeService.resolveLoginTheme()}]}}).state("dialog.externalLogin",{url:"externallogin?access_token&refresh_token&expires_in",templateUrl:"scripts/auth/controller/external-login.html",controller:"ExternalLoginController"}).state("dialog.inescapableError",{url:"fatal/:messageKey",templateUrl:"scripts/common/controller/fatal.html",controller:"FatalController",resolve:juco.resolve("messageKey")}).state("main.error",{url:"error?errorCode&errorMessage",templateUrl:"scripts/common/controller/errorPage.html",controller:"ErrorController",data:{titleKey:juco.fromStateParams("errorCode"),backButton:!0},resolve:juco.resolve("errorCode","errorMessage")}).state("redirect",{url:"/redirect?token",controller:"RedirectController",data:{showViewLoading:!0},resolve:{token:juco.fromStateParams("token"),resolvedToken:["$stateParams","UrlTokenResolver",function($stateParams,UrlTokenResolver){"ngInject";return UrlTokenResolver.resolveToken($stateParams.token)}],validConfigState:ensureValidConfigState}}),angular.extend(CacheFactoryProvider.defaults,{maxAge:18e4,deleteOnExpire:"passive"})}]).run(["$rootScope","$state","$stateParams","EVENTS","$injector","StorageService","UpdatesService","AuthenticationService","CurrentUser","Environment","ErrorHandler","EmojiUtil","TrackingService","PromiseUtil","$transitions",function($rootScope,$state,$stateParams,EVENTS,$injector,StorageService,UpdatesService,AuthenticationService,CurrentUser,Environment,ErrorHandler,EmojiUtil,TrackingService,PromiseUtil,$transitions){function init(){window.viewportUnitsBuggyfill&&window.viewportUnitsBuggyfill.init(),ErrorHandler.onAppStart(),AuthenticationService.onAppStart(),UpdatesService.onAppStart(),TrackingService.onAppStart(),EmojiUtil.setAssetsServerBase(Environment.getServerBase()),StorageService.isStorageAvailable()||$state.go("dialog.inescapableError",{messageKey:"general.noStorage"}),$rootScope.themeId="default-theme",hideSplashScreen()}function hideSplashScreen(){var splashScreen=document.getElementById("jc-splash-screen");splashScreen&&splashScreen.classList.add("splash-hidden")}function closeMenu(){$rootScope.menuOpen&&$rootScope.toggleMenu()}function calcScalar(complex){return"function"!=typeof complex?PromiseUtil.immediateResolve(complex):$injector.invoke(complex)}function bindStateDataToRootScope(data){return data?void PromiseUtil.all([calcScalar(data.titleKey),calcScalar(data.titleContext),calcScalar(data.backButton),calcScalar(data.additionalHeaderStyles),calcScalar(data.additionalStyles)],setupHeaderAndAdditionalStyles):void($rootScope.header={})}function setupHeaderAndAdditionalStyles(titleKey,titleContext,backButton,additionalHeaderStyles,additionalStyles){
$rootScope.header={titleTranslate:!0,titleKey:titleKey,titleContext:titleContext,titleValue:void 0,backButton:backButton,additionalHeaderStyles:additionalHeaderStyles},$rootScope.additionalStyles=additionalStyles}function toggleMenu(){$rootScope.menuOpen=!$rootScope.menuOpen,$rootScope.$broadcast(EVENTS.onToogleMenu,$rootScope.menuOpen)}function showPageLoading(){$rootScope.showViewLoading=!0}function hidePageLoading(){$rootScope.showViewLoading=!1}function setThemeId(themeId){$rootScope.themeId=themeId}$rootScope.$state=$state,$rootScope.$stateParams=$stateParams,$rootScope.menuOpen=!1,$rootScope.showViewLoading=!1,$rootScope.closeMenu=closeMenu,$rootScope.toggleMenu=toggleMenu,$rootScope.showPageLoading=showPageLoading,$rootScope.hidePageLoading=hidePageLoading,$rootScope.setThemeId=setThemeId,$rootScope.$on(EVENTS.onUserDeauthenticated,closeMenu),$transitions.onError({},function(){$rootScope.showViewLoading=!1}),$transitions.onStart({},function(transition){var to=transition.to();$rootScope.showViewLoading=to.data&&to.data.showViewLoading;var mustNotLogin=to.data&&to.data.mayNotBeLoggedIn&&CurrentUser.isAuthenticated();if(mustNotLogin)return!1;var mustAcceptTerm=CurrentUser.isAuthenticated()&&"REQUIRED_ACCEPTANCE"===CurrentUser.getAuthenticatedUserInfo().termsAcceptanceStatus;if(mustAcceptTerm&&"dialog.terms"!==to.name){var newStateParams={destination:encodeURIComponent($state.href(to.name,transition.params()))};return transition.router.stateService.target("dialog.terms",newStateParams)}to.data?calcScalar(to.data.autoscrollDisabled).then(function(autoScrollDisabled){$rootScope.autoscrollEnabled=!autoScrollDisabled}):$rootScope.autoscrollEnabled=!0}),$transitions.onSuccess({},function(transition){bindStateDataToRootScope(transition.to().data),$rootScope.showViewLoading=!1}),Environment.getConfigState().isConfigured?init():CurrentUser.clearAuthentication().then(init,init)}]),angular.module("juco.i18next").config(["$i18nextProvider","CONFIG",function($i18nextProvider,CONFIG){function doLoad(lng,ns,options,loadComplete){loadComplete(null,window.mobileNgI18n)}$i18nextProvider.options={useCookie:!1,useLocalStorage:!1,fallbackToDefaultNS:!0,lowerCaseLng:!0,postProcess:"displayKeyPostProcessor",fallbackLng:CONFIG.defaultLanguage,interpolationPrefix:"${",interpolationSuffix:"}",dynamicLoad:!0,ns:"mobile-ng-custom",customLoad:doLoad,setJqueryExt:!1}}]).run(["$rootScope","EVENTS","CurrentUser","$i18next","$window","$location",function($rootScope,EVENTS,CurrentUser,$i18next,$window,$location){$rootScope.$on("i18nextLanguageChange",function(){var userInfo=CurrentUser.getAuthenticatedUserInfo();userInfo&&userInfo.language!==$window.i18n.lng()&&($i18next.options.lng=userInfo.language)}),$rootScope.$on(EVENTS.onUserAuthenticated,function(event,userInfo){var language=userInfo.language;language&&language!==$i18next.options.lng&&language!==$window.i18n.lng()&&($i18next.options.lng=language)}),"true"===$location.search().displayPropertyKeys?$window.i18n.addPostProcessor($i18next.options.postProcess,function(value,key){return value&&(0===value.indexOf("context_not_found")||0===value.indexOf(key)&&value!==key)?value:key+" --> "+value}):$window.i18n.addPostProcessor($i18next.options.postProcess,function(value){return value})}]),angular.module("juco.shared.message").constant("DRIVE_MIME_TYPES",["application-ms-excel.png","application-ms-powerpoint.png","application-ms-word.png","application-msword.png","application-octet-stream.png","application-pdf.png","application-vnd.oasis.opendocument.presentation.png","application-vnd.oasis.opendocument.spreadsheet.png","application-vnd.oasis.opendocument.text.png","application-vnd.openxmlformats-officedocument.presentationml.presentation.png","application-vnd.openxmlformats-officedocument.spreadsheetml.sheet.png","application-vnd.openxmlformats-officedocument.wordprocessingml.document.png","application-zip.png","image.png","text-css.png","text-html.png","text.png"]),angular.module("juco.mobile.templates").run(["$templateCache",function($templateCache){$templateCache.put("scripts/account/controller/terms.html","<div class=login-page><div class=login-container><div class=login-logo></div><p ng-i18next=terms.termsHeader class=terms-title></p><div class=terms-text ng-bind-html=vm.termsTextSafeHtml></div><div class=terms-buttons><a class=terms-decline ng-i18next=account.declineTerms ng-click=vm.declineTerms();></a> <button class=terms-accept ng-i18next=account.acceptTerms ng-click=vm.acceptTerms();></button></div></div></div>"),$templateCache.put("scripts/auth/controller/external-login.html",""),$templateCache.put("scripts/auth/controller/login.html","<div class=login-page><div class=login-container><div class=login-logo></div><p ng-i18next=login.title class=login-title></p><form novalidate method=post ng-submit=login.submit() jc-blur=login,password jc-blur-event=submit><input type=email jc-novalidate class=login-input id=login name=login ng-i18next=[placeholder]login.username ng-model=login.username> <input type=password class=login-input id=password name=password ng-i18next=[placeholder]login.password ng-model=login.password> <button type=submit class=login-submit ng-i18next=login.submit jc-autofill-fix></button></form><div class=login-links ng-if=\"login.isCordova || login.showRequestNewPasswordLink || login.showAccountActivationLink || login.showRegistrationLink\"><a ng-if=login.showRequestNewPasswordLink login-page-link=login.requestNewPasswordUrl>{{ 'login.requestNewPasswordLinkLabel' | i18next }}</a> <a ng-if=login.showAccountActivationLink login-page-link=login.accountActivationUrl>{{ 'login.resendActivationLinkLabel' | i18next }}</a> <a ng-if=login.showRegistrationLink login-page-link=login.registrationUrl>{{ 'login.registrationLinkLabel' | i18next }}</a><div ng-if=login.isCordova><jc-change-platform class=change-platform jc-show-dialog=true></jc-change-platform></div></div><div class=footer><a login-page-link=login.termsUrl ng-if=login.terms>{{ login.terms }}</a> <a login-page-link=login.privacyUrl ng-if=login.privacy>{{ login.privacy }}</a> <a login-page-link=login.imprintUrl ng-if=login.imprint>{{ login.imprint }}</a> <a login-page-link=login.helpUrl ng-if=login.help>{{ login.help }}</a> <a login-page-link=login.pressUrl ng-if=login.press>{{ login.press }}</a> <a login-page-link=login.aboutUrl ng-if=login.about>{{ login.about }}</a> <a login-page-link=login.articlesOfAssociationUrl ng-if=login.articlesOfAssociation>{{ login.articlesOfAssociation }}</a></div></div></div>"),$templateCache.put("scripts/common/controller/dialog.html",'<main class="content dialog" ng-class="{\'scrolled\': scrollDetection.scrolled, \'no-scroll-detection\': !scrollDetection}"><jc-feedback></jc-feedback><div ui-view="" autoscroll=false></div></main>'),$templateCache.put("scripts/common/controller/errorPage.html",'<div class="error-page no-content text-danger"><span class=error-code ng-if=!errorMessage>{{ errorCode }}</span> <span class=error-message ng-if=errorMessage>{{ errorMessage.message | i18next:errorMessage.i18nOptions }}</span></div>'),$templateCache.put("scripts/common/controller/fatal.html",'<header class="vertical-centered vc-full-width" data-role=banner><div class=title><jc-header-logo></jc-header-logo></div></header><div class="page inescapable-error"><div class="alert alert-danger text-center" data-ng-i18next="{{ messageKey }}"></div></div>'),$templateCache.put("scripts/common/controller/main-navigation.html",'<nav ng-if=vm.currentUserInfo class=nav><div class=nav-current-user><div class=nav-current-user-teaser><a ng-click=vm.goToProfile() class=nav-current-user-link><img ng-src="{{vm.currentUserInfo.imageUrlPattern|jcImage:\'SMALL\'}}"> <span>{{vm.currentUserInfo.name}}</span></a></div><form class=nav-search ng-submit=vm.doSearch()><div class=input-group><span class=input-group-addon><i class="fa fa-search"></i></span> <input type=search class=form-control id=nav-search ng-i18next=[placeholder]search.enterSearchTextHere ng-model=vm.searchQuery jc-blur-on-event=jc-on-toogle-menu> <span class=input-group-addon ng-if="vm.searchQuery !== \'\'" jc-focus=nav-search><i class="fa fa-times" ng-click=vm.clearSearchQuery()></i></span></div></form></div><div class=nav-links><jc-menu-link class=list-group-item ng-repeat="menuLink in vm.menuLinks" link=menuLink user-id=vm.currentUserInfo.id></jc-menu-link></div><div class=nav-links ng-if=vm.driveAvailable><div class="nav-headline app-drive-color">{{ \'appName.drive\' | i18next }}</div><a class="list-group-item menu-link" ng-click=vm.goToMyDrives()>{{ \'drive.myDrives\' | i18next }}</a></div><div class=nav-links ng-if=vm.taskAvailable><div class="nav-headline app-tasks-color">{{ \'appName.tasks\' | i18next }}</div><a class="list-group-item menu-link" ng-click=vm.goToMyAssignedTasks()>{{ \'task.assignedToMe\' | i18next }}</a> <a class="list-group-item menu-link" ng-click=vm.goToMyCreatedTasks()>{{ \'task.createdByMe\' | i18next }}</a> <a class="list-group-item menu-link" ng-click=vm.goToMyTaskLists()>{{ \'task.myLists\' | i18next }}</a></div><div class=nav-links ng-if=vm.peopleAvailable><div class="nav-headline app-people-color">{{ \'appName.people\' | i18next }}</div><a class="list-group-item menu-link" ng-click=vm.goToAllUsers()>{{ \'people.allUsers\' | i18next }}</a></div><div class=nav-links ng-if=vm.isCordova><a class="list-group-item menu-link" ng-click=vm.goToSettings()>{{ \'wrapper.configuration.settings\' | i18next }}</a> <a class="list-group-item menu-link" ng-click=vm.goToDownloads()>{{ \'wrapper.downloads.currentDownloads\' | i18next }}</a></div><div class=nav-links><a class="list-group-item menu-link" ng-click=vm.logout()>{{ \'general.logout\' | i18next }}</a></div></nav>'),$templateCache.put("scripts/common/controller/main.html",'<div ui-view=main-navigation></div><main class=content ng-class="{\'scrolled\': scrollDetection.scrolled, \'no-scroll-detection\': !scrollDetection}"><header id=header class="vertical-centered vc-full-width vc-fixed" ng-class=header.additionalHeaderStyles role=banner><a class="link menu" ng-click=toggleMenu(); ng-show="!header.backButton || !hasHistoryBack"><i class="fa fa-bars"></i></a> <a class="link back" ng-click=$back() ng-show="hasHistoryBack && (header.backButton || showBackButtonByDefault)"><i class="fa fa-angle-left"></i></a><div class=title><span ng-if="header.titleKey && header.titleTranslate">{{ header.titleKey | i18next:{context:header.titleContext} }}</span> <span ng-if="header.titleValue && !header.titleTranslate" ng-bind-html=header.titleValue></span></div><jc-icon-link-with-count class="link-right notifications" count-changed-event="\'jcOnNotificationCountChanged\'" icon="\'fa-bell\'" toggle-state=toggleNotifications></jc-icon-link-with-count><jc-icon-link-with-count class="link-right conversations" ng-if=chatEnabled state="\'chat.allConversations\'" count-changed-event="\'jcOnUnreadConversationCountUpdate\'" icon="\'fa-comments\'"></jc-icon-link-with-count></header><div class=shadow ng-click=toggleMenu();></div><jc-feedback></jc-feedback><div id=main-content ui-view="" class=page autoscroll=autoscrollEnabled ng-class=additionalStyles></div><jc-auto-hide-snackbar></jc-auto-hide-snackbar></main>'),$templateCache.put("scripts/common/directive/jc-auto-hide-snackbar.html",'<div class="auto-hide-snackbar {{vm.additionalCssClass}}" ng-class="{\'show-snackbar\' : vm.showSnackbar}"><div class=auto-hide-snackbar-message>{{ vm.messageKey | i18next }}</div><div class=auto-hide-snackbar-action ng-click=vm.onDoAction()>{{ vm.actionLabelKey | i18next }}</div></div>'),$templateCache.put("scripts/common/directive/jc-feedback.html",'<div ng-class="{show: messages && messages.length > 0}" class=jc-feedback><div class=jc-feedback-message ng-repeat="message in messages" ng-click=removeMessage(message); ng-class=message.severity><i class=jc-close>&times;</i> <span>{{ message.message | i18next:message.i18nOptions }}</span></div></div>'),$templateCache.put("scripts/common/directive/jc-secured-image.html",'<div ng-if=!vm.base64Data class=jc-secured-image-placeholder></div><img ng-if=vm.base64Data class=jc-secured-image ng-src="{{ ::vm.base64Data }}">'),$templateCache.put("scripts/common/directive/jc-select-file.html",'<i class=fa ng-class=icon>&nbsp;</i> <input ng-if=multiple ng-attr-id="{{ inputId }}" class=element-invisible type=file ng-attr-accept="{{ accept }}" ngf-select=onFileSelect($files) ng-attr-capture="{{ capture ? \'\' : undefined }}" multiple> <input ng-if=!multiple ng-attr-id="{{ inputId }}" class=element-invisible type=file ng-attr-accept="{{ accept }}" ngf-select=onFileSelect($files) ng-attr-capture="{{ capture ? \'\' : undefined }}">'),$templateCache.put("scripts/common/directive/jc-simple-teaser.html",'<div class=teaser ng-class=styleName ng-show=teaser><span class="teaser-icon fa" ng-class=icon></span><div class=teaser-text><div class=teaser-title>{{ teaser.name }}</div></div></div>'),$templateCache.put("scripts/common/directive/jc-typed-value.html",'<span ng-repeat="value in values track by $index" ng-switch on=value.type><span ng-if=value.separator class=separator>{{value.separator}}</span> <a ng-switch-when=1 ng-href=mailto:{{value.value}} class=jc-typed-value>{{ value.value }}</a> <a ng-switch-when=2 ng-href=tel:{{value.value}} class=jc-typed-value>{{ value.value }}</a> <span ng-switch-default class=jc-typed-value jc-html-link-rewrite=value.value></span></span>'),$templateCache.put("scripts/component/directive/conversation-teaser.html",'<div class="teaser conversation-teaser" ng-if=teaser><i class="fa fa-comments teaser-icon"></i><div class=teaser-text><div class=teaser-title>{{ teaser.name }}</div></div></div>'),$templateCache.put("scripts/component/directive/dialog.html","<div class=jc-dialog data-ng-if=showDialog><div class=jc-dialog-content data-ng-transclude></div></div>"),$templateCache.put("scripts/component/directive/document-teaser.html",'<div class="teaser document-teaser" ng-show=teaser><div class=teaser-icon>{{ documentTag }}</div><div class=teaser-text><div class="teaser-title with-subtitle">{{ teaser.name }}</div><div class=teaser-subtitle><span ng-if=teaser.size>{{ teaser.size | jcFileSize }}</span> <span ng-if="teaser.size && teaser.modifyAt">-</span> <span ng-if=teaser.modifyAt>{{ teaser.modifyAt | date: (\'date.dateTimeFormat\' | i18next) }}</span></div></div></div>'),$templateCache.put("scripts/component/directive/entity-teaser.html","<div class=\"teaser entity-teaser\" ng-class=\"teaser.type | jcEntityClass\" ng-show=teaser><img ng-src=\"{{ teaser.imageUrlPattern | jcImage:'LARGE' }}\" class=\"teaser-icon {{ teaser.type }}\" ng-if=\"!startAtDate && teaser.imageUrlPattern\"><div class=\"entity-default-icon teaser-icon\" ng-class=\"'app-' + teaser.appId + '-color'\" ng-if=\"!startAtDate && !teaser.imageUrlPattern\"><i ng-class=\"['nav-entity-icon', 'fa3', 'fa', icon]\"></i></div><div class=\"teaser-icon teaser-date\" ng-class=\"'app-' + teaser.appId + '-border-color'\" ng-if=startAtDate><div class=teaser-date-month ng-class=\"'app-' + teaser.appId + '-bg-color'\">{{ 'date.monthOfYearShort' | i18next:{context: startAtDate.getMonth().toString() } }}</div><div class=teaser-date-day>{{ startAtDate | date: 'dd' }}</div></div><div class=teaser-text><div class=teaser-title ng-class=\"{'with-subtitle': startAtDate}\">{{ teaser.name }}</div><div class=teaser-subtitle ng-if=startAtDate>{{ 'appointment.begin' | i18next }}: {{ startAtDate | date: ('date.dateTimeFormat' | i18next) }}</div></div></div>"),$templateCache.put("scripts/component/directive/jc-dropdown.html",'<div class=jc-dropdown><span class=jc-dropdown-menu-toggle ng-click=vm.toggleDropdown()><i ng-if=!vm.overrideToggle class="fa fa-ellipsis-v"></i> <span ng-if=vm.overrideToggle ng-transclude></span></span><div class=jc-dropdown-menu ng-class="{\'open\' : vm.open}"><ul class=jc-dropdown-menu-options><li ng-repeat="value in vm.values | orderBy:\'order\'" class=jc-dropdown-menu-option ng-click="vm.toggleDropdown(); vm.onValueChanged(value);">{{value.i18nKey | i18next:{context:value.context} }}</li></ul></div></div>'),$templateCache.put("scripts/component/directive/jc-icon-link-with-count.html",'<a class=link><div class=jc-icon-link-with-count data-ng-click=toggleState();><i class="fa {{icon}}"></i><div class=count data-ng-if=count>{{ count | jcMaxNumber:9 }}</div></div><div data-ng-if=isState(state) class=jc-icon-link-arrow-up></div></a>'),$templateCache.put("scripts/component/directive/jc-labeled-row.html","<div class=labeled-row ng-show=values><div class=labeled-row-label ng-if=labelI18nKey>{{ labelI18nKey | jcI18nDynamicAttribute:labelI18nKeyPrefix:i18nOptions }}</div><div class=labeled-row-value><span ng-repeat=\"value in values track by $index\">{{ !$first ? ', ' : '' }} <span jc-typed-value=value></span></span></div></div>"),$templateCache.put("scripts/component/directive/jc-loading.html","<div class=jc-loading><div class=\"center-block-padded text-center\" ng-if=loading.showLoading><i class=\"fa fa-circle-o-notch fa-spin fa-2x\"></i></div><div class=\"no-content text-danger\" ng-if=loading.showErrorMessage ng-switch=loading.errorStatusCode><span ng-switch-when=403>{{ 'exception.forbidden' | i18next }}</span> <span ng-switch-default>{{loading.errorMessage || ('general.errorLoadingContent' | i18next)}}</span></div><div class=no-content ng-if=loading.showNoContentMessage>{{loading.noContentMessage || ('general.noContent' | i18next)}}</div></div>"),$templateCache.put("scripts/component/directive/jc-pretty-checkbox.html",'<div class=pretty-checkbox ng-class="{\'disabled\' : vm.isDisabled}"><input type=checkbox ng-attr-id=task-checkbox-{{::$id}} ng-checked=!!vm.isChecked ng-model=vm.isChecked ng-change=vm.onChange() ng-disabled="!!vm.isDisabled"><label ng-attr-for=task-checkbox-{{::$id}}><svg ng-attr-viewBox="0 0 {{ vm.attributes.width }} {{ vm.attributes.height }}" ng-attr-width="{{ vm.attributes.width }}px" ng-attr-height="{{ vm.attributes.height }}px"><rect class=checked-bg ng-attr-ry="{{ vm.attributes.radius }}" ng-attr-y="{{ vm.attributes.margin }}" ng-attr-x="{{ vm.attributes.margin }}" ng-attr-height="{{ vm.attributes.height - 2*vm.attributes.margin }}" ng-attr-width="{{ vm.attributes.width - 2*vm.attributes.margin }}"></rect><rect class=unchecked-bg ng-attr-ry="{{ vm.attributes.radius }}" ng-attr-y="{{ vm.attributes.margin - 0.5 }}" ng-attr-x="{{ vm.attributes.margin - 0.5 }}" ng-attr-height="{{ vm.attributes.height - 2*vm.attributes.margin + 1}}" ng-attr-width="{{ vm.attributes.width - 2*vm.attributes.margin + 1}}"></rect><text ng-if=vm.text class=text text-anchor=middle x=50% y=50% dy=5>{{vm.text}}</text><polyline class=check points="6,14.5 13.5,21.5 26,9" ng-attr-transform="{{ vm.attributes.checkmarkTransform }}"/></svg></label></div>'),$templateCache.put("scripts/component/directive/jc-progress-bar.html","<span class=progress-bar-title ng-if=title>{{ title }}</span><div class=progress-bar><span class=progress-bar-inner ng-style=\"{ width: progress + '%'}\"></span></div>"),$templateCache.put("scripts/component/directive/jc-tab.html","<div class=tabs__single-tab ng-transclude ng-class={active:selected} ng-style=style></div>"),$templateCache.put("scripts/component/directive/jc-tabs.html",'<div class=tabs><div class=tabs__headers-wrapper><div ng-repeat="tab in vm.tabs" class=tabs__single-header ng-style="{width: vm.indicatorLength}" ng-class={active:vm.isSelectedIndex($index)} ng-click=vm.select($index)>{{tab.title}}</div></div><div class=tabs__indicator-wrapper><div class=tabs__indicator ng-style="{width: vm.indicatorLength, left: vm.indicatorPosition}"></div></div><div class=tabs__contents-wrapper ng-transclude></div></div>'),$templateCache.put("scripts/component/directive/jc-teaser-link.html",'<span ng-if=!jcTeaserLink.url>{{ jcTeaserLink.name }}</span> <a class=app-connect-color href="{{ jcTeaserLink.url }}" ng-if=jcTeaserLink.url>{{ jcTeaserLink.name }}</a>'),$templateCache.put("scripts/component/directive/menu-link.html","<div ng-class=\"{'nav-headline': link.type === 'HEADLINE', 'menu-link': link.type !== 'HEADLINE'}\" ng-click=\"toggleMenu(); followLink();\"><span ng-if=\"link.type === 'HEADLINE'\" ng-class=style>{{text}}</span> <a ng-if=\"link.type !== 'HEADLINE'\"><span ng-if=i18nKey>{{ i18nKey | i18next:i18nContext }}</span> <span ng-if=text>{{ text }}</span></a></div>"),$templateCache.put("scripts/component/directive/profile-teaser.html",'<div class="teaser profile-teaser" ng-show=teaser><img ng-src="{{ teaser.imageUrlPattern | jcImage:\'SMALL\' }}" class="teaser-icon"><div class=teaser-text><div class=teaser-title>{{ teaser | profileName }}</div></div></div>'),$templateCache.put("scripts/component/directive/subnavigation.html",'<div class=jc-sub-navigation-container><ul class="sub-navigation navbar-nav" ng-class="{ closed: navHidden }"><li ng-repeat="value in values | orderBy:\'order\'" ng-class="{ active: value === selectedValue }"><a class=jc-unstyled-link ng-click="toggleNavigation(); onSelect(value);"><i ng-if=value.icon ng-class="[\'fa3\', \'fa\', value.icon]"></i>{{value.i18nKey | i18next:{context: value.context || defaultContext} }}</a></li></ul><i class="fa navbar-toggle" ng-class="{\'fa-chevron-down\': navHidden, \'fa-chevron-up\': !navHidden}" ng-if="values.length > 1" ng-click=toggleNavigation();></i></div>'),$templateCache.put("scripts/document/controller/document.html",'<jc-loading show-loading=document.loading show-error-message="!document.loading && document.showErrorMessage" error-message="\'document.errorLoadingDocument\' | i18next" error-status-code=document.errorStatusCode></jc-loading><div class=sub-view><jc-teaser ng-if=document.document teaser=document.document></jc-teaser></div>'),$templateCache.put("scripts/download/controller/downloads.html",'<div class=downloads><div class=no-content ng-if="currentDownloads.length === 0">{{ \'wrapper.downloads.noCurrentDownloads\' | i18next }}</div><div class=download ng-repeat="fileInfo in currentDownloads"><jc-progress-bar progress=fileInfo.progress title="fileInfo.fileName + \', \' + (fileInfo.size | jcFileSize)"></jc-progress-bar><a ng-click=abortDownload(fileInfo.uid);><i class="fa fa-2x fa-times-circle"></i></a></div></div>'),$templateCache.put("scripts/drive/controller/drive-folder.html",'<div class="sub-view drive-document-list"><jc-teaser ng-repeat="document in vm.documents" teaser=document></jc-teaser><div ng-if="vm.hasMore && !vm.loading" jc-on-scroll-event=jc-fetch-next-drive-documents></div><jc-loading show-loading=vm.loading show-no-content-message="!vm.loading && vm.documents.length === 0 && !vm.showErrorMessage" no-content-message="\'drive.noDocuments\' | i18next" show-error-message="!vm.loading && vm.documents.length === 0 && vm.showErrorMessage" error-message="\'drive.errorLoadingDocuments\' | i18next"></jc-loading></div>'),$templateCache.put("scripts/drive/controller/my-drives.html",'<div class=sub-view><drive-teaser ng-repeat="drive in vm.drives" teaser=drive ui-sref="main.driveFolder({folderId: drive.rootFolderId})"></drive-teaser><div ng-if="!vm.loading && (!vm.drives || vm.drives.length < 1)" class=no-content><div drive-icon></div>{{ \'drive.noDrivesAvailable\' | i18next}}</div></div>'),$templateCache.put("scripts/drive/directive/drive-icon.html",'<svg class=drive-icon viewBox="0 0 265 400" version=1.1 xmlns=http://www.w3.org/2000/svg xmlns:xlink=http://www.w3.org/1999/xlink><title>appicon_DRIVE_icon</title><desc>Created with Sketch.</desc><defs></defs><g id=Symbols stroke=none stroke-width=1 fill=none fill-rule=evenodd><g id=appicon_DRIVE transform="translate(-136.000000, 0.000000)"><g id=appicon_DRIVE_icon><rect id=Rectangle-2 x=0 y=0 width=400 height=400></rect><path fill=#CCC d="M200.069406,135.949454 L264.138812,200.01886 L200.069406,264.088266 L136,200.01886 L200.069406,135.949454 Z M268.025273,67.9935875 L332.094679,132.062993 L268.025273,196.132399 L203.955867,132.062993 L268.025273,67.9935875 Z M336.01886,-8.52651283e-14 L400.088266,64.0694058 L336.01886,128.138812 L271.949454,64.0694058 L336.01886,-8.52651283e-14 Z M268.025273,203.905321 L332.094679,267.974727 L268.025273,332.044133 L203.955867,267.974727 L268.025273,203.905321 Z M335.98114,271.861188 L400.050546,335.930594 L335.98114,400 L271.911734,335.930594 L335.98114,271.861188 Z" id=Combined-Shape transform="translate(268.044133, 200.000000) rotate(180.000000) translate(-268.044133, -200.000000) "></path></g></g></g></svg>'),$templateCache.put("scripts/drive/directive/drive-teaser.html",'<div class="teaser drive-teaser" ng-show=teaser><span class="teaser-icon fa fa-folder fa-3x app-drive-color"></span><div class=teaser-text><div class=teaser-title>{{ teaser.name }}</div></div></div>'),$templateCache.put("scripts/entity/controller/all-entities.html",'<div class=sub-view><div class=entities><jc-teaser ng-repeat="entity in vm.entities" teaser=entity></jc-teaser></div><div ng-if="!vm.loading && !vm.error && (!vm.entities || vm.entities.length < 1)" class=no-content>{{ \'entity.noEntitiesAvailable\' | i18next }}</div><div ng-if=vm.error class="no-content text-danger">{{ vm.error | i18next }}</div><div ng-if=vm.hasMore jc-on-scroll-event=jc-fetch-next-entities></div></div>'),$templateCache.put("scripts/entity/controller/child-entities.html",'<div class=sub-view><div data-ng-if=showFilter class=jc-duration-filter><jc-subnavigation data-on-value-change=onFilterChange data-values=filterValues data-preselected-value=selectedFilter data-default-context=childType></jc-subnavigation></div><jc-teaser data-ng-repeat="teaser in childEntities" teaser=teaser></jc-teaser><jc-loading data-show-loading=loading data-show-error-message="!loading && showErrorMessage" data-show-no-content-message="!loading && !showErrorMessage && totalSize === 0" data-no-content-message="\'entity.noChildEntitiesAvailable\' | i18next:{context: childType}"></jc-loading><div data-ng-if=hasMore data-jc-on-scroll-event=jc-fetch-next-children></div></div>'),$templateCache.put("scripts/entity/controller/document.html",'<div class=sub-view><jc-teaser data-ng-repeat="teaser in documents" teaser=teaser></jc-teaser><jc-loading data-show-loading=loading data-show-error-message="!loading && showErrorMessage" data-show-no-content-message="!loading && !showErrorMessage && documents.length === 0" data-no-content-message="\'document.noDocumentsAvailable\' | i18next"></jc-loading></div>'),$templateCache.put("scripts/entity/controller/entity-info.html","<div class=labeled-rows-body ng-if=entityInfo.baseData><div class=labeled-row ng-if=entityInfo.baseData.logoUrl><div class=labeled-row-image><image ng-src=\"{{ entityInfo.baseData.logoUrlPattern | jcImage:'LARGE' }}\"></image></div></div><div class=labeled-row ng-if=entityInfo.baseData.description><div class=labeled-row-label>{{ 'entity-baseData.description' | i18next }}</div><div class=\"labeled-row-value jc-user-generated-html\"><div jc-html-link-rewrite=\"entityInfo.baseData.description | jcTrustedHtml\" jc-additional-link-class=\"{{ 'app-' + entityInfo.baseData.appId + '-color' }}\" jc-rewrite-anchor></div></div></div><jc-labeled-row label-i18n-key=\"'entity-baseData.time'\" translate-values=false values=entityInfo.time ng-if=entityInfo.time></jc-labeled-row><jc-labeled-row label-i18n-key=\"'entity-baseData.registrationDeadline'\" translate-values=false values=entityInfo.registrationDeadline ng-if=entityInfo.registrationDeadline></jc-labeled-row><jc-labeled-row label-i18n-key=\"'entity-baseData.location'\" translate-values=false values=entityInfo.baseData.location ng-if=entityInfo.baseData.location></jc-labeled-row><div class=labeled-row ng-if=entityInfo.baseData.type><div class=labeled-row-label>{{ 'entity-baseData.type' | i18next }}</div><div class=labeled-row-value>{{ 'entityName.entitySingularUpper' | i18next: {context: entityInfo.baseData.type} }}</div></div><div class=labeled-row ng-if=\"entityInfo.baseData.linkedEntities.length > 0\"><div class=labeled-row-label>{{ 'entity-baseData.assignedEntities' | i18next }}</div><div class=labeled-row-value><div ng-repeat=\"entity in entityInfo.baseData.linkedEntities\"><jc-teaser-link teaser=entity></jc-teaser-link></div></div></div><div ng-repeat=\"dynAttribute in entityInfo.baseData.dynamicAttributes\" ng-if=\"dynAttribute.values.length > 0\"><jc-labeled-row label-i18n-key=dynAttribute.attributeId label-i18n-key-prefix=\"'dynamicAttributes.entity.'\" values=dynAttribute.values translate-values=\"dynAttribute.valueType === 'TRANSLATED_VALUE'\" values-i18n-key-prefix=\"'dynamicAttributes.entity.' + dynAttribute.attributeId + '.'\" i18n-options=\"{context : dynAttribute.entityType }\" ng-if=\"dynAttribute.valueType !== 'PERSON_ID'\"></jc-labeled-row><div class=labeled-row ng-if=\"dynAttribute.valueType === 'PERSON_ID'\"><div class=labeled-row-label>{{ dynAttribute.attributeId | jcI18nDynamicAttribute:'dynamicAttributes.entity.':{context : dynAttribute.entityType } }}</div><div class=labeled-row-value><div ng-repeat=\"profile in dynAttribute.personTeasers\"><jc-teaser-link teaser=profile></jc-teaser-link></div></div></div></div><div class=labeled-row ng-if=entityInfo.visibilityRules><div class=labeled-row-label>{{ 'entity-baseData.visibilyRule' | i18next:{context:entity.type} }}</div><div class=labeled-row-value><span ng-if=entityInfo.visibilityIconClass class=fa ng-class=entityInfo.visibilityIconClass></span> {{ entityInfo.visibilityRules }}</div></div><div class=labeled-row ng-if=entityInfo.joiningRules><div class=labeled-row-label>{{ 'entity-baseData.joiningRules' | i18next:{context:entity.type} }}</div><div class=labeled-row-value>{{ entityInfo.joiningRules }}</div></div><div class=labeled-row ng-if=entityInfo.joinRequestRules><div class=labeled-row-label>{{ 'entity-baseData.joinRequestRules' | i18next:{context:entity.type} }}</div><div class=labeled-row-value>{{ entityInfo.joinRequestRules }}</div></div><div class=labeled-row ng-if=entityInfo.invitingRules><div class=labeled-row-label>{{ 'entity-baseData.invitingRules' | i18next:{context:entity.type} }}</div><div class=labeled-row-value>{{ entityInfo.invitingRules }}</div></div><div class=labeled-row ng-if=entityInfo.invitingExternalRules><div class=labeled-row-label>{{ 'entity-baseData.invitingExternalRules' | i18next:{context:entity.type} }}</div><div class=labeled-row-value>{{ entityInfo.invitingExternalRules }}</div></div></div><jc-loading show-loading=loading show-error-message=\"!loading && showErrorMessage\" show-no-content-message=\"!loading && !showErrorMessage && baseData.length === 0\" no-content-message=\"'entity.noInfo' | i18next:{context:entity.type}\"></jc-loading>"),$templateCache.put("scripts/entity/controller/entity.html","<div class=\"no-content text-danger\" ng-if=error>{{ error | i18next }}</div><div class=entity ng-class=\"{ appointment: isEvent, '{{ entity.type | jcEntityClass }}': true}\" ng-if=\"entity && !error\"><div class=subheader ng-class=\"[( entity.type | jcEntityClass ), 'app-' + appId + '-bg-color']\"><div class=subheader-title><span class=subheader-subtitle>{{ 'entityName.entitySingularUpper' | i18next: {context:entityType} }}</span> {{ entity.name }}<div ng-if=isEvent class=entity-date>{{ entity | jcEntityDate }}</div><div ng-if=isEvent class=entity-location>{{ entity.location }}</div><jc-dropdown values=menuEntries selected-value=selectedComponent on-value-changed=onMenuEntrySelected></jc-dropdown></div></div><div ui-view=content class=component autoscroll=false></div></div><div jc-dialog=showSelectAttendanceStatus><div class=jc-dialog-text ng-if=selectAttendanceStatusMessage>{{ selectAttendanceStatusMessage | i18next:{context:entityType} }}</div><div class=jc-dialog-button ng-repeat=\"entityAction in entityActions\" ng-click=entityAction.action();>{{ entityAction.i18nKey | i18next:{context:entityType} }}</div><div class=jc-dialog-button ng-click=toggleShowSelectAttendanceStatus();>{{ 'general.buttonCancel' | i18next }}</div></div>"),$templateCache.put("scripts/entity/controller/raw-editor.html",'<div class=wiki-container><div class="panel panel-default jc-user-generated-html" ng-repeat="editor in rawEditor.rawEditors"><div class=panel-body jc-html-link-rewrite="editor.text | jcTrustedHtml" jc-additional-link-class=app-connect-color jc-rewrite-anchor></div></div></div><jc-loading show-loading=rawEditor.loading show-error-message="!rawEditor.loading && rawEditor.showErrorMessage" show-no-content-message="!rawEditor.loading && !rawEditor.showErrorMessage && rawEditor.rawEditors.length === 0" no-content-message="\'entity.noRawEditorsData\' | i18next"></jc-loading>'),
$templateCache.put("scripts/entity/controller/wiki.html",'<div class=wiki-container><div class="panel panel-default jc-user-generated-html" ng-repeat="section in wiki"><div class=panel-heading ng-bind-html=section.headline ng-if=section.headline></div><div class=panel-body jc-html-link-rewrite="section.text | jcTrustedHtml" jc-additional-link-class=app-connect-color jc-rewrite-anchor></div></div></div><jc-loading show-loading=loading show-error-message="!loading && showErrorMessage" show-no-content-message="!loading && !showErrorMessage && wiki.length === 0" no-content-message="\'entity-wiki.noData\' | i18next:{context:entity.type}"></jc-loading>'),$templateCache.put("scripts/feed/composer-image-preview/composer-image-preview.html",'<feed-image-attachment ng-if=$ctrl.isAttachment attachment=$ctrl.file ignore-click=true></feed-image-attachment><img ng-if=!$ctrl.isAttachment width=100% height=auto ng-src="{{ $ctrl.src }}"><jc-loading show-loading=!$ctrl.imagePreviewReady></jc-loading><div class=workstream-composer-attachment-delete ng-click=$ctrl.removeAttachment(); ng-if=$ctrl.imagePreviewReady><i class="fa fa-times"></i></div>'),$templateCache.put("scripts/feed/composer-progress-dialog/composer-progress-dialog.html","<div class=jc-dialog><div class=jc-progress-dialog-content><div class=jc-dialog-loading-icon><div class=jc-progress-dialog-text>{{'workstream.composerUploading' | i18next}}</div><i class=\"fa fa-circle-o-notch fa-spin fa-3x\"></i></div></div><div class=jc-dialog-content><div class=jc-dialog-button ng-click=$ctrl.onAbort();>{{ 'general.buttonCancel' | i18next }}</div></div></div>"),$templateCache.put("scripts/feed/fake-composer/fake-composer.html",'<div class="workstream-composer-fake-text-area clearfix"><div class=workstream-composer-fake-text-area-left ng-click=$ctrl.openComposer()><i class="fa fa-pencil workstream-composer-edit-icon"></i> <span class=workstream-composer-fake-placeholder>{{\'workstream.composerEnterTextHere\' | i18next}}</span></div><jc-select-file class=workstream-composer-fake-text-area-right jc-capture=true images-only=true on-file-select=$ctrl.onFileSelect icon=fa-camera></jc-select-file></div>'),$templateCache.put("scripts/feed/feed-attachment/feed-document-attachment/feed-document-attachment.html",'<div class="workstream-teaser workstream-document-teaser teaser" ng-click=$ctrl.onClick();><div class=teaser-icon>{{ $ctrl.documentTag }}</div><div class=teaser-text><div class="teaser-title with-subtitle">{{ $ctrl.attachment.title }}</div><div class=teaser-subtitle>{{ $ctrl.attachment.size | jcFileSize }}</div></div></div>'),$templateCache.put("scripts/feed/feed-attachment/feed-external-video-attachment/feed-external-video-attachment.html",'<div class=workstream-video-attachment><div class=workstream-video-thumbnail ng-if=!$ctrl.showVideo ng-click=$ctrl.onClick()><img class="img-responsive center-block" ng-src="{{$ctrl.thumbnailURL}}"><div class=workstream-video-play-icon-container><i class="fa fa-play-circle workstream-video-play-icon"></i></div></div><div class=jc-embed-video-container ng-bind-html="$ctrl.embedHTML | jcTrustedHtml" ng-if=$ctrl.showVideo></div><div class=workstream-video-title><a class=jc-unstyled-link feed-link-attachment-url=$ctrl.url>{{$ctrl.attachment.title}}</a></div></div>'),$templateCache.put("scripts/feed/feed-attachment/feed-image-attachment/feed-image-attachment.html",'<a ng-click=$ctrl.onImageClicked()><img class="img-responsive center-block" ng-src="{{$ctrl.previewUrl}}"></a>'),$templateCache.put("scripts/feed/feed-attachment/feed-link-attachment/feed-link-attachment.html",'<a class="jc-unstyled-link workstream-teaser workstream-link-teaser teaser" feed-link-attachment-url=$ctrl.attachment.url ignore-click=$ctrl.ignoreClick><div class=teaser-icon><img class=img-responsive ng-src="{{ $ctrl.faviconUrl }}"></div><div class=teaser-text><div class=teaser-title>{{ $ctrl.attachment.title }}</div></div></a>'),$templateCache.put("scripts/feed/feed-attachment/feed-video-attachment/feed-video-attachment.html",'<video ng-if=$ctrl.previewReady class=feed-video playsinline preload=metadata ng-attr-controls="{{ $ctrl.showControls }}" ng-attr-poster="{{ $ctrl.coverImage }}"><source ng-src="{{ $ctrl.videoUrl }}"></source><feed-document-attachment attachment=$ctrl.attachment></feed-document-attachment></video><div ng-if="!$ctrl.previewReady && $ctrl.showPreviewPendingHint" class=feed-video-preview-pending><div class=illustration></div><div class=text ng-i18next="[html]{{\'workstream.feedVideoPreviewPending\'}}"></div></div><span ng-if="!$ctrl.showControls && $ctrl.previewReady" class=workstream-attachment-file-type-hint><i class="fa fa-play-circle"></i></span>'),$templateCache.put("scripts/feed/feed-comment-composer/feed-comment-composer.html",'<div class=workstream-compose-comment><form ng-submit=$ctrl.postComment(); class="workstream-comment-text-area vertical-centered vc-full-width vc-fixed"><textarea id=comment-text-area ng-model=$ctrl.text ng-i18next=[placeholder]workstream.enterCommentHere rows="{{$ctrl.expanded ? 5 : 1}}" ng-focus=$ctrl.expand()>\n            </textarea><div class=workstream-post-comment-button ng-show=$ctrl.expanded ng-click=$ctrl.postComment();><i ng-class="$ctrl.commenting ? \'fa fa-circle-o-notch fa-spin fa-fw\' : \'fa fa-share fa-fw\'"></i></div></form></div>'),$templateCache.put("scripts/feed/feed-comment/feed-comment.html",'<div class=workstream-comment><img class=workstream-comment-author-image ng-src="{{ $ctrl.comment.author.imageUrlPattern |jcImage:\'X_SMALL\' }}" ng-click="$ctrl.goToAuthor()"><div class=workstream-comment-body><div class=workstream-comment-name><jc-dropdown class=workstream-comment-actions ng-if="$ctrl.menuItems.length > 0" values=$ctrl.menuItems on-value-changed=$ctrl.handleMenuItemSelected></jc-dropdown><span ng-click=$ctrl.goToAuthor()>{{ $ctrl.authorName }}</span></div><div class=workstream-comment-date>{{$ctrl.comment.postedDate | jcFromNow}}</div><feed-quill-message class=workstream-comment-text quill-delta=::$ctrl.comment.editorModel text=::$ctrl.comment.htmlText read-only=true></feed-quill-message><div class=workstream-comment-like ng-if="$ctrl.mayLikeOrUnlike() || $ctrl.comment.like.likeCount > 0"><a class=jc-unstyled-link ng-click=$ctrl.toggleLike(); ng-if=$ctrl.mayLikeOrUnlike()><i ng-class="$ctrl.liking\n                    ? \'fa fa-circle-o-notch fa-spin fa-fw\'\n                    : $ctrl.comment.like.iLike\n'+"                        ? 'fa fa-heart fa-fw app-' + $ctrl.appId + '-color'\n                        : 'fa fa-heart-o fa-fw'\"></i></a><div ng-if=\"$ctrl.comment.like.likeCount > 0\" ng-click=$ctrl.goToLikers() class=workstream-social-summary><span class=workstream-item-details-like-text>{{ 'like.xLikeThis' | i18next: {count: $ctrl.comment.like.likeCount} }}</span></div></div></div></div>"),$templateCache.put("scripts/feed/feed-comments/feed-comments.html","<div ng-if=\"$ctrl.comments.length > 0\" class=workstream-item-details-comments><div class=workstream-item-details-load-comments ng-if=\"$ctrl.moreCommentCount > 0\"><a class=jc-unstyled-link ng-click=$ctrl.loadAllComments();>{{ 'workstream.xMoreComments' | i18next:{count: $ctrl.moreCommentCount} }}</a></div><feed-comment comment=comment app-id=$ctrl.appId on-toggle-like=$ctrl.onToggleLike($event) on-delete-comment=$ctrl.onDeleteComment($event) ng-repeat=\"comment in $ctrl.comments\"></feed-comment></div><div jc-dialog=$ctrl.showCommentDeleteDialog><div class=jc-dialog-text>{{ 'workstream.deleteCommentConfirm' | i18next }}</div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.deleteComment();>{{ 'workstream.yesDeleteComment' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.abortDeleteComment();>{{ 'workstream.noDontDeleteComment' | i18next }}</div></div></div>"),$templateCache.put("scripts/feed/feed-message/feed-message-actions/feed-message-actions.html",'<div class=workstream-actions ng-if="$ctrl.mayLikeOrUnlike || $ctrl.mayComment"><feed-message-likes ng-if=$ctrl.mayLikeOrUnlike message=$ctrl.message app-id=$ctrl.appId></feed-message-likes><div ng-click=$ctrl.onShowDetails() ng-if=$ctrl.mayComment><i class="workstream-item-comment-button fa fa-comment-o fa-fw"></i> <span class=workstream-item-comment-count>{{ $ctrl.message.comments.totalSize }}</span></div></div>'),$templateCache.put("scripts/feed/feed-message/feed-message-attachments/feed-message-attachments.html",'<div class="workstream-message text-warning" ng-if=$ctrl.hasUnsupportedAttachments><small>{{\'workstream.missingAttachments\' | i18next}}</small></div><div class=workstream-attachments ng-if="$ctrl.hasMediaAttachments && !$ctrl.compactView"><div class=workstream-attachment ng-repeat="attachment in $ctrl.mediaAttachments"><feed-message-attachment attachment=attachment></feed-message-attachment></div></div><div class=workstream-attachments ng-if=$ctrl.hasNonMediaAttachments><div class=workstream-attachment ng-repeat="attachment in $ctrl.nonMediaAttachments"><feed-message-attachment attachment=attachment></feed-message-attachment></div></div>'),$templateCache.put("scripts/feed/feed-message/feed-message-content/feed-message-content.html","<div class=workstream-message><feed-quill-message ng-if=!$ctrl.isActivityMessage class=workstream-message-text quill-delta=::$ctrl.message.quillDelta text=::$ctrl.message.text read-only=true compact-view=::$ctrl.compactView></feed-quill-message><feed-activity-message ng-if=$ctrl.isActivityMessage class=workstream-message-text message=$ctrl.message></feed-activity-message></div>"),$templateCache.put("scripts/feed/feed-message/feed-message-cover/feed-message-cover.html",'<div class=workstream-message-cover><feed-message-attachment attachment=$ctrl.coverAttachment ignore-click=true></feed-message-attachment><div ng-if="$ctrl.totalAttachmentCount > 1" class=workstream-message-cover-total-count>{{ ::$ctrl.totalAttachmentCount }} <i class="fa fa-clone"></i></div></div>'),$templateCache.put("scripts/feed/feed-message/feed-message-create/feed-message-create.html","<feed-message-input author=$ctrl.author files=$ctrl.files target-id=$ctrl.targetId on-post=$ctrl.post($event) on-cancel=$ctrl.cancel()></feed-message-input><composer-progress-dialog ng-if=$ctrl.uploading on-abort=$ctrl.abortUpload()></composer-progress-dialog>"),$templateCache.put("scripts/feed/feed-message/feed-message-details/feed-message-details.html","<div class=workstream-item-details><feed-message-header display-actions=true message=$ctrl.message on-show-delete-dialog=$ctrl.showDeleteDialog() on-edit-message=$ctrl.editMessage()></feed-message-header><div ng-if=$ctrl.hasTitle class=workstream-message-title>{{$ctrl.message.title}}</div><div class=workstream-attachments ng-if=$ctrl.coverAttachment><feed-message-attachment attachment=$ctrl.coverAttachment></feed-message-attachment></div><feed-message-content ng-if=\"$ctrl.hasContent || $ctrl.isActivityMessage\" message=$ctrl.message compact-view=false></feed-message-content><feed-message-attachments attachments=$ctrl.attachments compact-view=false></feed-message-attachments><div ng-if=\"!$ctrl.isActivityMessage && !$ctrl.hasContent && !$ctrl.hasSupportedAttachments\" class=\"workstream-message text-warning\">{{'workstream.noContent' | i18next}}</div></div><div class=workstream-item-details-footer><div class=workstream-actions><feed-message-likes ng-if=$ctrl.mayLikeOrUnlike message=$ctrl.message app-id=$ctrl.appId></feed-message-likes></div><feed-comments app-id=$ctrl.appId message-id=$ctrl.message.id></feed-comments><feed-comment-composer message-id=$ctrl.message.id ng-show=$ctrl.mayComment></feed-comment-composer></div><div jc-dialog=$ctrl.deleteDialogVisible><div class=jc-dialog-text>{{ 'workstream.deletePostConfirm' | i18next }}</div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.deleteMessage();>{{ 'workstream.yesDeletePost' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.hideDeleteDialog();>{{ 'workstream.noDontDeletePost' | i18next }}</div></div></div>"),$templateCache.put("scripts/feed/feed-message/feed-message-edit/feed-message-edit.html","<feed-message-input message=$ctrl.message on-post=$ctrl.post($event) on-cancel=$ctrl.cancel()></feed-message-input><composer-progress-dialog ng-if=$ctrl.uploading on-abort=$ctrl.abortUpload()></composer-progress-dialog>"),$templateCache.put("scripts/feed/feed-message/feed-message-header/feed-message-header.html",'<div class=workstream-header><img class=workstream-author-image ng-src="{{$ctrl.message.author.imageUrlPattern|jcImage:\'SMALL\'}}" ng-click="$ctrl.goToAuthor($ctrl.message)"><div class=workstream-info><div class=workstream-name ng-click=$ctrl.goToAuthor($ctrl.message)>{{$ctrl.message.author | profileName}}</div><div class=workstream-origin ng-click=$ctrl.goToOrigin($ctrl.message)>{{$ctrl.message.originName | jcOrigin:$ctrl.message.originId:$ctrl.message.author}}</div><div class=workstream-message-date>{{$ctrl.message.publishedDate | jcFromNow}}</div></div><jc-dropdown ng-if="$ctrl.menuItems.length > 0" values=$ctrl.menuItems on-value-changed=$ctrl.handleMenuItemSelected></jc-dropdown></div>'),$templateCache.put("scripts/feed/feed-message/feed-message-input/feed-message-input.html","<div class=workstream-composer-item-details><div class=workstream-header><img class=workstream-author-image ng-src=\"{{$ctrl.author.imageUrlPattern | jcImage:'SMALL'}}\"><div class=workstream-info><div class=workstream-name>{{$ctrl.author.name}}</div><div class=workstream-origin>{{$ctrl.targetName | jcOrigin:$ctrl.targetId:$ctrl.author}}</div></div></div><div class=feed-message-input><input class=feed-message-input-title ng-model=$ctrl.title ng-i18next=[placeholder]workstream.composerEnterTitleHere><ng-quill-editor id=composerEditor class=feed-message-input-text format=\"{{ $ctrl.format }}\" ng-model=$ctrl.content theme=bubble modules=$ctrl.quillEditorModules on-editor-created=$ctrl.onEditorCreated(editor) placeholder=\"'workstream.composerEnterTextHere' | i18next\"></ng-quill-editor><div class=workstream-composer-post-actions><div class=workstream-composer-post-actions-button ng-click=$ctrl.requestCancel(); jc-blur=composerEditor jc-blur-event=click>{{'general.buttonCancel' | i18next}}</div><div class=\"jc-button workstream-composer-post-actions-button\" ng-click=$ctrl.post(); jc-blur=composerEditor jc-blur-event=click>{{'general.buttonPost' | i18next}}</div></div><div class=\"workstream-composer-attachments-warning text-warning\" ng-if=\"$ctrl.numFilteredFiles > 0\">{{'workstream.composerFilteredAttachments' | i18next:{count: $ctrl.numFilteredFiles} }}</div><div class=workstream-composer-attachments ng-if=$ctrl.files.length><composer-image-preview ng-repeat=\"file in $ctrl.files\" file=file on-remove-attachment=$ctrl.removeAttachment($event) class=\"workstream-attachment workstream-composer-attachment-image\"></composer-image-preview></div><div class=workstream-composer-attachment-actions><jc-select-file class=workstream-composer-attachments-actions-button jc-multiple=true images-only=true on-file-select=$ctrl.onFilesSelected icon=fa-picture-o></jc-select-file><jc-select-file class=workstream-composer-attachments-actions-button jc-capture=true images-only=true on-file-select=$ctrl.onFilesSelected icon=fa-camera></jc-select-file></div></div></div><div jc-dialog=$ctrl.showCancelDialog><div class=jc-dialog-text>{{ 'workstream.composerCancelConfirm' | i18next }}</div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.onCancel();>{{ 'workstream.composerYesCancel' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.abortCancel();>{{ 'workstream.composerNoDontCancel' | i18next }}</div></div></div>"),$templateCache.put("scripts/feed/feed-message/feed-message-likes/feed-message-likes.html","<i ng-click=$ctrl.toggleLike(); class=workstream-item-like-button ng-class=\"$ctrl.liking\n                ? 'fa fa-circle-o-notch fa-spin fa-fw app-' + $ctrl.appId + '-color'\n                : $ctrl.like.iLike\n                    ? 'fa fa-heart fa-fw app-' + $ctrl.appId + '-color'\n                    : 'fa fa-heart-o fa-fw app-' + $ctrl.appId + '-color'\"></i> <span class=workstream-item-like-count ui-sref=\"main.likers({'itemId':$ctrl.message.id, 'appId': $ctrl.appId})\">{{ $ctrl.like.likeCount }}</span>"),$templateCache.put("scripts/feed/feed-message/feed-message.html",'<div class=workstream-body><feed-message-header display-actions=false feed-id=$ctrl.feedId message=$ctrl.message></feed-message-header><div ng-click=$ctrl.showDetails()><div class=workstream-attachments ng-if=$ctrl.hasMediaAttachments><feed-message-cover media-attachments=$ctrl.mediaAttachments></feed-message-cover></div><div ng-if=$ctrl.hasTitle class=workstream-message-title>{{$ctrl.message.title}}</div><feed-message-content ng-if="$ctrl.hasContent || $ctrl.isActivityMessage" message=$ctrl.message compact-view=true></feed-message-content><feed-message-attachments ng-if=!$ctrl.isActivityMessage attachments=$ctrl.message.attachments compact-view=true></feed-message-attachments><div ng-if="!$ctrl.isActivityMessage && !$ctrl.hasContent && !$ctrl.hasSupportedAttachments" class="workstream-message text-warning">{{\'workstream.noContent\' | i18next}}</div></div></div><feed-message-actions ng-if=!$ctrl.isActivityMessage message=$ctrl.message app-id=$ctrl.appId on-show-details=$ctrl.showDetails()></feed-message-actions>'),$templateCache.put("scripts/feed/feed-messages/feed-messages.html",'<ul class="workstream list-unstyled clearfix"><li class=workstream-item ng-repeat="message in $ctrl.messages"><feed-message message=message feed-id=$ctrl.feedId app-id=$ctrl.appId on-show-details=$ctrl.goToDetails($event)></feed-message></li></ul>'),$templateCache.put("scripts/feed/feed/feed.html",'<fake-composer ng-if=$ctrl.feed.mayPost feed-id=$ctrl.feedId></fake-composer><pinned-feed-messages feed=$ctrl.pinnedFeed feed-id=$ctrl.feedId on-load-more=$ctrl.fetchNextPinnedMessages(hasHiddenPinnedMessages) on-hide-messages=$ctrl.hidePinnedMessages()><div class=workstream-section-title>{{ \'workstream.recentMessages\' | i18next }}</div></pinned-feed-messages><feed-messages ng-if=$ctrl.feed.messages app-id=$ctrl.appId feed-id=$ctrl.feedId messages=$ctrl.feed.messages></feed-messages><jc-loading show-loading=$ctrl.loading show-error-message="!$ctrl.loading && $ctrl.showErrorMessage" error-message="\'workstream.errorNoPostsAvailable\' | i18next" show-no-content-message="!$ctrl.loading && !$ctrl.showErrorMessage && $ctrl.feed.messages.length === 0" no-content-message="\'workstream.noPostsAvailable\' | i18next"></jc-loading><div ng-if=$ctrl.feed.hasMore jc-on-scroll-event=jc-fetch-next-ws-messages></div>'),$templateCache.put("scripts/feed/pinned-feed-message/pinned-feed-message.html",'<div class=workstream-body ng-click=$ctrl.goToDetails()><div class=workstream-header><img class=workstream-author-image ng-src="{{$ctrl.message.author.imageUrlPattern|jcImage:\'SMALL\'}}" ng-click="$ctrl.goToAuthor()"><div class=workstream-info><div class=workstream-message-title>{{$ctrl.title}}</div><div class=workstream-origin>{{$ctrl.message.originName | jcOrigin:vm.message.originId:vm.message.author}}</div><div class=workstream-message-date>{{$ctrl.message.publishedDate | jcFromNow}}</div></div></div></div>'),$templateCache.put("scripts/feed/pinned-feed-messages/pinned-feed-messages.html",'<div ng-if="$ctrl.feed.messages.length > 0 || $ctrl.hasHiddenPinnedMessages"><div class=workstream-section-title>{{ \'workstream.pinnedMessages\' | i18next }} <a class="workstream-section-title-hide-icon jc-unstyled-link" ng-if=$ctrl.hasPinnedMessagesToShow ng-click=$ctrl.onHideMessages()><i class="fa fa-eye-slash"></i></a></div><ul class="workstream pinned-workstream list-unstyled clearfix"><li class=workstream-item ng-repeat="pinnedMessage in $ctrl.feed.messages" ng-if=$ctrl.showMessage(pinnedMessage)><pinned-feed-message message=pinnedMessage></pinned-feed-message></li><div class=pinned-workstream-load-more ng-class="{\'has-new\': $ctrl.hasNewHiddenPinnedMessages}" ng-if="$ctrl.feed.hasMore || $ctrl.hasHiddenPinnedMessages" ng-click="$ctrl.onLoadMore({hasHiddenPinnedMessages: $ctrl.hasHiddenPinnedMessages})">{{\'workstream.loadMorePinnedMessages\' | i18next }}</div></ul><ng-transclude></ng-transclude></div>'),$templateCache.put("scripts/like/likes/likes.html",'<div class=likers><profile-teaser ng-repeat="profile in $ctrl.likers" teaser=profile ng-click=$ctrl.goTo(profile.id)></profile-teaser><div ng-if="!$ctrl.loading && !$ctrl.error && $ctrl.likers.length < 1" class=no-content>{{ \'like.noOneLikesThis\' | i18next}}</div><div ng-if=$ctrl.error class="no-content text-danger">{{ $ctrl.error | i18next }}</div><div ng-if=$ctrl.hasMoreResults jc-on-scroll-event=jc-fetch-next-likers></div></div>'),$templateCache.put("scripts/message/controller/all-conversations.html",'<div class=jc-ng-all-conversations><div class=jc-mobile-chat-header><div class=jc-mobile-chat-bar><jc-conversation-suggest-input class=jc-conversation-search ng-class="{\'collapsed\': !showSuggestions}" placeholder-text="{{\'conversation.chatWith\' | i18next}}" model=query suggestions=suggestions show-suggestions=showSuggestions></jc-conversation-suggest-input><jc-chat-presence-switch ng-if=!showSuggestions></jc-chat-presence-switch></div></div><div class=jc-ng-suggest-dropdown ng-show=showSuggestions><div class=jc-ng-suggest-dropdown-arrow-up></div><div class=jc-ng-suggest-list><div ng-click=handleSuggestionSelect(suggest) ng-repeat="suggest in suggestions" class=jc-ng-suggest-item><jc-conversation-search-teaser teaser=suggest></jc-conversation-search-teaser></div><div ng-click=createMultiUserConversation() class=jc-ng-suggest-item><start-multi-user-conversation conversation-name=query></start-multi-user-conversation></div></div></div><jc-conversation-list conversations=conversations ng-if=!showSuggestions loading-conversations=loadingConversations></jc-conversation-list><div ng-if=hasMoreConversation jc-on-scroll-event=jc-fetch-next-conversations ng-if=!showSuggestions></div></div><div jc-dialog=showLoading><div class=jc-loading-dialog-content><div class="fa fa-circle-o-notch fa-spin fa-3x jc-dialog-loading-icon"></div></div></div>'),$templateCache.put("scripts/message/controller/chat-deprecated.html","<div class=jc-chat-deprecated ng-if=!vm.appInstalled><div class=jc-hero-image></div><div class=\"jc-title jc-typography--headline5\">{{'chat.deprecated.title' | i18next}}</div><div class=\"jc-text jc-typography--subtitle1\">{{'chat.deprecated.text' | i18next}}</div><div class=\"jc-button app-chat-bg-color\" ng-click=vm.onInstall()>{{'chat.deprecated.action' | i18next}}</div></div>"),$templateCache.put("scripts/message/controller/conversation-delete-confirm.html","<div class=jc-mobile-edit-conversation ng-if=loadingConversationFailed>{{ 'conversation.failedToLoadConversation' | i18next }}</div><div class=jc-mobile-edit-conversation ng-show=!loadingConversationFailed jc-adjust-min-height><div class=jc-mobile-confirm-delete-conversation ng-show=!vm.loading><div class=jc-mobile-edit-conversation-info-text>{{'conversation.deleteConversationReallyDelete' | i18next}}</div><div class=jc-mobile-edit-conversation-info-text>{{'conversation.deleteConversationWarning' | i18next}}</div><div class=jc-mobile-edit-conversation-info-text>{{'conversation.deleteConversationPasswordHint' | i18next}}</div><form ng-submit=vm.deleteConversation()><input class=jc-mobile-edit-conversation-input ng-model=vm.password ng-i18next=[placeholder]conversation.deleteConversationPasswordPlaceholder ng-change=vm.updateDeleteEnabled()></form></div><jc-loading show-loading=vm.loading></jc-loading><div class=jc-mobile-confirm-delete-conversation-button-panel><div class=jc-mobile-edit-conversation-button ng-click=vm.cancel()>{{'general.buttonCancel' | i18next}}</div><div class=jc-mobile-edit-conversation-middle-button>&nbsp;</div><div class=jc-mobile-edit-conversation-button ng-class=\"{'disabled': !vm.deleteEnabled}\" ng-click=vm.deleteConversation()>{{'conversation.delete' | i18next}}</div></div></div>"),$templateCache.put("scripts/message/controller/conversation-participants-editor.html",'<div class=jc-mobile-edit-conversation ng-if=loadingConversationFailed>{{ \'conversation.failedToLoadConversation\' | i18next }}</div><div class=jc-mobile-edit-conversation ng-show=!loadingConversationFailed jc-adjust-min-height><form ng-submit=onSubmit()><jc-conversation-suggest-input class=jc-mobile-edit-conversation-suggest-input placeholder-text="{{\'message.addRecipient\' | i18next}}" model=query suggestions=suggestions show-suggestions=showSuggestions suggest-only-persons=true></jc-conversation-suggest-input></form><div class=jc-ng-suggest-dropdown ng-show="showSuggestions && suggestions"><div class=jc-ng-suggest-dropdown-arrow-up></div><div class=jc-ng-suggest-list jc-adjust-min-height=-65><div ng-click=addParticipant(suggest) ng-repeat="suggest in suggestions" class=jc-ng-suggest-item><jc-conversation-search-teaser teaser=suggest></jc-conversation-search-teaser></div><div ng-if="suggestions.length === 0" class=jc-ng-suggest-no-result><span>{{\'search.noSearchResult\' | i18next}}</span></div></div></div><div ng-if="!showSuggestions || !suggestions"><div class=jc-mobile-chat-participants-list-container><div class=jc-mobile-chat-participants-list><div class=jc-mobile-participant ng-repeat="participant in participants.values()"><div class=jc-mobile-participant-teaser><jc-participant-teaser teaser=participant show-highlighting=false link-participant=true></jc-participant-teaser></div><div class=jc-mobile-participant-delete-icon ng-click=removeParticipant(participant)><i class="fa fa-trash-o"></i></div></div></div></div><jc-loading show-loading=loadingConversation></jc-loading><div class=jc-mobile-edit-conversation-button-panel><div class=jc-mobile-edit-conversation-button ng-click=cancel()>{{ \'chat.backToConversation\' | i18next }}</div><div class=jc-mobile-edit-conversation-middle-button>&nbsp;</div><div class=jc-mobile-edit-conversation-button ng-click=createConversation() ng-if=!showEditButton>{{ \'conversation.create\' | i18next }}</div><div class=jc-mobile-edit-conversation-button ng-click=updateConversation() ng-if=showEditButton>{{ \'conversation.update\' | i18next }}</div></div></div></div>'),$templateCache.put("scripts/message/controller/conversation-title-editor.html","<div class=jc-mobile-edit-conversation ng-if=loadingConversationFailed>{{ 'conversation.failedToLoadConversation' | i18next }}</div><div class=\"jc-mobile-edit-conversation jc-mobile-edit-conversation-title\" ng-show=!loadingConversationFailed jc-adjust-min-height><form ng-submit=updateConversation()><input class=jc-mobile-edit-conversation-input ng-model=conversationTitle ng-i18next=[placeholder]conversation.setConversationTitle ng-change=onTitleChanged()></form><jc-loading show-loading=loadingConversation></jc-loading><div class=jc-mobile-edit-conversation-button-panel><div class=jc-mobile-edit-conversation-button ng-click=cancel()>{{ 'general.buttonCancel' | i18next }}</div><div class=jc-mobile-edit-conversation-middle-button>&nbsp;</div><div class=jc-mobile-edit-conversation-button ng-click=updateConversation()>{{ 'conversation.update' | i18next }}</div></div></div>"),$templateCache.put("scripts/message/controller/conversation.html",'<div id=chat-container class=jc-ng-chat-history><div class=jc-mobile-chat-show-more ng-if=conversation.hasMore ng-click=conversation.loadOlderMessages()><i class="fa fa-chevron-up"></i> {{\'chat.showMore\' | i18next}}</div><jc-loading ng-class="{\'jc-mobile-chat-error\': conversation.showErrorMessage}" show-loading="conversation.loadingInitialMessages || conversation.loadingOlderMessages" show-error-message="!conversation.loadingInitialMessages && conversation.showErrorMessage" error-message="\'message.failedToLoadMessages\' | i18next"></jc-loading><div id=chat-messages class=jc-mobile-chat-messages><jc-chat-message chat-message=chatMsg ng-repeat="chatMsg in conversation.chatMessages"></jc-chat-message></div><div class=jc-mobile-chat-history-footer id=chat-footer><jc-chat-upload-progress-bar queued-uploads=conversation.queuedUploads conversation-id=conversation.conversationId></jc-chat-upload-progress-bar><div class=jc-mobile-chat-history-toolbar-outer><div class=jc-mobile-chat-history-toolbar><i class="jc-mobile-chat-history-toolbar-icon fa fa-cog" ng-click=conversation.openEditDialog() ng-show=conversation.showEditButton></i><jc-select-file class="jc-mobile-chat-history-toolbar-icon icon-right" icon=fa-paperclip jc-multiple=true on-file-select=conversation.onFileSelected></jc-select-file></div></div><form class="jc-ng-vc jc-ng-vc-full-width jc-ng-vc-fixed"><textarea class=jc-mobile-chat-message-composer ng-i18next=[placeholder]chat.composerPlaceholder ng-model=conversation.message ng-focus=conversation.onComposerFocus() maxlength=10000>\n'+"            </textarea><div class=jc-mobile-chat-message-composer-button ng-click=conversation.sendMessage() ng-class=\"{'disabled': !conversation.allowedToSend() }\"><i class=\"fa fa-share fa-fw\"></i></div></form></div></div><div jc-dialog=conversation.showEditDialog><div ng-if=conversation.showLoadingSettingsSpinner class=jc-loading-dialog-content><div class=\"fa fa-circle-o-notch fa-spin fa-3x jc-dialog-loading-icon\"></div></div><div ng-if=!conversation.loadingSettings><div class=jc-dialog-button-group><div class=jc-dialog-button ng-if=conversation.showDeleteAction ng-click=conversation.confirmDeleteConversation()>{{ 'conversation.deleteConversation' | i18next }}</div><div class=jc-dialog-button ng-click=conversation.setMuted(!conversation.settings.muted)>{{ conversation.settings.muted ? 'conversation.activateNotifications' : 'conversation.deactivateNotifications' | i18next }}</div><div class=jc-dialog-button ng-click=conversation.hideShowConversation()>{{ conversation.settings.hidden ? 'conversation.showConversation' : 'conversation.hideConversation'| i18next }}</div><div class=jc-dialog-button ng-if=conversation.showAllEditActions ng-click=conversation.openConfirmDialog()>{{ 'conversation.leaveConversation' | i18next }}</div><div class=jc-dialog-button ng-if=conversation.showAllEditActions ng-click=conversation.editConversationParticipants()>{{ 'conversation.editParticipants' | i18next }}</div><div class=jc-dialog-button ng-if=conversation.showAllEditActions ng-click=conversation.editConversationTitle()>{{ 'conversation.editConversationTitle' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=conversation.closeDialog()>{{ 'general.buttonClose' | i18next }}</div></div></div></div><div jc-dialog=conversation.showConfirmDialog><div class=jc-dialog-text>{{ 'conversation.leaveConversationWarning' | i18next }}</div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=conversation.leaveConversation()>{{ 'conversation.leave' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=conversation.closeDialog()>{{ 'general.buttonCancel' | i18next }}</div></div></div>"),$templateCache.put("scripts/message/directive/chat-connection-info.html",'<i class="fa fa-warning icon-warning-sign" data-ng-if=!hasConnection data-ng-attr-title="{{\'chat.noConnectionToJabberServer\' | i18next }}"></i>'),$templateCache.put("scripts/message/directive/jc-chat-file.html","<jc-chat-message-container chat-message=chatFile.message><div class=chat-message-content-file ng-click=chatFile.download()><img class=chat-message-content-file-icon ng-src={{::chatFile.iconUrl}}> <span class=chat-message-content-file-name>{{::chatFile.filename}}</span></div></jc-chat-message-container>"),$templateCache.put("scripts/message/directive/jc-chat-image.html","<jc-chat-message-container chat-message=chatImage.message><div class=chat-message-content-image-container><div class=chat-message-content-image ng-click=chatImage.download()><jc-secured-image src={{::chatImage.imageUrl}}></jc-secured-image><div ng-if=::chatImage.isGif class=chat-message-content-image-gif-icon></div></div></div></jc-chat-message-container>"),
$templateCache.put("scripts/message/directive/jc-chat-message-container.html","<div ng-class=\"{'chat-message-own': chatMessageContainer.ownMessage,\n                'chat-message-buddy': !chatMessageContainer.ownMessage,\n                'chat-message-group-first': !chatMessageContainer.message.isSuccessor,\n                'chat-message-group-last': !chatMessageContainer.message.hasSuccessor,\n                'chat-message-group-middle': chatMessageContainer.message.isSuccessor}\" class=chat-message-container><div class=chat-message-sender-image ng-if=!chatMessageContainer.message.isSuccessor><img ng-src=\"{{ ::chatMessageContainer.message.sentFrom.imageUrlPattern | jcImage:'X_SMALL' }}\" class=\"jc-profile-image\"></div><div class=chat-message><div class=chat-message-sender ng-if=!chatMessageContainer.message.isSuccessor>{{::chatMessageContainer.message.sentFrom | sentFromName}}</div><div class=chat-message-timestamp ng-if=!chatMessageContainer.message.isSuccessor>\u2022 {{::chatMessageContainer.message.createDate | messageTime}}</div><div class=chat-message-content ng-transclude></div></div></div>"),$templateCache.put("scripts/message/directive/jc-chat-message.html","<div class=chat-message-new-day-title ng-if=\"chatMessage.message.isFirstOfANewDay && chatMessage.messageType !== 'new-messages'\">{{::chatMessage.message.createDate | messageDay}}</div><div ng-switch=chatMessage.messageType><jc-chat-text ng-switch-when=text chat-message=chatMessage.message></jc-chat-text><jc-chat-file ng-switch-when=file chat-message=chatMessage.message></jc-chat-file><jc-chat-image ng-switch-when=image chat-message=chatMessage.message></jc-chat-image><jc-chat-notification ng-switch-when=notification chat-message=chatMessage.message></jc-chat-notification><div ng-switch-when=new-messages class=chat-message-unread-from-here>{{'conversation.newMessages' | i18next}}</div></div>"),$templateCache.put("scripts/message/directive/jc-chat-notification.html",'<div class=chat-message-content-notification><i class="fa fa-quote-left"></i> <span ng-bind-html="chatNotification.translation.key | i18next:chatNotification.translation.context"></span></div>'),$templateCache.put("scripts/message/directive/jc-chat-presence-switch.html","<div class=jc-ng-presence-switch><div class=jc-ng-current ng-click=togglePresence();><jc-chat-presence-bubble class=jc-ng-bubble ng-if=connected profile-id={{currentUserId}}></jc-chat-presence-bubble><chat-connection-info ng-if=!connected class=jc-ng-chat-connection-info></chat-connection-info></div></div>"),$templateCache.put("scripts/message/directive/jc-chat-text.html","<jc-chat-message-container chat-message=chatText.message><div class=chat-message-content-text jc-html-link-rewrite=::chatText.urlifiedMsg jc-additional-link-class=app-chat-color></div></jc-chat-message-container>"),$templateCache.put("scripts/message/directive/jc-chat-upload-progress-bar.html",'<div class=jc-chat-upload-progress-bar ng-if="chatUploadProgressBar.queuedUploads.length > 0"><div class=jc-chat-upload-progress-bar-file-count>{{ chatUploadProgressBar.finishedUploadCount + 1}}/{{chatUploadProgressBar.finishedUploadCount + chatUploadProgressBar.queuedUploads.length}}</div><ul class=jc-chat-upload-progress-bar-file-list><li class=jc-chat-upload-progress-bar-queued-file><span class=jc-chat-upload-progress-bar-file-title>{{ chatUploadProgressBar.currentUpload.file.name }}</span><div class=jc-chat-upload-progress-bar-inner ng-style="{ \'width\': (chatUploadProgressBar.currentUpload ? chatUploadProgressBar.currentUpload.progress: 0) + \'%\'}">&nbsp;</div><span class=jc-chat-upload-progress-bar-upload-cancel ng-class="{\'inactive\' : chatUploadProgressBar.currentUpload.uploadFinished}" ng-click=chatUploadProgressBar.cancelUpload(chatUploadProgressBar.currentUpload);><i class="fa fa-times"></i></span></li></ul></div>'),$templateCache.put("scripts/message/directive/jc-conversation-list.html",'<div class=jc-ng-chat-conversations><div ng-if="!loadingConversations && conversations.size() === 0" class="jc-ng-center-text-large app-chat-bg-color"><div><span>{{ \'conversation.startYourFirstConversation\' | i18next }}</span></div></div><jc-conversation-teaser conversation=conversation class=jc-ng-chat-conversation-container ng-repeat="conversation in conversations.values()" active="conversation.id === selectedConversationId" ng-if=conversation></jc-conversation-teaser><div class="jc-ng-loading text-center" ng-if=loadingConversations><i class="icon-spin icon-refresh"></i></div></div>'),$templateCache.put("scripts/message/directive/jc-conversation-search-teaser.html",'<div class=chat-search-teaser ng-attr-title={{teaser.name}}><div class=chat-search-teaser-icon><jc-chat-presence class=jc-mobile-chat-buddy-icon profile-id=teaser.id image-url-pattern=teaser.imageUrlPattern ng-if="teaser.type===\'PROFILE\'"></jc-chat-presence><jc-chat-group-icon group-title=teaser.name ng-if="teaser.type===\'CONVERSATION\'"></jc-chat-group-icon></div><div class=chat-search-teaser-name><span ng-if="teaser.type===\'PROFILE\' && prefix">{{ prefix | i18next }}</span> <span ng-bind-html="teaser.htmlhightlightedName | jcHighlighting:{emojify: emojify}"></span></div></div>'),$templateCache.put("scripts/message/directive/jc-conversation-suggest-input.html",'<div class="jc-ng-suggest-input app-chat-bg-color-light"><span class="fa fa-search-plus" jc-focus=jc-ng-suggest-input-field></span> <input id={{inputId}} class=app-chat-bg-color-light placeholder={{placeholderText}} ng-model=query ng-model-options="{ updateOn: \'default change\', debounce: {\'default\': 200, \'change\': 500} }" ng-change=onInputChange() ng-blur=onInputBlur() ng-focus=onInputFocus()> <span class="fa fa-times jc-ng-suggest-clear-icon" ng-if=query ng-click=clearQuery()></span></div>'),$templateCache.put("scripts/message/directive/jc-conversation-teaser-message.html",'<div class="jc-ng-chat-conversation-teaser-message app-chat-color-light" ng-if=conversationTeaserMessage.messageText title="{{ \'conversation.teaser\' | i18next}}"><div class=jc-ng-chat-conversation-teaser-author-and-text ng-bind-html="::conversationTeaserMessage.teaserAuthor + \': \' + conversationTeaserMessage.messageText"></div><div class=jc-ng-chat-conversation-teaser-sent-at>{{::conversationTeaserMessage.conversationTeaser.teaserChatMessage.createDate | messageTime}}</div></div>'),$templateCache.put("scripts/message/directive/jc-conversation-teaser.html",'<a class=jc-unstyled-link ng-click=openConversation(conversation.id)><div class=jc-ng-chat-conversation ng-class="{\'jc-ng-chat-active-item\': active}"><div class=jc-mobile-chat-conversation-icon jc-chat-conversation-icon=conversation></div><div class=jc-ng-chat-conversation-teaser><div class=jc-ng-chat-conversation-teaser-title ng-class="{\'jc-ng-conversation-has-unread\': conversation.unreadMessagesCount.count > 0}" title="{{ \'conversation.title\' | i18next}}"><i class="fa fa-volume-off" ng-if=conversation.muted></i> <span ng-bind-html=::conversationTitleHtml></span></div><jc-conversation-teaser-message ng-if="conversation.teaserChatMessage && conversation.unreadMessagesCount.count > 0" conversation-teaser=conversation></jc-conversation-teaser-message></div><jc-unread-count count=conversation.unreadMessagesCount.count></jc-unread-count></div></a>'),$templateCache.put("scripts/message/directive/jc-participant-teaser.html",'<div class="jc-ng-teaser jc-ng-person-teaser" ng-attr-title={{::participantTeaser.teaser.name}}><div class=jc-ng-teaser-item><a class="jc-ng-teaser-name jc-unstyled-link" ng-if=::participantTeaser.isLinkable(participantTeaser.teaser) ui-sref="main.profile({profileId: participantTeaser.teaser.id})"><span ng-if=::participantTeaser.prefix>{{ ::participantTeaser.prefix | i18next }}</span> <span ng-if=::participantTeaser.showHighlighting ng-bind-html="::participantTeaser.teaser.htmlhightlightedName | jcHighlighting"></span> <span ng-if=::!participantTeaser.showHighlighting>{{ ::participantTeaser.teaser.name }}</span></a><div class=jc-ng-teaser-name ng-if=::!participantTeaser.isLinkable(participantTeaser.teaser)><span ng-if=::participantTeaser.prefix>{{ ::participantTeaser.prefix | i18next }}</span> <span ng-if=::participantTeaser.showHighlighting ng-bind-html="::participantTeaser.teaser.htmlhightlightedName | jcHighlighting"></span> <span ng-if=::!participantTeaser.showHighlighting>{{ ::participantTeaser.teaser.name }}</span></div></div><a class=jc-ng-teaser-image ng-if=::participantTeaser.isLinkable(participantTeaser.teaser) ui-sref="main.profile({profileId: participantTeaser.teaser.id})"><jc-chat-presence profile-id=::participantTeaser.teaser.id image-url-pattern=::participantTeaser.teaser.imageUrlPattern></jc-chat-presence></a><div class=jc-ng-teaser-image ng-if=::!participantTeaser.isLinkable(participantTeaser.teaser)><jc-chat-presence profile-id=::participantTeaser.teaser.id image-url-pattern=::participantTeaser.teaser.imageUrlPattern></jc-chat-presence></div></div>'),$templateCache.put("scripts/message/directive/start-multi-user-conversation.html","<span class=jc-icon-plus></span> <span ng-bind-html=\"'conversation.startNewMultiUserChat' | i18next:{name: wrapName(conversationName)}\"></span>"),$templateCache.put("scripts/my-content/controller/my-content-entities.html",'<div class=sub-view><div ng-if=showFilter class=jc-duration-filter><jc-subnavigation on-value-change=onFilterChange values=filterValues preselected-value=selectedFilter default-context=entityType></jc-subnavigation></div><jc-teaser ng-repeat="teaser in teasers" teaser=teaser></jc-teaser><jc-loading show-loading=loading show-error-message="!loading && showErrorMessage" error-message="\'entity.errorLoadingEntities\' | i18next" show-no-content-message="!loading && !showErrorMessage && teasers.length === 0" no-content-message="\'entity.noEntitiesAvailable\' | i18next"></jc-loading></div><div ng-if=hasMore jc-on-scroll-event=jc-fetch-my-content></div>'),$templateCache.put("scripts/my-content/controller/my-content.html",'<div class=sub-view><jc-teaser data-ng-repeat="teaser in teasers" teaser=teaser></jc-teaser><jc-loading data-show-loading=loading data-show-error-message="!loading && showErrorMessage" data-error-message="errorLoadingItemsMessageKey | i18next:{context: errorLoadingItemsMessageContext}" data-show-no-content-message="!loading && !showErrorMessage && teasers.length === 0" data-no-content-message="noItemsAvailableMessageKey | i18next:{context: noItemsAvailableMessageContext}"></jc-loading></div><div data-ng-if=hasMore data-jc-on-scroll-event=jc-fetch-my-content></div>'),$templateCache.put("scripts/notification-center/controller/notification-center.html","<div class=notification-center><jc-tabs><jc-tab title=\"{{ 'notification-center.new' | i18next }}\"><jc-notifications notification-state=OPEN></jc-notifications></jc-tab><jc-tab title=\"{{ 'notification-center.archived' | i18next }}\"><jc-notifications notification-state=ARCHIVED></jc-notifications></jc-tab></jc-tabs></div>"),$templateCache.put("scripts/notification-center/directive/notification.html","<div class=\"notification-center-notification {{vm.animationClass}}\"><div class=notification-center-notification-main-content ng-click=vm.onClick()><div class=notification-center-notification-info><span class=notification-center-app-icon ng-class=\"['app-' + vm.notification.appId + '-bg-color',\n                  'notification-center-app-icon-' + vm.notification.appId]\"></span> <span class=notification-center-app-name ng-class=\"['app-' + vm.notification.appId + '-color']\">{{ ::vm.appName }}</span> <span class=notification-center-notification-title-separator>\u2022</span> <span class=notification-center-notification-date>{{::vm.notification.timestamp | jcNotificationDate}}</span></div><div class=notification-center-notification-title>{{::vm.notification.title}}</div><div class=notification-center-notification-text>{{::vm.notification.text}}</div></div><div class=notification-center-notification-secondary-text ng-class=\"{'notification-center-notification-secondary-text-collapsed': vm.secondaryTextCollapsed}\" ng-if=::vm.notification.secondaryText ng-click=vm.toggleSecondaryTextCollapsed($event)>{{::vm.notification.secondaryText}}<div class=toggle><i class=fa ng-class=\"{'fa-chevron-down': vm.secondaryTextCollapsed, 'fa-chevron-up': !vm.secondaryTextCollapsed}\"></i></div></div><jc-dropdown values=vm.notification.options on-value-changed=::vm.onOptionSelected><div class=notification-center-notification-options><div class=notification-center-flag-icon ng-if=vm.notification.marked></div><i class=\"fa fa-ellipsis-v\"></i></div></jc-dropdown></div>"),$templateCache.put("scripts/notification-center/directive/notifications.html",'<div class=notification-center-notification-list jc-inner-scrolling><div ng-repeat="notification in vm.notifications track by notification.id"><div ng-if=notification.isFirstOfANewDay class=notification-center-new-day-title>{{notification.timestamp | jcNewDayMarker}}</div><jc-notification notification=notification notification-state=::vm.notificationState apps=::vm.apps on-move-notification-to-archive-click=::vm.onMoveNotificationToArchiveClick on-mark-notification-click=::vm.onMarkNotificationClick on-unmark-notification-click=::vm.onUnmarkNotificationClick on-notification-click=::vm.onNotificationClick></jc-notification></div><jc-loading show-loading="vm.loading && !vm.preventLoadingAnimation" show-error-message="!vm.loading && vm.error" error-message="vm.error | i18next"></jc-loading><div ng-if="!vm.loading && !vm.error && vm.notifications.length === 0" class=notification-center-no-content><div class=notification-center-no-content-image ng-class=vm.noContentImage></div>{{ ::vm.noContentMessage | i18next}}</div><div ng-if="vm.hasMore && vm.notifications.length !== 0" jc-fetch-more=vm.loadNotifications></div></div>'),$templateCache.put("scripts/people/controller/people.html",'<div class=search-input-group><i class="search-icon fa fa-search" jc-focus=search-field></i> <input class=search-input id=search-field ng-i18next=[placeholder]search.enterSearchTextHere ng-keyup=vm.updateSearchQuery($event)> <i class="clear-search-icon fa fa-times" ng-class="{\'clear-search-icon-disabled\': vm.searchQuery.trim() === \'\'}" ng-click=vm.clearSearchQuery(); jc-focus=search-field></i></div><div class=people-user-list jc-inner-scrolling><profile-teaser ng-repeat="teaser in vm.people track by teaser.id" teaser=teaser ng-click=vm.goToProfile(teaser.id)></profile-teaser><div ng-if="vm.hasMore && vm.people.length !== 0" jc-fetch-more=vm.fetchNextBatch showloading=vm.loading></div></div>'),$templateCache.put("scripts/profile/controller/profile-info.html",'<jc-loading show-loading=vm.loadingProfile show-no-content-message="!vm.loadingProfile && !vm.errorLoadingProfile && vm.empty" no-content-message="\'profile.noInfo\' | i18next" show-error-message="!vm.loadingProfile && vm.errorLoadingProfile" error-message="\'general.errorLoadingContent\' | i18next"></jc-loading><div ng-repeat="section in vm.sections" ng-if="!vm.empty && section.show" ng-class="{\'chronology\': section.type === \'CHRONOLOGY\'}"><div class=profile-section-heading>{{section.name | jcI18nDynamicAttribute:vm.i18nPrefix}}</div><div class=profile-section-blocks><div class=profile-section-block ng-repeat="sectionBlock in section.attributeBlocks"><jc-profile-attribute ng-repeat="attribute in sectionBlock.attributes" ng-class="{\'profile-chronology-label\': $first && section.type === \'CHRONOLOGY\'}" attribute=attribute display-label="section.type !== \'CHRONOLOGY\' && attribute.type !== \'DESCRIPTION\'" i18n-key-prefix=vm.i18nPrefix></jc-profile-attribute></div></div></div>'),$templateCache.put("scripts/profile/controller/profile.html",'<div jc-inner-scrolling><div class="no-content text-danger" ng-if=error>{{ error | i18next }}</div><div class=profile ng-if="profile && !error"><div class="subheader app-people-bg-color"><div class=image-text-teaser><span><img ng-src="{{profile.imageUrlPattern|jcImage:\'SMALL\'}}" width=64px height="64px"></span> <span class=profile-title-name>{{profile | profileName}}</span></div><jc-dropdown ng-if="availableActions.length > 0" values=availableActions on-value-changed=onMenuEntrySelected></jc-dropdown><i class="subheader-loading-status fa fa-circle-o-notch fa-spin" ng-if=loadingContactStatus></i></div><div ui-view=content class=component autoscroll=false></div></div><div jc-dialog=showSelectContactStatus><div class=jc-dialog-button-group><div class=jc-dialog-button ng-repeat="contactAction in contactActions" ng-click=contactAction.action();>{{ contactAction.i18nKey | i18next }}</div></div><div class=jc-dialog-button-group><div class="jc-dialog-button jc-dialog-button-cancel" ng-click=toggleShowSelectContactStatus();>{{ \'general.buttonCancel\' | i18next }}</div></div></div></div>'),$templateCache.put("scripts/profile/directive/jc-profile-attribute.html",'<div class=profile-attribute ng-show="profileAttribute.attributeValues.length > 0"><div class=profile-attribute-label ng-if=profileAttribute.labelI18nKey>{{ profileAttribute.labelI18nKey | jcI18nDynamicAttribute:profileAttribute.i18nKeyPrefix }}</div><div class=profile-attribute-values><span ng-repeat="attributeValue in profileAttribute.attributeValues track by $index" ng-switch on=profileAttribute.displayAs><span ng-if="!$first && profileAttribute.separateBy === \'DEFAULT\'">,</span><br ng-if="!$first && profileAttribute.separateBy === \'BR\'"><span ng-switch-when=TYPED jc-typed-value=attributeValue></span><span ng-switch-when=HTML ng-bind-html=attributeValue></span><span ng-switch-when=RAW>{{attributeValue}}</span></span></div></div>'),$templateCache.put("scripts/search/controller/search.html","<div class=search ng-class=\"{'search-error': searchStatusType === 'search-error'}\"><form ng-submit=doSearch(); jc-blur=search-field jc-blur-event=submit><div class=search-input-group><i class=\"search-icon fa fa-search\" ng-class=\"{'search-icon-disabled': searchQuery.trim() === ''}\" ng-click=\"searchQuery.trim() === '' || doSearch();\"></i> <input class=search-input id=search-field ng-i18next=[placeholder]search.enterSearchTextHere ng-model=searchQuery> <i class=\"clear-search-icon fa fa-times\" ng-class=\"{'clear-search-icon-disabled': searchQuery.trim() === ''}\" ng-click=clearSearchQuery(); jc-focus=search-field></i></div></form><div class=search-status ng-show=displayStatusText><span>{{ searchStatusI18nKey | i18next }}</span></div><div class=search-result><jc-teaser ng-repeat=\"teaser in searchResultTeasers\" teaser=teaser></jc-teaser></div><div ng-if=hasMore jc-on-scroll-event=jc-fetch-next-search-results></div></div><jc-loading show-loading=loading></jc-loading>"),$templateCache.put("scripts/task/task-assignment/task-assignment.html",'<div class=task-assign-container><div class=task-assign-input-group><a class=task-assign-search-icon jc-focus=task-assign-search-input><i class="fa fa-search"></i></a> <input id=task-assign-search-input class=task-assign-search-input placeholder="{{ \'task.searchAssignableUser\' | i18next }}" ng-keyup=$ctrl.updateQuery($event)></div><div class=search-result><profile-teaser ng-repeat="profile in $ctrl.profiles" teaser=profile ng-click=$ctrl.assignUser(profile.id)></profile-teaser><div ng-if="!$ctrl.loading && !$ctrl.error && $ctrl.profiles.length < 1" class=no-content>{{ \'task.noAssignableUsersAvailable\' | i18next}}</div><div ng-if=$ctrl.error class="no-content text-danger">{{ $ctrl.error | i18next }}</div><div ng-if=$ctrl.hasMoreResults jc-on-scroll-event=jc-fetch-next-task-assignable-users></div></div></div>'),$templateCache.put("scripts/task/task-details/task-details.html",'<jc-loading show-loading=$ctrl.loading show-error-message="!$ctrl.loading && $ctrl.error" error-message="$ctrl.error | i18next"></jc-loading><div class=task-details ng-if="!$ctrl.loading && !$ctrl.error"><span ng-if=$ctrl.isSubTask class=task-details-breadcrumb>{{ \'task.inParent\' | i18next: { parentName: $ctrl.parentName } }}</span><div class=task-details-header><task-title-editor class=task-title-editor title=$ctrl.name has-focus=$ctrl.shouldFocusTitle is-editable=$ctrl.titleEditable on-title-changed=$ctrl.titleChanged($event) on-save=$ctrl.saveChangedValues()></task-title-editor><span class=task-details-options ng-if="$ctrl.taskOptions.length > 0" ng-click=$ctrl.openOptionsDialog()><i class="fa fa-ellipsis-v"></i></span></div><div class=task-details-state><jc-pretty-checkbox class=task-details-state-button large=true is-checked=$ctrl.taskCompleted is-disabled=!$ctrl.statusChangeable text="{{ \'task.statusOpen\' | i18next }}" on-toggle=$ctrl.taskStatusChanged></jc-pretty-checkbox><div class=task-details-due-date-assignee><div class=task-details-due-date>{{ \'task.dueOn\' | i18next:{ dueDate: $ctrl.getFormattedDueDate() } }}</div><span class=task-details-assignee ng-click=$ctrl.goToProfile($ctrl.assignee.id)>{{ \'task.assignedTo\' | i18next:{ userName: $ctrl.assignee.name } }}</span></div></div><textarea class=task-details-description rows=5 ng-model=$ctrl.description ng-i18next=[placeholder]task.descriptionPlaceholder ng-blur=$ctrl.saveChangedValues() ng-readonly=!$ctrl.descriptionEditable>\n'+"    </textarea><div class=task-details-author ng-click=$ctrl.goToProfile($ctrl.task.owner.id)>{{ 'task.createdBy' | i18next: { userName: $ctrl.createdBy, createdAt: $ctrl.createdAt} }}</div><div class=task-subtasks ng-if=$ctrl.task.createSubtaskAllowed><span class=task-subtasks-header>{{ 'task.subtasksHeader' | i18next }}</span><tasks filter=$ctrl.taskId class=task-subtasks-list></tasks></div></div><div jc-dialog=$ctrl.showErrorDialog><div class=jc-dialog-text>{{ 'task.errorSavingChanges' | i18next }}</div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.retrySavingChanges()>{{ 'task.retrySavingChanges' | i18next }}</div><div class=jc-dialog-button ng-click=$ctrl.doForceStateChange()>{{ 'task.ignoreErrorAndProceed' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.closeDialog()>{{ 'general.buttonClose' | i18next }}</div></div></div><div jc-dialog=$ctrl.showOptionsDialog><div class=jc-dialog-button-group><div class=jc-dialog-button ng-repeat=\"option in $ctrl.taskOptions\" ng-click=option.action()>{{ option.label | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.closeDialog()>{{ 'general.buttonClose' | i18next }}</div></div></div><div jc-dialog=$ctrl.showDeleteTaskConfirmDialog><div class=jc-loading-dialog-content ng-if=$ctrl.isDeletingTask><div class=\"fa fa-circle-o-notch fa-spin fa-3x jc-dialog-loading-icon\"></div></div><div class=jc-dialog-text>{{ 'task.reallyDeleteTask' | i18next }}</div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.deleteTask()>{{ 'task.deleteTask' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.closeDialog()>{{ 'general.buttonClose' | i18next }}</div></div></div><div jc-dialog=$ctrl.showDatePicker><div jc-date-picker on-date-selected=$ctrl.onDateSelected selected-date=$ctrl.dueDate></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.removeDueDate()>{{ 'task.selectNoDueDate' | i18next }}</div></div><div class=jc-dialog-button-group><div class=jc-dialog-button ng-click=$ctrl.closeDialog()>{{ 'general.buttonClose' | i18next }}</div></div></div>"),$templateCache.put("scripts/task/task-lists/task-lists.html",'<jc-simple-teaser ng-repeat="taskList in $ctrl.taskLists" teaser=taskList style-name=task-list-teaser icon=fa-tasks ng-click=$ctrl.goToList(taskList.id)></jc-simple-teaser><div ng-if="!$ctrl.error && !$ctrl.loading && (!$ctrl.taskLists || $ctrl.taskLists.length < 1)" class=no-content>{{ \'task.noTaskListsAvailable\' | i18next}}</div><div ng-if=$ctrl.error class="no-content text-danger">{{ $ctrl.error | i18next }}</div>'),$templateCache.put("scripts/task/task-title-editor/task-title-editor.html","<form novalidate ng-submit=$ctrl.onSubmit()><input id=task-title-editor class=task-details-title ng-blur=$ctrl.onBlur() ng-focus=$ctrl.onFocus() ng-model=$ctrl.title ng-readonly=!$ctrl.isEditable jc-focus-if=$ctrl.focus></form>"),$templateCache.put("scripts/task/task.root.html",'<div class=sub-view><div ui-view="" autoscroll></div></div>'),$templateCache.put("scripts/task/task/task.html",'<div class="teaser task-teaser" ng-class="{\'task-completed\': $ctrl.checked}" ng-show=$ctrl.teaser><jc-pretty-checkbox class=jc-pretty-checkbox is-checked=$ctrl.checked on-toggle=$ctrl.valueChanged></jc-pretty-checkbox><div class=teaser-text ng-click=$ctrl.showDetails()><div class=teaser-title>{{ $ctrl.teaser.name }}</div></div><i class="task-teaser-go-to-details-icon fa fa-angle-right" ng-click=$ctrl.showDetails()></i></div>'),$templateCache.put("scripts/task/tasks/tasks.html",'<div class=create-task><jc-pretty-checkbox class=jc-pretty-checkbox is-disabled=true></jc-pretty-checkbox><form novalidate method=post ng-submit=$ctrl.createNewTask()><input class=create-task-input placeholder="{{ \'task.createTask\' | i18next }}" ng-model="$ctrl.newTaskName"></form></div><div class=open-tasks><task ng-repeat="task in $ctrl.openTasks" teaser=task></task></div><div ng-if=$ctrl.error class="no-content text-danger">{{ $ctrl.error | i18next }}</div><div ng-if=$ctrl.hasMoreOpenTasks jc-on-scroll-event=jc-fetch-next-open-tasks></div><div class=completed-tasks><div ng-if=$ctrl.hasCompletedTasks ng-click=$ctrl.toggleShowCompletedTasks() class=show-completed-tasks>{{ $ctrl.showCompletedTasks ? \'task.hideCompletedTasks\' : \'task.showCompletedTasks\' | i18next }}</div><task ng-repeat="task in $ctrl.completedTasks" teaser=task ng-show=$ctrl.showCompletedTasks></task><div ng-if="$ctrl.showCompletedTasks && $ctrl.hasMoreCompletedTasks" jc-on-scroll-event=jc-fetch-next-completed-tasks></div></div>'),$templateCache.put("scripts/wrapper/auth/controller/private-cloud-config.html",'<div class="wrapper-public jc-full-page"><div class=wrapper><span class=wrapper-logo></span><form novalidate ng-submit=submit() jc-blur=serverBase jc-blur-event=submit><input type=url jc-novalidate id=serverBase ng-model=serverBase ng-i18next=[placeholder]wrapper.auth.serverBase> <button type=submit ng-i18next=wrapper.auth.nextPrivate></button></form><div class=minor-links><a class=to-help jc-external-ref="{{ ::helpLink }}" ng-i18next=wrapper.auth.helpPrivateCloud></a></div></div><jc-feedback></jc-feedback></div>'),$templateCache.put("scripts/wrapper/common/directive/jc-app-deprecated.html","<div class=jc-app-deprecated ng-if=\"vm.show && !vm.dismissed\"><div class=jc-hero-image></div><div class=\"jc-title jc-typography--headline5\">{{'wrapper.deprecated.title' | i18next}}</div><div class=\"jc-text jc-typography--subtitle1\">{{'wrapper.deprecated.text' | i18next:{context: vm.platform} }}</div><div class=jc-button ng-click=vm.onInstall()>{{'wrapper.deprecated.action' | i18next}}</div><div class=\"jc-secondary-action jc-typography--button\" ng-click=vm.hide()>{{'wrapper.deprecated.secondaryAction' | i18next}}</div></div>"),$templateCache.put("scripts/wrapper/configuration/controller/settings.html","<div class=settings><div class=settings-option><jc-change-platform jc-show-dialog=true jc-to-private-login-key=\"'wrapper.configuration.logoutAndChangePlatform'\"></jc-change-platform></div></div>"),$templateCache.put("scripts/wrapper/configuration/directive/jc-change-platform.html","<div data-ng-click=toggleShowChangePlatformDialog() data-ng-i18next=\"[html]{{usingPrivateCloud\n            ? isAuthenticated\n                ? 'wrapper.configuration.logoutAndChangePlatform'\n                : 'wrapper.configuration.changePlatform'\n            : toPrivateLoginKey}}\"></div><div data-jc-dialog=showChangePlatformDialog><div class=jc-dialog-text>{{ (isAuthenticated ? 'wrapper.configuration.reallyWantToChangePlatformLoggedOut' : 'wrapper.configuration.reallyWantToChangePlatform') | i18next}}</div><div class=jc-dialog-button-group><div class=jc-dialog-button data-ng-click=changePlatform()>{{ 'general.yes' | i18next }}</div><div class=jc-dialog-button data-ng-click=toggleShowChangePlatformDialog()>{{ 'general.no' | i18next }}</div></div></div>"),$templateCache.put("scripts/wrapper/upgrade/controller/upgrade.html",'<div class="wrapper-public jc-full-page"><div class=wrapper><span class=wrapper-logo></span><p class=wrapper-heading data-ng-show="upgradeFailed || appOutdated || !loading" data-ng-i18next="{{ upgradeFailed ? \'wrapper.upgrade.synchronizationFailed\'\n                                             : appOutdated ? \'wrapper.upgrade.appOutdated\'\n                                                           : \'wrapper.upgrade.synchronization\' }}"></p><p class=description data-ng-show="upgradeFailed || appOutdated || !loading" data-ng-i18next="{{ upgradeFailed ? \'wrapper.upgrade.synchronizationFailedDescription\'\n                                             : appOutdated ?\n                                                    isAndroid ? \'wrapper.upgrade.appOutdatedDescriptionAndroid\'\n                                                              : \'wrapper.upgrade.appOutdatedDescriptionIOS\'\n                                                           : \'wrapper.upgrade.synchronizationDescription\' }}"></p><button data-ng-show=upgradeFailed data-ng-click=retry(); data-ng-i18next=wrapper.upgrade.retry></button> <button data-ng-show=appOutdated data-ng-click=openUrl(appStoreLink); data-ng-i18next="{{ isAndroid ? \'wrapper.upgrade.toAppStoreAndroid\' : \'wrapper.upgrade.toAppStoreIOS\' }}"></button><div class=jc-loading-dialog-content ng-show="!upgradeFailed && !appOutdated"><div class="fa fa-circle-o-notch fa-spin fa-3x jc-dialog-loading-icon" ng-show="loading || !upgradeInProgress && checkingForUpdates"></div><jc-progress-bar ng-show="upgradeInProgress && !loading && !checkingForUpdates" progress=progress></jc-progress-bar></div><div class=minor-links data-ng-show="upgradeFailed || appOutdated"><a class=pull-left data-ng-show="appOutdated && isAndroid" data-ng-click=closeApp(); data-ng-i18next=wrapper.common.closeApp></a> <a class=pull-right data-jc-external-ref="{{ ::helpLink }}" data-ng-i18next=wrapper.common.help></a></div></div><jc-change-platform ng-show=upgradeFailed class=change-platform></jc-change-platform><jc-feedback></jc-feedback></div>')}]),angular.module("juco.mobile.account").controller("TermsController",["$rootScope","AccountService","AuthenticationService","i18nextFilter","$sce","destination","loginCode","$location","$state",function($rootScope,AccountService,AuthenticationService,i18nextFilter,$sce,destination,loginCode,$location,$state){function init(){return loginCode?($rootScope.hidePageLoading(),self.acceptTerms=acceptTerms,self.declineTerms=declineTerms,void(self.termsTextSafeHtml=$sce.trustAsHtml(i18nextFilter("terms.termsText")))):void closeTermsPage()}function declineTerms(){AuthenticationService.logout(!1)}function acceptTerms(){$rootScope.showPageLoading(),AccountService.acceptTerms(loginCode).then(closeTermsPage,$rootScope.hidePageLoading)}function closeTermsPage(){var decodedDestination;$rootScope.hidePageLoading(),destination?(decodedDestination=decodeURIComponent(destination).replace(/^#!?/,""),$location.url(decodedDestination)):$state.go("main.start")}var self=this;init()}]),angular.module("juco.mobile.account").service("AccountService",["JucoRestService","REST","CurrentUser",function(JucoRestService,REST,CurrentUser){function getLoginCode(){return JucoRestService.get(REST.account.LOGIN_CODE)}function acceptTerms(loginCode){return JucoRestService.put(REST.account.ACCEPT_TERMS(loginCode)).then(function(updatedCurrentUser){return CurrentUser.updateUserInfo(updatedCurrentUser).then(function(){return updatedCurrentUser})})}this.acceptTerms=acceptTerms,this.getLoginCode=getLoginCode}]),angular.module("juco.mobile.auth").config(["$httpProvider",function($httpProvider){
"ngInject";$httpProvider.interceptors.push(["CurrentUser",function(CurrentUser){return{request:function(config){return CurrentUser.setOAuthHeaderAuthorization(config)}}}])}]),angular.module("juco.controller").controller("LoginController",["$rootScope","AuthenticationService","destination","loginThemeResolved","$location","$state","Environment","PlatformInfoService","i18nextFilter","LOGINPAGES",function($rootScope,AuthenticationService,destination,loginThemeResolved,$location,$state,Environment,PlatformInfoService,i18nextFilter,LOGINPAGES){function init(){$rootScope.hidePageLoading(),self.isCordova=Environment.isCordova(),self.submit=submit,self.showRequestNewPasswordLink=!1,self.showAccountActivationLink=!1,self.showRegistrationLink=!1,self.terms=i18nextFilter("footerPages.terms"),self.privacy=i18nextFilter("footerPages.privacy"),self.imprint=i18nextFilter("footerPages.imprint"),self.help=i18nextFilter("footerPages.help"),self.press=i18nextFilter("footerPages.press"),self.about=i18nextFilter("footerPages.about"),self.articlesOfAssociation=i18nextFilter("footerPages.articlesOfAssociation"),self.loginPages=LOGINPAGES,self.requestNewPasswordUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.REQUEST_NEW_PASSWORD,self.accountActivationUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.REQUEST_ACTIVATION,self.registrationUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.REGISTER,self.termsUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.TERMS,self.privacyUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.PRIVACY,self.imprintUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.IMPRINT,self.helpUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.HELP,self.pressUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.PRESS,self.aboutUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.ABOUT,self.articlesOfAssociationUrl=Environment.getAbsoluteApiContext()+LOGINPAGES.ARTICLES_OF_ASSOCIATION,PlatformInfoService.getPlatformInfo().then(function(platformInfo){self.showRequestNewPasswordLink=platformInfo.requestNewPasswordPossible,self.showAccountActivationLink=platformInfo.accountActivationPossible,self.showRegistrationLink=platformInfo.registrationPossible})}function submit(){function onLogin(){$rootScope.hidePageLoading(),destination?$location.url(decodeURIComponent(destination)):$state.go("main.start")}$rootScope.showPageLoading(),AuthenticationService.login(self.username,self.password).then(onLogin,$rootScope.hidePageLoading)}var self=this;init()}]),function(){function LoginPageLinkController($window,Environment,$element){function init(){self.url&&(Environment.isCordova()?$element.on("click",function(){$window.open(self.url,"_system")}):$element.attr("href",self.url))}var self=this;init()}angular.module("juco.directives").directive("loginPageLink",function(){return{restrict:"A",scope:{url:"=loginPageLink"},controller:"LoginPageLinkController",controllerAs:"loginPageLink",bindToController:!0}}),angular.module("juco.controller").controller("LoginPageLinkController",["$window","Environment","$element",LoginPageLinkController])}(),angular.module("juco.constants").constant("LOGINPAGES",function(){return{TERMS:"/terms",PRIVACY:"/privacy",IMPRINT:"/imprint",HELP:"/help",PRESS:"/press",ABOUT:"/about",ARTICLES_OF_ASSOCIATION:"/articlesOfAssociation",REQUEST_NEW_PASSWORD:"/requestNewPassword",REQUEST_ACTIVATION:"/requestActivation",REGISTER:"/register"}}()),angular.module("juco.mobile.auth").service("AuthenticationApiService",["$http","$q","Environment","REST","RestService",function($http,$q,Environment,REST,RestService){function login(username,password){var data={client_id:Environment.getOAuthClientId(),grant_type:"password",username:username,password:password};return request("POST",REST.oauth.token.BASE,data,!0)}function refreshAccessToken(refreshToken){var data={client_id:Environment.getOAuthClientId(),grant_type:"refresh_token",refresh_token:refreshToken};return request("POST",REST.oauth.token.BASE,data,!0)}function revokeAccessToken(){return RestService["delete"](REST.oauth.token.REVOKE,null,!1,!0)}function getJWT(){return RestService.get(REST.jwt.BASE())}function request(method,path,data,ignoreAuthInterceptor){var encodedData=data?toUrlParam(data):{};return $q(function(resolve,reject){$http({method:method,url:Environment.getAbsoluteOauthApiEndpoint()+"/"+path,headers:{Accept:"application/json","Content-Type":"application/x-www-form-urlencoded; charset=UTF-8"},data:encodedData,ignoreAuthModule:ignoreAuthInterceptor}).success(resolve).error(reject)})}function toUrlParam(data){function toKeyValuePair(key){return encodeURIComponent(key)+"="+encodeURIComponent(data[key])}return Object.keys(data).map(toKeyValuePair).join("&")}this.login=login,this.refreshAccessToken=refreshAccessToken,this.revokeAccessToken=revokeAccessToken,this.getJWT=getJWT}]),angular.module("juco.mobile.auth").service("AuthenticationService",["AuthenticationApiService","$window","$rootScope","$location","EVENTS","CacheFactory","CurrentUser","Environment","$state","OrderedSet","JucoRestService","authService","REST","$q",function(AuthenticationApiService,$window,$rootScope,$location,EVENTS,CacheFactory,CurrentUser,Environment,$state,OrderedSet,JucoRestService,authService,REST,$q){function onAppStart(){$rootScope.$on(EVENTS.onAuthenticationRequired,onAuthenticationRequired),$rootScope.$on(EVENTS.onCurrentUserCreated,onUserLoggedInFromOtherTab),$rootScope.$on(EVENTS.onCurrentUserDeleted,onUserLoggedOutInOtherTab),$rootScope.$on(EVENTS.onCurrentUserSwitched,onUserSwitchedInOtherTab)}function onUserLoggedInFromOtherTab(){broadcastUserAuthenticated()}function onUserLoggedOutInOtherTab(){logout(!1,!0)}function onUserSwitchedInOtherTab(){logout(!1,!0)}function cancelUnauthorizedRequests(){authService.loginCancelled()}function login(username,password){function cancelRequestsAndReject(reason){return cancelUnauthorizedRequests(),$q.reject(reason.info||reason)}return AuthenticationApiService.login(username,password).then(updateAccessToken).then(loadJWTToken).then(cancelUnauthorizedRequests).then(refreshUserInfo)["catch"](cancelRequestsAndReject)}function refreshOAuthAccessTokenWithToken(refreshToken){function clearAuthenticationAndReject(e){return CurrentUser.clearAuthentication(),$q.reject(e.info||e)}return CurrentUser.setTokenRefreshInProgress(!0),AuthenticationApiService.refreshAccessToken(refreshToken).then(updateAccessToken)["catch"](clearAuthenticationAndReject)["finally"](function(){CurrentUser.setTokenRefreshInProgress(!1)})}function updateAccessToken(authData){return CurrentUser.updateToken(authData.access_token,authData.refresh_token,authData.expires_in)}function loadJWTToken(){function resetJWTAndReject(e){return CurrentUser.updateJWTToken(null).then(function(){return $q.reject(e.info||e)})}return AuthenticationApiService.getJWT().then(CurrentUser.updateJWTToken)["catch"](resetJWTAndReject)}function externalLogin(authData){function cancelUnauthorizedRequestsAndReject(e){return cancelUnauthorizedRequests(),$q.reject(e.info||e)}return updateAccessToken(authData).then(refreshUserInfo)["catch"](cancelUnauthorizedRequestsAndReject)}function logout(redirectToCurrentLocationAfterLogin,userChangedInOtherTab){function clearAndLeave(){userChangedInOtherTab||CurrentUser.clearAuthentication(),CacheFactory.clearAll(),$rootScope.$broadcast(EVENTS.onUserDeauthenticated,null),goToLoginPage(redirectToCurrentLocationAfterLogin,userChangedInOtherTab)}function immediateLogout(){userChangedInOtherTab||!CurrentUser.getAccessToken()||Environment.isJustSocialNative()&&Environment.isIos()?clearAndLeave():AuthenticationApiService.revokeAccessToken()["finally"](clearAndLeave)}function delayedLogout(){handlerCount--,handlerCount<=0&&immediateLogout()}var handlers=beforeLogoutHandlers.entries(),handlerCount=handlers.length;handlerCount<=0?immediateLogout():handlers.forEach(function(handler){handler()["finally"](delayedLogout)})}function goToLoginPage(redirectToCurrentLocation,forceReload){function getTargetLoginStateName(){return $state.is(juco.baseStates.EXTERNAL_LOGIN)?juco.baseStates.EXTERNAL_LOGIN:Environment.getConfigState().loginState}function refreshAll(){forceReload&&!Environment.isCordova()&&$window.location.reload()}var targetState=getTargetLoginStateName(),redirectRequired=redirectToCurrentLocation&&"/"!==$location.path(),params=redirectRequired?{destination:encodeURIComponent($location.url())}:{};$state.go(targetState,params)["finally"](refreshAll)}function onAuthenticationRequired(event,error){function isAccessTokenExpired(e){var errorJson=(angular.toJson(e||"")||"").toLowerCase();return errorJson.indexOf("invalid_token")>-1&&errorJson.indexOf("access token")>-1}function succeedRefresh(){return authService.loginConfirmed(),refreshUserInfo()}function cancelRefreshAndLogout(){cancelUnauthorizedRequests(),logout(!0)}var refreshToken=CurrentUser.getRefreshToken();if(!isAccessTokenExpired(error)||!refreshToken)return cancelRefreshAndLogout();var refreshInProgress=CurrentUser.isTokenRefreshInProgress();return refreshInProgress?void 0:refreshOAuthAccessTokenWithToken(refreshToken).then(succeedRefresh)["catch"](cancelRefreshAndLogout)}function userInfoChanged(updatedUserInfo){return!angular.equals(CurrentUser.getAuthenticatedUserInfo(),updatedUserInfo)}function refreshUserInfo(forceUpdate){function onUserInfoLoaded(updatedUserInfo){return forceUpdate||userInfoChanged(updatedUserInfo)?CurrentUser.updateUserInfo(updatedUserInfo).then(broadcastUserAuthenticated).then(function(){return updatedUserInfo}):updatedUserInfo}return JucoRestService.get(REST.person.CURRENT).then(onUserInfoLoaded)}function forceRefreshUserInfo(){refreshUserInfo(!0)}function broadcastUserAuthenticated(){$rootScope.$broadcast(EVENTS.onUserAuthenticated,CurrentUser.getAuthenticatedUserInfo())}function addBeforeLogoutHandler(handler){beforeLogoutHandlers.add(handler)}function authenticate(){return CurrentUser.setAuthStateFromStorage().then(function(isAuthenticated){return isAuthenticated?loadJWTToken().then(forceRefreshUserInfo).then(function(){return isAuthenticated}):(logout(!Environment.isCordova()),$q.reject("unauthenticated"))})}var beforeLogoutHandlers=new OrderedSet;this.onAppStart=onAppStart,this.goToLoginPage=goToLoginPage,this.login=login,this.logout=logout,this.addBeforeLogoutHandler=addBeforeLogoutHandler,this.externalLogin=externalLogin,this.authenticate=authenticate,this.loadJWTToken=loadJWTToken}]),angular.module("juco.controller").controller("ExternalLoginController",["$rootScope","AuthenticationService","$stateParams","$state",function($rootScope,AuthenticationService,$stateParams,$state){function init(){$rootScope.showPageLoading();var authData={access_token:$stateParams.access_token,refresh_token:$stateParams.refresh_token,expires_in:$stateParams.expires_in};AuthenticationService.externalLogin(authData).then(goToStartPage,goToStartPage)}function goToStartPage(){$rootScope.hidePageLoading(),$state.go("main.start")}init()}]),angular.module("juco.controller").controller("ErrorController",["$scope","$rootScope","EVENTS","errorCode",function($scope,$rootScope,EVENTS,errorCode){function init(){$scope.errorCode=errorCode,$scope.errorMessage=$rootScope.errorPageErrorMessage,delete $rootScope.errorPageErrorMessage,$scope.errorMessage&&$rootScope.$broadcast(EVENTS.onFeedback,$scope.errorMessage)}init()}]),angular.module("juco.controller").controller("FatalController",["$scope","messageKey",function($scope,messageKey){var init=function(){$scope.messageKey=messageKey};init()}]),angular.module("juco.controller").controller("MainController",["$scope","$rootScope","$state","$window","$timeout","EVENTS","UpdatesService","ConfigurationService","StateUtil","CurrentUser","Environment","HtmlUtil",function($scope,$rootScope,$state,$window,$timeout,EVENTS,UpdatesService,ConfigurationService,StateUtil,CurrentUser,Environment,HtmlUtil){function init(){$scope.hasHistoryBack=StateUtil.hasPreviousState(),$scope.showBackButtonByDefault=Environment.isIos(),$scope.scrollDetection=void 0,$scope.$back=back,$scope.toggleNotifications=toggleNotifications,initAuthentication(),$scope.isAuthenticated&&UpdatesService.forceUpdate(),$scope.$on(EVENTS.onBackButtonUpdate,onBackButtonUpdate),$scope.$on(EVENTS.onHeaderTitleChanged,onHeaderTitleChanged),$scope.$on(EVENTS.onUserAuthenticated,onUserAuthenticated),$scope.$on(EVENTS.onUserDeauthenticated,onUserDeauthenticated),$scope.$watch(function(){return StateUtil.hasPreviousState()},function(hasPreviousState){$scope.hasHistoryBack=hasPreviousState}),initScrollDetection()}function initScrollDetection(){var noScrollDetection=Environment.isCordova()&&Environment.isIos();noScrollDetection||($scope.scrollDetection={scrolled:!1},angular.element($window).on("scroll",function(){var previouslyScrolled=$scope.scrollDetection.scrolled;$scope.scrollDetection.scrolled=$window.scrollY>5,previouslyScrolled!==$scope.scrollDetection.scrolled&&$scope.$apply()}))}function onUserAuthenticated(event,userInfo){$scope.currentUser=userInfo,$scope.isAuthenticated=!0}function onUserDeauthenticated(){$scope.isAuthenticated=!1,$scope.currentUser=void 0}function onBackButtonUpdate(event,showBackButton){$rootScope.header.backButton=showBackButton}function onHeaderTitleChanged(event,newHeaderTitle){$timeout(function(){newHeaderTitle.translate?($rootScope.header.titleTranslate=!0,$rootScope.header.titleKey=newHeaderTitle.key,$rootScope.header.titleContext=newHeaderTitle.context,$rootScope.header.titleValue=void 0):($rootScope.header.titleTranslate=!1,$rootScope.header.titleKey=void 0,$rootScope.header.titleContext=void 0,$rootScope.header.titleValue=newHeaderTitle.emojify?HtmlUtil.escapeAndEmojifyHtml(newHeaderTitle.value):HtmlUtil.escapeHtml(newHeaderTitle.value))})}function initAuthentication(){$scope.currentUser=CurrentUser.getAuthenticatedUserInfo(),$scope.currentUser&&ConfigurationService.isChatEnabled().then(function(enabled){$scope.chatEnabled=enabled}),$scope.isAuthenticated=CurrentUser.isAuthenticated()}function back(){$window.history.back()}function toggleNotifications(){$state.is("main.notification-center")?$window.history.back():$state.go("main.notification-center")}init()}]),angular.module("juco.mobile.common").controller("MainNavigationController",["$rootScope","$scope","$state","Environment","EVENTS","AuthenticationService","ConfigurationService","PlatformInfoService","searchPageCache","CurrentUser",function($rootScope,$scope,$state,Environment,EVENTS,AuthenticationService,ConfigurationService,PlatformInfoService,searchPageCache,CurrentUser){function init(){self.isCordova=Environment.isCordova(),self.driveAvailable=!1,self.taskAvailable=!1,self.peopleAvailable=!1,self.searchQuery="",self.logout=logout,self.doSearch=doSearch,self.clearSearchQuery=clearSearchQuery,self.goToProfile=goToProfile,self.goToMyDrives=goToMyDrives,self.goToMyAssignedTasks=goToMyAssignedTasks,self.goToMyCreatedTasks=goToMyCreatedTasks,self.goToMyTaskLists=goToMyTaskLists,self.goToSettings=goToSettings,self.goToDownloads=goToDownloads,self.goToAllUsers=goToAllUsers,self.currentUserInfo=CurrentUser.getAuthenticatedUserInfo(),ConfigurationService.getConfiguration().then(function(config){self.menuLinks=config.menuConfig.menuLinks}),checkAvailableFeatures(),$scope.$on(EVENTS.onUserAuthenticated,function(_,userInfo){self.currentUserInfo=userInfo}),$scope.$on(EVENTS.onUserDeauthenticated,function(){self.currentUserInfo=void 0})}function checkAvailableFeatures(){isTaskAvailable().then(function(available){self.taskAvailable=available}),isPeopleAvailable().then(function(available){self.peopleAvailable=available}),isDriveAvailable().then(function(available){self.driveAvailable=available})}function isTaskAvailable(){return PlatformInfoService.isTaskAvailable()}function isPeopleAvailable(){return PlatformInfoService.isPeopleAvailable()}function isDriveAvailable(){return PlatformInfoService.isDriveAvailable()}function logout(){AuthenticationService.logout(!1)}function doSearch(){searchPageCache.clear(),$rootScope.toggleMenu(),$state.go("main.search",{query:self.searchQuery})}function clearSearchQuery(){self.searchQuery=""}function goToProfile(){goToState("main.profile",{profileId:self.currentUserInfo.id},{reload:!0})}function goToMyDrives(){goToState("main.myDrives")}function goToMyAssignedTasks(){goToState("main.task.assignedToMe")}function goToMyCreatedTasks(){goToState("main.task.createdByMe")}function goToMyTaskLists(){goToState("main.task.myLists")}function goToSettings(){goToState("main.settings")}function goToDownloads(){goToState("main.downloads")}function goToAllUsers(){goToState("main.people")}function goToState(name,params,options){$state.go(name,params,options),$rootScope.toggleMenu()}var self=this;init()}]),angular.module("juco.controller").controller("RedirectController",["UrlTokenResolver","token","resolvedToken",function(UrlTokenResolver,token,resolvedToken){"ngInject";UrlTokenResolver.handleToken(token,resolvedToken,!0)}]),angular.module("juco.mobile.common").directive("jcAdjustMinHeight",["$document","DomUtil","$window",function($document,DomUtil,$window){var link=function(scope,element){function setSize(){var minHeight,minHeightPx,mainContent=$document[0].getElementById("main-content"),header=$document[0].getElementById("header");mainContent&&header&&(minHeight=DomUtil.getWindowHeight()-header.offsetHeight,scope.addSize&&(minHeight+=scope.addSize),minHeightPx=minHeight.toString()+"px",mainContent.style.minHeight=minHeightPx,element[0].style.minHeight=minHeightPx)}var w=angular.element($window);w.bind("resize",setSize),scope.$on("$destroy",function(){w.unbind("resize",setSize)}),setSize()};return{restrict:"A",link:link,scope:{addSize:"=?jcAdjustMinHeight"}}}]),function(){angular.module("juco.mobile.common").directive("jcAutoHideSnackbar",function(){return{templateUrl:"scripts/common/directive/jc-auto-hide-snackbar.html",restrict:"E",scope:{},controller:"AutoHideSnackbarController",controllerAs:"vm",bindToController:!0}}).controller("AutoHideSnackbarController",["$scope","EVENTS","CONFIG","$timeout",function($scope,EVENTS,CONFIG,$timeout){function init(){self.showSnackbar=!1,$scope.$on(EVENTS.onShowAutoHideSnackbar,onShowSnackbar)}function onShowSnackbar(event,data){showSnackbarTimer&&$timeout.cancel(showSnackbarTimer),self.showSnackbar?(self.showSnackbar=!1,showSnackbarTimer=$timeout(function(){showSnackbar(data)},350)):showSnackbar(data)}function showSnackbar(snackbarData){self.additionalCssClass=snackbarData.additionalCssClass,self.messageKey=snackbarData.messageKey,self.actionLabelKey=snackbarData.actionLabelKey,self.onDoAction=function(){"function"==typeof snackbarData.action&&snackbarData.action(),self.showSnackbar=!1},self.showSnackbar=!0,startAutoHideTimer()}function startAutoHideTimer(){autoHideTimer&&$timeout.cancel(autoHideTimer),autoHideTimer=$timeout(function(){self.showSnackbar=!1},CONFIG.autoHideSnackbarDisplayInterval)}var self=this,autoHideTimer=null,showSnackbarTimer=null;init()}])}(),angular.module("juco.directives").directive("jcBlur",["$window",function($window){var handler=function(id){return function(){$window.document.getElementById(id).blur()}},linker=function(scope,element,attrs){var elementIds=attrs.jcBlur.split(",");elementIds.forEach(function(id){element.on(attrs.jcBlurEvent,handler(id.trim()))})};return{restrict:"A",link:linker,priority:-1}}]),angular.module("juco.directives").directive("jcBlurOnEvent",[function(){var linker=function(scope,element,attrs){scope.$on(attrs.jcBlurOnEvent,function(){element[0].blur()})};return{restrict:"A",link:linker,priority:-1}}]),angular.module("juco.mobile.common").directive("jcFeedback",["$rootScope","EVENTS","$timeout","CONFIG",function($rootScope,EVENTS,$timeout,CONFIG){function removeMessage(message){var index=messages.indexOf(message);message.__timer&&($timeout.cancel(message.__timer),message.__timer=void 0),messages.splice(index,1)}function removeDuplicates(newMessage){messages.forEach(function(message){newMessage.message===message.message&&removeMessage(message)})}function handleFeedback(event,messageObject){messageObject&&(removeDuplicates(messageObject),messages.unshift(messageObject),messageObject.__timer=$timeout(function(){removeMessage(messageObject)},CONFIG.errorMessageDisplayInterval))}function handleStateChange(){messages.forEach(function(message){removeMessage(message)}),messages.length=0}function linker(scope){scope.messages=messages,scope.removeMessage=removeMessage,$rootScope.$on(EVENTS.onFeedback,handleFeedback),$rootScope.$on(EVENTS.onStateChangeStart,handleStateChange)}var messages=[];return{restrict:"E",scope:!0,link:linker,templateUrl:"scripts/common/directive/jc-feedback.html"}}]),angular.module("juco.mobile.common").directive("jcFetchMore",[function(){function link(scope){scope.$on("jc-scrolled-to-bottom",scope.fetchFn)}return{link:link,template:'<div class="center-block-padded"><i class="fa fa-circle-o-notch fa-spin fa-2x" ng-show="showLoading"></i></div>',scope:{fetchFn:"=jcFetchMore",showLoading:"="}}}]),angular.module("juco.mobile.common").directive("jcHtmlLinkRewrite",["$sce","$parse","LinkUtil",function($sce,$parse,LinkUtil){function link(scope,element,attributes){function getStringValue(){return(parsed(scope)||"").toString()}var parsed=$parse(attributes.jcHtmlLinkRewrite),doRewriteAnchor=angular.isDefined(attributes.jcRewriteAnchor),additionalLinkClass=attributes.jcAdditionalLinkClass;scope.$watch(getStringValue,function(){element.html($sce.getTrustedHtml(parsed(scope))||""),LinkUtil.rewriteLinks(element[0],doRewriteAnchor,additionalLinkClass)})}return{compile:function(){return link}}}]),angular.module("juco.mobile.common").directive("jcInnerScrolling",["$rootScope","DomUtil",function($rootScope,DomUtil){return{restrict:"A",link:function($scope,$elem){function onScrollHandler(event){event.stopPropagation(),DomUtil.isScrolledToBottom($elem[0])&&$rootScope.$broadcast("jc-scrolled-to-bottom")}function reset(){$elem.off("scroll",onScrollHandler),main.removeClass("page-no-scrolling")}$elem.addClass("inner-scrollable");var main=angular.element(document.querySelector("#main-content"));main.addClass("page-no-scrolling"),$elem.on("scroll",onScrollHandler),$scope.$on("$destroy",reset)}}}]),angular.module("juco.directives").directive("jcNovalidate",[function(){var linker=function(scope,element,attrs,ctrl){ctrl.$parsers.length=0,ctrl.$formatters.length=0,ctrl.$validators={}};return{restrict:"A",link:linker,require:"ngModel",priority:1}}]),angular.module("juco.directives").value("jcOnScrollEvents",{}).directive("jcOnScrollEvent",["$window","$log","$rootScope","jcOnScrollEvents","DomUtil",function($window,$log,$rootScope,jcOnScrollEvents,DomUtil){var link=function(scope){var onScrollHandler=("top"===scope.direction?onScrollTopHandler:onScrollBottomHandler).bind(null,scope);return scope.eventName?(scope.spinnerVisible=!1,Object.keys(jcOnScrollEvents).length||angular.element($window).on("scroll",onScrollHandler),registerEvent(scope.eventName),void scope.$on("$destroy",function(){unregisterEvent(scope.eventName),Object.keys(jcOnScrollEvents).length||angular.element($window).off("scroll",onScrollHandler)})):void $log.error("Missing event name for directive jcOnScrollEvent")},onScrollBottomHandler=function(scope){DomUtil.getScrollHeight()+1.5*DomUtil.getWindowHeight()>=DomUtil.getDocumentHeight()?(broadcastEvents(),scope.spinnerVisible=!0):scope.spinnerVisible=!1},onScrollTopHandler=function(scope){DomUtil.getScrollHeight()<DomUtil.getWindowHeight()/2?(broadcastEvents(),scope.spinnerVisible=!0):scope.spinnerVisible=!1},broadcastEvents=function(){Object.keys(jcOnScrollEvents).forEach(function(eventName){$rootScope.$broadcast(eventName)})},registerEvent=function(eventName){jcOnScrollEvents.hasOwnProperty(eventName)?jcOnScrollEvents[eventName]+=1:jcOnScrollEvents[eventName]=1},unregisterEvent=function(eventName){jcOnScrollEvents.hasOwnProperty(eventName)&&(1===jcOnScrollEvents[eventName]?delete jcOnScrollEvents[eventName]:jcOnScrollEvents[eventName]-=1)};return{link:link,template:'<div class="center-block-padded"><i class="fa fa-circle-o-notch fa-spin fa-2x" data-ng-show="spinnerVisible"></i></div>',scope:{eventName:"@jcOnScrollEvent",direction:"@?jcOnScrollDirection"}}}]),angular.module("juco.mobile.common").directive("jcSecuredImage",function(){return{restrict:"E",scope:{src:"@"},templateUrl:"scripts/common/directive/jc-secured-image.html",controller:"JcSecuredImageController",controllerAs:"vm",bindToController:!0}}),angular.module("juco.mobile.common").controller("JcSecuredImageController",JcSecuredImageController),angular.module("juco.mobile.common").directive("jcSelectFile",["Environment","PictureService","FileService","$window","$document","UUID","VersionUtil",function(Environment,PictureService,FileService,$window,$document,UUID,VersionUtil){function link(scope,element){function clickHandler(event){var inputElement=$document[0].getElementById(id);event.target!==inputElement&&(usePictureService?PictureService.getPicture(!scope.capture,function(result){var file=FileService.b64ToBlob(result,"image/jpeg");file.name="image.jpeg",scope.onFileSelect([file])}):inputElement.click())}var id=UUID.generate();scope.inputId=id,setFileUploadSettings(scope),element.on("click",clickHandler)}function setFileUploadSettings(scope){var android442VersionRegExp=/Android 4\.4\.2/,userAgent=navigator.userAgent||navigator.vendor,isAndroid442Mobile=android442VersionRegExp.test(userAgent),isAndroid442Wrapper=Environment.isCordova()&&Environment.isAndroid()&&"4.4.2"===$window.device.version;scope.multiple=scope.jcMultiple&&!isAndroid442Wrapper,scope.accept=scope.imagesOnly||isAndroid442Mobile?"image/*":"*/*",usePictureService=Environment.isCordova()&&(!Environment.isAndroid()||VersionUtil.compare($window.device.version,"4.4")>=0)}var usePictureService=!1;return{link:link,restrict:"E",templateUrl:"scripts/common/directive/jc-select-file.html",scope:{capture:"=jcCapture",jcMultiple:"=",imagesOnly:"=?",onFileSelect:"=",icon:"@"}}}]),angular.module("juco.mobile.common").directive("jcSimpleTeaser",function(){return{restrict:"E",scope:{teaser:"=",styleName:"@",icon:"@"},templateUrl:"scripts/common/directive/jc-simple-teaser.html"}}),angular.module("juco.mobile.common").directive("jcTypedValue",["regExpUtil","urlUtil","ArrayUtil","HtmlUtil",function(regExpUtil,urlUtil,ArrayUtil,HtmlUtil){function split(string){for(var values=[],match=multiValueSeparator.exec(string);""!==match[0];)values.push({value:match[2],separator:match[1]}),match=multiValueSeparator.exec(string);return multiValueSeparator.lastIndex=0,values}function createValue(value,separator){var trimmed=value.trim(),type=regExpUtil.checkForValueType(trimmed);return{separator:separator||"",type:type,value:type===regExpUtil.valueType.NONE?HtmlUtil.escapeAndLinkify(trimmed):value}}function linker(scope){scope.values=[],scope.value&&(ArrayUtil.containsSome(scope.value,separators)?scope.values=split(scope.value).map(function(splitValue){return createValue(splitValue.value,splitValue.separator)}):scope.values=[createValue(scope.value)])}var separators=[";",",","\n","\r"],multiValueSeparator=/(\s*[;,\n\r]*\s*)([^;,\n\r]*)/g;return{restrict:"A",scope:{value:"=jcTypedValue"},link:linker,templateUrl:"scripts/common/directive/jc-typed-value.html"}}]),angular.module("juco.mobile.common").directive("jcUnreadCount",[function(){return{template:'<div ng-show="count > 0" class="jc-mobile-unread-count">{{count | jcUnreadCount}}</div>',restrict:"E",scope:{count:"="}}}]),angular.module("juco.filters").filter("jcFromNow",["$window",function($window){return function(dateString){return $window.moment.locale($window.i18n.lng()),$window.moment(dateString).fromNow()}}]),angular.module("juco.filters").filter("jcMaxNumber",[function(){return function(number,largestNumber){return number<=largestNumber?number:largestNumber+"+"}}]),angular.module("juco.mobile.common").filter("jcNewDayMarker",["$i18next","$window",function($i18next,$window){return function(date){var today=$i18next("date.today"),yesterday=$i18next("date.yesterday"),last=$i18next("date.last");return $window.moment(date).calendar(null,{sameDay:"["+today+"]",lastDay:"["+yesterday+"]",lastWeek:"["+last+"] dddd",sameElse:"dddd, L"})}}]),angular.module("juco.filters").filter("jcOrigin",["i18nextFilter","ResourceType","IdUtil",function(i18nextFilter,ResourceType,IdUtil){var ORIGIN_TRANSLATION_BASE="origin.";return function(originName,originId,author){var resourceType=IdUtil.getResourceType(originId);return resourceType===ResourceType.PROFILE?originId===author.id||originName?i18nextFilter(ORIGIN_TRANSLATION_BASE+"originOwnProfile"):originName?i18nextFilter(ORIGIN_TRANSLATION_BASE+"originOtherProfile",{origin:originName}):i18nextFilter(ORIGIN_TRANSLATION_BASE+"originUnknownProfile"):originName?i18nextFilter(ORIGIN_TRANSLATION_BASE+"originGeneric",{origin:originName}):i18nextFilter(ORIGIN_TRANSLATION_BASE+"originUnknown")}}]),angular.module("juco.filters").filter("jcRemoveProtocol",["urlUtil",function(urlUtil){return function(url){return url?urlUtil.removeProtocol(url):null}}]),angular.module("juco.constants").constant("ENUMS",function(){return{staticAction:{CREATE:"CREATE",LIKE:"LIKE",UNLIKE:"UNLIKE",COMMENT:"COMMENT",DELETE:"DELETE",EDIT:"EDIT"},sortType:{RELEVANCE:"RELEVANCE",ACTIVITY:"ACTIVITY",ALPHABETICAL:"ALPHABETICAL",TIME_ASCENDING:"TIME_ASCENDING",TIME_DESCENDING:"TIME_DESCENDING",PUBLICATION_DATE:"PUBLICATION_DATE"},durationFilter:{ALL:"ALL",PAST:"PAST",FUTURE:"FUTURE"},menuLinkType:{STATIC:"STATIC",CUSTOM:"CUSTOM",MY_CONTENT_MOBILE:"MY_CONTENT_MOBILE",ALL_ENTITIES_MOBILE:"ALL_ENTITIES_MOBILE",HEADLINE:"HEADLINE"},staticMenuLinkType:{PROFILE:{name:"PROFILE",state:"main.profile",key:"mainNavigation.myProfile"},CONTACTS:{name:"CONTACTS",state:"main.myContact",key:"mainNavigation.myContacts"},MY_CONTENT:{name:"MY_CONTENT",state:"main.myContent",key:"mainNavigation.myContent"},MY_DOCUMENTS:{name:"MY_DOCUMENTS",state:"main.myDocument",key:"mainNavigation.myDocuments"}},searchFilterType:{PROFILE:"PROFILE",ENTITY:"ENTITY",DOCUMENT:"DOCUMENT",WORKSTREAM_MESSAGE:"WORKSTREAM_MESSAGE",NEWSBLOG:"NEWSBLOG"}}}()),angular.module("juco.mobile.configuration").constant("STATES",function(){return angular.extend({},juco.baseStates,{CHAT_CONVERSATION:"chat.conversation"})}()),angular.module("juco.mobile.common").constant("SupportLink",{HELP_UPGRADE:"https://www.just.social/cloud-help/upgrade-help",HELP_LOGIN:"https://www.just.social/cloud-help/login-help",APP_STORE_ANDROID:"market://details?id=de.justsoftware.mobile.just",APP_STORE_IOS:"https://itunes.apple.com/de/app/id997654609?mt=8"}),angular.module("juco.mobile.common").service("AppConfigurationService",["$q","$http","Environment","Cache",function($q,$http,Environment,Cache){"ngInject";function getCached(url,key,mappingFn){var fromCache=appConfigCache.get(key);if(fromCache)return $q(function(resolve){resolve(fromCache)});var req={methode:"GET",url:url};return $q(function(resolve,reject){$http(req).success(function(data){var mappedData=mappingFn?data.map(mappingFn):data;appConfigCache.put(key,mappedData),resolve(mappedData)}).error(function(info,status){reject({info:info,status:status})})})}function getAppConfiguration(){var key="APP_CONFIG",url=Environment.getAbsoluteContextApiEndpoint()+"/appConfig/availableApps";return getCached(url,key)}function getEntityTypesForApp(appId){var url=Environment.getAbsoluteContextApiEndpoint()+"/entityTypeAppMapping/"+appId;return getCached(url,appId,function(entityType){return entityType.name})}var appConfigCache=Cache.createCache("appConfigCache");this.getAppConfiguration=getAppConfiguration,this.getEntityTypesForApp=getEntityTypesForApp}]),angular.module("juco.mobile.common").service("CurrentUser",["$rootScope","$window","$log","EVENTS","StorageService","Environment","PromiseUtil",function($rootScope,$window,$log,EVENTS,StorageService,Environment,PromiseUtil){function init(){Environment.isCordova()||$window.addEventListener("storage",onStorageEvent)}function toStoredValue(value){return angular.toJson(value);
}function fromStoredValue(jsonValue){return angular.fromJson(jsonValue)}function onStorageEvent(event){event&&event.key===storageKey&&event.oldValue!==event.newValue&&setAuthStateFromStorage().then(function(){analyzeAndPropagateExternalChange(fromStoredValue(event.oldValue),fromStoredValue(event.newValue))})}function analyzeAndPropagateExternalChange(oldValue,newValue){var oldUserId=oldValue&&oldValue.userInfo?oldValue.userInfo.id:void 0,newUserId=newValue&&newValue.userInfo?newValue.userInfo.id:void 0;oldUserId===newUserId?oldUserId&&newUserId&&!angular.equals(oldValue.userInfo,newValue.userInfo)&&$rootScope.$broadcast(EVENTS.onCurrentUserUpdated,{oldValue:oldValue.userInfo,newValue:newValue.userInfo}):oldUserId?newUserId?$rootScope.$broadcast(EVENTS.onCurrentUserSwitched,{oldValue:oldUserId,newValue:newUserId}):$rootScope.$broadcast(EVENTS.onCurrentUserDeleted,oldUserId):$rootScope.$broadcast(EVENTS.onCurrentUserCreated,newUserId)}function createLogoutState(){return{accessToken:null,refreshToken:null,expiresAt:getCurrentTimestamp(),jwtToken:null}}function updateAuthState(updateFn){if(authState=updateFn(authState||createLogoutState()),StorageService.isStorageAvailable())try{return StorageService.setItem(AUTH_STATE_KEY,toStoredValue(authState))}catch(e){$log.error("error persisting auth state to local storage",e)}return PromiseUtil.immediateResolve(authState)}function loadAuthState(){return StorageService.isStorageAvailable()?StorageService.getItem(AUTH_STATE_KEY).then(function(authStateJSONString){return fromStoredValue(authStateJSONString)||createLogoutState()},function(err){return $log.error("error loading auth state from local storage",err),PromiseUtil.immediateReject()}):PromiseUtil.immediateResolve(createLogoutState())}function updateUserInfo(userInfo){return updateAuthState(function(authState){return authState.userInfo=userInfo,authState})}function updateJWTToken(token){return updateAuthState(function(authState){return authState.jwtToken=token,authState})}function updateToken(accessToken,refreshToken,expiresIn){return updateAuthState(function(authState){return authState.accessToken=accessToken,authState.refreshToken=refreshToken,authState.expiresAt=getExpiryTimestamp(expiresIn),authState})}function isAuthenticated(){return!!authState&&!!authState.accessToken}function getAuthenticatedUserInfo(){return isAuthenticated()?authState.userInfo:null}function clearAuthentication(){return updateAuthState(createLogoutState)}function getAccessToken(){return authState?authState.accessToken:null}function getRefreshToken(){return authState?authState.refreshToken:null}function getId(){var authUserInfo=getAuthenticatedUserInfo();return authUserInfo?authUserInfo.id:void 0}function getRawId(){var id=getId();return id?0!==id.indexOf("PROFILE,")?id:id.substring("PROFILE,".length):id}function getCurrentTimestamp(){var now=new Date,utc=Date.UTC(now.getFullYear(),now.getMonth(),now.getDate(),now.getHours(),now.getMinutes(),now.getSeconds(),now.getMilliseconds());return new Date(utc).getTime()}function getExpiryTimestamp(validForSeconds){return getCurrentTimestamp()+1e3*validForSeconds}function isTokenRefreshInProgress(){return tokenRefreshTimeout&&tokenRefreshTimeout>getCurrentTimestamp()}function setTokenRefreshInProgress(value){tokenRefreshTimeout=value?getExpiryTimestamp(120):void 0}function setOAuthHeaderAuthorization(config){var augmentRequest=function(){var accessToken=getAccessToken(),auth=accessToken?"Bearer "+accessToken:void 0;return config&&auth&&(config.headers=angular.extend({},config.headers,{Authorization:auth})),PromiseUtil.immediateResolve(config)};return isAuthenticated()?augmentRequest():setAuthStateFromStorage().then(augmentRequest)}function getJWTToken(){return authState&&authState.jwtToken}function setJWTHeaderAuthorization(config){var jwtToken=getJWTToken();return config&&jwtToken&&(config.headers?config.headers["just-token"]=jwtToken:config.headers={"just-token":jwtToken}),config}function setAuthStateFromStorage(){return loadAuthState().then(function(newAuthState){return authState=newAuthState,isAuthenticated()})}var AUTH_STATE_KEY="authState",storageKey=StorageService.getStorageKey(AUTH_STATE_KEY),tokenRefreshTimeout=void 0,authState=createLogoutState();init(),this.updateUserInfo=updateUserInfo,this.updateToken=updateToken,this.updateJWTToken=updateJWTToken,this.isAuthenticated=isAuthenticated,this.getAuthenticatedUserInfo=getAuthenticatedUserInfo,this.clearAuthentication=clearAuthentication,this.getAccessToken=getAccessToken,this.getRefreshToken=getRefreshToken,this.getJWTToken=getJWTToken,this.getId=getId,this.getRawId=getRawId,this.isTokenRefreshInProgress=isTokenRefreshInProgress,this.setTokenRefreshInProgress=setTokenRefreshInProgress,this.setOAuthHeaderAuthorization=setOAuthHeaderAuthorization,this.setJWTHeaderAuthorization=setJWTHeaderAuthorization,this.setAuthStateFromStorage=setAuthStateFromStorage}]),angular.module("juco.error").config(["$provide","$httpProvider",function($provide,$httpProvider){$httpProvider.interceptors.push(["$q","$injector",function($q,$injector){return{responseError:function(response){var config=response.config||{};return config.bypassErrorInterceptor||$injector.get("ErrorHandler").handleServerError(response.data,response.status),$q.reject(response)}}}])}]).service("ErrorHandler",["$rootScope","EVENTS","$state","MessageHandler","Environment","CommonErrorHandler","ERROR",function($rootScope,EVENTS,$state,MessageHandler,Environment,CommonErrorHandler,ERROR){function onAppStart(){$rootScope.$on(EVENTS.onError,handleErrorEvent)}function showErrorPage(errorCode,data){$rootScope.errorPageErrorMessage=MessageHandler.createErrorMessage(MessageHandler.getErrorMessageKey(data)),$state.go("main.error",{errorCode:errorCode},{location:"replace",inherit:!1})}function broadcastError(data){MessageHandler.error(MessageHandler.getErrorMessageKey(data))}function handleServerError(data,status){switch(status){case 403:case 401:break;case 0:broadcastError(CONNECTION_ERROR);break;case 404:Environment.isCordova()?broadcastError(CONNECTION_ERROR):showErrorPage(status,data);break;default:broadcastError(data)}}function handleErrorEvent(event,error){switch(error.type){case ERROR.CHAT.CHAT_UNAVAILABLE:CommonErrorHandler.handleError(error,"chat.chatUnavailable");break;case ERROR.CHAT.JABBER_ERROR:CommonErrorHandler.handleJabberError(error,"chat.chatUnavailable");break;case ERROR.CHAT.JABBER_MESSAGE_ERROR:CommonErrorHandler.handleJabberMessageError(error,"chat.failedToSentMessage");break;case ERROR.CHAT.UNEXPECTED_CHAT_ERROR:CommonErrorHandler.handleJabberError(error,"chat.unexpectedChatError")}}var CONNECTION_ERROR={error:"noConnectionToServer"};this.onAppStart=onAppStart,this.handleServerError=handleServerError,this.showErrorPage=showErrorPage}]),angular.module("juco.mobile.common").service("FileService",["$q","$interval","$log",function($q,$interval,$log){"ngInject";function isImage(file){if(!file)return!1;var mimeType=file.mimeType||file.type;return file.size>0&&(mimeType&&"image/"===mimeType.substr(0,6)||file.name&&file.name.match(/\.(jpe?g|png|gif)$/i))}function toAttachment(data){return data instanceof Blob?createAttachmentFromBlob(data):createAttachmentFromB64(data)}function createAttachmentFromBlob(blob){return $q(function(resolve){var fr=new FileReader;fr.onloadend=function(){resolve({filename:blob.name||"camera.jpeg",data:stripContentTypeFromB64(fr.result),type:blob.type,size:blob.size})},fr.readAsDataURL(blob)})}function createAttachmentFromB64(data){return $q.resolve({filename:"camera.jpeg",data:stripContentTypeFromB64(data),type:"image/jpeg",size:calculateB64Size(data)})}function calculateB64Size(b64){return(b64.length-814)/1.37}function blobToB64(blob){return $q(function(resolve){var reader=new FileReader;reader.onloadend=function(event){resolve(addContentTypeToB64(event.target.result,null))},reader.readAsDataURL(blob)})}function addContentTypeToB64(b64,contentType){return contentType=contentType||"data:image/jpeg;base64,",contentType+stripContentTypeFromB64(b64)}function getContentTypeFromB64(b64){var result=/^data:(.*);/i.exec(b64);return result?result[0]:null}function stripContentTypeFromB64(b64){var index=b64.indexOf(",");return index!==-1?b64.substr(index+1):(index=b64.indexOf("data:"),index!==-1?b64.substr(index+5):b64)}function b64ToBlob(b64Data,fallbackContentType){for(var contentType=getContentTypeFromB64(b64Data)||fallbackContentType||"",sliceSize=512,byteCharacters=atob(b64Data),byteArrays=[],offset=0;offset<byteCharacters.length;offset+=sliceSize){for(var slice=byteCharacters.slice(offset,offset+sliceSize),byteNumbers=new Array(slice.length),i=0;i<slice.length;i++)byteNumbers[i]=slice.charCodeAt(i);byteArrays.push(new Uint8Array(byteNumbers))}return createBlob(byteArrays,contentType)}function createBlob(parts,type){try{return new Blob(parts,{type:type})}catch(e){var BlobBuilder=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder;if(BlobBuilder){var builder=new BlobBuilder;return builder.append(parts),builder.getBlob(type)}throw new Error("Unable to create blob")}}function toAttachments(files){var attachments=[],pending=0,promise=void 0;return $q(function(resolve,reject){files&&0!==files.length?(files.forEach(function(file){pending++,toAttachment(file).then(function(attachment){return attachments.push(attachment)})["catch"](function(error){$log.error("An error occurred while transforming the attachments.",error)})["finally"](function(){pending--})}),promise=$interval(function(){0===pending&&($interval.cancel(promise),0===attachments.length?reject("No files could be transformed successfully."):resolve(attachments))},500)):resolve(attachments)})}this.isImage=isImage,this.toAttachments=toAttachments,this.blobToB64=blobToB64,this.addContentTypeToB64=addContentTypeToB64,this.b64ToBlob=b64ToBlob}]),angular.module("juco.mobile.common").service("HeaderTitleService",["$rootScope","EVENTS",function($rootScope,EVENTS){function setHeaderTitleTranslation(title,context){$rootScope.$broadcast(EVENTS.onHeaderTitleChanged,{translate:!0,key:title,context:context})}function setHeaderTitleValue(title,emojify){$rootScope.$broadcast(EVENTS.onHeaderTitleChanged,{translate:!1,value:title,emojify:emojify})}this.setHeaderTitleTranslation=setHeaderTitleTranslation,this.setHeaderTitleValue=setHeaderTitleValue}]),angular.module("juco.mobile.rest").factory("JucoRestService",["$http","$q","Upload","Environment",function($http,$q,Upload,Environment){function http(config){return $http(config).then(function(result){return result.data})["catch"](function(error){return $q.reject({info:error.data,status:error.status})})}function doGet(relPath){var params=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},bypassErrorInterceptor=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return http({method:"GET",url:Environment.getAbsoluteApiEndpoint()+"/"+relPath,params:params,bypassErrorInterceptor:bypassErrorInterceptor})}return{get:doGet,getCached:function(relPath,params,cache,key,bypassErrorInterceptor){if(cache){var fromCache=cache.get(key);if(fromCache)return $q.resolve(fromCache)}return doGet(relPath,params,bypassErrorInterceptor).then(function(data){return cache&&cache.put(key,data),data})},getBase64:function(relPath){return $q(function(resolve,reject){http({method:"GET",headers:{Accept:"*/*"},responseType:"blob",url:Environment.getAbsoluteApiEndpoint()+"/"+relPath,bypassErrorInterceptor:!0}).then(function(blob){var reader=new FileReader;reader.onloadend=function(){resolve(reader.result)},reader.readAsDataURL(blob)})["catch"](reject)})},deleteCall:function(relPath){var params=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},bypassErrorInterceptor=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return http({method:"DELETE",url:Environment.getAbsoluteApiEndpoint()+"/"+relPath,params:params,bypassErrorInterceptor:bypassErrorInterceptor})},post:function(relPath){var data=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},bypassErrorInterceptor=arguments.length>2&&void 0!==arguments[2]&&arguments[2],abortPromise=arguments.length>3&&void 0!==arguments[3]?arguments[3]:void 0;return http({method:"POST",url:Environment.getAbsoluteApiEndpoint()+"/"+relPath,data:data,bypassErrorInterceptor:bypassErrorInterceptor,timeout:abortPromise})},put:function(relPath){var data=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},bypassErrorInterceptor=arguments.length>2&&void 0!==arguments[2]&&arguments[2],abortPromise=arguments.length>3&&void 0!==arguments[3]?arguments[3]:void 0;return http({method:"PUT",url:Environment.getAbsoluteApiEndpoint()+"/"+relPath,data:data,bypassErrorInterceptor:bypassErrorInterceptor,timeout:abortPromise})},upload:function(relPath,data,files,fileFormDataName,bypassErrorInterceptor){return Upload.upload({url:Environment.getAbsoluteApiEndpoint()+"/"+relPath,method:"POST",file:files,fields:data||{},fileFormDataName:fileFormDataName,bypassErrorInterceptor:bypassErrorInterceptor})}}}]),angular.module("juco.mobile.common").service("JWTService",["AuthenticationService","$q","$http","CurrentUser",function(AuthenticationService,$q,$http,CurrentUser){"ngInject";function refreshJWTAndRetryOnce(request){return AuthenticationService.loadJWTToken().then(function(){return withJWTHeader(request)})}function withJWTHeader(request){return $q(function(resolve,reject){$http(CurrentUser.setJWTHeaderAuthorization(request)).success(resolve).error(function(info,status){reject({info:info,status:status})})})}function sendAuthenticated(request){return withJWTHeader(request)["catch"](function(error){if(403===error.status)return refreshJWTAndRetryOnce(request);throw error})}this.sendAuthenticated=sendAuthenticated}]),angular.module("juco.mobile.common").service("PictureService",["$log","MessageHandler","$window",function($log,MessageHandler,$window){function getPicture(chooseExisting,onSuccess,onError){var settings={destinationType:TARGET_BASE_64,sourceType:chooseExisting?SOURCE_PHOTO_LIBRARY:SOURCE_CAMERA},onFailure=function(e){"Camera cancelled."===e||"Selection cancelled."===e?$log.debug("Cancelled selection of Picture"):onError?onError(e):(MessageHandler.error("exception.anErrorOccurred"),$log.error("An error occurred while selecting a photo: "+e))};$window.navigator&&$window.navigator.camera?$window.navigator.camera.getPicture(onSuccess,onFailure,settings):onFailure("Camera plugin not available.")}var SOURCE_PHOTO_LIBRARY=0,SOURCE_CAMERA=1,TARGET_BASE_64=0;this.getPicture=getPicture}]),angular.module("juco.mobile.common").service("ResourceStateService",["ResourceType","$state","IdUtil","CONFIG",function(ResourceType,$state,IdUtil,CONFIG){function goToResource(resourceId,replace,stateParams){var options={},resourceType=IdUtil.getResourceType(resourceId),params=stateParams||{};switch(replace&&(options.location="replace"),resourceType){case ResourceType.ENTITY:return options.reload=!0,params.entityId=resourceId,$state.go("main.entity",params,options),!0;case ResourceType.PROFILE:return options.reload=!0,params.profileId=resourceId,$state.go("main.profile",params,options),!0;case ResourceType.WORKSTREAM_MESSAGE:return params.messageId=resourceId,$state.go("main.feedMessage",params,options),!0;case ResourceType.DOCUMENT:case ResourceType.DRIVE_DOCUMENT:return params.documentId=resourceId,$state.go("main.document",params,options),!0;case ResourceType.CONVERSATION:return params.conversationId=resourceId,$state.go("chat.conversation",params,options),!0;case ResourceType.TASK:return params.id=resourceId,$state.go("main.task.details",params,options),!0;case ResourceType.TASK_LIST:return params.id=resourceId,$state.go("main.task.list",params,options),!0;case ResourceType.SHARE:return params.folderId=resourceId,$state.go("main.driveFolder",params,options),!0}return!1}function hasAssociatedState(resourceId){var resourceType=IdUtil.getResourceType(resourceId);return[ResourceType.ENTITY,ResourceType.PROFILE,ResourceType.WORKSTREAM_MESSAGE,ResourceType.DOCUMENT,ResourceType.DRIVE_DOCUMENT,ResourceType.CONVERSATION,ResourceType.TASK,ResourceType.TASK_LIST,ResourceType.SHARE].indexOf(resourceType)>=0}function goToResolvedToken(resolvedToken,replace){var newState,options={reload:!0},resourceId=resolvedToken.resourceId,resourceType=IdUtil.getResourceType(resourceId);return resourceType===ResourceType.ENTITY&&resolvedToken.anchor&&resolvedToken.anchorEntityComponents&&resolvedToken.anchorEntityComponents.length?(replace&&(options.location="replace"),newState=getStateForEntityComponents(resolvedToken.anchorEntityComponents),$state.go(newState,{entityId:resourceId,anchor:resolvedToken.anchor},options),!0):goToResource(resourceId,replace)}function getStateForEntityComponents(entityComponents){var i,result,entityComponentToStateMap={};for(CONFIG.supportedEntityModules.forEach(function(module){module.components.forEach(function(component){entityComponentToStateMap[component]=module.state})}),CONFIG.supportedEntityTabs.forEach(function(tab){tab.components.forEach(function(component){entityComponentToStateMap[component]=tab.state})}),i=0;i<entityComponents.length;i++)if(result=entityComponentToStateMap[entityComponents[i]])return result;return"main.entity"}this.goToResource=goToResource,this.goToResolvedToken=goToResolvedToken,this.hasAssociatedState=hasAssociatedState}]),angular.module("juco.mobile.common").service("StorageService",["CONFIG","$window","$q",function(CONFIG,$window,$q){function getStorageKey(key){return CONFIG.storagePrefix+key}function isLocalStorageAvailable(){var now=new Date,key=getStorageKey(now);try{return $window.localStorage.setItem(key,now),$window.localStorage.removeItem(key),!0}catch(err){return!1}}function getItem(key){return $q(function(resolve,reject){var storageKey=getStorageKey(key);$window.NativeStorage?$window.NativeStorage.getItem(storageKey,resolve,function(err){2===err.code?resolve(void 0):reject(err)}):resolve($window.localStorage.getItem(storageKey))})}function removeItem(key){return $q(function(resolve,reject){var storageKey=getStorageKey(key);$window.NativeStorage?($window.localStorage.removeItem(storageKey),$window.NativeStorage.remove(storageKey,resolve,reject)):resolve($window.localStorage.removeItem(storageKey))})}function setItem(key,value){return $q(function(resolve,reject){var storageKey=getStorageKey(key);$window.NativeStorage?($window.localStorage.setItem(storageKey,value),$window.NativeStorage.setItem(storageKey,value,resolve,reject)):resolve($window.localStorage.setItem(storageKey,value))})}function isStorageAvailable(){return localStorageAvailable||!!$window.NativeStorage}var localStorageAvailable=isLocalStorageAvailable();this.getItem=getItem,this.removeItem=removeItem,this.setItem=setItem,this.isStorageAvailable=isStorageAvailable,this.getStorageKey=getStorageKey}]),angular.module("juco.mobile.common").service("TrackingService",["$rootScope","$window","Environment","EVENTS","HolmesService","PlatformInfoService","ConversationService","ChatMessageType",function($rootScope,$window,Environment,EVENTS,HolmesService,PlatformInfoService,ConversationService,ChatMessageType){function onAppStart(){syncMobileTrackingWithPlatform().then(function(){Environment.isCordova()?(clientInfo.client="wrapper",clientInfo.platform=Environment.isIos()?"iOS":"Android",$window.device&&(clientInfo.deviceModel=$window.device.manufacturer+" "+$window.device.model,clientInfo.osVersion=$window.device.version)):clientInfo.client="mobile",$rootScope.$on("$locationChangeSuccess",pageView),$rootScope.$on(EVENTS.onChatFileUploadFinished,function(event,file,message){trackSendMessage(message)}),pageView()})}function trackWithHolmes(type,additionalPayload){if(trackingEnabled){var trackingObject=angular.extend({},additionalPayload||{},clientInfo,{type:type});HolmesService.track(trackingObject)}}function trackCreateGroupChat(source){trackWithHolmes("CONNECT",{action:"CREATE_GROUP_CHAT",source:source})}function trackSendMessage(message,firstMessage){trackingEnabled&&HolmesService.isHolmesAvailable()&&ConversationService.getConversation(message.conversationId,!0).then(function(conversation){var payload={action:"SEND_MESSAGE",conversationType:conversation.type,messageType:message.type};"boolean"==typeof firstMessage&&(payload.firstMessageInChat=firstMessage),message.type===ChatMessageType.ATTACHMENT_CHAT_MESSAGE&&message.attachment&&(payload.attachmentType=(message.attachment.contentType||"").toLowerCase(),payload.attachmentSize=message.attachment.size),trackWithHolmes("CONNECT",payload)})}function pageView(){trackingEnabled&&HolmesService.pageView(clientInfo)}function syncMobileTrackingWithPlatform(){return trackingEnabled=!1,PlatformInfoService.getPlatformInfo(!0).then(function(platformInfo){trackingEnabled=!!platformInfo.mobileTrackingEnabled})["catch"](function(){trackingEnabled=!1})}var clientInfo={},trackingEnabled=!0;this.onAppStart=onAppStart,this.trackCreateGroupChat=trackCreateGroupChat,this.trackSendMessage=trackSendMessage,this.pageView=pageView,this.syncMobileTrackingWithPlatform=syncMobileTrackingWithPlatform}]),angular.module("juco.mobile.common").service("UrlTokenResolver",["$q","RestService","REST","ResolvedTokenType","CONFIG","ResourceStateService","Environment","ExternalRefUtil","TaskFilter","$window","$state","AppConfigurationService",function($q,RestService,REST,ResolvedTokenType,CONFIG,ResourceStateService,Environment,ExternalRefUtil,TaskFilter,$window,$state,AppConfigurationService){"ngInject";function resolveToken(token){return $q(function(resolve,reject){token||resolve(null),RestService.get(REST.token.RESOLVE,{token:encodeURIComponent(token)}).then(function(data){resolve(1===data.length?data[0]:null)},function(error){reject({error:error.info})},!0)})}function options(replace){return replace?{location:replace}:{}}function goToStartpage(replace){$state.go("main.start",void 0,options(replace))}function goToFeed(appId,replace){$state.go("main.feed",{appId:appId},options(replace))}function goToChannels(appId,replace){AppConfigurationService.getEntityTypesForApp(appId).then(function(entityTypes){$state.go("main.allEntities",{entityTypes:entityTypes,title:"news.discoverChannels"},options(replace))})}function goToErrorpage(msgKey,replace){$state.go("dialog.inescapableError",{messageKey:msgKey},options(replace))}function goToFile(resolvedToken,replace){$state.go("main.document",{documentId:resolvedToken.resourceId},options(replace))}function goToFolder(resolvedToken,replace){$state.go("main.driveFolder",{folderId:resolvedToken.resourceId},options(replace))}function goToNotificationCenter(replace){$state.go("main.notification-center",{showBackButton:!1},options(replace))}function goToTask(resolvedToken,replace){$state.go("main.task.details",{id:resolvedToken.resourceId},options(replace))}function goToTaskList(resolvedToken,replace){var filterId=resolvedToken.filterId;switch(filterId){case TaskFilter.ASSIGNED_TO_ME:$state.go("main.task.assignedToMe",{},options(replace));break;case TaskFilter.CREATED_BY_ME:$state.go("main.task.createdByMe",{},options(replace));break;default:$state.go("main.task.list",{id:filterId},options(replace))}}function redirectToDesktop(token){Environment.isCordova()?ExternalRefUtil.openUrl(Environment.getServerBase()+CONFIG.desktopClientUrl+"?"+CONFIG.noRedirectUrlParam+token):$window.location.href=[$window.location.protocol,"//",$window.location.host,CONFIG.desktopClientUrl,"?",CONFIG.noRedirectUrlParam,token].join("")}function handleToken(originalToken,resolvedToken,replace){if(!resolvedToken)return void goToStartpage(replace);if(resolvedToken.hasOwnProperty("error"))return void goToErrorpage("general.errorLoadingContent",replace);switch(resolvedToken.type){case ResolvedTokenType.RESOURCE:changedState=ResourceStateService.goToResolvedToken(resolvedToken,replace),changedState||redirectToDesktop(originalToken);break;case ResolvedTokenType.NOT_SUPPORTED:redirectToDesktop(originalToken);break;case ResolvedTokenType.STARTPAGE:goToFeed("connect",replace);break;case ResolvedTokenType.HOME:goToStartpage(replace);break;case ResolvedTokenType.FILE:goToFile(resolvedToken,replace);break;case ResolvedTokenType.FOLDER:goToFolder(resolvedToken,replace);break;case ResolvedTokenType.NOTIFICATION_CENTER:goToNotificationCenter(replace);break;case ResolvedTokenType.FEED:goToFeed("news",replace);break;case ResolvedTokenType.CHANNELS:goToChannels("news",replace);break;case ResolvedTokenType.TASK:goToTask(resolvedToken,replace);break;case ResolvedTokenType.TASK_LIST:goToTaskList(resolvedToken,replace);break;default:goToErrorpage("general.invalidUrl",replace)}}var changedState=void 0;this.resolveToken=resolveToken,this.handleToken=handleToken}]),angular.module("juco.mobile.common").service("ChangeWatcher",["$state","PromiseUtil",function($state,PromiseUtil){function ChangeWatcher(){function resetValueChanged(name){return function(){delete pendingSaves[name]}}function onValueChanged(name,saveFn){return function(newVal,oldVal){oldVal!==newVal&&(pendingSaves[name]=saveFn)}}function watchValue(scope,name,saveFn){scope.$watch(name,onValueChanged(name,saveFn),!0)}function hasChanges(){return Object.keys(pendingSaves).length>0}function saveChangedValues(){if(!savingPromise){if(!hasChanges())return PromiseUtil.immediateResolve();var promises=Object.keys(pendingSaves).map(function(changedValueName){var saveFn=pendingSaves[changedValueName];return"function"==typeof saveFn?saveFn().then(resetValueChanged(changedValueName)):PromiseUtil.immediateReject('Error saving value "'+changedValueName+'".')});savingPromise=PromiseUtil.all(promises,angular.noop)["catch"](PromiseUtil.immediateReject)["finally"](function(){savingPromise=void 0})}return savingPromise}function saveAllAndGoToState(toState,params){return saveChangedValues().then(function(){return shouldForceStateChange=!0,$state.go(toState,params)},function(){return abortedStateChange={state:toState,params:params},PromiseUtil.immediateReject()})}function saveAllBeforeStateChange(scope,errorCallback){scope.$on("$stateChangeStart",function(event,toState,toParams){shouldForceStateChange||(event.preventDefault(),saveAllAndGoToState(toState,toParams)["catch"](errorCallback))})}function didAbortStateChange(){return abortedStateChange&&abortedStateChange.state}function doForceStateChange(){didAbortStateChange()&&(shouldForceStateChange=!0,$state.go(abortedStateChange.state,abortedStateChange.params))}function retrySavingChanges(){return didAbortStateChange()?saveAllAndGoToState(abortedStateChange.state,abortedStateChange.params):saveChangedValues()}var self=this,pendingSaves={},shouldForceStateChange=!1,savingPromise=void 0,abortedStateChange=void 0;self.watchValue=watchValue,self.saveChangedValues=saveChangedValues,self.saveAllBeforeStateChange=saveAllBeforeStateChange,self.doForceStateChange=doForceStateChange,self.retrySavingChanges=retrySavingChanges}this.create=function(){return new ChangeWatcher}}]),angular.module("juco.util").service("cssUtil",[function(){function toFontAwesomeIcon(fa3){return fa3?"fa-"+getWellFormedCssClass(fa3):null}function getWellFormedCssClass(dirtyClass){return dirtyClass?dirtyClass.trim().toLowerCase().replace(/_/g,"-").replace(/ /g,"-"):null}this.toFontAwesomeIcon=toFontAwesomeIcon,this.getWellFormedCssClass=getWellFormedCssClass}]),angular.module("juco.util").service("DomUtil",["$window","$timeout",function($window,$timeout){function isScrolledToBottom(element){return 1.5*element.scrollTop+element.offsetHeight>=element.scrollHeight}function getScrollHeight(){return $window.scrollY||$window.document.documentElement.scrollTop}function getDocumentHeight(){var doc=$window.document;return Math.max(doc.body.scrollHeight,doc.documentElement.scrollHeight,doc.body.offsetHeight,doc.documentElement.offsetHeight,doc.body.clientHeight,doc.documentElement.clientHeight)}function getWindowHeight(){var doc=$window.document;return $window.innerHeight||doc.documentElement.clientHeight||doc.body.clientHeight}function scrollToYIfPossible(y,times){times<=0||$timeout(function(){return getDocumentHeight()-getWindowHeight()<y?void scrollToYIfPossible(y,times-1):void $timeout(function(){$window.scrollTo(0,y)},0,!1)},0,!1)}this.isScrolledToBottom=isScrolledToBottom,this.getScrollHeight=getScrollHeight,this.getDocumentHeight=getDocumentHeight,this.getWindowHeight=getWindowHeight,this.scrollToYIfPossible=scrollToYIfPossible}]),angular.module("juco.mobile.common").service("LinkUtil",["Environment","$i18next","$location","$anchorScroll","urlUtil","ExternalRefUtil","UrlTokenResolver",function(Environment,$i18next,$location,$anchorScroll,UrlUtil,ExternalRefUtil,UrlTokenResolver){function rewriteLink(link){var doRewriteAnchor=arguments.length>1&&void 0!==arguments[1]&&arguments[1],additionalLinkClass=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"";Environment.isDesktop()||rewriteInternalLinkOrAnchor(link,doRewriteAnchor,additionalLinkClass)}function rewriteLinks(element){var doRewriteAnchor=arguments.length>1&&void 0!==arguments[1]&&arguments[1],additionalLinkClass=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",uploadedVideoSrcRegExp=/\/toro\/video\/player\?id=\d*/;if(!Environment.isDesktop()){for(var links=element.getElementsByTagName("a"),i=0;i<links.length;i++)rewriteInternalLinkOrAnchor(links[i],doRewriteAnchor,additionalLinkClass);for(var iframes=element.getElementsByTagName("iframe"),_i=0;_i<iframes.length;_i++)uploadedVideoSrcRegExp.test(iframes[_i].src)&&markUploadedVideoAsUnsupported(iframes[_i])}if(Environment.isCordova())for(var images=element.getElementsByTagName("img"),_i2=0;_i2<images.length;_i2++){var src=images[_i2].getAttribute("src"),srcNormalized=UrlUtil.normalizeAbsolutePath(src,Environment.getServerBase());images[_i2].setAttribute("src",srcNormalized)}}function markUploadedVideoAsUnsupported(iframe){var div=document.createElement("div"),text=document.createElement("span"),textNode=document.createTextNode($i18next("entity-wiki.videoIncompatible")),icon=document.createElement("i");div.setAttribute("class","content-incompatible-warning"),text.setAttribute("class","content-incompatible-warning-text"),icon.setAttribute("class","fa fa-exclamation content-incompatible-warning-icon"),text.appendChild(textNode),div.appendChild(icon),div.appendChild(text),iframe.parentNode.replaceChild(div,iframe)}function rewriteInternalLinkOrAnchor(link,rewriteAnchor,additionalLinkClass){var originUrl=link.getAttribute("href");if(originUrl){var token=UrlUtil.getUrlToken(originUrl);if(""!==token)handleInternalLink(link,token);else if(Environment.isCordova()&&("_blank"===link.getAttribute("target")||UrlUtil.hasProtocol(originUrl)))addExternalRefClickHandler(link,originUrl,!1);else if(rewriteAnchor){var hash=UrlUtil.getDesktopURLHash(originUrl);hash&&0===hash.indexOf("#.")&&(link.setAttribute("href",""),link.addEventListener("click",function(event){event.preventDefault(),$location.hash(hash.substring(1)),$anchorScroll()}))}additionalLinkClass&&angular.element(link).addClass(additionalLinkClass)}}function handleInternalLink(element,token){var processingAttr="processing";element.removeAttribute("target"),element.addEventListener("click",function(event){event.preventDefault(),element.hasAttribute(processingAttr)||(element.setAttribute(processingAttr,""),UrlTokenResolver.resolveToken(token).then(function(resolvedToken){UrlTokenResolver.handleToken(token,resolvedToken),element.removeAttribute(processingAttr)}))})}function addExternalRefClickHandler(element,url,forceInAppBrowser){element.removeAttribute("target"),element.addEventListener("click",function(event){event.preventDefault(),ExternalRefUtil.openUrl(url,forceInAppBrowser)})}this.rewriteLink=rewriteLink,this.rewriteLinks=rewriteLinks}]),angular.module("juco.util").service("locationUtil",["$location","$timeout","$anchorScroll",function($location,$timeout,$anchorScroll){function replaceAndScrollToAnchor(anchor,withTimeout){function scrollTo(){$location.replace(),$location.hash(anchor),$anchorScroll()}withTimeout?$timeout(scrollTo):scrollTo();
}this.replaceAndScrollToAnchor=replaceAndScrollToAnchor}]),angular.module("juco.util").service("regExpUtil",[function(){function matchRegExp(inputString,regExp){return inputString.toString().search(regExp)>=0}function isEmail(inputString){return matchRegExp(inputString,mailRegExp)}function isTel(inputString){var value=inputString.replace(telSpecialCharacters,"");return/^\d{7,}$/.test(value)}function checkForValueType(inputString){return isTel(inputString)?VALUE_TYPE.TEL:isEmail(inputString)?VALUE_TYPE.MAIL:VALUE_TYPE.NONE}var telSpecialCharacters=/[+-\/\\\s()]/g,mailRegExp=/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i,VALUE_TYPE={NONE:0,MAIL:1,TEL:2};this.valueType=VALUE_TYPE,this.matchRegExp=matchRegExp,this.checkForValueType=checkForValueType}]),angular.module("juco.util").service("StateUtil",["$state","ENUMS","$rootScope","$location","$window","Environment","$transitions",function($state,ENUMS,$rootScope,$location,$window,Environment,$transitions){function init(){initialized||(initialized=!0,$transitions.onSuccess({},function(transition){var from=transition.from(),to=transition.to();ignoreLocationChange=$location.$$replace,shouldClearHistory=!1,Environment.isCordova()&&("upgrade"!==from.name&&"upgrade"!==to.name&&"dialog.login"!==from.name&&"dialog.login"!==to.name||(previousStates.length=0,clearBrowserHistory(),shouldClearHistory=!0,ignoreLocationChange=!0))}),$rootScope.$on("$locationChangeSuccess",function(){currentState&&""!==currentState.name&&!ignoreLocationChange&&previousStates.push(currentState),shouldClearHistory&&(clearBrowserHistory(),shouldClearHistory=!1),ignoreLocationChange=!1,currentState={state:$state.current,stateParams:$state.params},currentLocation=$location.path()}),$rootScope.$watch(function(){return $location.path()},function(newLocation){currentLocation===newLocation&&(previousStates.pop(),previousStates.pop())}))}function clearBrowserHistory(){$window.navigator.app&&$window.navigator.app.clearHistory()}function getPreviousState(index){var internalIndex=index?index:previousStates.length-1;if(previousStates.length>internalIndex)return previousStates[internalIndex]}function hasPreviousState(){return previousStates.length>0&&$window.history.length>1}function getCurrentComponentByState(availableComponents,defaultStateParams){var i,availableComponentsLength=availableComponents.length;for(i=0;i<availableComponentsLength;i++)if($state.includes(availableComponents[i].state,availableComponents[i].stateParams||defaultStateParams))return availableComponents[i];return null}function resolveStateByUrl(url){return 0===url.indexOf("#/entity/")?resolveState("main.entity",url):0===url.indexOf("#/profile/")?resolveState("main.profile",url):0===url.indexOf("#/feed/")?resolveState("main.feed",url):void 0}function resolveState(baseState,url){var urlParts=url.split("/"),profileSubStatesByUrl={info:"main.profile.information",workstream:"main.profile.workstream"},entitySubStatesByUrl={workstream:"main.entity.workstream",info:"main.entity.baseData",wiki:"main.entity.wiki",multiwiki:"main.entity.multiWiki",raweditors:"main.entity.raweditors",documents:"main.entity.document",children:"main.entity.children"},idPart=urlParts[2],subStateUrlPart=urlParts[3],result={name:"",params:{}};return"main.entity"===baseState?(result.name=entitySubStatesByUrl[subStateUrlPart]||baseState,result.params.entityId=idPart,result.name===entitySubStatesByUrl.children&&(result.params.childType=urlParts[4])):"main.profile"===baseState?(result.name=profileSubStatesByUrl[subStateUrlPart]||baseState,result.params.profileId=idPart):"main.feed"===baseState&&(result.name=baseState,result.params={appId:urlParts[2]}),result}var currentLocation,previousStates=[],currentState=null,initialized=!1,ignoreLocationChange=!1,shouldClearHistory=!1;this.init=init,this.getPreviousState=getPreviousState,this.hasPreviousState=hasPreviousState,this.getCurrentComponentByState=getCurrentComponentByState,this.resolveStateByUrl=resolveStateByUrl}]).run(["StateUtil",function(StateUtil){StateUtil.init()}]),angular.module("juco.mobile.common").service("VersionUtil",[function(){function isVersionRequirementSatisfied(v1,v2){return compare(v1,v2)>=0}function compare(v1,v2){function isValidPart(x){return/^\d+$/.test(x)}var v1parts=v1?v1.split("."):[],v2parts=v2?v2.split("."):[];if(!v1parts.every(isValidPart)||!v2parts.every(isValidPart))return NaN;for(;v1parts.length<v2parts.length;)v1parts.push("0");for(;v2parts.length<v1parts.length;)v2parts.push("0");v1parts=v1parts.map(Number),v2parts=v2parts.map(Number);for(var i=0;i<v1parts.length;++i){if(v2parts.length===i)return 1;if(v1parts[i]!==v2parts[i])return v1parts[i]>v2parts[i]?1:-1}return v1parts.length!==v2parts.length?-1:0}this.compare=compare,this.isVersionRequirementSatisfied=isVersionRequirementSatisfied}]),function(){function DatePickerController($element,$document,$scope,i18nextFilter){function getTranslations(key,count){var i,result=[];for(i=0;i<count;i++)result.push(i18nextFilter(key+"_"+i));return result}function load(){var defaultDate=self.selectedDate?new Date(self.selectedDate):null,setDefaultDate=!!self.selectedDate;container=$element[0],picker=new Pikaday({field:container,container:container,i18n:{previousMonth:i18nextFilter("date.previousMonth"),nextMonth:i18nextFilter("date.nextMonth"),months:getTranslations("date.monthOfYear",12),weekdays:getTranslations("date.dayOfWeek",7),weekdaysShort:getTranslations("date.dayOfWeekShort",7)},onSelect:function(date){$scope.$apply(function(){self.selectedDate=date.getTime()}),self.onDateSelected()},defaultDate:defaultDate,setDefaultDate:setDefaultDate}),picker.show(),$scope.$on("$destroy",function(){picker.destroy()})}var container,picker,self=this;$document.ready(load)}angular.module("juco.mobile.common").directive("jcDatePicker",function(){return{restrict:"A",scope:{onDateSelected:"=",selectedDate:"="},controller:"DatePickerController",controllerAs:"vm",bindToController:!0}}),angular.module("juco.mobile.common").controller("DatePickerController",["$element","$document","$scope","i18nextFilter",DatePickerController])}(),angular.module("juco.directives").directive("jcDialog",function(){return{transclude:!0,templateUrl:"scripts/component/directive/dialog.html",scope:{showDialog:"=jcDialog"}}}),angular.module("juco.mobile.component").directive("jcDropdown",function(){return{restrict:"E",replace:!0,transclude:!0,scope:{values:"=",selectedValue:"=?",onValueChanged:"="},templateUrl:"scripts/component/directive/jc-dropdown.html",controller:"JcDropdownController",controllerAs:"vm",bindToController:!0}}),angular.module("juco.mobile.component").controller("JcDropdownController",["$timeout","$transclude","$scope",JcDropdownController]),angular.module("juco.mobile.common").directive("jcIconLinkWithCount",["$state","$window",function($state,$window){var toggleState=function(state){return function(){$state.is(state)?$window.history.back():$state.go(state)}},isState=function(state){return $state.is(state)},linker=function(scope){scope.toggleState=scope.toggleState||toggleState(scope.state),scope.isState=isState,scope.$on(scope.countChangedEvent,function(event,newCount){scope.count=newCount})};return{restrict:"E",replace:!0,scope:{state:"=",countChangedEvent:"=",icon:"=",toggleState:"=?"},link:linker,templateUrl:"scripts/component/directive/jc-icon-link-with-count.html"}}]),angular.module("juco.directives").directive("jcLabeledRow",["dateFilter","i18nextFilter","jcI18nDynamicAttributeFilter",function(dateFilter,i18nextFilter,jcI18nDynamicAttributeFilter){function linker(scope){var i,value;for(scope.values=scope.values||[],angular.isArray(scope.values)||(scope.values=[scope.values]),i=0;i<scope.values.length;i++)value=scope.values[i],scope.translateValues?scope.values[i]=jcI18nDynamicAttributeFilter(value,scope.valuesI18nKeyPrefix,scope.i18nOptions):angular.isDate(value)&&(scope.values[i]=dateFilter(value,i18nextFilter("date.dateTimeFormat")))}return{restrict:"E",replace:!0,scope:{labelI18nKey:"=",labelI18nKeyPrefix:"=",translateValues:"=",values:"=",valuesI18nKeyPrefix:"=",i18nOptions:"="},link:linker,templateUrl:"scripts/component/directive/jc-labeled-row.html"}}]),function(){function LoadingController(){}angular.module("juco.directives").directive("jcLoading",function(){return{restrict:"E",replace:!0,templateUrl:"scripts/component/directive/jc-loading.html",scope:{showLoading:"=?",showErrorMessage:"=?",errorMessage:"=?",errorStatusCode:"=?",showNoContentMessage:"=?",noContentMessage:"=?"},controller:"LoadingController",controllerAs:"loading",bindToController:!0}}),angular.module("juco.directives").controller("LoadingController",[LoadingController])}(),angular.module("juco.directives").directive("jcMenuLink",["$state","$window","ENUMS","urlUtil","ExternalRefUtil","Environment","StateUtil","$i18next",function($state,$window,ENUMS,urlUtil,ExternalRefUtil,Environment,StateUtil,$i18next){function linker(scope){function openUrl(){var state;urlUtil.hasProtocol(menuLink.url)?ExternalRefUtil.openUrl(menuLink.url):Environment.isCordova()?(state=StateUtil.resolveStateByUrl(menuLink.url),state?$state.go(state.name,state.params,{reload:!0}):ExternalRefUtil.openUrl(urlUtil.joinParts([Environment.getServerBase(),menuLink.url]))):$window.open(menuLink.url,"_self")}function openStaticLink(){staticType.name===ENUMS.staticMenuLinkType.PROFILE.name?$state.go(staticType.state,{profileId:scope.userId},{reload:!0}):$state.go(staticType.state)}function openMyContent(){var entityTypes=menuLink.entityTypes.map(function(t){return t.name}).join(",");$state.go("main.myEntity",{entityTypes:entityTypes,title:menuLink.translation||$i18next("entity.myEntities")})}function openAllEntities(){var entityTypes=menuLink.entityTypes.map(function(t){return t.name}).join(",");$state.go("main.allEntities",{entityTypes:entityTypes,title:menuLink.translation||$i18next("entity.allEntities")})}var staticType,menuLink=scope.link;switch(menuLink.type){case ENUMS.menuLinkType.CUSTOM:scope.text=menuLink.translation||menuLink.url,scope.followLink=openUrl,scope.toggleMenu=scope.$parent.toggleMenu;break;case ENUMS.menuLinkType.STATIC:staticType=ENUMS.staticMenuLinkType[menuLink.staticType],staticType&&(scope.i18nKey=staticType.key,scope.followLink=openStaticLink),scope.toggleMenu=scope.$parent.toggleMenu;break;case ENUMS.menuLinkType.MY_CONTENT_MOBILE:scope.i18nKey=menuLink.translation||"entity.myEntities",scope.followLink=openMyContent,scope.toggleMenu=scope.$parent.toggleMenu;break;case ENUMS.menuLinkType.ALL_ENTITIES_MOBILE:scope.i18nKey=menuLink.translation||"entity.allEntities",scope.followLink=openAllEntities,scope.toggleMenu=scope.$parent.toggleMenu;break;case ENUMS.menuLinkType.HEADLINE:scope.text=menuLink.headline,scope.style=menuLink.cssClass}}return{restrict:"E",replace:!0,scope:{link:"=",userId:"="},link:linker,templateUrl:"scripts/component/directive/menu-link.html"}}]),function(){function CheckboxController(){function init(){self.attributes=self.large?{width:80,height:40,margin:1,radius:5,checkmarkTransform:"translate(24,4)"}:{width:24,height:24,margin:2,radius:3,checkmarkTransform:"scale(0.75)"}}var self=this;self.onChange=function(){self.onToggle&&"function"==typeof self.onToggle&&self.onToggle(self.isChecked)},init()}angular.module("juco.directives").directive("jcPrettyCheckbox",function(){return{restrict:"E",scope:{isChecked:"=?",isDisabled:"=?",onToggle:"=?",large:"=?",text:"@?"},templateUrl:"scripts/component/directive/jc-pretty-checkbox.html",controller:"CheckboxController",controllerAs:"vm",bindToController:!0}}),angular.module("juco.directives").controller("CheckboxController",[CheckboxController])}(),angular.module("juco.mobile.common").directive("jcProgressBar",[function(){return{restrict:"E",scope:{progress:"=",title:"=?"},templateUrl:"scripts/component/directive/jc-progress-bar.html"}}]),function(){angular.module("juco.directives").directive("jcSubnavigation",function(){var linker=function(scope){scope.navHidden=!0,scope.selectedValue=scope.preselectedValue,scope.toggleNavigation=function(){scope.navHidden=!scope.navHidden},scope.onSelect=function(value){scope.selectedValue!==value&&(scope.selectedValue=value,angular.isFunction(scope.onValueChange)&&scope.onValueChange(value))}};return{restrict:"E",replace:!0,scope:{defaultContext:"=",values:"=",preselectedValue:"=",onValueChange:"="},link:linker,templateUrl:"scripts/component/directive/subnavigation.html"}})}(),angular.module("juco.mobile.component").directive("jcTabs",[function(){return{restrict:"E",scope:{},transclude:!0,replace:!0,controllerAs:"vm",controller:"TabsController",templateUrl:"scripts/component/directive/jc-tabs.html",bindToController:!0}}]).directive("jcTab",[function(){return{require:"^^jcTabs",restrict:"E",scope:{title:"@"},transclude:!0,replace:!0,link:function(scope,element,attrs,ctrl){ctrl.addTab(scope)},templateUrl:"scripts/component/directive/jc-tab.html"}}]),angular.module("juco.mobile.component").controller("TabsController",[function(){function addTab(tab){self.tabs.push(tab),self.indicatorLength=100/self.tabs.length+"%",select(0)}function select(index){self.tabs.forEach(function(tab,i){tab.selected=i===index,tab.style={left:100*(i-index)+"%"}}),self.selectedIndex=index,self.indicatorPosition=self.selectedIndex*(100/self.tabs.length)+"%"}function isSelectedIndex(index){return self.selectedIndex===index}var self=this;self.tabs=[],self.selectedIndex=0,self.indicatorLength="0%",self.indicatorPosition="0%",this.addTab=addTab,this.select=select,this.isSelectedIndex=isSelectedIndex}]),angular.module("juco.directives").directive("jcTeaser",["ResourceType","$templateCache","$compile","DocumentService","IdUtil","$state","cssUtil",function(ResourceType,$templateCache,$compile,DocumentService,IdUtil,$state,cssUtil){function createTemplate(scope,element){var teaser=scope.teaser,teaserType=IdUtil.getResourceType(teaser.id);switch(teaserType){case ResourceType.DRIVE_DOCUMENT:return handleDriveDocument(scope,element,teaser);case ResourceType.PROFILE:return element.on("click",function(){$state.go("main.profile",{profileId:teaser.id},{reload:!0})}),$templateCache.get("scripts/component/directive/profile-teaser.html");case ResourceType.CONVERSATION:return element.on("click",function(){$state.go("chat.conversation",{conversationId:teaser.id},{reload:!0})}),$templateCache.get("scripts/component/directive/conversation-teaser.html");case ResourceType.ENTITY:default:return teaser.startAt&&(scope.startAtDate=new Date(teaser.startAt)),teaser.imageUrlPattern||(scope.icon=cssUtil.toFontAwesomeIcon(teaser.icon)),element.on("click",function(){$state.go("main.entity",{entityId:teaser.id},{reload:!0})}),$templateCache.get("scripts/component/directive/entity-teaser.html")}}function handleDriveDocument(scope,element,teaser){switch(teaser.type){case"DOCUMENT":return scope.documentTag=DocumentService.getDocumentFileTypeTag(teaser),element.on("click",function(){DocumentService.downloadDocument(teaser.id)}),$templateCache.get("scripts/component/directive/document-teaser.html");case"FOLDER":case"SHARE":default:return element.on("click",function(){$state.go("main.driveFolder",{folderId:teaser.id})}),$templateCache.get("scripts/drive/directive/drive-teaser.html")}}function linker(scope,element){element.html(createTemplate(scope,element)),$compile(element.contents())(scope)}return{restrict:"E",replace:!0,scope:{teaser:"=teaser"},link:linker}}]),function(){angular.module("juco.directives").directive("jcTeaserLink",function(){return{restrict:"E",scope:{teaser:"="},controllerAs:"jcTeaserLink",controller:"TeaserLinkController",templateUrl:"scripts/component/directive/jc-teaser-link.html",bindToController:!0}}),angular.module("juco.directives").controller("TeaserLinkController",["ResourceType","IdUtil","$state","profileNameFilter",function(ResourceType,IdUtil,$state,profileNameFilter){var self=this,teaser=self.teaser,teaserType=IdUtil.getResourceType(teaser.id);switch(teaserType){case ResourceType.PROFILE:return self.url=teaser.deleted?null:$state.href("main.profile",{profileId:teaser.id}),void(self.name=profileNameFilter(teaser));case ResourceType.ENTITY:default:self.url=$state.href("main.entity",{entityId:teaser.id}),self.name=teaser.name}}])}(),angular.module("juco.directives").directive("profileTeaser",[function(){return{restrict:"E",replace:!0,templateUrl:"scripts/component/directive/profile-teaser.html",scope:{teaser:"=teaser"}}}]),angular.module("juco.directives").directive("username",["$compile","$state",function($compile,$state){function goToProfile(id){$state.go("main.profile",{profileId:id},{reload:!0})}function linker(scope,element){var innerHtml=element.html();scope.goToProfile=goToProfile,scope.notification&&!scope.compactView&&(innerHtml='<a class="jc-notification-color" ng-click="goToProfile(notification.originator.id);">'+innerHtml+"</a>"),element.html(innerHtml),$compile(element.contents())(scope)}return{restrict:"E",link:linker}}]),angular.module("juco.mobile.quill").service("JcQuill",["LinkEllipsisModule","TextEllipsisModule","LinkFormat","MentionBlot",function(LinkEllipsisModule,TextEllipsisModule,LinkFormat,MentionBlot){"ngInject";function init(){Quill.register("modules/LinkEllipsis",LinkEllipsisModule,!0),Quill.register("modules/TextEllipsis",TextEllipsisModule,!0),Quill.register("formats/link",LinkFormat,!0),Quill.register("formats/mention",MentionBlot,!0)}function create(element,modules,readOnly){return new Quill(element,{readOnly:readOnly,theme:"bubble",modules:modules})}this.create=create,init()}]),angular.module("juco.mobile.quill").factory("MentionBlot",["ResourceStateService",function(ResourceStateService){"ngInject";var Link=Quill["import"]("formats/link"),MentionBlot=function(_Link){function MentionBlot(){return _classCallCheck(this,MentionBlot),_possibleConstructorReturn(this,(MentionBlot.__proto__||Object.getPrototypeOf(MentionBlot)).apply(this,arguments))}return _inherits(MentionBlot,_Link),_createClass(MentionBlot,null,[{key:"create",value:function(id){var domNode=_get(MentionBlot.__proto__||Object.getPrototypeOf(MentionBlot),"create",this).call(this);return domNode.setAttribute("profileid",id),domNode.removeAttribute("href"),domNode.removeAttribute("target"),domNode.addEventListener("click",function(){return ResourceStateService.goToResource(id)}),domNode.removeAttribute("rel"),domNode.classList.add("workstream-item-link"),domNode}},{key:"formats",value:function(domNode){return domNode.getAttribute("profileid")}}]),MentionBlot}(Link);return MentionBlot.blotName="mention",MentionBlot.tagName="a",MentionBlot.className="mention",MentionBlot}]),angular.module("juco.mobile.quill").factory("LinkFormat",["LinkUtil",function(LinkUtil){"ngInject";var Link=Quill["import"]("formats/link"),LinkFormat=function(_Link2){function LinkFormat(){return _classCallCheck(this,LinkFormat),_possibleConstructorReturn(this,(LinkFormat.__proto__||Object.getPrototypeOf(LinkFormat)).apply(this,arguments))}return _inherits(LinkFormat,_Link2),_createClass(LinkFormat,null,[{key:"create",value:function(value){var node=_get(LinkFormat.__proto__||Object.getPrototypeOf(LinkFormat),"create",this).call(this,value);return node.setAttribute("href",LinkFormat.sanitize(value)),LinkUtil.rewriteLink(node,!1,"workstream-item-link"),node}},{key:"sanitize",value:function(url){return LinkFormat.isProtocolWhitelisted(url,LinkFormat.PROTOCOL_WHITELIST)?url:"https://"+url}},{key:"isProtocolWhitelisted",value:function(url,whitelistedProtocols){return whitelistedProtocols.some(function(protocol){return url.startsWith(protocol)})}}]),LinkFormat}(Link);return LinkFormat.PROTOCOL_WHITELIST=["http://","https://","mailto:","tel:","ftp://"],LinkFormat}]),angular.module("juco.mobile.quill").factory("LinkEllipsisModule",["HtmlUtil",function(HtmlUtil){"ngInject";var LinkEllipsisModule=function(){function LinkEllipsisModule(quill,options){var _this4=this;_classCallCheck(this,LinkEllipsisModule);var maxUrlLength=options.maxUrlLength;quill.on("text-change",function(){_this4.shortenUrls(quill,maxUrlLength)})}return _createClass(LinkEllipsisModule,[{key:"shortenUrls",value:function(quill,maxUrlLength){var content=quill.getContents().slice();content.ops.forEach(function(element){if(element.attributes&&element.attributes.link&&element.attributes.link===element.insert&&"string"==typeof element.insert){var fullUrl=element.insert;element.insert=maxUrlLength>0?HtmlUtil.shorten(fullUrl,maxUrlLength,0):fullUrl}}),quill.setContents(content,Quill.sources.SILENT)}}]),LinkEllipsisModule}();return LinkEllipsisModule}]),angular.module("juco.mobile.quill").factory("TextEllipsisModule",["i18nextFilter",function(i18nextFilter){"ngInject";var TextEllipsisModule=function(){function TextEllipsisModule(quill,options){var _this5=this;_classCallCheck(this,TextEllipsisModule);var maxTextLength=options.maxTextLength;quill.on("text-change",function(){_this5.ellipsifyText(quill,maxTextLength)})}return _createClass(TextEllipsisModule,[{key:"ellipsifyText",value:function(quill,maxTextLength){var Delta=Quill["import"]("delta"),totalLength=quill.getLength();if(totalLength>maxTextLength){var text=quill.getText().substring(maxTextLength,totalLength),retainIndex=maxTextLength+TextEllipsisModule.findFirstWhitespace(text);quill.updateContents((new Delta).retain(retainIndex)["delete"](totalLength).insert("...\n\n").insert(i18nextFilter("workstream.showEntireMessage")).insert("\n",{align:"center"}),Quill.sources.SILENT)}}}],[{key:"isWhitespace",value:function(ch){return" "===ch||"\t"===ch||"\n"===ch}},{key:"findFirstWhitespace",value:function(text){for(var i=0;i<text.length;i++)if(this.isWhitespace(text.charAt(i)))return i;return text.length}}]),TextEllipsisModule}();return TextEllipsisModule}]),angular.module("juco.mobile.configuration").constant("CONFIG",function(){return angular.extend({},juco.baseConstants,{oauthApiClientId:"mobile",oauthApiEndpoint:juco.baseConstants.apiContext,oauthCallbackUrl:"/m/#/login/callback?",noRedirectUrlParam:"nomobile",supportedEntityModules:[{components:["MULTI_WIKI"],i18nKey:"entity.multiwikiModuleName",state:"main.entity.multiWiki",icon:"fa-file-text-o",order:0,force:!1},{components:["WIKI_EDITOR"],i18nKey:"entity.wikiModuleName",state:"main.entity.wiki",icon:"fa-file-text-o",order:1,force:!1},{components:["RAW_EDITOR1","RAW_EDITOR2","RAW_EDITOR3","RAW_EDITOR4"],i18nKey:"entity.rawEditorsModuleName",state:"main.entity.raweditors",icon:"fa-file-text-o",order:2,force:!1},{components:["WORKSTREAM"],i18nKey:"entity.workstreamModuleName",state:"main.entity.workstream",icon:"fa-rss",order:3,force:!1},{components:["DOCUMENT"],i18nKey:"entity.documentModuleName",state:"main.entity.document",icon:"fa-file-text",order:5,force:!0}],supportedEntityTabs:[{components:["INFORMATION"],i18nKey:"entity.baseDataModuleName",state:"main.entity.baseData",icon:"fa-info-circle",order:4,force:!1}],entityBaseDataOrder:["startAt","endAt","timeZone","location","versionStatus","dynamicAttributes"],fileTypeTag:{DEFAULT:"N/A",DOC:"DOC",DOCX:"DOC",GIF:"GIF",JPG:"JPG",JPEG:"JPG",PDF:"PDF",PNG:"PNG",PPS:"PPS",PPT:"PPT",PPTX:"PPT",TXT:"TXT",XLS:"XLS",XLSX:"XLS",ZIP:"ZIP",ODT:"ODT",ODP:"ODP",ODS:"ODS",ODG:"ODG",OTT:"OTT",OTP:"OTP",OTS:"OTS",OTG:"OTG"},maxCompactMicroblogTextLength:250,maxPinnedMicroblogTextLength:100,maxMicroblogLinkLength:40,storagePrefix:"juco.",conversationItemsInConversationOverview:15,cloudServerBase:"https://cloud.just.social",cloudServerAppFileBase:"https://cloud.just.social",androidSenderId:"250731085579",wrapperUpgradeTimeout:18e4,defaultFeed:"news"})}()),angular.module("juco.mobile.document").controller("DocumentController",["DocumentService","documentId",function(DocumentService,documentId){"ngInject";function init(){self.document=null,self.loading=!1,self.showErrorMessage=!1,self.errorStatusCode=null,documentId?(self.loading=!0,DocumentService.getDocumentById(documentId).then(function(data){self.loading=!1,self.document=data})["catch"](function(e){self.loading=!1,self.errorStatusCode=e.status,self.showErrorMessage=!0})):self.showErrorMessage=!0}var self=this;init()}]),angular.module("juco.mobile.document").controller("DocumentsController",["$scope","$stateParams","DocumentService","MessageHandler","CONFIG",function($scope,$stateParams,DocumentService,MessageHandler,CONFIG){function init(){var id=$stateParams.entityId;$scope.loading=!1,$scope.showErrorMessage=!1,$scope.getDocumentTag=getDocumentTag,id?($scope.loading=!0,DocumentService.getDocumentsByParentId(id).then(updateScope,function(){$scope.loading=!1,$scope.showErrorMessage=!0})):($scope.showErrorMessage=!0,MessageHandler.error("entity.noEntityIdProvided"))}function updateScope(documents){return documents?($scope.documents=documents,void($scope.loading=!1)):void MessageHandler.error("document.errorGettingDocumentsFromServer")}function getDocumentTag(document){var tag;return document?(tag=CONFIG.fileTypeTag[document.fileType.toUpperCase()],tag||CONFIG.fileTypeTag.DEFAULT):{}}init()}]),angular.module("juco.mobile.document").service("DocumentService",["JucoRestService","Cache","MessageHandler","$window","REST","CONFIG","$rootScope","EVENTS","urlUtil","CurrentUser","Environment","DownloadsService","PromiseUtil",function(JucoRestService,Cache,MessageHandler,$window,REST,CONFIG,$rootScope,EVENTS,urlUtil,CurrentUser,Environment,DownloadsService,PromiseUtil){function downloadDocument(id){PromiseUtil.all([getDocumentDownloadUrl(id),getDocumentById(id)],function(downloadUrl,document){downloadUrl?DownloadsService.downloadDocument(downloadUrl,document.name,document.size,document.contentType):MessageHandler.error("document.errorGettingDocumentFromServer")})}function getDocumentDownloadUrl(id){var inline=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return JucoRestService.get(REST.document.URL(id,inline),{}).then(function(url){return url?Environment.getAbsoluteApiContext()+url:void 0})}function downloadChatAttachment(messageId,chatAttachment){var documentVersionId=chatAttachment.documentVersionId,fileName=chatAttachment.filename,fileSize=chatAttachment.size,fileType=chatAttachment.contentType,documentUrl=void 0;JucoRestService.get(REST.message.MESSAGE_ATTACHMENT_URL(messageId),{}).then(function(authorizedUrl){authorizedUrl&&(documentUrl=Environment.getAbsoluteApiContext()+authorizedUrl,DownloadsService.downloadDocument(documentUrl,fileName,fileSize,fileType,documentVersionId))})}function getDocumentsByParentId(id){var params={offset:0,limit:1e3};return JucoRestService.getCached(REST.document.DOCUMENTS+"/"+id,params,documentsCache,id)}function getDocumentFileTypeTag(document){var tag=void 0;return document&&document.fileType&&(tag=CONFIG.fileTypeTag[document.fileType.toUpperCase()]),tag||CONFIG.fileTypeTag.DEFAULT}function getDocumentById(id){return JucoRestService.getCached(REST.document.BASE+"/"+id,{},documentCache,id)}var documentsCache=Cache.createCache("documentsCache"),documentCache=Cache.createCache("documentCache");$rootScope.$on(EVENTS.onProfileContactChanged,function(data){documentsCache.remove(data.personId),documentsCache.remove(data.contactId),documentCache.removeAll()}),$rootScope.$on(EVENTS.onEntityMemberStatusChanged,function(data){documentsCache.remove(data.entityId),documentCache.removeAll()}),this.getDocumentsByParentId=getDocumentsByParentId,this.getDocumentFileTypeTag=getDocumentFileTypeTag,this.getDocumentById=getDocumentById,this.downloadDocument=downloadDocument,this.downloadChatAttachment=downloadChatAttachment,this.getDocumentDownloadUrl=getDocumentDownloadUrl}]),angular.module("juco.mobile.download").controller("DownloadsController",["DownloadsService","$scope","EVENTS",function(DownloadsService,$scope,EVENTS){function init(){$scope.abortDownload=abortDownload,$scope.$on(EVENTS.onDownloadProgress,updateDownloads),$scope.$on(EVENTS.onDownloadAborted,updateDownloads),$scope.$on(EVENTS.onDownloadSuccessful,updateDownloads),$scope.currentDownloads=DownloadsService.getCurrentDownloads()}function abortDownload(uid){DownloadsService.abortDownload(uid)}function updateDownloads(){$scope.$apply(function(){$scope.currentDownloads=DownloadsService.getCurrentDownloads()})}init()}]),angular.module("juco.mobile.download").service("DownloadsService",["$window","$rootScope","EVENTS","$q","Map","MessageHandler","Environment","ExternalRefUtil","UUID",function($window,$rootScope,EVENTS,$q,Map,MessageHandler,Environment,ExternalRefUtil,UUID){function addFileExtension(fileName,fileType){var extension=MIME_TYPE_EXTENSIONS[fileType];return extension?fileName+"."+extension:fileName}function prepareDownloadFileName(fileName,fileType){var hasExtension=fileName.lastIndexOf(".")!==-1,downloadFileName=hasExtension?fileName:addFileExtension(fileName,fileType);return Environment.isCordova()&&Environment.isAndroid()?downloadFileName.toLowerCase():downloadFileName}function downloadDocument(url,fileName,fileSize,fileType,uuid){function onProgress(progressEvent){var perc=0;progressEvent.lengthComputable&&(perc=Math.ceil(progressEvent.loaded/progressEvent.total*100),perc>=lastPercentage+PROGRESS_STEP&&(lastPercentage=perc,fileInfo.progress=perc,$rootScope.$broadcast(EVENTS.onDownloadProgress,fileInfo)))}function onSuccess(fileEntry){currentDownloads.remove(uid),fileInfo.fileEntry=fileEntry,$rootScope.$broadcast(EVENTS.onDownloadSuccessful,fileInfo),$window.plugins&&$window.plugins.fileOpener&&Environment.isCordova()&&Environment.isAndroid()?$window.plugins.fileOpener.open(fileEntry.toURL()):ExternalRefUtil.openUrl(fileEntry.toURL(),!0,!0)}function onError(error){return currentDownloads.remove(uid),"abort"===error.type?void $rootScope.$broadcast(EVENTS.onDownloadAborted,fileInfo):(MessageHandler.error("wrapper.downloads.downloadFailed",{fileName:fileName}),fileInfo.error=error,void $rootScope.$broadcast(EVENTS.onDownloadFailed,fileInfo))}var transfer,downloadFileName=prepareDownloadFileName(fileName,fileType),localRelativePath="/downloads/"+encodeURIComponent(downloadFileName),uid=uuid?uuid:UUID.generate(),lastPercentage=0,fileInfo={uid:uid,fileName:fileName,url:url,progress:0,size:fileSize};Environment.isCordova()?(MessageHandler.info("wrapper.downloads.downloadStarted",{fileName:fileName}),transfer=FileUtil.downloadFile(!1,url,localRelativePath,onProgress),transfer.then(onSuccess,onError),fileInfo.transfer=transfer,currentDownloads.put(uid,fileInfo)):$window.location.href=url}function getCurrentDownloads(){return currentDownloads.values()}function abortDownload(uid){var fileInfo=currentDownloads.get(uid);fileInfo&&fileInfo.transfer.abort()}var PROGRESS_STEP=1,MIME_TYPE_EXTENSIONS={"image/gif":"gif","image/x-icon":"ico","image/jpeg":"jpg","image/png":"png","image/svg+xml":"svg","image/tiff":"tiff","image/webp":"webp"},currentDownloads=new Map;this.downloadDocument=downloadDocument,this.getCurrentDownloads=getCurrentDownloads,this.abortDownload=abortDownload}]),angular.module("juco.mobile.drive").controller("DriveFolderController",["$scope","DriveService","HeaderTitleService","$rootScope","folderId",function($scope,DriveService,HeaderTitleService,$rootScope,folderId){function init(){$scope.$on("jc-fetch-next-drive-documents",fetchNextDocuments),fetchNextDocuments().then(function(documentsList){documentsList&&HeaderTitleService.setHeaderTitleValue(documentsList.folder.name,!0)})}function fetchNextDocuments(){var offset=self.documents.length;return self.loading=!0,DriveService.getDocuments(folderId,offset,batchSize).then(function(documentsList){return self.documents=self.documents.concat(documentsList.documents),self.hasMore=documentsList.totalDocumentCount>self.documents.length,self.showErrorMessage=!1,documentsList},function(){self.showErrorMessage=!0})["finally"](function(){self.loading=!1})}var self=this,batchSize=25;self.documents=[],self.showErrorMessage=!1,self.hasMore=!1,self.loading=!1,init()}]),angular.module("juco.mobile.drive").controller("MyDrivesController",["DriveService","ArrayUtil",function(DriveService,ArrayUtil){function init(){self.loading=!0,DriveService.getDrives().then(function(drives){self.drives=ArrayUtil.copyAndSortByItemMember(drives,"name"),
self.loading=!1},function(){self.loading=!1})}var self=this;self.drives=[],self.loading=!1,init()}]),angular.module("juco.mobile.drive").directive("driveIcon",function(){return{restrict:"A",templateUrl:"scripts/drive/directive/drive-icon.html"}}),angular.module("juco.mobile.drive").directive("driveTeaser",function(){return{restrict:"E",scope:{teaser:"="},templateUrl:"scripts/drive/directive/drive-teaser.html"}}),angular.module("juco.mobile.drive").service("DriveRestService",["Environment","JWTService",function(Environment,JWTService){"ngInject";function get(path,params){var url=buildDriveApiUrl(path);return JWTService.sendAuthenticated({method:"GET",url:url,params:params||{}})}function head(path){var url=buildDriveApiUrl(path);return JWTService.sendAuthenticated({method:"HEAD",url:url,bypassErrorInterceptor:!0})}function buildDriveApiUrl(path){return Environment.getAbsoluteDriveApiEndpoint()+"/"+path}this.get=get,this.head=head,this.buildDriveApiUrl=buildDriveApiUrl}]),angular.module("juco.mobile.drive").service("DriveService",["DriveRestService","PlatformInfoService","REST","CurrentUser","ResourceType",function(DriveRestService,PlatformInfoService,REST,CurrentUser,ResourceType){function getDrives(){return DriveRestService.get(REST.drive.BASE())}function getDrive(driveId){var idWithType=addIdTypeIfNecessary(driveId,ResourceType.SHARE);return DriveRestService.get(REST.drive.DRIVE(idWithType))}function getDocuments(id,offset,limit){var params={offset:offset,limit:limit};if(id.startsWith(ResourceType.SHARE))return DriveRestService.get(REST.drive.SHARE_DOCUMENTS(id),params).then(mapDriveDocumentList(id));var folderIdWithoutType=stripIdTypeIfPresent(id,ResourceType.DRIVE_DOCUMENT);return DriveRestService.get(REST.drive.DOCUMENTS(folderIdWithoutType),params).then(mapDriveDocumentList(folderIdWithoutType))}function mapDriveDocumentList(folderId){return function(driveDocumentList){var path=driveDocumentList.documentPath.path,folder=path.length>0?path[path.length-1]:null,hasParent=path.length>1,documents=void 0;if(null===folder)throw"Unable to load folder with id "+folderId;return folder.name=hasParent?folder.name:driveDocumentList.documentPath.rootItem.name,documents=driveDocumentList.documents.map(mapDriveDocument),{folder:folder,totalDocumentCount:driveDocumentList.numberOfDocs,documents:documents}}}function mapDriveDocument(driveDocument){return{id:addIdTypeIfNecessary(driveDocument.id,ResourceType.DRIVE_DOCUMENT),name:driveDocument.name,type:driveDocument.documentType===DriveDocumentType.FILE?DocumentType.DOCUMENT:DocumentType.FOLDER,fileType:driveDocument.documentType===DriveDocumentType.FILE?driveDocument.extension:void 0,size:driveDocument.documentType===DriveDocumentType.FILE?driveDocument.size:void 0}}function getVideoPreview(documentId){return getAccessToken(documentId).then(function(token){return DriveRestService.head(REST.drive.PREVIEW_IMAGE(token)).then(function(){return{coverImage:getPreviewImageUrl(token),video:getVideoPreviewUrl(token)}})})}function getVideoPreviewUrl(accessToken){return DriveRestService.buildDriveApiUrl(REST.drive.PREVIEW_VIDEO(accessToken))}function getPreviewImageUrl(accessToken){return DriveRestService.buildDriveApiUrl(REST.drive.PREVIEW_IMAGE(accessToken))}function getAccessToken(documentId){var id=stripIdTypeIfPresent(documentId,ResourceType.DRIVE_DOCUMENT);return DriveRestService.get(REST.drive.ACCESS_TOKEN(id))}function stripIdTypeIfPresent(id,type){return id&&id.startsWith(type)?id.substring(type.length+1):id}function addIdTypeIfNecessary(id,type){return!id||id.startsWith(type)?id:type+","+id}var DriveDocumentType={FILE:"FILE",FOLDER:"FOLDER"},DocumentType={DOCUMENT:"DOCUMENT",FOLDER:"FOLDER"};this.getDrives=getDrives,this.getDrive=getDrive,this.getDocuments=getDocuments,this.getVideoPreview=getVideoPreview}]),angular.module("juco.mobile").config(["$stateProvider",function($stateProvider){var resolveEntity=function($stateParams,EntityService){return $stateParams.entityId?EntityService.getEntityById($stateParams.entityId).then(null,function(error){$stateParams.error=error.info}):($stateParams.error="entity.noEntityIdProvided",null)};resolveEntity.$inject=["$stateParams","EntityService"];var resolveAdditionalHeaderStyles=function($stateParams,EntityService){return EntityService.getEntityById($stateParams.entityId).then(function(entity){return entity?"header-colored-background app-"+entity.appId+"-bg-color":""},function(){return""})};$stateProvider.state("main.entity",{url:"entity/:entityId",templateUrl:"scripts/entity/controller/entity.html",controller:"EntityController",params:{showInvitationActions:null},data:{showViewLoading:!0,additionalHeaderStyles:resolveAdditionalHeaderStyles},resolve:{entityId:juco.fromStateParams("entityId"),entity:resolveEntity,countPerChildType:["$stateParams","EntityChildrenService","ENUMS",function($stateParams,EntityChildrenService,ENUMS){return $stateParams.entityId?EntityChildrenService.getChildEntities($stateParams.entityId,0,0,ENUMS.durationFilter.ALL).then(null,function(error){$stateParams.error=error.info}):($stateParams.error="entity.noEntityIdProvided",null)}],entityThemeResolved:["$stateParams","ThemeService",function($stateParams,ThemeService){return!!$stateParams.entityId&&ThemeService.resolveThemeByEntityId($stateParams.entityId)}]}}).state("main.entity.workstream",{url:"/workstream",views:{content:"feed"},params:{appId:void 0},resolve:{appId:["$transition$",function($transition$){return $transition$.params().appId}],feedId:["$transition$",function($transition$){return $transition$.params().entityId}]},data:{autoscrollDisabled:!0}}).state("main.entity.baseData",{url:"/info?anchor",views:{content:{templateUrl:"scripts/entity/controller/entity-info.html",controller:"EntityInfoController",controllerAs:"entityInfo"}},resolve:{anchor:juco.fromStateParams("anchor")}}).state("main.entity.wiki",{url:"/wiki?anchor",views:{content:{templateUrl:"scripts/entity/controller/wiki.html",controller:"WikiController"}},resolve:{anchor:juco.fromStateParams("anchor")}}).state("main.entity.multiWiki",{url:"/multiwiki?anchor",views:{content:{templateUrl:"scripts/entity/controller/wiki.html",controller:"MultiWikiController"}},resolve:{anchor:juco.fromStateParams("anchor")}}).state("main.entity.raweditors",{url:"/raweditors?anchor",views:{content:{templateUrl:"scripts/entity/controller/raw-editor.html",controller:"RawEditorController",controllerAs:"rawEditor"}},resolve:{anchor:juco.fromStateParams("anchor")}}).state("main.entity.document",{url:"/documents",views:{content:{templateUrl:"scripts/entity/controller/document.html",controller:"DocumentsController"}}}).state("main.entity.children",{url:"/children/:childType",views:{content:{templateUrl:"scripts/entity/controller/child-entities.html",controller:"ChildEntitiesController"}},resolve:{parentId:juco.fromStateParams("entityId"),childType:juco.fromStateParams("childType")}}).state("main.myEntity",{url:"myEntity/:entityTypes",templateUrl:"scripts/my-content/controller/my-content-entities.html",controller:"MyContentEntityController",params:{title:"entity.myEntities"},data:{titleKey:juco.fromStateParams("title")},resolve:juco.resolve("entityTypes","title")}).state("main.allEntities",{url:"allEntities/:entityTypes",templateUrl:"scripts/entity/controller/all-entities.html",controller:"AllEntitiesController",params:{title:"entity.allEntities"},data:{titleKey:juco.fromStateParams("title")},controllerAs:"vm",resolve:juco.resolve("entityTypes","title")})}]),angular.module("juco.mobile.entity").controller("AllEntitiesController",["EntityService","MessageHandler","$scope","$state","entityTypes",function(EntityService,MessageHandler,$scope,$state,entityTypes){function onEntitiesLoaded(searchResult){self.entities=self.entities.concat(searchResult.subList),self.hasMore=searchResult.totalSize>self.entities.length,self.loading=!1}function onErrorLoadingEntities(){var errorMessage="entity.errorLoadingEntities";self.loading=!1,MessageHandler.error(errorMessage),self.error=errorMessage}function loadEntities(){self.loading=!0;var offset=self.entities.length;EntityService.getEntities(entityTypes,offset,batchSize).then(onEntitiesLoaded,onErrorLoadingEntities)}function init(){self.entities=[],self.entityTypes=entityTypes,$scope.$on("jc-fetch-next-entities",function(){self.loading||loadEntities()}),loadEntities()}var self=this,batchSize=25;init()}]),angular.module("juco.controller").controller("ChildEntitiesController",["$scope","parentId","childType","EntityChildrenService","MessageHandler","CONFIG","ENUMS",function($scope,parentId,childType,EntityChildrenService,MessageHandler,CONFIG,ENUMS){function init(){$scope.loading=!1,$scope.showErrorMessage=!1,$scope.hasMore=!1,$scope.childEntities=[],$scope.showFilter=!1,$scope.filterValues=[{filter:ENUMS.durationFilter.FUTURE,i18nKey:"entity.upcomingEntities"},{filter:ENUMS.durationFilter.PAST,i18nKey:"entity.pastEntities"}],$scope.selectedFilter=$scope.filterValues[0],$scope.$on("jc-fetch-next-children",fetchNextChildren),$scope.onFilterChange=onFilterChange,parentId?childType?($scope.childType=childType,$scope.loading=!0,fetchNextChildren()):($scope.showErrorMessage=!0,MessageHandler.error("entity.noEntityTypeProvided")):($scope.showErrorMessage=!0,MessageHandler.error("entity.noEntityIdProvided"))}function addChildren(children){lastFetchOffset===fetchOffset&&lastDurationfilter===$scope.selectedFilter.filter&&($scope.loading=!1,isFetchingData=!1,$scope.childEntities=$scope.childEntities.concat(children.childEntities.subList),$scope.totalSize=children.childEntities.totalSize,fetchOffset+=fetchCount,$scope.hasMore=fetchOffset<children.childEntities.totalSize,$scope.showFilter=children.hasDuration)}function fetchNextChildren(){isFetchingData||(isFetchingData=!0,lastFetchOffset=fetchOffset,lastDurationfilter=$scope.selectedFilter.filter,EntityChildrenService.getChildEntitiesByIdAndChildType(parentId,childType,fetchOffset,fetchCount,lastDurationfilter).then(addChildren,function(){$scope.loading=!1,$scope.showErrorMessage=!0,isFetchingData=!1}))}function reloadChildren(){lastFetchOffset=void 0,lastDurationfilter=void 0,fetchOffset=0,isFetchingData=!1,$scope.loading=!0,$scope.showErrorMessage=!1,$scope.hasMore=!1,$scope.childEntities=[],fetchNextChildren()}function onFilterChange(value){$scope.selectedFilter=value,reloadChildren()}var lastFetchOffset,lastDurationfilter,fetchCount=25,fetchOffset=0,isFetchingData=!1;init()}]),angular.module("juco.mobile.entity").controller("EntityController",["$scope","entityId","entity","countPerChildType","entityThemeResolved","$stateParams","$state","EntityService","ErrorHandler","ENTITY","StateUtil","MessageHandler","$q","EntityActionsBuilder","EntityUtil",function($scope,entityId,entity,countPerChildType,entityThemeResolved,$stateParams,$state,EntityService,ErrorHandler,ENTITY,StateUtil,MessageHandler,$q,EntityActionsBuilder,EntityUtil){function handleError(error){error?(ErrorHandler.handleServerError(error),error.data&&"FORBIDDEN"===error.data.code?$scope.error="entity.entityNotVisible":$scope.error="exception.anErrorOccurred"):entityId?ErrorHandler.showErrorPage(404,MessageHandler.createErrorMessage("entity.errorGettingEntityFromServer")):ErrorHandler.showErrorPage(400,MessageHandler.createErrorMessage("entity.noEntityIdProvided"))}function buildMenu(){$scope.menuEntries=$scope.entityComponents.length>1?$scope.entityComponents.filter(function(c){return c!==$scope.selectedComponent}).concat($scope.entityActions):$scope.entityActions}function getSelectedComponent(entity,availableComponents){if(availableComponents.length>=1){var entityStateParams={entityId:entityId};return StateUtil.getCurrentComponentByState(availableComponents,entityStateParams)}}function toggleShowSelectAttendanceStatus(){$scope.showSelectAttendanceStatus=!$scope.showSelectAttendanceStatus&&$scope.entityActions.length>0}function onMenuEntrySelected(entry){switch(entry.type){case ENTITY.menuEntryType.ATTENDANCE_ACTION:entry.action().then(EntityUtil.reloadEntity);break;case ENTITY.menuEntryType.SUBSCRIPTION_ACTION:entry.action().then(MessageHandler.info).then(updateMenu);break;case ENTITY.menuEntryType.SUB_COMPONENT:selectComponent(entry).then(buildMenu)}}function selectComponent(selectedComponent){return $scope.selectedComponent=selectedComponent,$state.go(selectedComponent.state,selectedComponent.stateParams)}function updateMenu(){return EntityService.getEntityById($scope.entity.id).then(function(entity){$scope.entity=entity,$scope.entityActions=EntityActionsBuilder.getEntityActions(entity),buildMenu()})}var ctrl=this;ctrl.$onInit=function(){return $scope.entity=null,$scope.selectAttendanceStatusMessage="",$scope.toggleShowSelectAttendanceStatus=toggleShowSelectAttendanceStatus,$scope.onMenuEntrySelected=onMenuEntrySelected,entityId?entity&&countPerChildType?($scope.entityType=entity.type,$scope.entity=entity,$scope.appId=entity.appId,$scope.isEvent=entity.memberWorkflow===ENTITY.entityMemberWorkflow.EVENT,$scope.isEvent&&($scope.selectAttendanceStatusMessage="entity.willYouAttendThisEntity"),$scope.entityActions=EntityActionsBuilder.getEntityActions(entity),$scope.entityComponents=EntityUtil.getEntityComponents(entity,countPerChildType),$scope.selectedComponent=getSelectedComponent(entity,$scope.entityComponents),$scope.selectedComponent?buildMenu():selectComponent($scope.entityComponents[0]).then(buildMenu),void($stateParams.showInvitationActions&&($scope.showSelectAttendanceStatus=!0))):void handleError($stateParams.error):void handleError()}}]),angular.module("juco.controller").controller("EntityInfoController",["EntityService","ErrorHandler","MessageHandler","i18nextFilter","dateFilter","locationUtil","entityId","anchor",function(EntityService,ErrorHandler,MessageHandler,i18nextFilter,dateFilter,locationUtil,entityId,anchor){function init(){self.loading=!1,self.showErrorMessage=!1,self.baseData=null,self.registrationDeadline=null,self.time=null,self.visibilityRules=[],self.joiningRules=[],self.joinRequestRules=[],self.invitingRules=[],self.invitingExternalRules=[],self.visibilityIconClass=null,entityId?(self.loading=!0,EntityService.getEntityBaseDataById(entityId).then(updateScope,function(){self.loading=!1,self.showErrorMessage=!0})):(self.showErrorMessage=!0,MessageHandler.error("entity.noEntityIdProvided"))}function updateScope(entityBaseData){return entityBaseData?(buildBaseData(entityBaseData),void(anchor&&locationUtil.replaceAndScrollToAnchor(anchor,!0))):void ErrorHandler.showErrorPage(404,MessageHandler.createErrorMessage("entity.errorGettingEntityFromServer"))}function createTime(baseData){var dateTimeFormat="date.dateTimeFormat";return baseData.startAt&&baseData.endAt?dateFilter(baseData.startAt,i18nextFilter(dateTimeFormat))+" - "+dateFilter(baseData.endAt,i18nextFilter(dateTimeFormat))+(baseData.timeZone?" ["+baseData.timeZone+"]":""):null}function buildBaseData(baseData){self.baseData=baseData,self.registrationDeadline=baseData.registrationDeadline?new Date(baseData.registrationDeadline):null,self.time=createTime(baseData),self.visibilityRules=translateRoles(baseData.entityPrivacySettings.visibilityRules),self.joiningRules=translateRoles(baseData.entityPrivacySettings.joiningRules),self.joinRequestRules=translateRoles(baseData.entityPrivacySettings.joinRequestRules),self.invitingRules=translateRoles(baseData.entityPrivacySettings.invitingRules),self.invitingExternalRules=translateRoles(baseData.entityPrivacySettings.invitingExternalRules),baseData.entityPrivacySettings.workstreamPublicRolesExists?self.visibilityIconClass=baseData.entityPrivacySettings.workstreamPublicVisible?"fa-unlock":"fa-lock":self.visibilityIconClass="",self.loading=!1}function translateRoles(roles){return roles.map(function(role){return i18nextFilter("roles."+role)}).join(", ")}var self=this;init()}]),angular.module("juco.controller").controller("MultiWikiController",["$scope","entityId","anchor","EntityService","MessageHandler","locationUtil",function($scope,entityId,anchor,EntityService,MessageHandler,locationUtil){function init(){$scope.loading=!1,$scope.showErrorMessage=!1,entityId?($scope.loading=!0,EntityService.getMultiWikiByEntityId(entityId).then(updateScope,function(){$scope.loading=!1,$scope.showErrorMessage=!0})):($scope.showErrorMessage=!0,MessageHandler.error("entity.noEntityIdProvided"))}function updateScope(multiWiki){return $scope.loading=!1,multiWiki?($scope.wiki=multiWiki.filter(function(section){return section.headline||section.text}),void(anchor&&locationUtil.replaceAndScrollToAnchor(anchor,!0))):void MessageHandler.error("entity.errorGettingMultiWikiFromServer")}init()}]),angular.module("juco.controller").controller("RawEditorController",["EntityService","ErrorHandler","MessageHandler","locationUtil","entityId","anchor",function(EntityService,ErrorHandler,MessageHandler,locationUtil,entityId,anchor){function init(){entityId?(self.loading=!0,EntityService.getRawEditorsByEntityId(entityId).then(handleLoadRawEditors,function(){self.loading=!1,self.showErrorMessage=!0,MessageHandler.error("entity.errorGettingRawEditorsFromServer")})):(self.showErrorMessage=!0,MessageHandler.error("entity.noEntityIdProvided"))}function handleLoadRawEditors(rawEditors){self.loading=!1,self.rawEditors=rawEditors.filter(function(editor){return editor.text}),anchor&&locationUtil.replaceAndScrollToAnchor(anchor,!0)}var self=this;init()}]),angular.module("juco.controller").controller("WikiController",["$scope","entityId","anchor","EntityService","MessageHandler","locationUtil",function($scope,entityId,anchor,EntityService,MessageHandler,locationUtil){function init(){$scope.loading=!1,$scope.showErrorMessage=!1,entityId?($scope.loading=!0,EntityService.getWikiByEntityId(entityId).then(updateScope,function(){$scope.loading=!1,$scope.showErrorMessage=!0})):($scope.showErrorMessage=!0,MessageHandler.error("entity.noEntityIdProvided"))}function updateScope(wiki){return $scope.loading=!1,wiki?($scope.wiki=wiki.filter(function(section){return section.headline||section.text}),void(anchor&&locationUtil.replaceAndScrollToAnchor(anchor,!0))):void MessageHandler.error("entity.errorGettingWikiFromServer")}init()}]),angular.module("juco.directives").directive("entity",["$compile","$state",function($compile,$state){function goToEntity(id){$state.go("main.entity",{entityId:id},{reload:!0})}function linker(scope,element){var innerHtml=element.html();scope.goToEntity=goToEntity,scope.notification&&!scope.compactView&&(innerHtml='<a class="jc-notification-color" ng-click="goToEntity(notification.entity.id);">'+innerHtml+"</a>"),element.html(innerHtml),$compile(element.contents())(scope)}return{restrict:"E",link:linker}}]),angular.module("juco.filters").filter("jcEntityClass",[function(){return function(entityType,prefix){return entityType?[prefix?prefix:"entity-type-",entityType.toLowerCase()].join(""):null}}]),angular.module("juco.mobile.entity").filter("jcEntityDate",["DateUtil","$i18next","dateFilter",function(DateUtil,$i18next,dateFilter){function time(d){return dateFilter(d,$i18next("date.timeFormat"))}function date(d){return dateFilter(d,$i18next("date.dateFormat"))}function dateTime(d){return dateFilter(d,$i18next("date.dateTimeFormat"))}return function(entity){var start=entity.startAt,end=entity.endAt;return entity?DateUtil.isAllDayEvent(start,end)?date(start)+" - "+date(end):DateUtil.isSameDay(start,end)?date(start)+" "+time(start)+" - "+time(end):dateTime(start)+" - "+dateTime(end):""}}]),angular.module("juco.constants").constant("ENTITY",function(){var eventWorkflowStatus={NONE:{name:"NONE",key:"entity.youAreNotMember"},IS_ATTENDING:{name:"IS_ATTENDING",key:"entity.attend"},IS_NOT_ATTENDING:{name:"IS_NOT_ATTENDING",key:"entity.doNotAttend"},IS_MAYBE_ATTENDING:{name:"IS_MAYBE_ATTENDING",key:"entity.undecided"},IS_ON_WAITLIST:{name:"IS_ON_WAITLIST",key:"entity.youAreOnWaitlist"},IS_INVITED:{name:"IS_INVITED",key:"entity.youHaveAnInvitation"},HAS_REJECTED_INVITATION:{name:"HAS_REJECTED_INVITATION",key:"entity.youRejectedTheInvitation"}},memberWorkflowStatus={NONE:{name:"NONE",key:"entity.youAreNotMember"},MEMBER:{name:"MEMBER",key:"entity.youAreMember"},HAS_REJECTED:{name:"HAS_REJECTED",key:"entity.youRejectedTheInvitation"},HAS_SENT_JOINREQUEST:{name:"HAS_SENT_JOINREQUEST",key:"entity.youHaveSentAJoinRequest"},HAS_INVITATION:{name:"HAS_INVITATION",key:"entity.youHaveAnInvitation"}};return{membershipActions:{JOIN:{name:"JOIN",key:"entity.join",targetMemberWorkflowStatus:memberWorkflowStatus.MEMBER},LEAVE:{name:"LEAVE",key:"entity.leave",targetMemberWorkflowStatus:memberWorkflowStatus.NONE},ACCEPT_INVITATION:{name:"ACCEPT_INVITATION",key:"entity.acceptInvitation",targetMemberWorkflowStatus:memberWorkflowStatus.MEMBER},ACCEPT_DECLINED_INVITATION:{name:"ACCEPT_DECLINED_INVITATION",key:"entity.acceptDeclinedInvitation",targetMemberWorkflowStatus:memberWorkflowStatus.MEMBER},DECLINE_INVITATION:{name:"DECLINE_INVITATION",key:"entity.declineInvitation",targetMemberWorkflowStatus:memberWorkflowStatus.HAS_REJECTED},SEND_JOIN_REQUEST:{name:"SEND_JOIN_REQUEST",key:"entity.sendJoinRequest",targetMemberWorkflowStatus:memberWorkflowStatus.HAS_SENT_JOINREQUEST},WITHDRAW_JOIN_REQUEST:{name:"WITHDRAW_JOIN_REQUEST",key:"entity.withdrawJoinRequest",targetMemberWorkflowStatus:memberWorkflowStatus.NONE},ACCEPT_JOIN_REQUEST:{name:"ACCEPT_JOIN_REQUEST",key:"entity.acceptJoinRequest",targetMemberWorkflowStatus:memberWorkflowStatus.MEMBER},DECLINE_JOIN_REQUEST:{name:"DECLINE_JOIN_REQUEST",key:"entity.declineJoinRequest",targetMemberWorkflowStatus:memberWorkflowStatus.NONE}},eventActions:{EVENT_ATTEND:{name:"EVENT_ATTEND",key:"entity.doAttend",targetEventWorkflowStatus:eventWorkflowStatus.IS_ATTENDING},EVENT_MAYBE_ATTEND:{name:"EVENT_MAYBE_ATTEND",key:"entity.undecided",targetEventWorkflowStatus:eventWorkflowStatus.IS_MAYBE_ATTENDING},EVENT_DONT_ATTEND:{name:"EVENT_DONT_ATTEND",key:"entity.doNotAttend",targetEventWorkflowStatus:eventWorkflowStatus.IS_NOT_ATTENDING},DECLINE_INVITATION:{name:"DECLINE_INVITATION",key:"entity.declineInvitation",targetEventWorkflowStatus:eventWorkflowStatus.HAS_REJECTED_INVITATION},LEAVE:{name:"LEAVE",key:"entity.leave",targetEventWorkflowStatus:eventWorkflowStatus.NONE,targetMemberWorkflowStatus:memberWorkflowStatus.NONE}},subscriptionActions:{SUBSCRIBE:{name:"SUBSCRIBE",key:"entity.subscribe"},ENABLE_NOTIFICATIONS:{name:"ENABLE_NOTIFICATIONS",key:"entity.enableNotifications"},DISABLE_NOTIFICATIONS:{name:"DISABLE_NOTIFICATIONS",key:"entity.disableNotifications"},UNSUBSCRIBE:{name:"UNSUBSCRIBE",key:"entity.unsubscribe"}},entityMemberWorkflow:{MEMBER:"MEMBER",EVENT:"EVENT"},defaultAttendanceStatus:{key:"entity.youAreNotMember",icon:"fa-times"},menuEntryType:{ATTENDANCE_ACTION:"ATTENDANCE_ACTION",SUBSCRIPTION_ACTION:"SUBSCRIPTION_ACTION",SUB_COMPONENT:"SUB_COMPONENT"}}}()),angular.module("juco.mobile.entity").factory("EntityActionsBuilder",["EntityService","ENTITY","ArrayUtil","ObjectUtil","CurrentUser","$q",function(EntityService,ENTITY,ArrayUtil,ObjectUtil,CurrentUser,$q){function buildActions(actions,allowedActions){return Object.keys(actions).filter(function(key){return ArrayUtil.contains(allowedActions,key)}).map(function(key){return actions[key]})}function getAllowedEventActions(entity){return buildActions(ENTITY.eventActions,entity.memberStatus.allowedEditorActions).map(function(action){return createAttendanceAction(entity,action)})}function getAllowedMembershipActions(entity){return buildActions(ENTITY.membershipActions,entity.memberStatus.allowedEditorActions).map(function(action){return createAttendanceAction(entity,action)})}function getAllowedSubscriptionActions(entity){return buildActions(ENTITY.subscriptionActions,entity.memberStatus.allowedEditorActions).map(function(action){return createSubscriptionAction(entity,action)})}function createAttendanceAction(entity,action){var targetMemberStatus={eventWorkflowStatus:ObjectUtil.getProperty(action.targetEventWorkflowStatus,"name"),memberWorkflowStatus:ObjectUtil.getProperty(action.targetMemberWorkflowStatus,"name"),allowedEditorActions:[]};return{type:ENTITY.menuEntryType.ATTENDANCE_ACTION,i18nKey:action.key,context:entity.type,action:function(){return busy?$q.reject("update already in progress"):(busy=!0,EntityService.updateMemberStatus(CurrentUser.getId(),entity.id,targetMemberStatus)["finally"](function(){busy=!1}))}}}function createSubscriptionAction(entity,_action){return{type:ENTITY.menuEntryType.SUBSCRIPTION_ACTION,i18nKey:_action.key,context:entity.type,action:function(){if(!busy){busy=!0;var promise=void 0;switch(_action.name){case ENTITY.subscriptionActions.SUBSCRIBE.name:promise=EntityService.subscribe(entity.id).then(function(){return"entity.successfullySubscribed"});break;case ENTITY.subscriptionActions.UNSUBSCRIBE.name:promise=EntityService.unsubscribe(entity.id).then(function(){return"entity.successfullyUnsubscribed"});break;case ENTITY.subscriptionActions.ENABLE_NOTIFICATIONS.name:promise=EntityService.subscribe(entity.id).then(function(){return"entity.successfullyEnabledNotifications"});break;case ENTITY.subscriptionActions.DISABLE_NOTIFICATIONS.name:promise=EntityService.subscribe(entity.id,!0).then(function(){return"entity.successfullyDisabledNotifications"});break;default:promise=$q.reject("unknown subscription action")}return promise["finally"](function(){busy=!1})}return $q.reject("update already in progress")}}}function getEntityActions(entity){var isEvent=entity.memberWorkflow===ENTITY.entityMemberWorkflow.EVENT,allowedAttendanceActions=isEvent?getAllowedEventActions(entity):getAllowedMembershipActions(entity),allowedSubscriptionActions=getAllowedSubscriptionActions(entity);return allowedSubscriptionActions.concat(allowedAttendanceActions)}var busy=!1;return{getEntityActions:getEntityActions}}]),angular.module("juco.services").service("EntityChildrenService",["JucoRestService","Cache","REST",function(JucoRestService,Cache,REST){var childEntitiesCache=Cache.createCache("childEntitiesCache"),cacheKey=function(id,offset,count,sortBy,childrenType,durationFilter){return[id,offset,count,sortBy||"",durationFilter||"",childrenType||""].join("#")};this.getChildEntitiesByIdAndChildType=function(parentId,childEntityType,offset,count,durationFilter,sortBy,bypassErrorInterceptor){var params={offset:offset,numberOfResults:count,durationFilter:durationFilter,sortBy:sortBy};return JucoRestService.getCached(REST.childEntities.BASE+"/"+parentId+"/"+childEntityType,params,childEntitiesCache,cacheKey(parentId,offset,count,sortBy,durationFilter,childEntityType),bypassErrorInterceptor)},this.getChildEntities=function(parentId,offset,count,durationFilter,sortBy,bypassErrorInterceptor){var params={offset:offset,numberOfResults:count,durationFilter:durationFilter,sortBy:sortBy};return JucoRestService.getCached(REST.childEntities.BASE+"/"+parentId,params,childEntitiesCache,cacheKey(parentId,offset,count,sortBy,durationFilter),bypassErrorInterceptor)}}]),angular.module("juco.services").service("EntityService",["JucoRestService","SearchService","Cache","REST","$rootScope","EVENTS",function(JucoRestService,SearchService,Cache,REST,$rootScope,EVENTS){function removeEntityFromCaches(entityId){entityCache.remove(entityId),baseDataCache.remove(entityId),wikiCache.remove(entityId),multiWikiCache.remove(entityId),rawEditorCache.remove(entityId),myContentCache.removeAll(),entitiesCache.removeAll()}function getMyContentByProfileIdAndType(entityTypes,offset,durationFilter){var params={},key=entityTypes;return durationFilter&&(params.durationFilter=durationFilter,key+=","+durationFilter),offset&&(params.offset=offset,key+=","+offset),JucoRestService.getCached(REST.myContent.TYPES(entityTypes),params,myContentCache,key)}function getEntityById(id,bypassErrorInterceptor){return JucoRestService.getCached(REST.entity.ENTITY(id),{},entityCache,id,bypassErrorInterceptor)}function getEntityBaseDataById(id){return JucoRestService.getCached(REST.entity.BASE_DATA(id),{},baseDataCache,id)}function getWikiByEntityId(id){return JucoRestService.getCached(REST.entity.WIKI(id),{},wikiCache,id)}function getMultiWikiByEntityId(id){return JucoRestService.getCached(REST.entity.MULTI_WIKI(id),{},multiWikiCache,id)}function getRawEditorsByEntityId(id){return JucoRestService.getCached(REST.entity.RAW_EDITORS(id),{},rawEditorCache,id)}function getMemberStatus(entityId,memberId){return JucoRestService.get(REST.entity.MEMBERS(entityId,memberId))}function updateMemberStatus(personId,entityId,targetMemberStatus){var memberInfo={memberId:personId,entityId:entityId,entityMemberStatus:targetMemberStatus};return JucoRestService.put(REST.entity.MEMBERS(entityId,personId),memberInfo).then(function(updatedMemberStatus){return removeEntityFromCaches(updatedMemberStatus.entityId),$rootScope.$broadcast(EVENTS.onEntityMemberStatusChanged,{entityId:updatedMemberStatus.entityId,updatedMemberInfo:updatedMemberStatus}),updatedMemberStatus})}function getEntities(entityTypes,offset,batchSize){var cacheKey=entityTypes+":"+offset+":"+batchSize;return JucoRestService.getCached(REST.entity.ENTITIES_BY_TYPES(entityTypes),{offset:offset,count:batchSize},entitiesCache,cacheKey)}function subscribe(entityId,disableNotifications){var data=disableNotifications?'"SUBSCRIBED_WITHOUT_MAIL"':'"SUBSCRIBED"';return JucoRestService.put(REST.entity.SUBSCRIPTION(entityId),data).then(function(){return removeEntityFromCaches(entityId)})}function unsubscribe(entityId){return JucoRestService.put(REST.entity.SUBSCRIPTION(entityId),'"UNSUBSCRIBED"').then(function(){return removeEntityFromCaches(entityId)})}var entityCache=Cache.createCache("entityCache"),entitiesCache=Cache.createCache("entitiesCache"),baseDataCache=Cache.createCache("baseDataCache"),wikiCache=Cache.createCache("wikiCache"),multiWikiCache=Cache.createCache("multiWikiCache"),rawEditorCache=Cache.createCache("rawEditorCache"),myContentCache=Cache.createCache("myContentEntityCache");this.getMyContentByProfileIdAndType=getMyContentByProfileIdAndType,this.getEntityById=getEntityById,this.getEntityBaseDataById=getEntityBaseDataById,this.getWikiByEntityId=getWikiByEntityId,this.getMultiWikiByEntityId=getMultiWikiByEntityId,this.getRawEditorsByEntityId=getRawEditorsByEntityId,this.getMemberStatus=getMemberStatus,this.updateMemberStatus=updateMemberStatus,this.getEntities=getEntities,this.subscribe=subscribe,this.unsubscribe=unsubscribe}]),angular.module("juco.mobile.entity").service("EntityUtil",["CONFIG","EVENTS","ENTITY","ArrayUtil","$state","$rootScope",function(CONFIG,EVENTS,ENTITY,ArrayUtil,$state,$rootScope){function getEntityComponents(entity,childEntities){var modules=entity.modules,tabs=entity.entityTabs,supportedModules=CONFIG.supportedEntityModules.filter(function(element){return element.force||ArrayUtil.containsSome(modules,element.components)}),supportedTabs=CONFIG.supportedEntityTabs.filter(function(element){return element.force||ArrayUtil.containsSome(tabs,element.components)}),result=supportedModules.concat(supportedTabs).sort(sortComponentByOrder),childEntitiesOrder=result[result.length-1].order+1;return childEntities.forEach(function(childrenByType,index){childrenByType.childEntities.totalSize>0&&result.push({i18nKey:"entity.childEntitiesModuleName",state:"main.entity.children",stateParams:{entityId:entity.id,childType:childrenByType.entityType},context:childrenByType.entityType,icon:"fa-"+childrenByType.entityTypeIcon,order:childEntitiesOrder+index})}),result.map(function(c){return c.type=ENTITY.menuEntryType.SUB_COMPONENT,c.stateParams=c.stateParams||{},c.stateParams.appId=entity.appId,c.stateParams.entityId=entity.id,c})}function sortComponentByOrder(componentA,componentB){return componentA.order-componentB.order}function reloadEntity(){var updatedParams=angular.copy($state.params);updatedParams.showInvitationActions=!1,$state.transitionTo($state.current,updatedParams,{reload:!0,inherit:!1,notify:!0}).then(function(){$state.is("main.entity.workstream")&&$rootScope.$broadcast(EVENTS.onWorkstreamInvalidated)})}this.getEntityComponents=getEntityComponents,
this.reloadEntity=reloadEntity}]),angular.module("juco.mobile.feed",["juco.mobile.configuration","juco.constants","juco.shared.common","juco.services","juco.mobile.quill","ngQuill"]),angular.module("juco.mobile.feed").service("FeedService",FeedService);var composerImagePreview={bindings:{file:"<",onRemoveAttachment:"&"},templateUrl:"scripts/feed/composer-image-preview/composer-image-preview.html",controller:"ComposerImagePreviewController"};angular.module("juco.mobile.feed").component("composerImagePreview",composerImagePreview),angular.module("juco.mobile.feed").controller("ComposerImagePreviewController",ComposerImagePreviewController);var composerProgressDialog={bindings:{onAbort:"&"},templateUrl:"scripts/feed/composer-progress-dialog/composer-progress-dialog.html"};angular.module("juco.mobile.feed").component("composerProgressDialog",composerProgressDialog);var fakeComposer={bindings:{feedId:"<"},templateUrl:"scripts/feed/fake-composer/fake-composer.html",controller:"FakeComposerController"};angular.module("juco.mobile.feed").component("fakeComposer",fakeComposer),angular.module("juco.mobile.feed").controller("FakeComposerController",FakeComposerController);var feed={bindings:{appId:"<",feedId:"<"},templateUrl:"scripts/feed/feed/feed.html",controller:"FeedController"};angular.module("juco.mobile.feed").component("feed",feed).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.feed",{url:"feed/{appId}",component:"feed",params:{appId:void 0},resolve:{appId:["$transition$","CONFIG",function($transition$,CONFIG){return $transition$.params().appId||CONFIG.defaultFeed}],feedId:["$transition$","CONFIG",function($transition$,CONFIG){return"FEED,"+($transition$.params().appId||CONFIG.defaultFeed)}]},data:{editorDisabled:!0,initialScrollTop:!0,autoscrollDisabled:!0,titleKey:function(){return"header.feed"},titleContext:function($stateParams){return $stateParams.appId},additionalHeaderStyles:function($stateParams){return"header-colored-background app-"+$stateParams.appId+"-bg-color"}}})}]),angular.module("juco.mobile.feed").factory("FeedCache",["Cache",function(Cache){return Cache.createCache("feedCache")}]).controller("FeedController",FeedController),angular.module("juco.mobile.feed").service("FeedAttachments",FeedAttachments),angular.module("juco.mobile.feed").constant("FEED_ATTACHMENT_TYPE",{IMAGE:"IMAGE",DOCUMENT:"DOCUMENT",EXTERNAL_VIDEO:"EXTERNAL_VIDEO",INTERNAL_LINK:"INTERNAL_LINK",EXTERNAL_LINK:"EXTERNAL_LINK",MAILTO_LINK:"MAILTO_LINK"});var feedDocumentAttachment={bindings:{attachment:"<",ignoreClick:"<"},templateUrl:"scripts/feed/feed-attachment/feed-document-attachment/feed-document-attachment.html",controller:"FeedDocumentAttachmentController"};angular.module("juco.mobile.feed").component("feedDocumentAttachment",feedDocumentAttachment),angular.module("juco.mobile.feed").controller("FeedDocumentAttachmentController",FeedDocumentAttachmentController);var feedExternalVideoAttachment={bindings:{attachment:"<",ignoreClick:"<"},templateUrl:"scripts/feed/feed-attachment/feed-external-video-attachment/feed-external-video-attachment.html",controller:"FeedExternalVideoAttachmentController"};angular.module("juco.mobile.feed").component("feedExternalVideoAttachment",feedExternalVideoAttachment),angular.module("juco.mobile.feed").controller("FeedExternalVideoAttachmentController",FeedExternalVideoAttachmentController);var feedImageAttachment={bindings:{attachment:"<",ignoreClick:"<"},templateUrl:"scripts/feed/feed-attachment/feed-image-attachment/feed-image-attachment.html",controller:"FeedImageAttachmentController"};angular.module("juco.mobile.feed").component("feedImageAttachment",feedImageAttachment),angular.module("juco.mobile.feed").controller("FeedImageAttachmentController",FeedImageAttachmentController);var feedLinkAttachment={bindings:{attachment:"<",ignoreClick:"<"},templateUrl:"scripts/feed/feed-attachment/feed-link-attachment/feed-link-attachment.html",controller:"FeedLinkAttachmentController"};angular.module("juco.mobile.feed").component("feedLinkAttachment",feedLinkAttachment),angular.module("juco.mobile.feed").controller("FeedLinkAttachmentController",FeedLinkAttachmentController),angular.module("juco.mobile.feed").directive("feedLinkAttachmentUrl",feedLinkAttachmentUrl),angular.module("juco.mobile.feed").directive("feedMessageAttachment",FeedMessageAttachment);var feedVideoAttachment={bindings:{attachment:"<",showControls:"<"},templateUrl:"scripts/feed/feed-attachment/feed-video-attachment/feed-video-attachment.html",controller:"FeedVideoAttachmentController"};angular.module("juco.mobile.feed").component("feedVideoAttachment",feedVideoAttachment),angular.module("juco.mobile.feed").controller("FeedVideoAttachmentController",FeedVideoAttachmentController);var feedComment={bindings:{comment:"<",appId:"<",onToggleLike:"&",onDeleteComment:"&"},templateUrl:"scripts/feed/feed-comment/feed-comment.html",controller:"FeedCommentController"};angular.module("juco.mobile.feed").component("feedComment",feedComment),angular.module("juco.mobile.feed").controller("FeedCommentController",FeedCommentController);var feedCommentComposer={bindings:{messageId:"<"},templateUrl:"scripts/feed/feed-comment-composer/feed-comment-composer.html",controller:"FeedCommentComposerController"};angular.module("juco.mobile.feed").component("feedCommentComposer",feedCommentComposer),angular.module("juco.mobile.feed").controller("FeedCommentComposerController",FeedCommentComposerController);var feedComments={bindings:{messageId:"<",appId:"<"},templateUrl:"scripts/feed/feed-comments/feed-comments.html",controller:"FeedCommentsController"};angular.module("juco.mobile.feed").component("feedComments",feedComments),angular.module("juco.mobile.feed").controller("FeedCommentsController",FeedCommentsController),angular.module("juco.mobile.feed").service("CommentService",["JucoRestService","$q","$log","REST","$rootScope","EVENTS",function(JucoRestService,$q,$log,REST,$rootScope,EVENTS){"ngInject";this.getComments=function(parentId,newestFirst,max){var params={parentId:parentId,newestFirst:newestFirst,max:max};return JucoRestService.get(REST.comment.BASE(),params)},this.postComment=function(parentId,text,bypassErrorInterceptor){var params={parentId:parentId,text:text};return JucoRestService.post(REST.comment.BASE(),params,bypassErrorInterceptor).then(function(commentId){return $rootScope.$broadcast(EVENTS.onCommentCreated,{parentId:parentId,commentId:commentId}),commentId})},this.deleteComment=function(commentId,parentId){return JucoRestService.deleteCall(REST.comment.COMMENT(commentId)).then(function(result){return $rootScope.$broadcast(EVENTS.onCommentDeleted,{parentId:parentId,commentId:commentId}),result})},this.likeComment=function(commentId,like){return JucoRestService.put(REST.like.BASE(commentId),angular.toJson(like))}}]);var feedMessage={bindings:{appId:"<",feedId:"<",message:"<",onShowDetails:"&"},templateUrl:"scripts/feed/feed-message/feed-message.html",controller:"FeedMessageController"};angular.module("juco.mobile.feed").component("feedMessage",feedMessage),angular.module("juco.mobile.feed").controller("FeedMessageController",FeedMessageController),angular.module("juco.mobile.feed").constant("FEED_MESSAGE_TYPE",{ENTITY_CREATED:"ENTITY_CREATED",ENTITY_NEW_MEMBERSHIP:"ENTITY_NEW_MEMBERSHIP",ENTITY_DESCRIPTION_UPDATED:"ENTITY_DESCRIPTION_UPDATED",NEWSBLOG_ARTICLE_CREATED:"NEWSBLOG_ARTICLE_CREATED",NEWSBLOG_ARTICLE_UPDATED:"NEWSBLOG_ARTICLE_UPDATED",NEWSBLOG_ARTICLE_COMMENTED:"NEWSBLOG_ARTICLE_COMMENTED",MICROBLOG_POSTING:"MICROBLOG_POSTING",ALBUM_CREATED:"ALBUM_CREATED",ALBUM_IMAGE_CREATED:"ALBUM_IMAGE_CREATED",ALBUM_IMAGE_COMMENTED:"ALBUM_IMAGE_COMMENTED",WIKI_VERSION_CREATED:"WIKI_VERSION_CREATED",DOCUMENT_NEW:"DOCUMENT_NEW",DOCUMENT_NEW_VERSION:"DOCUMENT_NEW_VERSION",DOCUMENT_BLOG_NEW:"DOCUMENT_BLOG_NEW",DOCUMENT_COMMENT:"DOCUMENT_COMMENT",VIDEOLINK_CREATED:"VIDEOLINK_CREATED",VIDEOLINK_COMMENTED:"VIDEOLINK_COMMENTED",PROFILE_UPDATED:"PROFILE_UPDATED",PROFILE_NEW_CONTACT:"PROFILE_NEW_CONTACT",ENTITY_VERSION_PUBLISHED:"ENTITY_VERSION_PUBLISHED",ENTITY_PARENTS_CHANGED:"ENTITY_PARENTS_CHANGED",SURVEY_PUBLISHED:"SURVEY_PUBLISHED",TASK_STATUS_CHANGED:"TASK_STATUS_CHANGED",TASK_ASSIGNED:"TASK_ASSIGNED",DRIVE_DOCUMENT_NEW_VERSION:"DRIVE_DOCUMENT_NEW_VERSION",DRIVE_DOCUMENT_COMMENT:"DRIVE_DOCUMENT_COMMENT"});var feedMessageActions={bindings:{message:"<",appId:"<",onShowDetails:"&"},templateUrl:"scripts/feed/feed-message/feed-message-actions/feed-message-actions.html",controller:"FeedMessageActionsController"};angular.module("juco.mobile.feed").component("feedMessageActions",feedMessageActions),angular.module("juco.mobile.feed").controller("FeedMessageActionsController",FeedMessageActionsController);var feedMessageAttachments={bindings:{attachments:"<",compactView:"<"},templateUrl:"scripts/feed/feed-message/feed-message-attachments/feed-message-attachments.html",controller:"FeedMessageAttachmentsController"};angular.module("juco.mobile.feed").component("feedMessageAttachments",feedMessageAttachments),angular.module("juco.mobile.feed").controller("FeedMessageAttachmentsController",FeedMessageAttachmentsController),angular.module("juco.mobile.feed").directive("feedActivityMessage",FeedActivityMessage),angular.module("juco.mobile.feed").service("FeedActivityMessageTranslationService",FeedActivityMessageTranslationService);var feedMessageContent={bindings:{message:"<",compactView:"<"},templateUrl:"scripts/feed/feed-message/feed-message-content/feed-message-content.html",controller:"FeedMessageContentController"};angular.module("juco.mobile.feed").component("feedMessageContent",feedMessageContent),angular.module("juco.mobile.feed").controller("FeedMessageContentController",FeedMessageContentController),angular.module("juco.mobile.feed").directive("feedQuillMessage",["CONFIG","JcQuill","$compile",function(CONFIG,JcQuill,$compile){"ngInject";function link(scope,element){var foldingOptions={maxTextLength:CONFIG.maxCompactMicroblogTextLength},quillDelta=scope.quillDelta?JSON.parse(scope.quillDelta):null,readOnly=!0,modules={toolbar:!1,LinkEllipsis:{maxUrlLength:CONFIG.maxMicroblogLinkLength},TextEllipsis:!!scope.compactView&&foldingOptions,mention:!1};if(quillDelta){var quill=JcQuill.create(element[0],modules,readOnly);quill.setContents(quillDelta.ops)}else element.html(FALLBACK),$compile(element.contents())(scope)}var FALLBACK='<div jc-html-link-rewrite="::text" jc-additional-link-class="workstream-item-link"></div>';return{restrict:"E",scope:{quillDelta:"<",text:"<",compactView:"<"},link:link}}]);var feedMessageCover={bindings:{mediaAttachments:"<"},templateUrl:"scripts/feed/feed-message/feed-message-cover/feed-message-cover.html",controller:"FeedMessageCoverController"};angular.module("juco.mobile.feed").component("feedMessageCover",feedMessageCover),angular.module("juco.mobile.feed").controller("FeedMessageCoverController",FeedMessageCoverController);var feedMessageCreate={bindings:{targetId:"<",author:"<",files:"<?"},templateUrl:"scripts/feed/feed-message/feed-message-create/feed-message-create.html",controller:"FeedMessageCreateController"};angular.module("juco.mobile.feed").component("feedMessageCreate",feedMessageCreate).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.feedMessageCreate",{url:"feed/{feedId}/create",component:"feedMessageCreate",params:{files:[]},resolve:{targetId:["$transition$",function($transition$){return $transition$.params().feedId}],author:["AuthenticationService","CurrentUser",function(AuthenticationService,CurrentUser){return AuthenticationService.authenticate().then(CurrentUser.getAuthenticatedUserInfo)}],files:["$transition$",function($transition$){return $transition$.params().files}]},data:{titleKey:"workstream.newPost",additionalHeaderStyles:"header-minimal no-menu"}})}]),angular.module("juco.mobile.feed").controller("FeedMessageCreateController",FeedMessageCreateController);var feedMessageDetails={bindings:{message:"<",appId:"<"},templateUrl:"scripts/feed/feed-message/feed-message-details/feed-message-details.html",controller:"FeedMessageDetailsController"};angular.module("juco.mobile.feed").component("feedMessageDetails",feedMessageDetails).config(["$stateProvider",function($stateProvider){function getWorkstreamMessage(FeedService,messageId){var numberOfCommentsToLoad=2;return FeedService.getMessage(messageId,numberOfCommentsToLoad)}function resolveWorkstreamMessage(FeedService,$stateParams){var messageId=$stateParams.messageId;return messageId?getWorkstreamMessage(FeedService,messageId)["catch"](function(error){$stateParams.error=error}):($stateParams.error="workstream.noMessageIdProvided",null)}function resolveAppId(EntityService,FeedService,$stateParams){var messageId=$stateParams.messageId;return messageId?getWorkstreamMessage(FeedService,messageId).then(function(workstreamMessage){return EntityService.getEntityById(workstreamMessage.originId)}).then(function(entity){return entity.appId}):""}function resolveHeaderStyle(EntityService,FeedService,$stateParams){return resolveAppId(EntityService,FeedService,$stateParams).then(function(appId){return appId?"header-colored-background app-"+appId+"-bg-color":""})}function resolveTitleKey(FeedService,$stateParams){var messageId=$stateParams.messageId;return messageId?getWorkstreamMessage(FeedService,messageId).then(function(workstreamMessage){return workstreamMessage.originName}):""}resolveWorkstreamMessage.$inject=["FeedService","$stateParams"],resolveAppId.$inject=["EntityService","FeedService","$stateParams"],$stateProvider.state("main.feedMessage",{url:"feed/message/:messageId",views:{"@main":"feedMessageDetails"},resolve:{message:resolveWorkstreamMessage,appId:resolveAppId},data:{titleKey:resolveTitleKey,additionalHeaderStyles:resolveHeaderStyle,backButton:!0}})}]),angular.module("juco.mobile.feed").controller("FeedMessageDetailsController",FeedMessageDetailsController);var feedMessageEdit={bindings:{message:"<"},templateUrl:"scripts/feed/feed-message/feed-message-edit/feed-message-edit.html",controller:"FeedMessageEditController"};angular.module("juco.mobile.feed").component("feedMessageEdit",feedMessageEdit).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.feedMessage.edit",{url:"/edit",views:{"@main":"feedMessageEdit"}})}]),angular.module("juco.mobile.feed").controller("FeedMessageEditController",FeedMessageEditController);var feedMessageHeader={bindings:{displayActions:"<",message:"<",feedId:"<",onShowDeleteDialog:"&",onEditMessage:"&"},templateUrl:"scripts/feed/feed-message/feed-message-header/feed-message-header.html",controller:"FeedMessageHeaderController"};angular.module("juco.mobile.feed").component("feedMessageHeader",feedMessageHeader),angular.module("juco.mobile.feed").controller("FeedMessageHeaderController",FeedMessageHeaderController);var feedMessageInput={bindings:{message:"<?",author:"<?",targetId:"<?",files:"<?",onPost:"&",onCancel:"&"},templateUrl:"scripts/feed/feed-message/feed-message-input/feed-message-input.html",controller:"FeedMessageInputController"};angular.module("juco.mobile.feed").component("feedMessageInput",feedMessageInput),angular.module("juco.mobile.feed").controller("FeedMessageInputController",FeedMessageInputController);var feedMessageLikes={bindings:{message:"<",appId:"<"},templateUrl:"scripts/feed/feed-message/feed-message-likes/feed-message-likes.html",controller:"FeedMessageLikesController"};angular.module("juco.mobile.feed").component("feedMessageLikes",feedMessageLikes),angular.module("juco.mobile.feed").controller("FeedMessageLikesController",FeedMessageLikesController);var feedMessages={bindings:{appId:"<",feedId:"<",messages:"<"},templateUrl:"scripts/feed/feed-messages/feed-messages.html",controller:"FeedMessagesController"};angular.module("juco.mobile.feed").component("feedMessages",feedMessages),angular.module("juco.mobile.feed").controller("FeedMessagesController",FeedMessagesController);var pinnedFeedMessage={bindings:{message:"<"},templateUrl:"scripts/feed/pinned-feed-message/pinned-feed-message.html",controller:"PinnedFeedMessageController"};angular.module("juco.mobile.feed").component("pinnedFeedMessage",pinnedFeedMessage),angular.module("juco.mobile.feed").controller("PinnedFeedMessageController",PinnedFeedMessageController);var pinnedFeedMessages={bindings:{feed:"<",feedId:"<",onLoadMore:"&",onHideMessages:"&"},templateUrl:"scripts/feed/pinned-feed-messages/pinned-feed-messages.html",controller:"PinnedFeedMessagesController",transclude:!0};angular.module("juco.mobile.feed").component("pinnedFeedMessages",pinnedFeedMessages),angular.module("juco.mobile.feed").controller("PinnedFeedMessagesController",PinnedFeedMessagesController),angular.module("juco.mobile.like",["juco.shared.common","juco.shared.rest","juco.mobile.rest"]),angular.module("juco.mobile.like").service("LikeService",["Cache","JucoRestService","REST",function(Cache,JucoRestService,REST){"ngInject";function cacheKey(itemId,offset,limit){return itemId+"o"+offset+"l"+limit}function getLikers(itemId,offset,limit){return JucoRestService.getCached(REST.like.LIKERS(itemId),{offset:offset||0,limit:limit},likersCache,cacheKey(itemId,offset,limit),!0)}var likersCache=Cache.createCache("likersCache");this.getLikers=getLikers}]);var likes={bindings:{itemId:"<"},templateUrl:"scripts/like/likes/likes.html",controller:"LikesController"};angular.module("juco.mobile.like").component("likes",likes).config(["$stateProvider",function($stateProvider){function resolveHeaderStyle($stateParams){var appId=$stateParams.appId;return appId?"header-colored-background app-"+appId+"-bg-color":""}$stateProvider.state("main.likers",{url:":itemId/likers",component:"likes",params:{appId:void 0},resolve:{itemId:["$transition$",function($transition$){return $transition$.params().itemId}]},data:{titleKey:"like.likes",backButton:!0,additionalHeaderStyles:resolveHeaderStyle}})}]),angular.module("juco.mobile.like").controller("LikesController",LikesController),angular.module("juco.mobile").config(["$stateProvider",function($stateProvider){$stateProvider.state("chat",{parent:"main","abstract":!0,template:'<ui-view autoscroll="autoscrollEnabled"/>',controller:"ChatController",data:{additionalStyles:"jc-mobile-chat app-chat-bg-color",additionalHeaderStyles:"app-chat-bg-color header-colored-background"},resolve:{chatEnabled:["ConfigurationService",function(ConfigurationService){return ConfigurationService.isChatEnabled()}],chatDeprecated:["Environment",function(Environment){return Environment.isJustSocialNative()||Environment.isCordova()}]}}).state("chat.deprecated",{url:"deprecated",templateUrl:"scripts/message/controller/chat-deprecated.html",controller:"ChatDeprecatedController",controllerAs:"vm",data:{additionalHeaderStyles:"header-minimal",additionalStyles:"",titleKey:"message.messages"}}).state("chat.allConversations",{url:"conversations",templateUrl:"scripts/message/controller/all-conversations.html",controller:"AllConversationsController",data:{titleKey:"message.messages"}}).state("chat.conversation",{url:"conversations/:conversationId",templateUrl:"scripts/message/controller/conversation.html",controller:"ConversationController",controllerAs:"conversation",data:{backButton:!0,additionalStyles:"jc-mobile-chat jc-mobile-chat-sub-view",autoscrollDisabled:!0},resolve:juco.resolve("conversationId")}).state("chat.editParticipants",{url:"editparticipants?conversationId",templateUrl:"scripts/message/controller/conversation-participants-editor.html",controller:"ConversationParticipantsEditorController",data:{titleKey:function($stateParams){return $stateParams.conversationId?null:"message.messages"},backButton:!0,additionalStyles:"jc-mobile-chat app-chat-bg-color"},resolve:juco.resolve("conversationId")}).state("chat.editTitle",{url:"edittitle?conversationId",templateUrl:"scripts/message/controller/conversation-title-editor.html",controller:"ConversationTitleEditorController",data:{titleKey:function($stateParams){return $stateParams.conversationId?null:"message.messages"},backButton:!0,additionalStyles:"jc-mobile-chat app-chat-bg-color"},resolve:juco.resolve("conversationId")}).state("chat.deleteConversation",{url:"deleteconversation?conversationId",templateUrl:"scripts/message/controller/conversation-delete-confirm.html",controller:"ConversationDeleteConfirmController",controllerAs:"vm",data:{titleKey:function($stateParams){return $stateParams.conversationId?null:"message.messages"},backButton:!0,additionalStyles:"jc-mobile-chat app-chat-bg-color"},resolve:juco.resolve("conversationId")})}]).run(["$rootScope","$q","EVENTS","MessageReceiverService","XmppService","AuthenticationService","ConfigurationService",function($rootScope,$q,EVENTS,MessageReceiverService,XmppService,AuthenticationService,ConfigurationService){function init(){$rootScope.$on(EVENTS.onUserAuthenticated,onAuthenticated),$rootScope.$on(EVENTS.onUserDeauthenticated,onJabberMessageDeregistrationFn)}function onAuthenticated(){function onJabberMessage(event,message){MessageReceiverService.onJabberMessage(message)}function initChat(enabled){enabled&&(XmppService.loginToChat(),onJabberMessageDeregistrationFn=$rootScope.$on(EVENTS.onJabberMessage,onJabberMessage),AuthenticationService.addBeforeLogoutHandler(function(){return XmppService.logoutOfChat(),$q.resolve()}))}ConfigurationService.isChatEnabled().then(initChat)}var onJabberMessageDeregistrationFn=angular.noop;init()}]),angular.module("juco.mobile.message").controller("AllConversationsController",["$scope","$rootScope","ConversationService","Map","EVENTS","CONFIG","CONVERSATION_SUGGEST_INPUT_ID","XmppService","CurrentUser","$state","ChatMessageType","ConversationTitleUtil","MessageHandler","ResourceType","ConversationType","ConversationMarkAsReadService","TrackingService","$timeout","$window",function($scope,$rootScope,ConversationService,Map,EVENTS,CONFIG,CONVERSATION_SUGGEST_INPUT_ID,XmppService,CurrentUser,$state,ChatMessageType,ConversationTitleUtil,MessageHandler,ResourceType,ConversationType,ConversationMarkAsReadService,TrackingService,$timeout,$window){function init(){$scope.connected=XmppService.isConnected(),$scope.loadingConversations=!1,$scope.hasMoreConversation=!0,$scope.conversations=new Map,$scope.currentUserId=CurrentUser.getId(),$scope.selectedConversationId=void 0,$scope.query="",$scope.suggestions=[],$scope.showSuggestions=!1,$scope.showLoading=!1,$scope.createMultiUserConversation=createMultiUserConversation,$scope.loadNextConversations=loadNextConversations,$scope.handleSuggestionSelect=handleSuggestionSelect,$scope.$on(EVENTS.onNewConversationMessage,onNewConversationMessage),$scope.$on(EVENTS.onJabberConnected,onJabberConnected),$scope.$on(EVENTS.onJabberDisconnected,onJabberDisconnected),$scope.$on(EVENTS.onNewConversation,addConversationOnTop),$scope.$on(EVENTS.onConversationSelectedViaSearch,addConversationOnTop),$scope.$on(EVENTS.onRemovedFromConversation,onRemovedFromConversation),$scope.$on(EVENTS.onConversationMarkedAsRead,onConversationMarkedAsRead),$scope.$on(EVENTS.onConversationSettingsChanged,onConversationSettingsChanged),$scope.$on(EVENTS.onReloadConversations,onReloadConversations),$scope.$on("$stateChangeStart",onStateChangeStart),$scope.$on("jc-fetch-next-conversations",onFetchNextConversations),$rootScope.$on(EVENTS.onConversationTitleChanged,onConversationTitleChanged),loadNextConversations(!0)}function handleSuggestionSelect(item){switch(blurInputField(),item.type){case ResourceType.PROFILE:createAndOpenConversation(item.id);break;case ResourceType.CONVERSATION:$scope.showLoading=!0,$state.go("chat.conversation",{conversationId:item.id}),$scope.showLoading=!1}}function blurInputField(){var inputField=$window.document.getElementById(CONVERSATION_SUGGEST_INPUT_ID.ID);inputField&&inputField.blur()}function createMultiUserConversation(){blurInputField(),createAndOpenConversation(CurrentUser.getId(),$scope.query)}function createAndOpenConversation(participantId,customTitle){var title;participantId===CurrentUser.getId()&&(title=customTitle||ConversationTitleUtil.getDefaultConversationTitle()),ConversationService.startNewConversation([participantId],title).then(function(conversation){$scope.showLoading=!0,conversation.type===ConversationType.MULTI_USER_CHAT?(ConversationMarkAsReadService.markConversationReadImmediately(conversation.id),TrackingService.trackCreateGroupChat("all-conversations"),$state.go("chat.editParticipants",{conversationId:conversation.id})):$state.go("chat.conversation",{conversationId:conversation.id}),$scope.showLoading=!1},function(){MessageHandler.error("conversation.failedToCreateConversation")})}function onNewConversationMessage(event,data){var conversationId=data.conversationId,conversation=angular.copy($scope.conversations.get(conversationId));conversation?(data.message.sentFrom.id!==CurrentUser.getId()&&conversation.unreadMessagesCount.count++,updateConversationTeaser(conversation,data.message),$scope.conversations.putFirst(conversationId,conversation)):($scope.conversations.putFirst(conversationId,void 0),ConversationService.loadConversationTeaser(conversationId).then(function(teaser){teaser.teaserChatMessage||updateConversationTeaser(teaser,data.message),$scope.conversations.put(teaser.id,teaser)}))}function onConversationMarkedAsRead(event,unreadMessagesCount){var conversationId=unreadMessagesCount.conversationId,conversation=$scope.conversations.get(conversationId);conversation&&(conversation.unreadMessagesCount.count=unreadMessagesCount.count||0)}function onConversationSettingsChanged(event,conversationSettings){var conversation=$scope.conversations.get(conversationSettings.conversationId);conversation&&(conversation.muted=conversationSettings.muted)}function updateConversationTeaser(teaser,chatMessage){chatMessage&&chatMessage.type===ChatMessageType.CHAT_MESSAGE&&(teaser.teaserAuthor=chatMessage.sentFrom,teaser.teaserChatMessage=chatMessage)}function onJabberConnected(){$scope.connected=!0,$scope.hasMoreConversation=!0,loadNextConversations(!0)}function onJabberDisconnected(){$scope.connected=!1}function addConversationOnTop(event,conversation){var existingConversation=$scope.conversations.get(conversation.id);existingConversation?$scope.conversations.putFirst(conversation.id,existingConversation):$scope.conversations.putFirst(conversation.id,conversation)}function onRemovedFromConversation(event,conversationId){$scope.conversations.remove(conversationId)}function onStateChangeStart(event,toState,toParams){$scope.selectedConversationId=toParams.conversationId}function onConversationTitleChanged(event,newConversation){$scope.conversations.contains(newConversation.id)&&$scope.conversations.put(newConversation.id,newConversation)}function onFetchNextConversations(){loadNextConversations(!1)}function onReloadConversations(){$scope.hasMoreConversation=!0,loadNextConversations(!0)}function loadNextConversations(clearPreviousConversations){var offset=clearPreviousConversations?0:$scope.conversations.size();$scope.loadingConversations||!$scope.hasMoreConversation||$scope.showSuggestions||($scope.loadingConversations=!0,ConversationService.getConversationTeasers(offset,maxConversationPerLoad+1).then(function(result){clearPreviousConversations&&$scope.conversations.clear(),$scope.hasMoreConversation=result.length>maxConversationPerLoad,result.forEach(function(conversation,i){i<maxConversationPerLoad&&$scope.conversations.put(conversation.id,conversation)}),$scope.loadingConversations=!1}))}var maxConversationPerLoad=CONFIG.conversationItemsInConversationOverview;init()}]),angular.module("juco.mobile.message").controller("ChatController",["chatEnabled","chatDeprecated","$state","MessageHandler",function(chatEnabled,chatDeprecated,$state,MessageHandler){var init=function(){chatEnabled?chatDeprecated&&$state.go("chat.deprecated"):($state.go("main.start"),MessageHandler.error("chat.notEnabled"))};init()}]),angular.module("juco.mobile.message").controller("ChatDeprecatedController",["ExternalRefUtil","Environment","$window","$scope","$state","ChatDeprecatedState",ChatDeprecatedController]).value("ChatDeprecatedState",{shouldBeSkipped:!1}),angular.module("juco.mobile.message").controller("ConversationController",["$scope","$state","$rootScope","conversationId","ConversationService","MessageService","$timeout","$window","$document","DomUtil","MessageHandler","EVENTS","ConversationMarkAsReadService","ChatMessageSet","ConversationTitleUtil","ConversationType","ChatMessageType","CurrentUser","MessageComposerCache","Environment","$log","ConversationFileUploadService","CONFIG","HeaderTitleService","locationUtil","$q","PromiseUtil","ConversationAction","ArrayUtil","TrackingService",function($scope,$state,$rootScope,conversationId,ConversationService,MessageService,$timeout,$window,$document,DomUtil,MessageHandler,EVENTS,ConversationMarkAsReadService,ChatMessageSet,ConversationTitleUtil,ConversationType,ChatMessageType,CurrentUser,MessageComposerCache,Environment,$log,ConversationFileUploadService,CONFIG,HeaderTitleService,locationUtil,$q,PromiseUtil,ConversationAction,ArrayUtil,TrackingService){function init(){self.chatMessages=new ChatMessageSet,self.queuedUploads=[],self.loadingOlderMessages=!1,self.loadingInitialMessages=!1,self.loadingSettings=!1,self.showLoadingSettingsSpinner=!1,self.updateMuteSetting=!1,self.updateHiddenSetting=!1,self.showErrorMessage=!1,self.showEditButton=!1,self.showEditDialog=!1,self.showAllEditActions=!1,self.showDeleteAction=!1,self.showConfirmDialog=!1,self.hasMore=!1,self.message="",self.allowedToSend=allowedToSend,self.loadOlderMessages=loadOlderMessages,self.onComposerFocus=angular.bind(null,scrollToFooter,!0),self.sendMessage=sendMessage,self.editConversationParticipants=editConversationParticipants,self.editConversationTitle=editConversationTitle,self.openEditDialog=openEditDialog,self.setMuted=setMuted,self.leaveConversation=leaveConversation,self.openConfirmDialog=openConfirmDialog,self.confirmDeleteConversation=confirmDeleteConversation,self.closeDialog=closeDialogs,self.onFileSelected=onFileSelected,self.hideShowConversation=hideShowConversation,self.sendMessageEnabled=!0,self.conversationId=conversationId,self.showPageLoading=$rootScope.showPageLoading,self.hidePageLoading=$rootScope.hidePageLoading,$scope.$on(EVENTS.onNewConversationMessage,onNewConversationMessage),$rootScope.$on(EVENTS.onConversationTitleChanged,onConversationTitleChanged),conversationId&&(self.message=MessageComposerCache.getMessage(conversationId),loadConversation(),loadInitialMessages(),$scope.$on("$destroy",function(){MessageComposerCache.setMessage(conversationId,self.message)}))}function onFileSelected(files){if(files&&0!==files.length)return self.queuedUploads=ConversationFileUploadService.enqueue(conversationId,files),self.queuedUploads}function onConversationTitleChanged(event,conversation){conversationId===conversation.id&&HeaderTitleService.setHeaderTitleValue(ConversationTitleUtil.getConversationTitle(conversation),!0)}function loadConversation(){ConversationService.getConversation(conversationId).then(function(conversation){self.showEditButton=!0,self.showAllEditActions=conversation.type===ConversationType.MULTI_USER_CHAT,onConversationTitleChanged(null,conversation)},function(){HeaderTitleService.setHeaderTitleTranslation("general.error")})}function loadInitialMessages(){self.loadingInitialMessages=!0,MessageService.getInitialMessagesForConversation(conversationId).then(function(result){ConversationMarkAsReadService.markConversationReadImmediately(conversationId).then(function(unreadCount){var initialMessages=result.subList.reverse();self.chatMessages=new ChatMessageSet,self.chatMessages.addAllMessages(initialMessages),self.hasMore=result.hasMore,self.loadingInitialMessages=!1,addMarkerMessage(unreadCount),initialScrollToFooter()})},function(){self.loadingInitialMessages=!1,self.showErrorMessage=!0,initialScrollToFooter()})}function addMarkerMessage(unreadCount){var firstMessageDate,lastMessageDate,hasUnreadMessages,allMessagesAreUnread,markerMessage,lastReadDate=unreadCount.unreadMessagesCount.lastReadDate,messageCount=self.chatMessages.length;
messageCount<=1||(firstMessageDate=self.chatMessages[0].createDate,lastMessageDate=self.chatMessages[messageCount-1].createDate,hasUnreadMessages=lastReadDate<lastMessageDate,allMessagesAreUnread=!self.hasMore&&lastReadDate<firstMessageDate,hasUnreadMessages&&!allMessagesAreUnread&&(markerMessage={id:UNREAD_MESSAGES_MARKER_ID,createDate:lastReadDate,type:ChatMessageType.NEW_MESSAGES},self.chatMessages.addMessage(markerMessage)))}function loadOlderMessages(){self.loadingOlderMessages||(self.loadingOlderMessages=!0,self.hasMore=!1,MessageService.getMessagesForConversation(conversationId,getOldestMessageDate()).then(function(result){var scrollY=DomUtil.getDocumentHeight()-DomUtil.getScrollHeight(),olderMessages=result.subList.reverse();self.chatMessages.addAllMessages(olderMessages),$timeout(function(){$window.scrollTo(0,DomUtil.getDocumentHeight()-scrollY),self.loadingOlderMessages=!1,self.hasMore=result.hasMore})},function(){self.hasMore=!1,self.loadingOlderMessages=!1,self.showErrorMessage=!0}))}function getOldestMessageDate(){var i,message,length=self.chatMessages.length;for(i=0;i<length;i++)if(message=self.chatMessages[i],message.type&&message.type!==ChatMessageType.NEW_MESSAGES)return message.createDate}function doScrollToFooter(viaAnchorScroll){viaAnchorScroll?locationUtil.replaceAndScrollToAnchor("chat-footer",!1):DomUtil.scrollToYIfPossible(DomUtil.getDocumentHeight()-DomUtil.getWindowHeight(),3)}function initialScrollToFooter(){$timeout(function(){var windowHeight,minHeight,minHeightPx,mainContent=$document[0].getElementById("main-content"),chatContainer=$document[0].getElementById("chat-container");return header=$document[0].getElementById("header"),footer=$document[0].getElementById("chat-footer"),mainContent&&chatContainer&&header?(windowHeight=DomUtil.getWindowHeight(),minHeight=windowHeight-header.offsetHeight,minHeightPx=minHeight.toString()+"px",mainContent.style.minHeight=minHeightPx,chatContainer.style.minHeight=minHeightPx,void adjustPaddingAndScrollToFooter()):void doScrollToFooter()})}function adjustPaddingAndScrollToFooter(viaAnchorScroll){var footerPos,windowHeight,originalPadding,padding,chatMessages=$document[0].getElementById("chat-messages");chatMessages&&footer&&(windowHeight=DomUtil.getWindowHeight(),footerPos=footer.getBoundingClientRect().bottom.toFixed(0),footerPos<windowHeight&&(originalPadding=parseInt($window.getComputedStyle(chatMessages).getPropertyValue("padding-top")),padding=originalPadding+windowHeight-footerPos,chatMessages.style.paddingTop=padding.toString()+"px")),doScrollToFooter(viaAnchorScroll)}function scrollToFooter(viaAnchorScroll){$timeout(angular.bind(null,adjustPaddingAndScrollToFooter,viaAnchorScroll))}function allowedToSend(){return self.message.trim().length>0&&self.sendMessageEnabled}function closeDialogs(){self.showEditDialog=!1,self.showConfirmDialog=!1}function sendMessage(){var currentMessageCount;allowedToSend()&&(self.sendMessageEnabled=!1,currentMessageCount=self.chatMessages.length,MessageService.sendMessage(self.message.trim(),conversationId).then(function(newMsg){self.message="",MessageComposerCache.resetMessage(conversationId),self.sendMessageEnabled=!0,TrackingService.trackSendMessage(newMsg,0===currentMessageCount)},function(){MessageHandler.error("message.failedToSendMessage"),self.sendMessageEnabled=!0}))}function openEditDialog(){var spinnerTimer;self.loadingSettings=!0,self.showEditDialog=!0,self.showLoadingSettingsSpinner=!1,spinnerTimer=$timeout(function(){self.loadingSettings&&(self.showLoadingSettingsSpinner=!0)},500),$q.all([ConversationService.getConversationSettings(conversationId),ConversationService.getConversationAllowedActions(conversationId)]).then(PromiseUtil.spread(function(conversationSettings,conversationAllowedActions){$timeout.cancel(spinnerTimer),self.loadingSettings=!1,self.showLoadingSettingsSpinner=!1,self.settings=conversationSettings,self.showDeleteAction=ArrayUtil.contains(conversationAllowedActions.allowedActions,ConversationAction.CONVERSATION_DELETE)}),function(){$timeout.cancel(spinnerTimer),MessageHandler.error("exception.anErrorOccurred"),self.loadingSettings=!1,self.showLoadingSettingsSpinner=!1,self.showEditDialog=!1})}function setMuted(muted){var newSettings=angular.copy(self.settings);newSettings.muted=muted,updateSettings(newSettings,"updateMuteSetting")}function editConversationParticipants(){closeDialogs(),$state.go("chat.editParticipants",{conversationId:conversationId})}function editConversationTitle(){closeDialogs(),$state.go("chat.editTitle",{conversationId:conversationId})}function leaveConversation(){closeDialogs(),self.showPageLoading(),ConversationService.leaveConversation(conversationId,CurrentUser.getId(),!0).then(function(){self.hidePageLoading(),$state.go("chat.allConversations")},function(){self.hidePageLoading(),MessageHandler.error("conversation.failedToUpdateConversation")})}function openConfirmDialog(){self.showEditDialog=!1,self.showConfirmDialog=!0}function confirmDeleteConversation(){closeDialogs(),$state.go("chat.deleteConversation",{conversationId:conversationId})}function onNewConversationMessage(event,data){var wasBottom;data.message.conversationId===conversationId&&(wasBottom=DomUtil.getScrollHeight()+DomUtil.getWindowHeight()>=DomUtil.getDocumentHeight(),self.chatMessages.addMessage(data.message),ConversationMarkAsReadService.markConversationRead(conversationId),wasBottom&&scrollToFooter())}function updateSettings(newSettings,updateFlagName){return self[updateFlagName]=!0,ConversationService.updateConversationSettings(newSettings).then(function(updatedSettings){return self.settings=updatedSettings,self[updateFlagName]=!1,updatedSettings},function(){self[updateFlagName]=!1,MessageHandler.error("exception.anErrorOccurred")})}function hideShowConversation(){var newSettings=angular.copy(self.settings);newSettings.hidden=!newSettings.hidden,updateSettings(newSettings,"updateHiddenSetting").then(function(storedSettings){storedSettings.hidden?($state.go("chat.allConversations"),$rootScope.$broadcast(EVENTS.onShowAutoHideSnackbar,{additionalCssClass:"chat-color",messageKey:"conversation.conversationHidden",actionLabelKey:"conversation.undoHideConversation",action:function(){newSettings.hidden=!1,ConversationService.updateConversationSettings(newSettings).then(function(){$rootScope.$broadcast(EVENTS.onReloadConversations)})}})):closeDialogs()})}var header,footer,self=this,UNREAD_MESSAGES_MARKER_ID="UNREAD_MESSAGES_MARKER";init()}]),angular.module("juco.mobile.message").controller("ConversationDeleteConfirmController",["conversationId","$state","i18nextFilter","ConversationService","ConversationTitleUtil","HeaderTitleService","MessageHandler",function(conversationId,$state,i18nextFilter,ConversationService,ConversationTitleUtil,HeaderTitleService,MessageHandler){function init(){self.loading=!0,self.deleteEnabled=!1,self.password="",self.updateDeleteEnabled=updateDeleteEnabled,self.deleteConversation=deleteConversation,self.cancel=cancel,conversationId&&loadConversation()}function loadConversation(){self.loading=!0,ConversationService.getConversation(conversationId,!0).then(function(conversation){HeaderTitleService.setHeaderTitleValue(ConversationTitleUtil.getConversationTitle(conversation),!0),self.loading=!1},function(){self.loading=!1,self.loadingConversationFailed=!0,HeaderTitleService.setHeaderTitleTranslation("general.error"),MessageHandler.error("conversation.failedToLoadConversation")})}function updateDeleteEnabled(){self.deleteEnabled=self.password.toLocaleUpperCase()===expectedPassword}function deleteConversation(){self.deleteEnabled&&(self.password="",self.deleteEnabled=!1,self.loading=!0,ConversationService.deleteConversation(conversationId,!0).then(function(){$state.go("chat.allConversations")},function(){self.loading=!1,MessageHandler.error("conversation.failedToDeleteConversation")}))}function cancel(){conversationId?$state.go("chat.conversation",{conversationId:conversationId}):$state.go("chat.allConversations")}var self=this,expectedPassword=i18nextFilter("conversation.deleteConversationPassword").toLocaleUpperCase();init()}]),angular.module("juco.mobile.message").controller("ConversationParticipantsEditorController",["$rootScope","$scope","$state","SearchService","ConversationService","CurrentUser","MessageHandler","Map","MessageUtil","conversationId","ArrayUtil","ConversationTitleUtil","EVENTS","HeaderTitleService","TrackingService",function($rootScope,$scope,$state,SearchService,ConversationService,CurrentUser,MessageHandler,Map,MessageUtil,conversationId,ArrayUtil,ConversationTitleUtil,EVENTS,HeaderTitleService,TrackingService){function init(){$scope.query="",$scope.suggestions=void 0,$scope.showSuggestions=!1,$scope.loadingConversationFailed=!1,$scope.showEditButton=!!conversationId,$scope.loadingConversation=!1,$scope.participants=new Map,$scope.addParticipant=addParticipant,$scope.removeParticipant=removeParticipant,$scope.createConversation=createConversation,$scope.updateConversation=updateConversation,$scope.cancel=cancel,$scope.onSubmit=onSubmit,conversationId&&loadConversation()}function loadConversation(){$scope.loadingConversation=!0,ConversationService.getConversation(conversationId,!0).then(function(conversation){var userId=CurrentUser.getId(),participants=new Map,participantsSorted=MessageUtil.sortParticipants(conversation.participants.slice(0));participantsSorted.forEach(function(participant){participant.id===userId?myParticipant=participant:participants.put(participant.id,participant)}),HeaderTitleService.setHeaderTitleValue(ConversationTitleUtil.getConversationTitle(conversation),!0),$scope.loadingConversation=!1,$scope.participants=participants},function(){$scope.loadingConversation=!1,$scope.loadingConversationFailed=!0,HeaderTitleService.setHeaderTitleTranslation("general.error"),MessageHandler.error("conversation.failedToLoadConversation")})}function addParticipant(participant){CurrentUser.getId()===participant.id||$scope.participants.contains(participant.id)||ConversationService.getConversationConfig().then(function(config){$scope.participants.size()<config.maxParticipants?$scope.participants.putFirst(participant.id,participant):MessageHandler.error("conversation.onlyXParticipantsAllowed",{count:config.maxParticipants})}),$scope.$broadcast(EVENTS.onConversationParticipantSuggestionSelected)}function removeParticipant(participant){$scope.participants.remove(participant.id)}function createConversation(){var participantIds=$scope.participants.keySet().entries(),defaultTitle=null,isMultiUserChat=MessageUtil.isMultiUserChat(participantIds);$rootScope.showPageLoading(),isMultiUserChat&&(defaultTitle=ConversationTitleUtil.getDefaultConversationTitle()),ConversationService.startNewConversation(participantIds,defaultTitle).then(function(conversation){$rootScope.hidePageLoading(),isMultiUserChat&&TrackingService.trackCreateGroupChat("conversation-participants-editor"),$state.go("chat.conversation",{conversationId:conversation.id},{location:"replace"})},function(){$rootScope.hidePageLoading(),MessageHandler.error("conversation.failedToCreateConversation")})}function updateConversation(){var updatedParticipants=$scope.participants.values();updatedParticipants.push(myParticipant),$rootScope.showPageLoading(),ConversationService.updateParticipants(conversationId,updatedParticipants,!0).then(function(){$rootScope.hidePageLoading(),$state.go("chat.conversation",{conversationId:conversationId})},function(){$rootScope.hidePageLoading(),MessageHandler.error("conversation.failedToUpdateConversation")})}function cancel(){conversationId?$state.go("chat.conversation",{conversationId:conversationId}):$state.go("chat.allConversations")}function onSubmit(){1===$scope.suggestions.length&&addParticipant($scope.suggestions[0])}var myParticipant=null;init()}]),angular.module("juco.mobile.message").controller("ConversationTitleEditorController",["$rootScope","$scope","$state","ConversationService","MessageHandler","conversationId","ConversationTitleUtil","HeaderTitleService",function($rootScope,$scope,$state,ConversationService,MessageHandler,conversationId,ConversationTitleUtil,HeaderTitleService){function init(){$scope.conversationTitle="",$scope.updateConversation=updateConversation,$scope.onTitleChanged=onTitleChanged,$scope.cancel=cancel,$scope.loadingConversationFailed=!1,$scope.loadingConversation=!1,conversationId&&loadConversation()}function loadConversation(){$scope.loadingConversation=!0,ConversationService.getConversation(conversationId,!0).then(function(conversation){$scope.conversationTitle=ConversationTitleUtil.getConversationTitle(conversation),HeaderTitleService.setHeaderTitleValue($scope.conversationTitle,!0),$scope.loadingConversation=!1},function(){$scope.loadingConversation=!1,$scope.loadingConversationFailed=!0,HeaderTitleService.setHeaderTitleTranslation("general.error"),MessageHandler.error("conversation.failedToLoadConversation")})}function cancel(){conversationId?$state.go("chat.conversation",{conversationId:conversationId}):$state.go("chat.allConversations")}function onTitleChanged(){titleChanged=!0}function updateConversation(){var title;titleChanged?(title=ConversationTitleUtil.createConversationTitle($scope.conversationTitle),$rootScope.showPageLoading(),ConversationService.updateTitle(conversationId,title).then(function(conversation){$rootScope.hidePageLoading(),$state.go("chat.conversation",{conversationId:conversation.id},{location:"replace"})},function(){$rootScope.hidePageLoading(),MessageHandler.error("conversation.failedToUpdateConversation")})):cancel()}var titleChanged;init()}]),angular.module("juco.mobile.message").directive("chatConnectionInfo",["EVENTS","XmppService",function(EVENTS,XmppService){return{templateUrl:"scripts/message/directive/chat-connection-info.html",restrict:"E",link:function($scope){function updateScope(){$scope.hasConnection=XmppService.isConnected()}$scope.$on(EVENTS.onJabberConnected,updateScope),$scope.$on(EVENTS.onJabberDisconnected,updateScope),updateScope()}}}]),angular.module("juco.mobile.message").directive("jcChatConversationIcon",["$compile","ConversationType","CurrentUser","$log",function($compile,ConversationType,CurrentUser,$log){function findBuddy(participants){return CurrentUser.getId()===participants[0].id?participants[1]:participants[0]}function getAndPrepareUserImageTemplate($scope,conversation){return $scope.participant=findBuddy(conversation.participants.concat(conversation.deletedParticipants)),userImageTemplate}function getAndPrepareGroupImageTemplate(){return groupImageTemplate}function getAndPrepareImageTemplate($scope){var conversationType=$scope.conversation?$scope.conversation.type:void 0;return conversationType?conversationType===ConversationType.ONE_ON_ONE?getAndPrepareUserImageTemplate($scope,$scope.conversation):getAndPrepareGroupImageTemplate():($log.error("no conversation to render an icon for"),"<div></div>")}function link($scope,$element){$element.html(getAndPrepareImageTemplate($scope)),$compile($element.contents())($scope)}var groupImageTemplate='<jc-chat-group-icon group-title="conversation.title"></jc-chat-group-icon>',userImageTemplate='<jc-chat-presence profile-id="participant.id" image-url-pattern="participant.imageUrlPattern" class="jc-mobile-chat-buddy-icon" ></jc-chat-presence>';return{scope:{conversation:"=jcChatConversationIcon"},link:link}}]),function(){function ChatFileController(DocumentService,FileIconUtil){function init(){self.filename=self.message.attachment.filename,self.iconUrl=FileIconUtil.getFileIconUrl(self.message.attachment.contentType),self.download=download}function download(){DocumentService.downloadChatAttachment(self.message.id,self.message.attachment)}var self=this;init()}angular.module("juco.mobile.message").directive("jcChatFile",function(){return{restrict:"E",scope:{message:"=chatMessage"},templateUrl:"scripts/message/directive/jc-chat-file.html",controller:"ChatFileController",controllerAs:"chatFile",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatFileController",["DocumentService","FileIconUtil",ChatFileController])}(),function(){function ChatGroupIconController($scope,StringUtil,HtmlUtil){function init(){setIcon(getGroupTitle()),$scope.$watch(getGroupTitle,setIcon)}function getGroupTitle(){return self.groupTitle}function setIcon(title){self.icon=StringUtil.isBlank(title)?"?":HtmlUtil.emojifyFirstChar(title.toUpperCase())}var self=this;init()}angular.module("juco.mobile.message").directive("jcChatGroupIcon",function(){return{template:'<span class="jc-mobile-chat-group-icon app-chat-color" ng-bind-html="chatGroupIcon.icon"></span>',restrict:"E",scope:{groupTitle:"="},controller:"ChatGroupIconController",controllerAs:"chatGroupIcon",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatGroupIconController",["$scope","StringUtil","HtmlUtil",ChatGroupIconController])}(),function(){function ChatImageController(DocumentService,FileIconUtil,REST,CHAT_THUMBNAIL_SIZE,ContentTypeUtil){function init(){self.imageUrl=REST.message.MESSAGE_THUMBNAIL(self.message.id,CHAT_THUMBNAIL_SIZE.MOBILE,FALLBACK_TO_ORIGINAL_IMAGE),self.isGif=ContentTypeUtil.isGif(self.message.attachment.contentType),self.filename=self.message.attachment.filename,self.iconUrl=FileIconUtil.getFileIconUrl(self.message.attachment.contentType),self.download=download}function download(){DocumentService.downloadChatAttachment(self.message.id,self.message.attachment)}var self=this;init()}var FALLBACK_TO_ORIGINAL_IMAGE=!1;angular.module("juco.mobile.message").directive("jcChatImage",function(){return{restrict:"E",scope:{message:"=chatMessage"},templateUrl:"scripts/message/directive/jc-chat-image.html",controller:"ChatImageController",controllerAs:"chatImage",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatImageController",["DocumentService","FileIconUtil","REST","CHAT_THUMBNAIL_SIZE","ContentTypeUtil",ChatImageController])}(),function(){function ChatMessageContainerController(CurrentUser){function init(){self.ownMessage=CurrentUser.getId()===self.message.sentFrom.id}var self=this;init()}angular.module("juco.mobile.message").directive("jcChatMessageContainer",function(){return{restrict:"E",transclude:!0,scope:{message:"=chatMessage"},templateUrl:"scripts/message/directive/jc-chat-message-container.html",controller:"ChatMessageContainerController",controllerAs:"chatMessageContainer",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatMessageContainerController",["CurrentUser",ChatMessageContainerController])}(),function(){function ChatMessageController(ChatMessageType,ContentTypeUtil){function init(){setMessageType()}function setMessageType(){self.message.type===ChatMessageType.CHAT_MESSAGE?self.messageType="text":self.message.type===ChatMessageType.ATTACHMENT_CHAT_MESSAGE?ContentTypeUtil.isSupportedImageContentType(self.message.attachment.contentType)?self.messageType="image":self.messageType="file":self.message.type===ChatMessageType.NEW_MESSAGES?self.messageType="new-messages":self.messageType="notification"}var self=this;init()}angular.module("juco.mobile.message").directive("jcChatMessage",function(){return{restrict:"E",scope:{message:"=chatMessage"},templateUrl:"scripts/message/directive/jc-chat-message.html",controller:"ChatMessageController",controllerAs:"chatMessage",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatMessageController",["ChatMessageType","ContentTypeUtil",ChatMessageController])}(),function(){function ChatNotificationController(ChatMessageType,CurrentUser,ConversationService,ArrayUtil,HtmlUtil,messageTimeFilter,profileNameFilter,i18nextFilter){function init(){var messageType=self.message.type;messageType===ChatMessageType.CONVERSATION_CREATED?handleConversationCreated():messageType===ChatMessageType.CONVERSATION_TITLE_CHANGED?handleConversationTitleChanged():messageType===ChatMessageType.LEFT_CONVERSATION?handleLeftConversation():messageType===ChatMessageType.REMOVED_FROM_CONVERSATION||messageType===ChatMessageType.ADDED_TO_CONVERSATION||messageType===ChatMessageType.YOU_WERE_REMOVED||messageType===ChatMessageType.YOU_WERE_ADDED?handleAddedOrRemoved():messageType===ChatMessageType.PERSON_DELETED&&handlePersonDeleted()}function formatTimestampHtml(date){return'<span class="chat-message-timestamp">\u2022 '+messageTimeFilter(date)+"</span>"}function getI18Next(message,conversation){var removed,affectedProfiles=message.someAffectedIds?sortAffectedProfiles(message.someAffectedIds):[],totalAffectedCount=message.totalAffectedCount,affectedCount=affectedProfiles.length,additionalAffectedCount=totalAffectedCount-affectedCount;if(message.type===ChatMessageType.REMOVED_FROM_CONVERSATION)removed=!0;else{if(message.type!==ChatMessageType.ADDED_TO_CONVERSATION)return;removed=!1}return 1===affectedCount?affectedProfiles[0]===CurrentUser.getId()?buildI18NextObject("youWere",removed,message,{}):buildI18NextObject("oneWas",removed,message,{who:getParticipantNameEscaped(resolveParticipantIdToParticipant(affectedProfiles[0],conversation))}):2===affectedCount?buildI18NextObject("twoWere",removed,message,{who1:getParticipantNameEscaped(resolveParticipantIdToParticipant(affectedProfiles[0],conversation)),who2:getParticipantNameEscaped(resolveParticipantIdToParticipant(affectedProfiles[1],conversation))}):affectedCount>2&&additionalAffectedCount<=0?buildI18NextObject("someWere",removed,message,{whos:buildParticipantNames(affectedProfiles,conversation)}):affectedCount>2&&1===additionalAffectedCount?buildI18NextObject("someAndOneAdditionalWere",removed,message,{whos:buildParticipantNames(affectedProfiles,conversation)}):affectedCount>2&&additionalAffectedCount>1?buildI18NextObject("someAndNAdditionalWere",removed,message,{whos:buildParticipantNames(affectedProfiles,conversation),additionalCount:additionalAffectedCount}):void 0}function sortAffectedProfiles(affectedProfiles){var currentUserId=CurrentUser.getId(),profilesFiltered=affectedProfiles.filter(function(profileId){return profileId!==currentUserId});return affectedProfiles.length===profilesFiltered.length?affectedProfiles:(profilesFiltered.unshift(currentUserId),profilesFiltered)}function getParticipantNameEscaped(participant){return participant.id===CurrentUser.getId()?i18nextFilter("message.youCapital"):HtmlUtil.escapeHtml(profileNameFilter(participant))}function getSentFromEscaped(message){return message.sentFrom.id===CurrentUser.getId()?i18nextFilter("message.youDative"):HtmlUtil.escapeHtml(profileNameFilter(message.sentFrom))}function buildI18NextObject(keyBase,removed,message,additionalData){return{key:"message."+keyBase+(removed?"Removed":"Added"),context:angular.extend({byWhom:getSentFromEscaped(message),createDate:formatTimestampHtml(message.createDate)},additionalData)}}function buildParticipantNames(participants,conversation){return participants.map(function(participantId){return getParticipantNameEscaped(resolveParticipantIdToParticipant(participantId,conversation))}).join(", ")}function resolveParticipantIdToParticipant(participantId,conversation){function isParticipant(participant){return participant.id===participantId}return ArrayUtil.find(conversation.participants,isParticipant)||ArrayUtil.find(conversation.deletedParticipants,isParticipant)}function handleLeftConversation(){self.translation={},self.translation.context={createDate:formatTimestampHtml(self.message.createDate)},self.message.sentFrom.id===CurrentUser.getId()?self.translation.key="message.youLeft":(self.translation.key="message.oneLeft",self.translation.context.who=getSentFromEscaped(self.message))}function handleAddedOrRemoved(){ConversationService.getConversation(self.message.conversationId).then(function(conversation){self.translation=getI18Next(self.message,conversation)})}function handleConversationCreated(){var key,title=self.message.title;key=title?self.message.sentFrom.id===CurrentUser.getId()?"conversation.youCreatedTheConversation":"conversation.someoneCreatedTheConversation":self.message.sentFrom.id===CurrentUser.getId()?"conversation.youCreatedTheConversationEmptyTitle":"conversation.someoneCreatedTheConversationEmptyTitle",self.translation={key:key,context:{title:HtmlUtil.escapeAndEmojifyHtml(title),who:getParticipantNameEscaped(self.message.sentFrom),createDate:formatTimestampHtml(self.message.createDate)}}}function handleConversationTitleChanged(){var oldTitle=self.message.oldTitle,newTitle=self.message.newTitle;self.translation={key:self.message.sentFrom.id===CurrentUser.getId()?"conversation.youChangedTitle":"conversation.someoneChangedTitle",context:{oldTitle:HtmlUtil.escapeAndEmojifyHtml(oldTitle),newTitle:HtmlUtil.escapeAndEmojifyHtml(newTitle),who:getParticipantNameEscaped(self.message.sentFrom),createDate:formatTimestampHtml(self.message.createDate)}}}function handlePersonDeleted(){self.translation={key:"conversation.aDeletedUserWasRemovedFromTheConversation",context:{createDate:formatTimestampHtml(self.message.createDate)}}}var self=this;init()}angular.module("juco.mobile.message").directive("jcChatNotification",function(){return{restrict:"E",scope:{message:"=chatMessage"},templateUrl:"scripts/message/directive/jc-chat-notification.html",controller:"ChatNotificationController",controllerAs:"chatNotification",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatNotificationController",["ChatMessageType","CurrentUser","ConversationService","ArrayUtil","HtmlUtil","messageTimeFilter","profileNameFilter","i18nextFilter",ChatNotificationController])}(),angular.module("juco.mobile.message").directive("jcChatPresenceBubble",[function(){return{template:'<i class="fa fa-circle icon-circle" ng-class="presenceClass"></i>',restrict:"E",controller:"PresenceDirectiveController",scope:{presence:"=?",profileId:"@?"},replace:!0}}]),angular.module("juco.mobile.message").directive("jcChatPresenceSwitch",["JcXmppPresenceType","XmppService","CurrentUser",function(JcXmppPresenceType,XmppService,CurrentUser){function linker($scope){$scope.currentUserId=CurrentUser.getId(),$scope.togglePresence=togglePresence}function onSwitchPresenceOf(presence){XmppService.isConnected()?XmppService.setMyPresence(presence===JcXmppPresenceType.online?JcXmppPresenceType.dnd:JcXmppPresenceType.online):XmppService.setMyPresence(presence)}function togglePresence(){XmppService.getMyPresence().then(onSwitchPresenceOf)}return{restrict:"AE",replace:!0,templateUrl:"scripts/message/directive/jc-chat-presence-switch.html",link:linker}}]),angular.module("juco.mobile.message").directive("jcChatPresence",[function(){return{restrict:"E",template:'<img ng-src="{{imageUrlPattern | jcImage:\'SMALL\' }}" ng-class="presenceClass" class="jc-profile-image jc-ng-presence"/>',replace:!0,scope:{imageUrlPattern:"=",profileId:"="},controller:"PresenceDirectiveController"}}]),function(){function ChatTextController(HtmlUtil){function init(){var linkyfiedMsg=HtmlUtil.escapeAndLinkify(self.message.message);self.urlifiedMsg=HtmlUtil.emojify(linkyfiedMsg)}var self=this;init()}angular.module("juco.mobile.message").directive("jcChatText",function(){return{restrict:"E",scope:{message:"=chatMessage"},templateUrl:"scripts/message/directive/jc-chat-text.html",controller:"ChatTextController",controllerAs:"chatText",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatTextController",["HtmlUtil",ChatTextController])}(),function(){function ChatUploadProgressBarController($scope,ConversationFileUploadService,MessageHandler,EVENTS,ArrayUtil,CONFIG){function init(){self.cancelUpload=cancelUpload,self.finishedUploadCount=0,self.currentUpload=void 0,$scope.$on(EVENTS.onChatFileUploadStarted,onUploadProgress),$scope.$on(EVENTS.onChatFileUploadProgress,onUploadProgress),$scope.$on(EVENTS.onChatFileUploadFinished,onUploadSuccess),$scope.$on(EVENTS.onChatFileUploadFailed,onUploadError),$scope.$on(EVENTS.onChatFileUploadRetry,onUploadRetry),handleQueueUpdated()}function cancelUpload(current){current&&!current.uploadFinished&&(current.abort(),finishUpload(current))}function finishUpload(finishedFile){finishedFile.conversationId===self.conversationId&&(self.finishedUploadCount++,self.queuedUploads=self.queuedUploads.filter(function(file){return file.id!==finishedFile.id}),handleQueueUpdated())}function getQueuedUploadById(id){return ArrayUtil.find(self.queuedUploads,function(file){return file.id===id})}function handleQueueUpdated(){self.currentUpload=self.queuedUploads&&self.queuedUploads.length>0?self.queuedUploads[0]:void 0,self.currentUpload||(self.finishedUploadCount=0)}function onUploadProgress(event,current){current.conversationId===self.conversationId&&(self.queuedUploads=ConversationFileUploadService.getCurrentUploadsForConversation(self.conversationId),self.currentUpload=getQueuedUploadById(current.id),self.currentUpload&&(self.currentUpload.progress=current.progress,100===current.progress?self.currentUpload.uploadFinished=!0:self.currentUpload.uploadFinished=!1))}function onUploadSuccess(event,current){finishUpload(current)}function onUploadError(event,current){MessageHandler.error("chat.upload.ultimatelyFailedUploadingFile",{fileName:current.file.name}),finishUpload(current)}function onUploadRetry(event,current){var remainingRetries=CONFIG.fileUploadRetries-(current.retries||0);MessageHandler.error("chat.upload.uploadFailedRetrying",{fileName:current.file.name,remainingRetries:remainingRetries}),self.queuedUploads=ConversationFileUploadService.getCurrentUploadsForConversation(self.conversationId),handleQueueUpdated()}var self=this;init()}angular.module("juco.mobile.message").directive("jcChatUploadProgressBar",function(){return{restrict:"E",scope:{conversationId:"=",queuedUploads:"="},templateUrl:"scripts/message/directive/jc-chat-upload-progress-bar.html",controller:"ChatUploadProgressBarController",controllerAs:"chatUploadProgressBar",bindToController:!0}}),angular.module("juco.mobile.message").controller("ChatUploadProgressBarController",["$scope","ConversationFileUploadService","MessageHandler","EVENTS","ArrayUtil","CONFIG",ChatUploadProgressBarController])}(),angular.module("juco.mobile.message").directive("jcConversationList",[function(){return{restrict:"E",templateUrl:"scripts/message/directive/jc-conversation-list.html",scope:{conversations:"=",selectedConversationId:"=?",loadingConversations:"="}}}]),angular.module("juco.mobile.message").directive("jcConversationSearchTeaser",["ResourceType","ProfileService",function(ResourceType,ProfileService){function link(scope){var teaser=scope.teaser;scope.emojify=teaser.type!==ResourceType.PROFILE,scope.prefix=teaser.type===ResourceType.PROFILE?ProfileService.getProfileNamePrefixTranslationKey(teaser):""}return{templateUrl:"scripts/message/directive/jc-conversation-search-teaser.html",scope:{teaser:"="},link:link}}]),angular.module("juco.mobile.message").directive("jcConversationSuggestInput",["ConversationService","SortType","EVENTS","CONVERSATION_SUGGEST_INPUT_ID","$timeout",function(ConversationService,SortType,EVENTS,CONVERSATION_SUGGEST_INPUT_ID,$timeout){function linker(scope,$element){function init(){scope.query||(scope.query=""),scope.inputId=CONVERSATION_SUGGEST_INPUT_ID.ID,scope.onInputChange=onInputChange,scope.onInputFocus=onInputFocus,scope.onInputBlur=onInputBlur,scope.clearQuery=clearQuery,scope.$on(EVENTS.onConversationParticipantSuggestionSelected,onSuggestionSelected)}function clearQuery(){scope.query="",scope.suggestions=void 0,inputElement||(inputElement=$element[0].querySelector("#"+CONVERSATION_SUGGEST_INPUT_ID.ID)),inputElement&&inputElement.blur()}function onInputFocus(){scope.showSuggestions=!0}function onInputBlur(){$timeout(function(){scope.showSuggestions=!1})}function onInputChange(){scope.query&&scope.query.length>=minQueryCharacterLength?scope.suggestOnlyPersons?ConversationService.suggestParticipant(scope.query,SortType.relevance,0,8).then(setSuggestions):ConversationService.suggestConversation(scope.query,SortType.relevance,0,8).then(setSuggestions):scope.suggestions=void 0;
}function setSuggestions(suggestions){scope.suggestions=suggestions.teasers}function onSuggestionSelected(){clearQuery()}var inputElement,minQueryCharacterLength=1;init()}return{scope:{placeholderText:"@",query:"=model",suggestions:"=",showSuggestions:"=",suggestOnlyPersons:"=?"},restrict:"E",templateUrl:"scripts/message/directive/jc-conversation-suggest-input.html",link:linker}}]),function(){function ConversationTeaserMessageController(ChatMessageType,ContentTypeUtil,i18nextFilter,sentFromNameFilter,HtmlUtil){function init(){var i18nParams,i18nKey,chatMessage=self.conversationTeaser.teaserChatMessage;if(chatMessage)switch(self.teaserAuthor=HtmlUtil.escapeHtml(sentFromNameFilter(self.conversationTeaser.teaserAuthor)),chatMessage.type){case ChatMessageType.CHAT_MESSAGE:self.messageText=HtmlUtil.escapeAndEmojifyHtml(chatMessage.message);break;case ChatMessageType.ATTACHMENT_CHAT_MESSAGE:i18nParams={filename:chatMessage.attachment.filename},i18nKey=ContentTypeUtil.isSupportedImageContentType(chatMessage.attachment.contentType)?"chat.imageAttachmentFileName":"chat.documentAttachmentFileName",self.messageText=i18nextFilter(i18nKey,i18nParams)}}var self=this;init()}angular.module("juco.mobile.message").directive("jcConversationTeaserMessage",function(){return{restrict:"E",scope:{conversationTeaser:"="},templateUrl:"scripts/message/directive/jc-conversation-teaser-message.html",controller:"ConversationTeaserMessageController",controllerAs:"conversationTeaserMessage",bindToController:!0}}),angular.module("juco.mobile.message").controller("ConversationTeaserMessageController",["ChatMessageType","ContentTypeUtil","i18nextFilter","sentFromNameFilter","HtmlUtil",ConversationTeaserMessageController])}(),angular.module("juco.mobile.message").directive("jcConversationTeaser",["$state","ConversationTitleUtil","ConversationType","HtmlUtil",function($state,ConversationTitleUtil,ConversationType,HtmlUtil){function openConversation(conversationId){$state.go("chat.conversation",{conversationId:conversationId},{inherit:!1})}function linker(scope){var conversationTitle=ConversationTitleUtil.getConversationTitle(scope.conversation);scope.conversationTitleHtml=scope.conversation.type===ConversationType.MULTI_USER_CHAT?HtmlUtil.escapeAndEmojifyHtml(conversationTitle):HtmlUtil.escapeHtml(conversationTitle),scope.openConversation=openConversation}return{restrict:"E",templateUrl:"scripts/message/directive/jc-conversation-teaser.html",scope:{conversation:"=",active:"=?"},link:linker}}]),function(){function ParticipantTeaserController(JcXmppPresenceType,ProfileService){function init(){self.isOnline=isPresence(JcXmppPresenceType.online),self.isOffline=isPresence(JcXmppPresenceType.offline)||isPresence(JcXmppPresenceType.unkown)||isPresence(JcXmppPresenceType.dnd),self.isAway=isPresence(JcXmppPresenceType.away),self.isLinkable=isLinkable,self.prefix=self.teaser?ProfileService.getProfileNamePrefixTranslationKey(self.teaser):void 0}function isPresence(expected){return self.teaser&&self.teaser.jabberPresence===expected}function isLinkable(participant){return self.linkParticipant&&participant&&participant.id&&!participant.deleted}var self=this;init()}angular.module("juco.mobile.message").directive("jcParticipantTeaser",function(){return{restrict:"E",replace:!0,templateUrl:"scripts/message/directive/jc-participant-teaser.html",scope:{teaser:"=",showHighlighting:"=",linkParticipant:"=?"},controller:"ParticipantTeaserController",controllerAs:"participantTeaser",bindToController:!0}}),angular.module("juco.mobile.message").controller("ParticipantTeaserController",["JcXmppPresenceType","ProfileService",ParticipantTeaserController])}(),angular.module("juco.mobile.message").controller("PresenceDirectiveController",["$scope","JcXmppPresenceType","EVENTS","XmppService","CurrentUser","$element","$animate",function($scope,JcXmppPresenceType,EVENTS,XmppService,CurrentUser,$element,$animate){function init(){$animate&&$animate.enabled(!1,$element),$scope.profileId||($scope.profileId=CurrentUser.getId()),$scope.$on(EVENTS.onPresenceChanged,function(event,presenceData){$scope.profileId===presenceData.profileId&&$scope.presence!==presenceData.presence&&($scope.presence=presenceData.presence,updatePresence())}),$scope.$on(EVENTS.onJabberDisconnected,function(){$scope.profileId===CurrentUser.getId()&&($scope.presence=JcXmppPresenceType.offline),updatePresence()}),updatePresence()}function updatePresence(){var isOwnPresence=$scope.profileId===CurrentUser.getId(),isConnected=XmppService.isConnected();$scope.presence||($scope.presence=JcXmppPresenceType.unknown,(isConnected||isOwnPresence)&&XmppService.getJabberPresenceByProfileId($scope.profileId).then(function(presence){presence&&($scope.presence=presence,updateVisiblePresence(isOwnPresence))})),updateVisiblePresence(isOwnPresence)}function updateVisiblePresence(isOwnPresence){var presenceViewProperties=mapPresenceToDisplayProperties($scope.presence,isOwnPresence);presenceViewProperties&&($scope.presenceInfoI18nKey=presenceViewProperties.presenceInfoI18nKey,$scope.presenceClass=presenceViewProperties.presenceClass)}function mapPresenceToDisplayProperties(presence,isOwnPresence){switch(presence){case JcXmppPresenceType.online:case JcXmppPresenceType.chat:case JcXmppPresenceType.away:case JcXmppPresenceType.xa:return{presenceInfoI18nKey:"chat.online",presenceClass:"jc-ng-presence-online"};case JcXmppPresenceType.offline:case JcXmppPresenceType.connecting:case JcXmppPresenceType.unknown:return{presenceInfoI18nKey:isOwnPresence?"chat.noConnectionToJabberServer":"chat.offline",presenceClass:"jc-ng-presence-offline"};case JcXmppPresenceType.dnd:return{presenceInfoI18nKey:"chat.displayAsOffline",presenceClass:"jc-ng-presence-dnd"};default:return}}init()}]),angular.module("juco.mobile.message").directive("startMultiUserConversation",["HtmlUtil",function(HtmlUtil){function linker(scope){function wrapName(name){return name?'<span class="conversation-name">"'+HtmlUtil.escapeHtml(name)+'"</span>':name}scope.wrapName=wrapName}return{scope:{conversationName:"="},restrict:"E",templateUrl:"scripts/message/directive/start-multi-user-conversation.html",link:linker}}]),angular.module("juco.mobile.message").filter("messageDay",["$i18next","dateFilter",function($i18next,dateFilter){return function(millis){var day;if(millis)return day=new Date(millis),dateFilter(day,$i18next("date.dayFormat",{dayInWeek:day.getDay()}))}}]),angular.module("juco.mobile.message").filter("messageTime",["$i18next","dateFilter",function($i18next,dateFilter){return function(millis){var time;if(millis)return time=new Date(millis),dateFilter(time,$i18next("date.timeFormat"))}}]),angular.module("juco.mobile.message").filter("sentFromName",["i18nextFilter","CurrentUser","profileNameFilter",function(i18nextFilter,CurrentUser,profileNameFilter){return function(person){if(person)return person.id===CurrentUser.getId()?i18nextFilter("message.me"):profileNameFilter(person)}}]),angular.module("juco.constants").constant("CONVERSATION_SUGGEST_INPUT_ID",function(){return{ID:"jc-ng-suggest-input-field"}}()),angular.module("juco.mobile.message").service("ConversationTitleUtil",["dateFilter","StringUtil","$i18next","ConversationType","CurrentUser","profileNameFilter",function(dateFilter,StringUtil,$i18next,ConversationType,CurrentUser,profileNameFilter){function createConversationTitle(conversationTitle){var now=new Date;return StringUtil.isBlank(conversationTitle)?$i18next("conversation.noTitle",{date:dateFilter(now,$i18next("date.dateFormat"))}):conversationTitle.trim()}function getDefaultConversationTitle(){return createConversationTitle()}function getConversationTitle(conversation){var chatPartner;if(conversation)return conversation.type===ConversationType.ONE_ON_ONE?(chatPartner=getChatPartner(conversation.participants.concat(conversation.deletedParticipants)),profileNameFilter(chatPartner)):conversation.title}function getChatPartner(participants){return participants[0].id===CurrentUser.getId()?participants[1]:participants[0]}this.createConversationTitle=createConversationTitle,this.getDefaultConversationTitle=getDefaultConversationTitle,this.getConversationTitle=getConversationTitle}]),angular.module("juco.controller").controller("MyContentBaseController",["$scope","fetchContents","onInit",function($scope,fetchContents,onInit){function init(){$scope.teasers=[],$scope.fetchingData=!1,$scope.hasMore=!1,$scope.loading=!0,$scope.showErrorMessage=!1,"function"==typeof onInit&&onInit(),fetchMyContent()}var fetchMyContent=function(){var offset=0;$scope.fetchingData||($scope.fetchingData=!0,$scope.teasers.length&&(offset=$scope.teasers.length),fetchContents(offset).then(function(data){$scope.teasers=$scope.teasers.concat(data.subList),$scope.hasMore=data.totalSize>$scope.teasers.length,$scope.fetchingData=!1,$scope.loading=!1},function(){$scope.loading=!1,$scope.showErrorMessage=!0}))};init(),$scope.$on("jc-fetch-my-content",fetchMyContent)}]),angular.module("juco.controller").controller("MyContentContactController",["$scope","ProfileService","$controller",function($scope,ProfileService,$controller){$controller("MyContentBaseController",{$scope:$scope,fetchContents:function(offset){return ProfileService.getContactsForPerson($scope.currentUser.id,{offset:offset})},onInit:function(){$scope.noItemsAvailableMessageKey="contacts.noContactsAvailable",$scope.errorLoadingItemsMessageKey="contacts.errorLoadingContacts"}})}]),angular.module("juco.controller").controller("MyContentController",["$scope","MyContentService","ENUMS","$controller",function($scope,MyContentService,ENUMS,$controller){var filters=[ENUMS.searchFilterType.PROFILE,ENUMS.searchFilterType.ENTITY,ENUMS.searchFilterType.DOCUMENT];$controller("MyContentBaseController",{$scope:$scope,fetchContents:function(offset){return MyContentService.getMyContent(offset,filters)},onInit:function(){$scope.noItemsAvailableMessageKey="myContent.noContentAvailable",$scope.errorLoadingItemsMessageKey="myContent.errorLoadingContents"}})}]),angular.module("juco.controller").controller("MyContentDocumentController",["$scope","MyContentService","ENUMS","$controller",function($scope,MyContentService,ENUMS,$controller){$controller("MyContentBaseController",{$scope:$scope,fetchContents:function(offset){return MyContentService.getMyContent(offset,[ENUMS.searchFilterType.DOCUMENT])},onInit:function(){$scope.noItemsAvailableMessageKey="document.noDocumentsAvailable",$scope.errorLoadingItemsMessageKey="document.errorLoadingDocuments"}})}]),angular.module("juco.controller").controller("MyContentEntityController",["$scope","entityTypes","EntityService","ErrorHandler","MessageHandler","ENUMS",function($scope,entityTypes,EntityService,ErrorHandler,MessageHandler,ENUMS){var fetchingData=!1,init=function(){$scope.entityTypes=entityTypes,$scope.teasers=[],$scope.showFilter=!1,$scope.filterValues=[{filter:ENUMS.durationFilter.FUTURE,i18nKey:"entity.upcomingEntities"},{filter:ENUMS.durationFilter.PAST,i18nKey:"entity.pastEntities"}],$scope.selectedFilter=$scope.filterValues[0],$scope.hasMore=!1,$scope.loading=!0,$scope.showErrorMessage=!1,entityTypes?loadMyContent():ErrorHandler.showErrorPage(400,MessageHandler.createErrorMessage("entity.noEntityTypeProvided"))},loadMyContent=function(){$scope.showErrorMessage=!1,$scope.loading=!0,fetchingData=!1,$scope.teasers=[],$scope.hasMore=!1,EntityService.getMyContentByProfileIdAndType(entityTypes,0,$scope.selectedFilter.filter).then(function(data){$scope.teasers=data.entities.subList,$scope.hasMore=data.entities.totalSize>$scope.teasers.length,$scope.showFilter=data.hasDuration,$scope.loading=!1},function(){$scope.loading=!1,$scope.showErrorMessage=!0})},fetchNext=function(){var offset=0;fetchingData||(fetchingData=!0,$scope.teasers.length&&(offset=$scope.teasers.length),EntityService.getMyContentByProfileIdAndType(entityTypes,offset,$scope.selectedFilter.filter).then(function(data){$scope.teasers=$scope.teasers.concat(data.entities.subList),$scope.hasMore=data.entities.totalSize>$scope.teasers.length,fetchingData=!1},function(){fetchingData=!1,$scope.showErrorMessage=!0}))};init(),$scope.onFilterChange=function(value){$scope.selectedFilter=value,loadMyContent()},$scope.$on("jc-fetch-my-content",fetchNext)}]),angular.module("juco.filters").filter("jcMyContent",function(){return function(entityEntries){if(entityEntries)return entityEntries.filter(function(entityEntry){return entityEntry.entities&&entityEntry.entities.totalSize>0}).map(function(entityEntry){return entityEntry.entityType.name})}}),angular.module("juco.services").service("MyContentService",["JucoRestService","Cache","REST",function(JucoRestService,Cache,REST){var myContentCache=Cache.createCache("myContentCache"),getCacheKey=function(offset,filters){return"__MY_CONTENT__"+offset+filters.join("-")};this.getMyContent=function(offset,filters){var params={offset:offset,filter:filters};return JucoRestService.getCached(REST.myContent.BASE+"/",params,myContentCache,getCacheKey(offset,filters))}}]),angular.module("juco.mobile").config(["$stateProvider",function($stateProvider){$stateProvider.state("main.notification-center",{url:"notification-center/",templateUrl:"scripts/notification-center/controller/notification-center.html",params:{showBackButton:!0},data:{additionalHeaderStyles:"header-minimal",additionalStyles:"",titleKey:"notification-center.notifications",backButton:function($stateParams){return $stateParams.showBackButton}}})}]),angular.module("juco.mobile.notification-center").service("NotificationCenterApi",["Environment","JWTService",function(Environment,JWTService){"ngInject";function get(relPath){var params=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},url=Environment.getAbsoluteNotificationCenterApiEndpoint()+"/"+relPath;return JWTService.sendAuthenticated({method:"GET",url:url,params:params})}function put(relPath){var params=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},url=Environment.getAbsoluteNotificationCenterApiEndpoint()+"/"+relPath;return JWTService.sendAuthenticated({method:"PUT",url:url,data:params})}this.get=get,this.put=put}]),angular.module("juco.mobile.notification-center").directive("jcNotification",[function(){return{restrict:"E",scope:{apps:"=",notification:"=",notificationState:"=",onMoveNotificationToArchiveClick:"=",onUnmarkNotificationClick:"=",onMarkNotificationClick:"=",onNotificationClick:"="},replace:!0,controllerAs:"vm",controller:"NotificationController",templateUrl:"scripts/notification-center/directive/notification.html",bindToController:!0}}]),angular.module("juco.mobile.notification-center").controller("NotificationController",["$element","$q","MessageHandler","NOTIFICATION_OPTIONS","NOTIFICATION_STATE",function($element,$q,MessageHandler,NOTIFICATION_OPTIONS,NOTIFICATION_STATE){function init(){self.appName=self.apps[self.notification.appId],self.secondaryTextCollapsed=!0,self.onOptionSelected=onOptionSelected,self.toggleSecondaryTextCollapsed=toggleSecondaryTextCollapsed,self.onClick=onClick}function animateMoveNotification(){return self.animationClass=self.notificationState===NOTIFICATION_STATE.ARCHIVED?"animate-move-to-open":"animate-move-to-archive",$q(function(resolve){$element.one("animationend",animateHeightChange),$element.one("transitionend",resolve),$element[0].style.animationPlayState="running"})}function animateHeightChange(){var elementHeight=$element[0].scrollHeight,elementTransition=$element[0].style.transition;$element[0].style.animationPlayState="paused",$element[0].style.transition="",requestAnimationFrame(function(){$element[0].style.height=elementHeight+"px",$element[0].style.transition=elementTransition,requestAnimationFrame(function(){$element[0].style.height="0px"})})}function onClick(){self.notification.isUnsupported?MessageHandler.info("notification-center.notificationNotSupported",{type:self.notification.title}):self.notification.shouldAnimate?animateMoveNotification().then(function(){self.onNotificationClick(self.notification)}):self.onNotificationClick(self.notification)}function toggleSecondaryTextCollapsed(event){event.stopPropagation(),self.secondaryTextCollapsed=!self.secondaryTextCollapsed}function onOptionSelected(selectedOption){selectedOption===NOTIFICATION_OPTIONS.MOVE_TO_ARCHIVE?animateMoveNotification().then(function(){self.onMoveNotificationToArchiveClick(self.notification)}):selectedOption===NOTIFICATION_OPTIONS.MARK?self.onMarkNotificationClick(self.notification):selectedOption===NOTIFICATION_OPTIONS.MARK_AND_MOVE_TO_NEW?animateMoveNotification().then(function(){self.onMarkNotificationClick(self.notification)}):selectedOption===NOTIFICATION_OPTIONS.UNMARK&&self.onUnmarkNotificationClick(self.notification)}var self=this;init()}]),angular.module("juco.mobile.notification-center").directive("jcNotifications",[function(){return{restrict:"E",scope:{notificationState:"@"},controllerAs:"vm",controller:"NotificationsController",templateUrl:"scripts/notification-center/directive/notifications.html",bindToController:!0,replace:!0}}]),angular.module("juco.mobile.notification-center").controller("NotificationsController",["NotificationService","AppConfigurationService","ResourceStateService","DateUtil","PromiseUtil","MessageHandler","$rootScope","$scope","$i18next","$q","ResourceType","IdUtil","NOTIFICATION_OPTIONS","NOTIFICATION_STATE",function(NotificationService,AppConfigurationService,ResourceStateService,DateUtil,PromiseUtil,MessageHandler,$rootScope,$scope,$i18next,$q,ResourceType,IdUtil,NOTIFICATION_OPTIONS,NOTIFICATION_STATE){function init(){self.loading=!1,self.preventLoadingAnimation=!1,self.hasMore=!1,self.notifications=[],self.noContentMessage=self.notificationState===NOTIFICATION_STATE.ARCHIVED?"notification-center.noArchivedNotifications":"notification-center.noUnreadNotifications",self.noContentImage=self.notificationState===NOTIFICATION_STATE.ARCHIVED?"notification-center-no-content-image-archived":"notification-center-no-content-image-unread",self.onNotificationClick=onNotificationClick,self.onMoveNotificationToArchiveClick=onMoveNotificationToArchiveClick,self.onUnmarkNotificationClick=onUnmarkNotificationClick,self.onMarkNotificationClick=onMarkNotificationClick,self.loadNotifications=loadNotifications,self.notificationState===NOTIFICATION_STATE.ARCHIVED?$scope.$on("jc-archived-notifications-changed",forceReload):$scope.$on("jc-open-notifications-changed",forceReload),loadNotifications()}function forceReload(){var limit=self.notifications.length+BATCH_SIZE,offset=new Date;if(!self.loading)return self.preventLoadingAnimation=!0,self.loading=!0,PromiseUtil.all([AppConfigurationService.getAppConfiguration(),NotificationService.getNotifications(self.notificationState,offset,limit)],function(appConfig,notificationSublist){self.notifications=[],onNotificationsLoaded(appConfig,notificationSublist)})["catch"](onErrorLoadingNotifications)}function loadNotifications(){var offset=self.notifications.length>0?self.notifications[self.notifications.length-1].timestamp:new Date;if(!self.loading)return self.loading=!0,PromiseUtil.all([AppConfigurationService.getAppConfiguration(),NotificationService.getNotifications(self.notificationState,offset,BATCH_SIZE)],onNotificationsLoaded)["catch"](onErrorLoadingNotifications)}function translateAppNames(appConfig){var translated=appConfig.reduce(function(acc,curr){var key="appName."+curr.appId,translation=$i18next(key),hasTranslation=translation!==key;return acc[curr.appId]=hasTranslation?translation:curr.name,acc},{});return translated[UNKNOWN_APP_ID]=$i18next("notification-center.appNoLongerAvailable"),translated}function onNotificationsLoaded(appConfig,notificationSublist){var availableApps=appConfig.map(function(app){return app.appId}),notifications=notificationSublist.notifications;self.hasMore=notificationSublist.hasMore,self.apps=translateAppNames(appConfig),self.notifications=0===notifications.length?self.notifications:self.notifications.slice().concat(notifications).map(function(n){return availableApps.indexOf(n.appId)===-1&&(n.appId=UNKNOWN_APP_ID),n.shouldAnimate=self.notificationState!==NOTIFICATION_STATE.ARCHIVED&&!n.marked,n.isUnsupported=!NotificationService.isSupportedNotificationType(n.type),n.options=getOptions(n),n}).map(applyFirstOfANewDay),self.loading=!1,self.preventLoadingAnimation=!1}function getOptions(notification){var options=[];return self.notificationState!==NOTIFICATION_STATE.ARCHIVED&&options.push(NOTIFICATION_OPTIONS.MOVE_TO_ARCHIVE),notification.marked?options.push(NOTIFICATION_OPTIONS.UNMARK):self.notificationState===NOTIFICATION_STATE.OPEN?options.push(NOTIFICATION_OPTIONS.MARK):options.push(NOTIFICATION_OPTIONS.MARK_AND_MOVE_TO_NEW),options}function onErrorLoadingNotifications(){var errorMessage="notification-center.errorLoadingNotifications";self.loading=!1,self.preventLoadingAnimation=!1,MessageHandler.error(errorMessage),self.error=errorMessage}function onNotificationClick(notification){if(!notification.isUnsupported)return archiveIfUnreadAndUnmarked(notification).then(function(goToResource){if(goToResource){var stateParams=getStateParams(notification);ResourceStateService.goToResource(notification.targetId,!1,stateParams)}})}function onMoveNotificationToArchiveClick(notification){NotificationService.archiveNotification(notification.id).then(function(){$rootScope.$broadcast("jc-archived-notifications-changed"),forceReload()})}function onUnmarkNotificationClick(notification){NotificationService.unmarkNotification(notification.id).then(forceReload)}function onMarkNotificationClick(notification){NotificationService.markNotification(notification.id).then(function(){self.notificationState!==NOTIFICATION_STATE.OPEN&&$rootScope.$broadcast("jc-open-notifications-changed"),forceReload()})}function getStateParams(notification){return isEntityInvitationNotification(notification)?{showInvitationActions:self.notificationState!==NOTIFICATION_STATE.ARCHIVED}:isContactRequestNotification(notification)?{showContactActions:self.notificationState!==NOTIFICATION_STATE.ARCHIVED}:{}}function isEntityInvitationNotification(notification){var resourceType=IdUtil.getResourceType(notification.targetId);return resourceType===ResourceType.ENTITY&&"INVITATION"===notification.type}function isContactRequestNotification(notification){return"CONTACT_REQUEST"===notification.type}function archiveIfUnreadAndUnmarked(notification){var willChangeState=ResourceStateService.hasAssociatedState(notification.targetId);return $q(function(resolve,reject){notification.marked||self.notificationState===NOTIFICATION_STATE.ARCHIVED?resolve(willChangeState):NotificationService.archiveNotification(notification.id).then(function(){return willChangeState||($rootScope.$broadcast("jc-archived-notifications-changed"),forceReload()),willChangeState}).then(resolve,reject)})}function applyFirstOfANewDay(notification,index,array){var previous=0===index?null:array[index-1];return notification.isFirstOfANewDay=!previous||!DateUtil.isSameDay(previous.timestamp,notification.timestamp),notification}var self=this,BATCH_SIZE=20,UNKNOWN_APP_ID="unknown";init()}]),angular.module("juco.mobile.notification-center").filter("jcNotificationDate",["$window",function($window){return function(date){return $window.moment(date).calendar(null,{sameDay:function(){return"["+this.fromNow()+"]"},lastDay:"LT",lastWeek:"LT",sameElse:"LT"})}}]),angular.module("juco.mobile.notification-center").constant("NOTIFICATION_OPTIONS",{MARK:{i18nKey:"notification-center.mark"},MARK_AND_MOVE_TO_NEW:{i18nKey:"notification-center.markAndMoveToNew"},UNMARK:{i18nKey:"notification-center.unmark"},MOVE_TO_ARCHIVE:{i18nKey:"notification-center.moveToArchive"}}),angular.module("juco.mobile.notification-center").constant("NOTIFICATION_STATE",{ARCHIVED:"ARCHIVED",OPEN:"OPEN"}),angular.module("juco.mobile.notification-center").service("NotificationService",["$rootScope","$interval","$window","PromiseUtil","REST","EVENTS","NotificationCenterApi",function($rootScope,$interval,$window,PromiseUtil,REST,EVENTS,NotificationCenterApi){function getNotifications(){var status=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"OPEN",offset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:new Date,limit=arguments.length>2&&void 0!==arguments[2]?arguments[2]:20,params={date:offset,loadDirection:"OLDER",locale:$window.i18n.lng(),maxElements:limit,status:status};return NotificationCenterApi.get(REST.notificationCenter.NOTIFICATION,params).then(function(notifications){return{hasMore:notifications.length>=limit,notifications:notifications}})}function getNotificationCount(){return NotificationCenterApi.get(REST.notificationCenter.COUNT())}function updateNotificationCount(){return getNotificationCount().then(function(notificationCount){$rootScope.$broadcast(EVENTS.onNotificationCountChanged,notificationCount.open)})}function archiveNotification(id){return NotificationCenterApi.put(REST.notificationCenter.ARCHIVE_NOTIFICATION(id)).then(updateNotificationCount)}function markNotification(id){return NotificationCenterApi.put(REST.notificationCenter.MARK_NOTIFICATION(id)).then(updateNotificationCount)}function unmarkNotification(id){return NotificationCenterApi.put(REST.notificationCenter.UNMARK_NOTIFICATION(id)).then(updateNotificationCount)}function isSupportedNotificationType(type){return unsupportedNotificationTypes.indexOf(type)<0}var unsupportedNotificationTypes=["COMMENT_ON_DRIVE_SUBSCRIPTION","DRIVE_SHARE_ACCESS_REQUEST","VERSION_RELEASE_REQUEST","VERSION_RELEASE_REQUEST_DECLINED","VERSION_RELEASE_REQUEST_ACCEPTED","ENTITY_JOIN_REQUEST"];this.getNotifications=getNotifications,this.archiveNotification=archiveNotification,this.markNotification=markNotification,this.unmarkNotification=unmarkNotification,this.getNotificationCount=getNotificationCount,this.isSupportedNotificationType=isSupportedNotificationType}]),angular.module("juco.mobile").config(["$stateProvider",function($stateProvider){$stateProvider.state("main.people",{url:"people/",templateUrl:"scripts/people/controller/people.html",controller:"PeopleController",controllerAs:"vm",data:{additionalHeaderStyles:"header-colored-background app-people-bg-color",titleKey:"people.allUsers"}})}]),angular.module("juco.mobile.people").controller("PeopleController",["PeopleService","$scope","$state","$timeout",function(PeopleService,$scope,$state,$timeout){function init(){self.people=[],self.loading=!1,self.hasMore=!1,self.searchQuery="",self.goToProfile=goToProfile,self.fetchNextBatch=fetchNextBatch,self.clearSearchQuery=clearSearchQuery,self.updateSearchQuery=updateSearchQuery,inputElement=document.querySelector("#search-field"),fetchNextBatch()}function fetchNextBatch(){if(!self.loading){self.loading=!0;var offset=self.people.length;PeopleService.getPeople(self.searchQuery,offset,batchSize).then(function(searchResult){self.people=self.people.concat(searchResult.teasers),self.hasMore=self.people.length<searchResult.numberOfResults,self.loading=!1})}}function clearSearchQuery(){inputElement.value="",updateSearchQuery({target:inputElement})}function updateSearchQuery(event){debounce(function(){self.searchQuery=event.target.value,self.people=[],fetchNextBatch()})}function debounce(fn){var debounceDelay=200;$timeout.cancel(pendingDebounce),pendingDebounce=$timeout(fn,debounceDelay)}function goToProfile(id){$state.go("main.profile",{profileId:id})}var self=this,batchSize=50,pendingDebounce=void 0,inputElement=void 0;init()}]),angular.module("juco.mobile.people").service("PeopleService",["PlatformInfoService","SearchService","Cache",function(PlatformInfoService,SearchService,Cache){function cacheKey(query,offset,limit){return[query,offset,limit].join(":")}function getPeople(query,offset,limit){return SearchService.suggestProfiles(query,offset,limit,peopleCache,cacheKey(query,offset,limit))}var peopleCache=Cache.createCache("peopleCache");this.getPeople=getPeople}]),angular.module("juco.mobile").config(["$stateProvider",function($stateProvider){$stateProvider.state("main.profile",{url:"profile/:profileId",views:{"":{templateUrl:"scripts/profile/controller/profile.html",controller:"ProfileController"},"content@main.profile":{templateUrl:"scripts/profile/controller/profile-info.html",controller:"ProfileInfoController",controllerAs:"vm"}},params:{showContactActions:null},data:{showViewLoading:!0,additionalHeaderStyles:"header-colored-background app-people-bg-color"},resolve:{profileId:juco.fromStateParams("profileId"),profile:["$stateParams","ProfileService",function($stateParams,ProfileService){return $stateParams.profileId?ProfileService.getProfile($stateParams.profileId).then(null,function(error){$stateParams.error=error.info}):($stateParams.error="profile.noProfileIdProvided",null)}],chatEnabled:["ConfigurationService",function(ConfigurationService){return ConfigurationService.isChatEnabled()}]}})}]),angular.module("juco.mobile.profile").controller("ProfileController",["$scope","CurrentUser","profileId","profile","$stateParams","ProfileService","ErrorHandler","ArrayUtil","$state","StateUtil","PROFILE","MessageHandler","$q","$rootScope","EVENTS","chatEnabled","ConversationService",function($scope,CurrentUser,profileId,profile,$stateParams,ProfileService,ErrorHandler,ArrayUtil,$state,StateUtil,PROFILE,MessageHandler,$q,$rootScope,EVENTS,chatEnabled,ConversationService){function init(){return $scope.toggleShowSelectContactStatus=toggleShowSelectContactStatus,$scope.onMenuEntrySelected=onMenuEntrySelected,$stateParams.error||!profile?void handleServerError($stateParams.error):($scope.profile=profile,buildMenu(),void($stateParams.showContactActions&&($scope.showSelectContactStatus=!0)))}function startChat(){ConversationService.startNewConversation([profileId]).then(function(conversation){$state.go("chat.conversation",{conversationId:conversation.id})},function(){MessageHandler.error("conversation.failedToCreateConversation")})}function handleServerError(error){if(!error)return void ErrorHandler.showErrorPage(404,MessageHandler.createErrorMessage("profile.errorGettingProfileFromServer"));var errorInfo=error.info||error;ErrorHandler.handleServerError(error),$scope.error=errorInfo.data&&"FORBIDDEN"===errorInfo.data.code?"profile.profileNotVisible":"exception.anErrorOccurred"}function reloadProfile(){var updatedParams=angular.copy($state.params);updatedParams.showContactActions=!1,$state.transitionTo($state.current,updatedParams,{reload:!0,inherit:!1,notify:!0})}function createContactAction(functionToChangeStatus){return function(){$scope.loadingContactStatus?MessageHandler.warn("profile.warningAlreadyChangingContactStatus"):($scope.loadingContactStatus=!0,functionToChangeStatus(profileId,!0).then(reloadProfile,function(error){$scope.loadingContactStatus=!1,error.info&&error.info.data&&"CONFLICT"===error.info.data.code?(reloadProfile(),MessageHandler.error("profile.contactRequestExpired")):handleServerError(error)}))}}function getAvailableContactActions(){return ProfileService.getContactStatus(CurrentUser.getId(),profileId).then(function(contactStatus){return contactStatus?ArrayUtil.contains(contactStatus.allowedActions,PROFILE.contactAction.ACCEPT_CONTACT_REQUEST)?[{i18nKey:"profile.acceptContactRequest",action:createContactAction(ProfileService.acceptContactRequest)},{i18nKey:"profile.declineContactRequest",action:createContactAction(ProfileService.declineContactRequest)}]:ArrayUtil.contains(contactStatus.allowedActions,PROFILE.contactAction.WITHDRAW_CONTACT_REQUEST)?[{i18nKey:"profile.withdrawContactRequest",action:createContactAction(ProfileService.withdrawContactRequest)}]:ArrayUtil.contains(contactStatus.allowedActions,PROFILE.contactAction.REMOVE_CONTACT)?[{i18nKey:"profile.removeContact",action:createContactAction(ProfileService.removeContact)}]:ArrayUtil.contains(contactStatus.allowedActions,PROFILE.contactAction.ADD_CONTACT)?[{i18nKey:"profile.sendContactRequest",action:createContactAction(ProfileService.sendContactRequest)}]:[]:[]})}function buildMenu(){var availableActions=[];isOwnProfile||(chatEnabled&&profile.mayChatWith&&availableActions.push({
i18nKey:"chat.startChat",action:startChat}),getAvailableContactActions().then(function(availableContactActions){$scope.contactActions=availableContactActions,$scope.availableActions=availableActions.concat(availableContactActions)}))}function onMenuEntrySelected(menuEntry){menuEntry.action()}function toggleShowSelectContactStatus(){$scope.showSelectContactStatus=!$scope.showSelectContactStatus&&$scope.contactActions.length>0}var isOwnProfile=profileId===CurrentUser.getId();init()}]),angular.module("juco.controller").controller("ProfileInfoController",["$scope","profileId","ProfileService","MessageHandler","ObjectUtil","CONFIG","ProfileAttributeType","ProfileSectionType",function($scope,profileId,ProfileService,MessageHandler,ObjectUtil,CONFIG,ProfileAttributeType,ProfileSectionType){function init(){return profileId?(self.i18nPrefix="profileAttribute.",void loadAttributes()):(MessageHandler.error("profile.noProfileIdProvided"),void(self.errorLoadingProfile=!0))}function loadAttributes(){self.loadingProfile=!0,ProfileService.getProfileAttributes(profileId).then(function(profile){var sectionsModel=addDisplayInfoToSections(profile.sections);self.loadingProfile=!1,self.sections=sectionsModel.sections,self.empty=sectionsModel.empty},function(){self.loadingProfile=!1,self.errorLoadingProfile=!0})}function addDisplayInfoToSections(sections){var empty=!0;return sections?(sections.forEach(function(section){var blocks=section.attributeBlocks||[];blocks.forEach(function(block){var attributes=block.attributes||[];section.show=attributes.length&&(section.type===ProfileSectionType.DEFAULT||section.type===ProfileSectionType.CHRONOLOGY),section.show&&(empty=!1)})}),{sections:sections,empty:empty}):{sections:sections,empty:!0}}var self=this;init()}]),function(){function ProfileAttributeController(ProfileAttributeType,i18nextFilter,dateFilter,jcI18nDynamicAttributeFilter){function init(){self.labelI18nKey=self.displayLabel?self.attribute.name:null,self.displayAs=getDisplayAs(self.attribute.type),self.separateBy=self.attribute.type===ProfileAttributeType.TREE_SELECT?"BR":"DEFAULT",self.attributeValues=self.attribute.values.filter(function(value){return value&&value.trim().length>0}).map(mapAttributeValue)}function mapAttributeValue(value){switch(self.attribute.type){case ProfileAttributeType.SELECT:case ProfileAttributeType.CHECKRADIO:case ProfileAttributeType.DESCRIPTION:return jcI18nDynamicAttributeFilter(value,self.i18nKeyPrefix);case ProfileAttributeType.TEXT:case ProfileAttributeType.TEXT_PHONE:case ProfileAttributeType.TEXTAREA:return value;case ProfileAttributeType.MONTH_YEAR_PERIOD:return mapMonthYearPeriod(value);case ProfileAttributeType.TREE_SELECT:return value.split(",").map(function(treeValue){return jcI18nDynamicAttributeFilter(treeValue,self.i18nKeyPrefix)}).join(", ");default:return value}}function getDisplayAs(attributeType){switch(attributeType){case ProfileAttributeType.TEXT:case ProfileAttributeType.TEXT_PHONE:case ProfileAttributeType.TEXTAREA:return"TYPED";case ProfileAttributeType.DESCRIPTION:return"HTML";case ProfileAttributeType.SELECT:case ProfileAttributeType.CHECKRADIO:case ProfileAttributeType.MONTH_YEAR_PERIOD:case ProfileAttributeType.TREE_SELECT:return"RAW";default:return"RAW"}}function mapMonthYearPeriod(value){var datePattern,fromString,toString,period=parsePeriodString(value),now=new Date;if(!period)return value;if(datePattern=i18nextFilter("profile.monthYearPeriodDatePattern"),fromString=dateFilter(period.fromDate,datePattern),period.toDate)toString=dateFilter(period.toDate,datePattern);else{if(!(period.fromDate<now))return i18nextFilter("profile.monthYearPeriodFuture",{from:fromString});toString=i18nextFilter("profile.monthYearPeriodToday")}return i18nextFilter("profile.monthYearPeriod",{from:fromString,to:toString})}function parsePeriodString(periodString){var fromDate,toDate,parts=periodString.split("-");return 2!==parts.length?null:(fromDate=parseMonthYearString(parts[0]),toDate=parseMonthYearString(parts[1]),fromDate?{fromDate:fromDate,toDate:toDate}:null)}function parseMonthYearString(monthYearString){var fromMatches,month,year;return monthYearString&&"today"!==monthYearString.toLowerCase()&&(fromMatches=monthYearString.match(MONTH_YEAR_REGEX))?(month=parseInt(fromMatches[1]),month<1||month>12?null:(year=parseInt(fromMatches[2]),new Date(year,month-1,1))):null}var self=this,MONTH_YEAR_REGEX=/^(\d{2})\/(\d{4})$/;init()}angular.module("juco.mobile.profile").directive("jcProfileAttribute",function(){return{restrict:"E",scope:{attribute:"=",displayLabel:"=",i18nKeyPrefix:"="},templateUrl:"scripts/profile/directive/jc-profile-attribute.html",controller:"ProfileAttributeController",controllerAs:"profileAttribute",bindToController:!0}}),angular.module("juco.mobile.profile").controller("ProfileAttributeController",["ProfileAttributeType","i18nextFilter","dateFilter","jcI18nDynamicAttributeFilter",ProfileAttributeController])}(),angular.module("juco.mobile.profile").filter("profileName",["i18nextFilter","ProfileService",function(i18nextFilter,ProfileService){return function(profile){var prefixKey,prefix;return!profile||profile.deleted?i18nextFilter("profile.deletedUser"):(prefixKey=ProfileService.getProfileNamePrefixTranslationKey(profile),prefix=i18nextFilter(prefixKey)||"",prefix+profile.name)}}]),angular.module("juco.constants").constant("ProfileAttributeType",function(){return{TEXT:"TEXT",TEXT_PHONE:"TEXT_PHONE",TEXTAREA:"TEXTAREA",SELECT:"SELECT",CHECKRADIO:"CHECKRADIO",MONTH_YEAR_PERIOD:"MONTH_YEAR_PERIOD",DESCRIPTION:"DESCRIPTION",TREE_SELECT:"TREE_SELECT"}}()),angular.module("juco.constants").constant("ProfileSectionType",function(){return{DEFAULT:"DEFAULT",CHRONOLOGY:"CHRONOLOGY"}}()),angular.module("juco.controller").factory("searchPageCache",["Cache",function(Cache){var cacheKey="searchPage",cache=Cache.createCache("searchPageCache",{maxAge:864e5});return{get:function(){return cache.get(cacheKey)},put:function(searchPage){cache.put(cacheKey,searchPage)},clear:function(){cache.removeAll()}}}]).controller("SearchController",["$scope","$rootScope","$log","EVENTS","SearchService","$timeout","query","searchPageCache","DomUtil",function($scope,$rootScope,$log,EVENTS,SearchService,$timeout,query,searchPageCache,DomUtil){function init(){var cached=searchPageCache.get()||{};lastSearchResult=cached.lastSearchResult,$scope.searchResultTeasers=cached.searchResultTeasers||[],$scope.loading=!1,$scope.displayStatusText=!1,$scope.searchStatusI18nKey="",$scope.searchStatusType="search-info",$scope.hasMore=!1,$scope.searchQuery="",$scope.doSearch=doSearch,$scope.clearSearchQuery=clearSearchQuery,$scope.$on("jc-fetch-next-search-results",fetchNextSearchResults),onStateChangeStartListenerDeregistration=$rootScope.$on("$stateChangeStart",function(){scrollHeightOnLeaving=DomUtil.getScrollHeight()}),$scope.$on("$destroy",function(){searchPageCache.put({lastSearchResult:lastSearchResult,searchResultTeasers:$scope.searchResultTeasers,scrollHeight:scrollHeightOnLeaving}),onStateChangeStartListenerDeregistration&&onStateChangeStartListenerDeregistration()}),query?($scope.searchQuery=query,doSearch()):cached.lastSearchResult?($scope.searchQuery=cached.lastSearchResult.searchQuery,$scope.hasMore=checkHasMore(),DomUtil.scrollToYIfPossible(cached.scrollHeight,3)):doSearch()}function checkHasMore(){return lastSearchResult.numberOfResults>lastSearchResult.offset+lastSearchResult.teasers.length}function fetchNextSearchResults(){if($log.info("Event to fetch new Search result received."),!fetchingNextSearchResult&&lastSearchResult){fetchingNextSearchResult=!0;var offset=lastSearchResult.offset+searchResultLoadCount;SearchService.suggest(lastSearchResult.searchQuery,offset,searchResultLoadCount).then(showSearchResult)}}function clearSearchResult(){$scope.searchResultTeasers=[],$scope.hasMore=!1,lastSearchResult=void 0}function displayStatusInfo(i18nKey){$scope.searchStatusType="search-info",$scope.searchStatusI18nKey=i18nKey,$scope.displayStatusText=!0}function displayStatusError(i18nKey){$scope.searchStatusType="search-error",$scope.searchStatusI18nKey=i18nKey,$scope.displayStatusText=!0}function hideStatusText(){$scope.displayStatusText=!1}function showSearchResult(searchResult){$scope.loading=!1,lastSearchResult=searchResult,0===searchResult.numberOfResults?(displayStatusInfo("search.noSearchResult"),clearSearchResult()):(hideStatusText(),$scope.searchResultTeasers=$scope.searchResultTeasers.concat(searchResult.teasers),$scope.hasMore=checkHasMore()),fetchingNextSearchResult=!1}function doSearch(){clearSearchResult(),""===$scope.searchQuery.trim()?displayStatusError("search.noSearchTextDefined"):(hideStatusText(),$scope.loading=!0,SearchService.suggest($scope.searchQuery,0,searchResultLoadCount).then(showSearchResult,function(){$scope.loading=!1,displayStatusError("search.errorSearching")}))}function clearSearchQuery(){clearSearchResult(),$scope.searchQuery=""}var searchResultLoadCount=25,scrollHeightOnLeaving=void 0,onStateChangeStartListenerDeregistration=void 0,fetchingNextSearchResult=!1,lastSearchResult=void 0;init()}]),angular.module("juco.services").service("SearchService",["JucoRestService","REST",function(JucoRestService,REST){function suggest(searchString,offset,limit){var params={query:searchString,type:"ALL",excludeType:["NEWSBLOG","WORKSTREAM"],offset:offset,count:limit};return JucoRestService.get(REST.search.SUGGEST(),params)}function suggestProfiles(searchString,offset,limit,cache,key){var params={query:searchString,type:"PERSON",offset:offset,count:limit,sortBy:"ALPHABETICAL"};return JucoRestService.getCached(REST.search.SUGGEST(),params,cache,key)}this.suggest=suggest,this.suggestProfiles=suggestProfiles}]),angular.module("juco.mobile.task",["juco.shared.common","juco.services","juco.mobile.rest"]);var taskAssignment={bindings:{taskId:"<"},templateUrl:"scripts/task/task-assignment/task-assignment.html",controller:"TaskAssignmentController"};angular.module("juco.mobile.task").component("taskAssignment",taskAssignment).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.task.details.assign",{url:"/assign",views:{"@main.task":"taskAssignment"},resolve:{taskId:["$transition$",function($transition$){return $transition$.params().id}]},data:{backButton:!0,titleKey:"task.assign"}})}]),angular.module("juco.mobile.task").controller("TaskAssignmentController",TaskAssignmentController);var task={bindings:{teaser:"<"},templateUrl:"scripts/task/task/task.html",controller:"TaskController"};angular.module("juco.mobile.task").component("task",task),angular.module("juco.mobile.task").controller("TaskController",TaskController);var taskDetails={bindings:{taskId:"<",previousState:"<"},templateUrl:"scripts/task/task-details/task-details.html",controller:"TaskDetailsController"};angular.module("juco.mobile.task").component("taskDetails",taskDetails).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.task.details",{url:"details/:id",views:{"@main.task":"taskDetails","subtasks@main.task.details":"tasks"},resolve:{taskId:["$transition$",function($transition$){return $transition$.params().id}],previousState:["$state",function($state){return $state.current}]},data:{backButton:!0}})}]),angular.module("juco.mobile.task").controller("TaskDetailsController",TaskDetailsController);var taskLists={templateUrl:"scripts/task/task-lists/task-lists.html",controller:"TaskListsController"};angular.module("juco.mobile.task").component("taskLists",taskLists).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.task.myLists",{url:"my-lists",component:"taskLists",data:{titleKey:"task.myLists"}})}]),angular.module("juco.mobile.task").controller("TaskListsController",TaskListsController);var taskTitleEditor={bindings:{title:"<",isEditable:"<",hasFocus:"<",onTitleChanged:"&",onSave:"&"},templateUrl:"scripts/task/task-title-editor/task-title-editor.html",controller:"TaskTitleEditorController"};angular.module("juco.mobile.task").component("taskTitleEditor",taskTitleEditor),angular.module("juco.mobile.task").controller("TaskTitleEditorController",TaskTitleEditorController);var tasks={bindings:{filter:"<"},templateUrl:"scripts/task/tasks/tasks.html",controller:"TasksController"};angular.module("juco.mobile.task").component("tasks",tasks).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.task.createdByMe",{url:"created-by-me",component:"tasks",resolve:{filter:["TaskFilter",function(TaskFilter){return TaskFilter.CREATED_BY_ME}]},data:{titleKey:"task.createdByMe"}}).state("main.task.assignedToMe",{url:"assigned-to-me",component:"tasks",resolve:{filter:["TaskFilter",function(TaskFilter){return TaskFilter.ASSIGNED_TO_ME}]},data:{titleKey:"task.assignedToMe"}}).state("main.task.list",{url:"list/:id",component:"tasks",resolve:{filter:["$transition$",function($transition$){return $transition$.params().id}]},data:{backButton:!0,titleKey:"task.myLists"}})}]),angular.module("juco.mobile.task").controller("TasksController",TasksController);var taskRoot={bindings:{showBackButton:"<"},templateUrl:"scripts/task/task.root.html",controller:"TaskRootController"};angular.module("juco.mobile.task").component("taskRoot",taskRoot).config(["$stateProvider",function($stateProvider){$stateProvider.state("main.task",{"abstract":!0,url:"task/",component:"taskRoot",resolve:{showBackButton:["$transition$",function($transition$){return $transition$.params().showBackButton}]},data:{additionalHeaderStyles:"header-colored-background app-tasks-bg-color",additionalStyles:"app-tasks"}})}]),angular.module("juco.mobile.task").controller("TaskRootController",TaskRootController),angular.module("juco.mobile.task").constant("TaskFilter",{ASSIGNED_TO_ME:"assignedToMe",CREATED_BY_ME:"createdByMe"}),angular.module("juco.mobile.task").constant("TaskStatus",{OPEN:"OPEN",COMPLETED:"COMPLETED"}),angular.module("juco.mobile.task").service("TaskService",["PlatformInfoService","HeaderTitleService","Cache","JucoRestService","REST","TaskFilter","TaskStatus","IdUtil","CurrentUser","MessageHandler","PromiseUtil","$i18next",function(PlatformInfoService,HeaderTitleService,Cache,JucoRestService,REST,TaskFilter,TaskStatus,IdUtil,CurrentUser,MessageHandler,PromiseUtil,$i18next){"ngInject";function cacheKey(filter,status,offset,limit){return filter+":"+status+":"+offset+":"+limit}function updateTaskInCache(taskId,taskDetails){taskByIdCache.put(taskId,taskDetails),tasksCache.removeAll()}function removeTaskFromCache(taskId){taskByIdCache.remove(taskId),tasksCache.removeAll()}function getMyTaskLists(){return JucoRestService.getCached(REST.task.MY_LISTS(),{},myTaskListsCache,"MY_TASK_LISTS",!0)}function getTaskListById(taskListId){return JucoRestService.getCached(REST.task.LIST(taskListId),{},taskListCache,taskListId,!0)}function getTasksByFilterAndStatus(filter,status){var offset=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,limit=arguments.length>3&&void 0!==arguments[3]?arguments[3]:50;filter=filter||TaskFilter.ASSIGNED_TO_ME;var statusFilter=status||TaskStatus.OPEN,key=cacheKey(filter,status,offset,limit),params={offset:offset,limit:limit,statusFilter:statusFilter};return JucoRestService.getCached(REST.task.TASKS_FILTER(filter),params,tasksCache,key,!0)}function setTaskStatus(taskId,status){return JucoRestService.put(REST.task.STATUS(taskId,status),{},!0).then(function(){taskByIdCache.remove(taskId),tasksCache.removeAll()})}function getTaskById(taskId){return JucoRestService.getCached(REST.task.TASK(taskId),{},taskByIdCache,taskId,!0)}function createNewTask(filterId,taskName){return JucoRestService.post(REST.task.NEW(filterId),taskName,!0).then(function(newTask){return tasksCache.removeAll(),newTask})}function saveDescription(taskId,description){return JucoRestService.post(REST.task.DESCRIPTION(taskId),description,!0).then(function(taskDetails){return updateTaskInCache(taskId,taskDetails),taskDetails})}function saveAssignee(taskId,profileId){var personId=IdUtil.toPersonId(profileId);return JucoRestService.post(REST.task.ASSIGNEE(taskId),personId,!0).then(function(taskDetails){return updateTaskInCache(taskId,taskDetails),taskDetails})}function saveTitle(taskId,title){return JucoRestService.post(REST.task.TITLE(taskId),title,!0).then(function(taskDetails){return updateTaskInCache(taskId,taskDetails),taskDetails})}function saveDueDate(taskId,date){return JucoRestService.post(REST.task.DUE_DATE(taskId),date,!0).then(function(taskDetails){return updateTaskInCache(taskId,taskDetails),taskDetails})}function deleteTask(taskId){return JucoRestService.deleteCall(REST.task.TASK(taskId)).then(function(){return removeTaskFromCache(taskId)})}function isTaskListId(arg){return!!arg&&0===arg.toString().indexOf("TASK_LIST,")}function isTaskId(arg){return!!arg&&0===arg.toString().indexOf("TASK,")}function setHeaderTitleToAssignedToMeOrCreatedByMe(ownerId,assigneeId){var titleKey=void 0;return assigneeId===CurrentUser.getId()?(titleKey="task.assignedToMe",HeaderTitleService.setHeaderTitleTranslation(titleKey),PromiseUtil.immediateResolve($i18next(titleKey))):ownerId===CurrentUser.getId()?(titleKey="task.createdByMe",HeaderTitleService.setHeaderTitleTranslation(titleKey),PromiseUtil.immediateResolve($i18next(titleKey))):PromiseUtil.immediateReject()}function setParentTitleAsHeader(parentId,ownerId,assigneeId){function errorHandler(errorKey){return function(error){return 403===error.status?setHeaderTitleToAssignedToMeOrCreatedByMe(ownerId,assigneeId):(MessageHandler.error(errorKey),PromiseUtil.immediateReject(error))}}return isTaskListId(parentId)?getTaskListById(parentId).then(function(list){return HeaderTitleService.setHeaderTitleValue(list.name),list.name})["catch"](errorHandler("task.errorLoadingParentList")):isTaskId(parentId)?getTaskById(parentId).then(function(taskDetails){return HeaderTitleService.setHeaderTitleValue(taskDetails.task.name),taskDetails.task.name})["catch"](errorHandler("task.errorLoadingParentTask")):setHeaderTitleToAssignedToMeOrCreatedByMe(ownerId,assigneeId)}var tasksCache=Cache.createCache("tasksCache"),taskByIdCache=Cache.createCache("taskByIdCache"),taskListCache=Cache.createCache("taskListCache"),myTaskListsCache=Cache.createCache("myTaskListsCache");this.getMyTaskLists=getMyTaskLists,this.getTaskListById=getTaskListById,this.getTasksByFilterAndStatus=getTasksByFilterAndStatus,this.setTaskStatus=setTaskStatus,this.getTaskById=getTaskById,this.createNewTask=createNewTask,this.saveDescription=saveDescription,this.saveAssignee=saveAssignee,this.saveTitle=saveTitle,this.saveDueDate=saveDueDate,this.deleteTask=deleteTask,this.isTaskListId=isTaskListId,this.isTaskId=isTaskId,this.setParentTitleAsHeader=setParentTitleAsHeader}]),angular.module("juco.constants").constant("THEME_ATTRIBUTE_DATA_TYPE",function(){return{COLOR:"COLOR",IMAGE:"IMAGE",PIXEL:"PIXEL",BOOLEAN:"BOOLEAN"}}()),angular.module("juco.constants").constant("THEME_TEMPLATES",function(){return{defaultTemplate:"@THEME_CLASS header {    background-color: @HORIZONTAL_NAVIGATION_BACKGROUND_COLOR;    color: @HORIZONTAL_NAVIGATION_LINK_COLOR;}@THEME_CLASS header .link,@THEME_CLASS header .link:hover,@THEME_CLASS header .link:focus {    color: @HORIZONTAL_NAVIGATION_LINK_COLOR;}@THEME_CLASS header .link-right.conversations .jc-icon-link-with-count .count,@THEME_CLASS header .link-right.notifications .jc-icon-link-with-count .count {    background-color: @HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR;}@THEME_CLASS .header-logo {    background-image: @MOBILE_LOGO_IMAGE;}@THEME_CLASS .jc-ng-all-conversations .jc-mobile-unread-count,@THEME_CLASS .jc-notification-bg-color {    background-color: @HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR;}@THEME_CLASS .jc-notification-color {    color: @HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR;}@THEME_CLASS .jc-notification-border-color {    border-color: @HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR;}@THEME_CLASS .app-connect-bg-color {    background-color: @APP_CONNECT_BACKGROUND_COLOR;}@THEME_CLASS .app-connect-color {    color: @APP_CONNECT_BACKGROUND_COLOR;}@THEME_CLASS .app-connect-border-color {    border-color: @APP_CONNECT_BACKGROUND_COLOR;}@THEME_CLASS .app-drive-bg-color {    background-color: @APP_DRIVE_BACKGROUND_COLOR;}@THEME_CLASS .app-drive-color {    color: @APP_DRIVE_BACKGROUND_COLOR;}@THEME_CLASS .app-tasks-bg-color {    background-color: @APP_TASKS_BACKGROUND_COLOR;}@THEME_CLASS .app-tasks-color {    color: @APP_TASKS_BACKGROUND_COLOR;}@THEME_CLASS .app-news-color {    color: @APP_NEWS_BACKGROUND_COLOR;}@THEME_CLASS .app-news-bg-color {    background-color: @APP_NEWS_BACKGROUND_COLOR;}@THEME_CLASS .app-wiki-color {    color: @APP_WIKI_BACKGROUND_COLOR;}@THEME_CLASS .app-wiki-bg-color {    background-color: @APP_WIKI_BACKGROUND_COLOR;}@THEME_CLASS .app-people-color {    color: @APP_PEOPLE_BACKGROUND_COLOR;}@THEME_CLASS .app-people-bg-color {    background-color: @APP_PEOPLE_BACKGROUND_COLOR;}@THEME_CLASS .entity .subheader .sub-navigation.navbar-nav {    background-color: @APP_CONNECT_BACKGROUND_COLOR;}@THEME_CLASS .entity .subheader .sub-navigation.navbar-nav li.active {    background-color: lighten(@APP_CONNECT_BACKGROUND_COLOR, 25%);}@THEME_CLASS .app-chat-bg-color {    background-color: @APP_CHAT_BACKGROUND_COLOR;}@THEME_CLASS .app-chat-bg-color-light {    background-color: lighten(@APP_CHAT_BACKGROUND_COLOR, 25%);}@THEME_CLASS .app-chat-color {    color: @APP_CHAT_BACKGROUND_COLOR;}@THEME_CLASS .app-chat-color-light {    color: lighten(@APP_CHAT_BACKGROUND_COLOR, 55%);}@THEME_CLASS .jc-mobile-chat-bar {    border-bottom: 1px solid lighten(@APP_CHAT_BACKGROUND_COLOR, 55%)}@THEME_CLASS .chat-search-teaser-icon .jc-mobile-chat-group-icon {    color: darken(@APP_CHAT_BACKGROUND_COLOR, 22%);}@THEME_CLASS .jc-ng-suggest-list {    background-color: darken(@APP_CHAT_BACKGROUND_COLOR, 22%);}@THEME_CLASS .jc-ng-suggest-dropdown-arrow-up {    border-bottom-color: darken(@APP_CHAT_BACKGROUND_COLOR, 22%);}@THEME_CLASS header .link-right.conversations .jc-icon-link-arrow-up {    border-bottom-color: @APP_CHAT_BACKGROUND_COLOR;}@THEME_CLASS .profile .subheader .sub-navigation.navbar-nav {    background-color: @APP_CONNECT_BACKGROUND_COLOR;}@THEME_CLASS .profile .subheader .sub-navigation.navbar-nav li.active {    background-color: lighten(@APP_CONNECT_BACKGROUND_COLOR, 25%);}@THEME_CLASS .login-page {    color: @NG_LOGIN_TEXT_COLOR;    background: -webkit-linear-gradient(top, @NG_LOGIN_PAGE_BACKGROUND_GRADIENT_START_COLOR, @NG_LOGIN_PAGE_BACKGROUND_GRADIENT_END_COLOR) no-repeat;    background: linear-gradient(to bottom, @NG_LOGIN_PAGE_BACKGROUND_GRADIENT_START_COLOR, @NG_LOGIN_PAGE_BACKGROUND_GRADIENT_END_COLOR) no-repeat;}@THEME_CLASS .login-input::-moz-placeholder {    color: @NG_LOGIN_TEXT_COLOR;}@THEME_CLASS .login-input:-ms-input-placeholder {    color: @NG_LOGIN_TEXT_COLOR;}@THEME_CLASS .login-input::-webkit-input-placeholder {    color: @NG_LOGIN_TEXT_COLOR;}@THEME_CLASS .login-page a, .login-page .change-platform {    color: @NG_LOGIN_LINK_COLOR;}@THEME_CLASS .login-input {    border-bottom-color: @NG_LOGIN_TEXT_COLOR;}@THEME_CLASS .login-submit {    color: @NG_LOGIN_BUTTON_TEXT_COLOR;    background-color: @NG_LOGIN_BUTTON_BACKGROUND_COLOR;}@THEME_CLASS .login-submit:active {    color: darken(@NG_LOGIN_BUTTON_TEXT_COLOR, 86.5%);    background-color: darken(@NG_LOGIN_BUTTON_BACKGROUND_COLOR, 10%);}@THEME_CLASS .login-logo {    background-image: @NG_LOGIN_PAGE_LOGO;}@THEME_CLASS .terms-buttons {    color: @NG_LOGIN_BUTTON_TEXT_COLOR;    background-color: @NG_LOGIN_PAGE_BACKGROUND_GRADIENT_START_COLOR;}"}}()),angular.module("juco.services").service("ThemeService",["$rootScope","$document","$log","REST","EVENTS","Cache","JucoRestService","ThemeTemplateService",function($rootScope,$document,$log,REST,EVENTS,Cache,JucoRestService,ThemeTemplateService){function init(){generateFallbackDefaultTheme(),$rootScope.$on(EVENTS.onUserDeauthenticated,onUserDeauthenticated)}function onUserDeauthenticated(){initialThemeResolved=!1,currentLayoutEntityId=void 0}function resolveLoginTheme(){return globalThemeId?(activateThemeId(globalThemeId),!0):getGlobalTheme().then(function(theme){return globalThemeId=ThemeTemplateService.normalizeThemeId(theme.id),activateLoadedTheme(theme)},errorHandler)}function getGlobalTheme(){return JucoRestService.get(REST.theme.GLOBAL(),{},!0)}function resolveInitialTheme(){return!!initialThemeResolved||getDefaultThemeInfo().then(function(themeInfo){if(!initialThemeResolved)return switchTheme(themeInfo,!0)},errorHandler)}function getDefaultThemeInfo(){return JucoRestService.get(REST.theme.DEFAULT(),{},!0)}function resolveThemeByEntityId(entityId){return getThemeInfoByEntityId(entityId).then(function(themeInfo){return switchTheme(themeInfo,!1)},errorHandler)}function errorHandler(error){return $log.error("Error loading theme",error),!1}function switchTheme(themeInfo,defaultTheme){var themeId=ThemeTemplateService.normalizeThemeId(themeInfo.id);return defaultTheme||(currentLayoutEntityId=themeInfo.currentLayoutEntityId),themeCache[themeId]?(initialThemeResolved=!0,activateThemeId(themeId),!0):getThemeById(themeInfo.id).then(function(theme){return!(!defaultTheme||!initialThemeResolved)||(initialThemeResolved=!0,activateLoadedTheme(theme))})}function activateLoadedTheme(theme){var themeId=ThemeTemplateService.normalizeThemeId(theme.id);return themeCache[themeId]||(addCssToDocument(generateThemeCss(theme)),themeCache[themeId]=!0),activateThemeId(themeId),!0}function activateThemeId(themeId){$log.debug("Activate theme with id "+themeId),$rootScope.setThemeId(themeId)}function getThemeInfoByEntityId(entityId){var url=REST.theme.INFO(entityId),params={},cacheKey=[entityId,currentLayoutEntityId].join("#");return currentLayoutEntityId&&(params.currentLayoutEntityId=currentLayoutEntityId),JucoRestService.getCached(url,params,entityThemeInfoCache,cacheKey,!0)}function getThemeById(themeId){var url=REST.theme.THEME(themeId);return JucoRestService.get(url,{},!0)}function generateThemeCss(theme){return ThemeTemplateService.compileDefaultTemplate(theme)}function addCssToDocument(css){var document=$document[0],style=document.createElement("style");style.type="text/css",style.styleSheet?style.styleSheet.cssText=css:style.innerHTML=css,document.getElementsByTagName("head")[0].appendChild(style)}function generateFallbackDefaultTheme(){var defaultThemeAttributes=[{attributeType:"MOBILE_LOGO_IMAGE",dataType:"IMAGE",value:null},{attributeType:"HORIZONTAL_NAVIGATION_BACKGROUND_COLOR",dataType:"COLOR",value:"#ffffff"},{attributeType:"HORIZONTAL_NAVIGATION_LINK_COLOR",dataType:"COLOR",value:"#404040"},{attributeType:"HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR",dataType:"COLOR",value:"#D81B60"},{attributeType:"APP_CONNECT_BACKGROUND_COLOR",dataType:"COLOR",value:"#7CB342"},{attributeType:"APP_CHAT_BACKGROUND_COLOR",dataType:"COLOR",value:"#5587A2"},{attributeType:"APP_DRIVE_BACKGROUND_COLOR",dataType:"COLOR",value:"#FFA000"},{attributeType:"APP_TASKS_BACKGROUND_COLOR",dataType:"COLOR",value:"#EF5350"},{attributeType:"APP_NEWS_BACKGROUND_COLOR",dataType:"COLOR",value:"#CD52B0"},{attributeType:"APP_WIKI_BACKGROUND_COLOR",dataType:"COLOR",value:"#7CB342"},{attributeType:"NG_LOGIN_TEXT_COLOR",dataType:"COLOR",value:"#ffffff"},{attributeType:"NG_LOGIN_LINK_COLOR",dataType:"COLOR",value:"#ffffff"},{attributeType:"NG_LOGIN_PAGE_BACKGROUND_GRADIENT_START_COLOR",dataType:"COLOR",value:"#D81B60"},{attributeType:"NG_LOGIN_PAGE_BACKGROUND_GRADIENT_END_COLOR",dataType:"COLOR",value:"#EF5350"},{attributeType:"NG_LOGIN_BUTTON_TEXT_COLOR",dataType:"COLOR",value:"#D81B60"},{attributeType:"NG_LOGIN_BUTTON_BACKGROUND_COLOR",dataType:"COLOR",value:"#ffffff"},{attributeType:"NG_LOGIN_PAGE_LOGO",dataType:"IMAGE",value:null}],defaultCss=ThemeTemplateService.compileDefaultTemplate({id:"default-theme",attributes:defaultThemeAttributes});addCssToDocument(defaultCss)}var globalThemeId,currentLayoutEntityId,themeCache={},entityThemeInfoCache=Cache.createCache("entityThemeInfoCache"),initialThemeResolved=!1;init(),this.resolveLoginTheme=resolveLoginTheme,this.resolveInitialTheme=resolveInitialTheme,this.resolveThemeByEntityId=resolveThemeByEntityId}]),angular.module("juco.services").service("ThemeTemplateService",["THEME_ATTRIBUTE_DATA_TYPE","THEME_TEMPLATES","Environment",function(THEME_ATTRIBUTE_DATA_TYPE,THEME_TEMPLATES,Environment){function compileDefaultTemplate(theme){return getThemeAttributes(theme).reduce(applyAttributeToTemplate,THEME_TEMPLATES.defaultTemplate)}function applyAttributeToTemplate(template,attribute){return template.replace(new RegExp("(darken|lighten)\\(@"+attribute.attributeType+", ([0-9.]+)%\\)","g"),function(match,f,p){var percent=parseFloat(p)/100;return"darken"===f&&(percent*=-1),shadeColor2(attribute.value,percent)}).replace(new RegExp("@"+attribute.attributeType,"g"),getAttributeValue(attribute))}function getAttributeValue(attribute){return attribute.dataType!==THEME_ATTRIBUTE_DATA_TYPE.IMAGE?attribute.value:attribute.value?"url('"+Environment.getServerBase()+attribute.value+"')":"none"}function getThemeAttributes(theme,entityType){return theme.attributes.filter(function(attribute){return!attribute.entityType||attribute.entityType.toLowerCase()===entityType}).concat([{attributeType:"THEME_CLASS",value:"."+normalizeThemeId(theme.id)}])}function normalizeThemeId(themeId){return themeId.toLowerCase().replace(/,/g,"-")}function shadeColor2(color,percent){var f=parseInt(color.slice(1),16),t=percent<0?0:255,p=percent<0?percent*-1:percent,R=f>>16,G=f>>8&255,B=255&f;return"#"+(16777216+65536*(Math.round((t-R)*p)+R)+256*(Math.round((t-G)*p)+G)+(Math.round((t-B)*p)+B)).toString(16).slice(1)}this.compileDefaultTemplate=compileDefaultTemplate,this.normalizeThemeId=normalizeThemeId}]),angular.module("juco.services").service("UpdatesService",["JucoRestService","PlatformInfoService","NotificationService","$interval","$rootScope","$window","EVENTS","REST","CurrentUser","ObjectUtil","PromiseUtil","Environment",function(JucoRestService,PlatformInfoService,NotificationService,$interval,$rootScope,$window,EVENTS,REST,CurrentUser,ObjectUtil,PromiseUtil,Environment){function checkForUpdates(forceNotificationEvents){var params=Environment.isCordova()?{includeManifestVersion:!0}:{};JucoRestService.get(REST.updates.BASE(),params,!0).then(function(updates){var previousNextUpdateIn=nextUpdateIn;nextUpdateIn=updates.nextUpdateIn,updateChatCounts(updates,forceNotificationEvents),updateLogConfigurationVersion(updates),Environment.isCordova()&&updateManifestVersion(updates),previousNextUpdateIn!==nextUpdateIn&&nextUpdateIn&&reScheduleCheck()}),updateNotificationCounts(forceNotificationEvents)}function updateNotificationCounts(forceNotificationEvents){NotificationService.getNotificationCount().then(function(notificationCount){var updatedOpenNotifications=notificationCount.open;(forceNotificationEvents||updatedOpenNotifications!==newNotifications)&&ObjectUtil.isDefined(updatedOpenNotifications)&&(newNotifications=updatedOpenNotifications,$rootScope.$broadcast(EVENTS.onNotificationCountChanged,newNotifications))})}function updateChatCounts(updates,forceNotificationEvents){var updatedUnreadConversations=updates.unreadConversations;(forceNotificationEvents||updatedUnreadConversations!==unreadConversations)&&ObjectUtil.isDefined(updatedUnreadConversations)&&(unreadConversations=updatedUnreadConversations,$rootScope.$broadcast(EVENTS.onUnreadConversationCountUpdate,unreadConversations))}function updateLogConfigurationVersion(updates){var newLogConfigurationVersion=updates.logConfigurationVersion;logConfigurationVersion!==newLogConfigurationVersion&&(logConfigurationVersion=newLogConfigurationVersion,$rootScope.$broadcast(EVENTS.onLogConfigurationVersionChanged,logConfigurationVersion))}function updateManifestVersion(updates){$window.Manifest&&$window.Manifest.version&&updates.manifestVersion&&$window.Manifest.version!==updates.manifestVersion&&$rootScope.$broadcast(EVENTS.onManifestVersionChanged)}function checkForUpdatesHandler(){
checkForUpdates(!1)}function scheduleCheck(){promise||(promise=$interval(checkForUpdatesHandler,nextUpdateIn))}function stopCheck(){$interval.cancel(promise),promise=void 0}function reScheduleCheck(){stopCheck(),scheduleCheck()}function onAppStart(){$rootScope.$on(EVENTS.onUserAuthenticated,scheduleCheck),CurrentUser.isAuthenticated()&&scheduleCheck(),$rootScope.$on(EVENTS.onUserDeauthenticated,function(){stopCheck(),newNotifications=void 0,unreadConversations=void 0})}function getNewNotifications(){return newNotifications}function getUnreadConversations(){return unreadConversations}function forceUpdate(){checkForUpdates(!0)}var nextUpdateIn=1e4,newNotifications=void 0,unreadConversations=void 0,logConfigurationVersion=void 0,promise=void 0;this.onAppStart=onAppStart,this.getNewNotifications=getNewNotifications,this.getUnreadConversations=getUnreadConversations,this.forceUpdate=forceUpdate}]);