#!/bin/sh

# Displays an error message (first parameter) and exits
# the backup script with error code 1
error() {
    time=$(date '+%Y-%m-%d %T')
    echo "[ERROR] $time $1"
    exit 1
}
# Reads the main properties from search-ltr-backup.properties file
# and sets additional properties
setProperties() {

    SCRIPT_DIR=$(dirname $0)
    property_file=$SCRIPT_DIR/search-ltr-backup.properties
    . $property_file

    #Setting additional properties
    DIR=$(date +%Y-%m-%d-%H%M%S)
    DEST=/home/mongodb/backup/$DB/$DIR
}

# Creates a mongo database dump and in case of an error exits the backup
dumpMongoDB() {
    docker exec just-mongodb mkdir -p $DEST || error "Could not create $DEST"
    docker exec just-mongodb mongodump --quiet -d $DB -u $USER -p $PASSWORD --authenticationDatabase=admin --gzip --archive=$DEST || error "Failed to dump search-ltr database into $DEST."
}


# Removes old backups of search-ltr mongo db dumps
removeOldBackups() {
    find $BACKUP_DIR -name "*" -mtime +3 | xargs rm -rf
}


setProperties
dumpMongoDB
removeOldBackups
