#!/usr/bin/env bash

# Set some defaults
export NUMSESS=""
export USERNAME=""
export OK_STATUSLEVEL=0
export OK_STATUSSTRING="OK"
export WARNING_STATUSLEVEL=1
export WARNING_STATUSSTRING="WARNING"
export CRITICAL_STATUSLEVEL=2
export CRITICAL_STATUSSTRING="CRITICAL"
export UNKNOWN_STATUSLEVEL=3
export UNKNOWN_STATUSSTRING="UNKNOWN"
export STATUSLEVEL=$OK_STATUSLEVEL
export STATUSSTRING="$OK_STATUSSTRING"


export OK_VERSION="7*"
export WARN_VERSION="6*"
export CRIT_VERSION="5*"

export WGET=`which wget`
if [ -z "$WGET" ]
then
        wget command not found. This plugin depends on it. Please install it and put it in path.
        exit 1
fi

usage ()
{
        echo "Usage: `basename $0` [ -h hostname or IP address ] [ -u username ] [ -p password ]" >&2
        echo ""
        echo "DEFAULTS" >&2
        echo "hostname=justconnect.example.com" >&2
        echo "username=optional" >&2
        echo "password=optional" >&2
        exit 1
}
# MAIN
HOSTNAME=$1
while getopts ":h:u:p:w:c:v" opt
do
        case "$opt" in
                h)
                        HOSTNAME="$OPTARG"
                ;;
                u)
                        USERNAME="$OPTARG"
                ;;
                p)
                        PASSWORD="$OPTARG"
                ;;
                w)
                        WARNING_LEVEL="$OPTARG"
                ;;
                c)
                        CRITICAL_LEVEL="$OPTARG"
                ;;
                v)
                        echo "Version 1";
                        usage
                        exit 1
                ;;
        esac
done


if [ "$USERNAME" = "" ]
then
        NUMSESS=`$WGET --no-proxy --no-check-certificate -o /dev/null -O - "http://$HOSTNAME" | grep platformVersion | sed 's/platformVersion: //' | sed 's/ //g' | sed 's/"//g'`
fi

if [ "$USERNAME" != "" ]
then
        NUMSESS=`$WGET --no-proxy --no-check-certificate -o /dev/null -O - "http://$USERNAME:$PASSWORD@$HOSTNAME" | grep platformVersion | sed 's/platformVersion: //' | sed 's/ //g' | sed 's/"//g'`
fi

if [ -z "$NUMSESS" -o "$?" -gt 0 ]
then
        STATUSLEVEL=$UNKNOWN_STATUSLEVEL
        STATUSSTRING="$UNKNOWN_STATUSSTRING"
fi

if [[ $NUMSESS == $WARN_VERSION ]]
then
        STATUSLEVEL=$WARNING_STATUSLEVEL
        STATUSSTRING="$WARNING_STATUSSTRING"
fi

if [[ $NUMSESS == $CRIT_VERSION ]]
then
        STATUSLEVEL=$CRITICAL_STATUSLEVEL
        STATUSSTRING="$CRITICAL_STATUSSTRING"
fi


echo "Just Connect Version $STATUSSTRING: $NUMSESS | jcversion=$NUMSESS"

exit $STATUSLEVEL

