#!/usr/bin/env bash

# File: /usr/lib/nagios/plugins/check_searchltr_heartbeat
#    0 - all ok
#    1 - warning
#    2 - critical
#    3 - unknown

HOSTNAME="localhost"
PORT=7469

WARNING_STATUS=1;
CRITICAL_STATUS=2;
OK_STATUS=0;

OUTPUT=""
RETURN_STATUS=${OK_STATUS}

while getopts ":H:P:A:" OPT; do
    case ${OPT} in
        H)
            HOSTNAME="${OPTARG}"
            ;;
        P)
            PORT="${OPTARG}"
            ;;
        \?)
            echo "Usage: `basename ${0}` [ -H hostname or IP address ] [ -P port ]" >&2
            exit 1
            ;;
    esac
done

URL="http://${HOSTNAME}:${PORT}/heartbeat"
DATA=$(curl -sfkL --connect-timeout 2 ${URL})

RESULT=$?
if [ ${RESULT} -ne 0 ]; then
    echo "Heartbeat on ${URL} failed."
    exit ${CRITICAL_STATUS}
fi

echo "${DATA}" | tr -d "\r" | while read LINE; do
    SERVICE=$(echo ${LINE} | cut -d ':' -f 1)
    STATUS=$(echo ${LINE} | cut -d ':' -f 2)

    if [ "${STATUS}" != "OK" ]; then
        echo "[ERROR] | ${SERVICE}"
        exit ${CRITICAL_STATUS}
    fi
done
echo "OK - Success"
exit ${OK_STATUS}
