#!/bin/sh

set -e

# Returns the heartbeat status list of Just Connect and its used sub-systems
# of localhost as service:[OK,WARN,ERROR] status
getHeartbeatByServer() {
    if list=$(curl -skL --connect-timeout 5 http://localhost:8080/toro/rest/heartbeat); then
        echo "$list" | tr -d "\r" | while read -r line; do
            service=$(echo "$line" | cut -d ':' -f 1)
            status=$(echo "$line" | cut -d ':' -f 2)

            if [ "$status" != "OK" ]; then
                echo "Heartbeat of $service shows $status."
                exit 2
            fi
        done

        echo "All Status checks show OK"
        exit 0
    else
        echo "Heartbeat not found on localhost."
        exit 2
    fi
}

getHeartbeatByServer
