# Installing MongoDB with Ansible

This role installs a MongoDB server on your remote host. In addition, it creates an admin user 
(mongodb_auth_admin_user) in the pre-existing admin db to create additional users later on.

Currently, Debian, Ubuntu and SuSE are supported.

To use this role you can list the mongodb role in your playbook, e.g. mongodb.yml:

```
- hosts: mongodb
  become: True

  roles:
    - mongodb
```

In your inventory file residing in the server directory you need to add the entry:

```
[mongodb]
<YOUR_INVENTORY_HOSTNAME>
```

All variables that this role uses are defined in defaults/main.yml. Those variables can be 
overwritten, e.g. in your host_vars. You can use the default values, but we recommend to overwrite
the mongodb_auth_admin_password, e.g. in your extra_vars (see below). 

Please note that the configuration dir and the MongoDB user and 
group are not configurable, since it's hardwired in the package manager provided startup script.


To run your playbook you command can look like:

```
ansible-playbook -i server/just/host-test --extra-vars="mongodb_auth_admin_password=MyPassword" mongodb.yml
```

If using the default variables MongoDB is available on port 27017 at localhost.