#!/bin/sh

help() {
    echo "Usage $0 [db [full]]"
    echo "Database-backup: db=pg or db=ora, default = pg"
    echo "If you want to explicitely trigger a full duplicity backup to ftp space, then add the parameter \"full\""
    echo "If you add no parameter an incremental backup will be triggered unless the last full backup is older than 2 weeks"
}


checkArguments() {

    db_type="pg"

    if [ $# -eq 1 -o $# -eq 2 ]; then
        if [ "$1" = "ora" ]; then
            db_type="ora"
        elif [ "$1" != "pg" -a "$1" != "ora" ]; then
            help
            exit 1
        elif [ "$1" = "--help" ]; then
            help
            exit 0
        fi
    fi

    if [ $# -eq 2 ]; then
        if [ "$2" != "full" ]; then
            help
            exit 1
        fi
    fi
}


# Reads the main properties from backup.properties file
setProperties() {
    property_file=$(dirname $0)/backup.properties
    . $property_file
}

createLogDir() {
    if [ ! -d $BACKUP_LOG_DIR ] ; then
        mkdir -p $BACKUP_LOG_DIR
        status=$?
        if [ $status -ne 0 ] ; then
            message="Backup failed on $SERVER: Could not create log dir '$BACKUP_LOG_DIR' ($status)"
            echo -e "$message" | mail -s "[BACKUP ERROR] Backup failed on $SERVER" $MAIL_RECEIVER
            exit 1
        fi
    fi
}

executeBackup() {

    backup_script_dir=$(dirname $0) 
    time=$(date '+%Y-%m-%d-%H%M%S')
    current_backup_error_log_file="$BACKUP_ERROR_LOG_FILE.tmp.$time"
    $backup_script_dir/backup.sh $db_type $2 2>$current_backup_error_log_file 1>>$BACKUP_LOG_FILE
    status=$?
    
    if [ $status -ne 0 ]; then
        message=$(cat $current_backup_error_log_file)
        message="Backup failed on $SERVER. Please see error messages below:\n\n$message"
        echo -e "$message" | mail -s "[BACKUP ERROR] Backup failed on $SERVER" $MAIL_RECEIVER
    fi

    if [ -e $current_backup_error_log_file ]; then
        cat $current_backup_error_log_file >> $BACKUP_ERROR_LOG_FILE
        rm -f $current_backup_error_log_file
    fi

}

args=$*
checkArguments $args
setProperties
createLogDir
executeBackup $args

